# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KeyArgs', 'Key']

@pulumi.input_type
class KeyArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 full_path: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Key resource.
        :param pulumi.Input[_builtins.str] content: Content of SSL certificate key present on local Disk
        :param pulumi.Input[_builtins.str] name: Name of the SSL Certificate key to be Imported on to BIGIP
        :param pulumi.Input[_builtins.str] full_path: Full Path Name of ssl key
        :param pulumi.Input[_builtins.str] partition: Partition of ssl certificate key
        :param pulumi.Input[_builtins.str] passphrase: Passphrase on key.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        if full_path is not None:
            pulumi.set(__self__, "full_path", full_path)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        Content of SSL certificate key present on local Disk
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the SSL Certificate key to be Imported on to BIGIP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full Path Name of ssl key
        """
        return pulumi.get(self, "full_path")

    @full_path.setter
    def full_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "full_path", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Partition of ssl certificate key
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Passphrase on key.
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passphrase", value)


@pulumi.input_type
class _KeyState:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 full_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Key resources.
        :param pulumi.Input[_builtins.str] content: Content of SSL certificate key present on local Disk
        :param pulumi.Input[_builtins.str] full_path: Full Path Name of ssl key
        :param pulumi.Input[_builtins.str] name: Name of the SSL Certificate key to be Imported on to BIGIP
        :param pulumi.Input[_builtins.str] partition: Partition of ssl certificate key
        :param pulumi.Input[_builtins.str] passphrase: Passphrase on key.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if full_path is not None:
            pulumi.set(__self__, "full_path", full_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Content of SSL certificate key present on local Disk
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full Path Name of ssl key
        """
        return pulumi.get(self, "full_path")

    @full_path.setter
    def full_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "full_path", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the SSL Certificate key to be Imported on to BIGIP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Partition of ssl certificate key
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Passphrase on key.
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passphrase", value)


@pulumi.type_token("f5bigip:ssl/key:Key")
class Key(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 full_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `ssl.Key` This resource will import SSL certificate key on BIG-IP LTM.
        Certificate key can be imported from certificate key files on the local disk, in PEM format

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip
        import pulumi_std as std

        test_key = f5bigip.ssl.Key("test-key",
            name="serverkey.key",
            content=std.file(input="serverkey.key").result,
            partition="Common")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content: Content of SSL certificate key present on local Disk
        :param pulumi.Input[_builtins.str] full_path: Full Path Name of ssl key
        :param pulumi.Input[_builtins.str] name: Name of the SSL Certificate key to be Imported on to BIGIP
        :param pulumi.Input[_builtins.str] partition: Partition of ssl certificate key
        :param pulumi.Input[_builtins.str] passphrase: Passphrase on key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ssl.Key` This resource will import SSL certificate key on BIG-IP LTM.
        Certificate key can be imported from certificate key files on the local disk, in PEM format

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip
        import pulumi_std as std

        test_key = f5bigip.ssl.Key("test-key",
            name="serverkey.key",
            content=std.file(input="serverkey.key").result,
            partition="Common")
        ```

        :param str resource_name: The name of the resource.
        :param KeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 full_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyArgs.__new__(KeyArgs)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = None if content is None else pulumi.Output.secret(content)
            __props__.__dict__["full_path"] = full_path
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["partition"] = partition
            __props__.__dict__["passphrase"] = None if passphrase is None else pulumi.Output.secret(passphrase)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["content", "passphrase"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Key, __self__).__init__(
            'f5bigip:ssl/key:Key',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            full_path: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partition: Optional[pulumi.Input[_builtins.str]] = None,
            passphrase: Optional[pulumi.Input[_builtins.str]] = None) -> 'Key':
        """
        Get an existing Key resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content: Content of SSL certificate key present on local Disk
        :param pulumi.Input[_builtins.str] full_path: Full Path Name of ssl key
        :param pulumi.Input[_builtins.str] name: Name of the SSL Certificate key to be Imported on to BIGIP
        :param pulumi.Input[_builtins.str] partition: Partition of ssl certificate key
        :param pulumi.Input[_builtins.str] passphrase: Passphrase on key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyState.__new__(_KeyState)

        __props__.__dict__["content"] = content
        __props__.__dict__["full_path"] = full_path
        __props__.__dict__["name"] = name
        __props__.__dict__["partition"] = partition
        __props__.__dict__["passphrase"] = passphrase
        return Key(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        Content of SSL certificate key present on local Disk
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> pulumi.Output[_builtins.str]:
        """
        Full Path Name of ssl key
        """
        return pulumi.get(self, "full_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the SSL Certificate key to be Imported on to BIGIP
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Partition of ssl certificate key
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Passphrase on key.
        """
        return pulumi.get(self, "passphrase")

