"""
Copyright 2018 Goldman Sachs.
Licensed under the Apache License, Version 2.0 (the 'License');
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
'AS IS' BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
"""
import pytest
import datetime as dt

from gs_quant.api.gs.hedges import GsHedgeApi
from gs_quant.markets.hedge import HedgeExclusions, HedgeConstraints, Constraint, Hedge, PerformanceHedge, \
    PerformanceHedgeParameters
from gs_quant.markets.position_set import PositionSet, Position

mock_hedge = PerformanceHedge(parameters=None)

calculation_results = {'hedgedTarget': {
    'constituents': [
        {'country': 'United States',
         'name': 'Apple Inc', 'transactionCost': 1.1936100899058002, 'sector': 'Information Technology', 'shares': 26,
         'assetId': 'MA4B66MW5E27U9VBB94', 'bbid': 'AAPL UW', 'currency': 'USD',
         'industry': 'Technology Hardware, Storage & Peripherals', 'marginalCost': 0.09597615517006632,
         'advPercentage': 0, 'notional': 3819.9199999999996, 'price': 146.92, 'weight': 0.08040829746809594,
         'borrowCost': 40}, {'country': 'United States', 'name': 'Albemarle Corp', 'transactionCost': 5.661775350570679,
                             'sector': 'Materials', 'shares': -2.9210200815542167, 'assetId': 'MA4B66MW5E27U9XPVYM',
                             'bbid': 'ALB UN', 'currency': 'USD', 'industry': 'Chemicals',
                             'marginalCost': 0.078815239121909, 'advPercentage': 2e-06, 'notional': -661.3189464638747,
                             'price': 226.4, 'weight': -0.01392058749098281, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Advanced Micro Devices', 'transactionCost': 0.5830498039722443,
         'sector': 'Information Technology', 'shares': -0.8120055824108264, 'assetId': 'MA4B66MW5E27U9YGMB9',
         'bbid': 'AMD UW', 'currency': 'USD', 'industry': 'Semiconductors & Semiconductor Equipment',
         'marginalCost': 0.0010543794559583631, 'advPercentage': 0, 'notional': -85.91019061906543, 'price': 105.8,
         'weight': -0.0018083866056981923, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Best Buy Co Inc', 'transactionCost': 2.401727557182312,
         'sector': 'Consumer Discretionary', 'shares': -4.535031177626968, 'assetId': 'MA4B66MW5E27UA39J2L',
         'bbid': 'BBY UN', 'currency': 'USD', 'industry': 'Specialty Retail', 'marginalCost': 0.02401392704093342,
         'advPercentage': 2e-06, 'notional': -474.99916554464863, 'price': 104.74, 'weight': -0.009998605782375405,
         'borrowCost': 40}, {'country': 'United States', 'name': 'Citigroup Inc', 'transactionCost': 1.4510516652072596,
                             'sector': 'Financials', 'shares': -27.227187182634943, 'assetId': 'MA4B66MW5E27UA4ZCWT',
                             'bbid': 'C UN', 'currency': 'USD', 'industry': 'Banks',
                             'marginalCost': 0.05919571023849292, 'advPercentage': 2e-06,
                             'notional': -1938.0311836599553, 'price': 71.18, 'weight': -0.040795039665274604,
                             'borrowCost': 40},
        {'country': 'United States', 'name': 'Cummins Inc', 'transactionCost': 3.3661617040634155,
         'sector': 'Industrials', 'shares': -0.4130028393296445, 'assetId': 'MA4B66MW5E27UACX6RZ', 'bbid': 'CMI UN',
         'currency': 'USD', 'industry': 'Machinery', 'marginalCost': 0.006662256400232119, 'advPercentage': 0,
         'notional': -94.02422640178686, 'price': 227.66, 'weight': -0.0019791848954225427, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Citrix Systems Inc', 'transactionCost': 2.754676938056946,
         'sector': 'Information Technology', 'shares': -2.204015152257958, 'assetId': 'MA4B66MW5E27UAE4LLL',
         'bbid': 'CTXS UW', 'currency': 'USD', 'industry': 'Software', 'marginalCost': 0.014082314238438266,
         'advPercentage': 2e-06, 'notional': -242.86042962730437, 'price': 110.19, 'weight': -0.005112147288085058,
         'borrowCost': 40},
        {'country': 'United States', 'name': 'Duke Realty Corp', 'transactionCost': 1.3627572059631348,
         'sector': 'Real Estate', 'shares': -8.864060939026558, 'assetId': 'MA4B66MW5E27UAEP46J', 'bbid': 'DRE UN',
         'currency': 'USD', 'industry': 'Equity Real Estate Investment Trusts (REITs)',
         'marginalCost': 0.012421166613716166, 'advPercentage': 5e-06, 'notional': -433.0093768714474, 'price': 48.85,
         'weight': -0.009114731926834648, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Davita Inc', 'transactionCost': 3.084942579269409,
         'sector': 'Health Care', 'shares': -3.4880239796169494, 'assetId': 'MA4B66MW5E27UAEP4D8', 'bbid': 'DVA UN',
         'currency': 'USD', 'industry': 'Health Care Providers & Services', 'marginalCost': 0.027406811709718284,
         'advPercentage': 6e-06, 'notional': -422.05090153365086, 'price': 121, 'weight': -0.008884058942908718,
         'borrowCost': 40},
        {'country': 'United States', 'name': 'Electronic Arts Inc', 'transactionCost': 2.1669615507125854,
         'sector': 'Communication Services', 'shares': -6.899047429867354, 'assetId': 'MA4B66MW5E27UAEP4H9',
         'bbid': 'EA UW', 'currency': 'USD', 'industry': 'Entertainment', 'marginalCost': 0.040878606822697415,
         'advPercentage': 3e-06, 'notional': -896.1862611397693, 'price': 129.9, 'weight': -0.01886448184060066,
         'borrowCost': 40},
        {'country': 'United States', 'name': 'Extra Space Storage Inc', 'transactionCost': 3.9990124702453613,
         'sector': 'Real Estate', 'shares': -3.1030213327842304, 'assetId': 'MA4B66MW5E27UAFU2CS', 'bbid': 'EXR UN',
         'currency': 'USD', 'industry': 'Equity Real Estate Investment Trusts (REITs)',
         'marginalCost': 0.04508686837043359, 'advPercentage': 5e-06, 'notional': -535.6125122518861, 'price': 172.61,
         'weight': -0.011274500568803494, 'borrowCost': 40},
        {'country': 'United States', 'name': 'General Motors Co', 'transactionCost': 1.0103281140327454,
         'sector': 'Consumer Discretionary', 'shares': -3.0290208240423557, 'assetId': 'MA4B66MW5E27UAGYYVE',
         'bbid': 'GM UN', 'currency': 'USD', 'industry': 'Automobiles', 'marginalCost': 0.003364583586707687,
         'advPercentage': 0, 'notional': -158.20575763973224, 'price': 52.23, 'weight': -0.003330189014812112,
         'borrowCost': 40},
        {'country': 'United States', 'name': 'The Goldman Sachs Group, Inc.', 'transactionCost': 3.2194154492372298,
         'sector': 'Financials', 'shares': 51, 'assetId': 'MA4B66MW5E27UAHKG34', 'bbid': 'GS UN', 'currency': 'USD',
         'industry': 'Capital Markets', 'marginalCost': 1.3508400095029636, 'advPercentage': 2.3e-05,
         'notional': 19933.350000000002, 'price': 390.85, 'weight': 0.4195917025319039, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Hormel Foods Corp', 'transactionCost': 1.4352393746376038,
         'sector': 'Consumer Staples', 'shares': -11.239077266890737, 'assetId': 'MA4B66MW5E27UAJ5XEZ',
         'bbid': 'HRL UN', 'currency': 'USD', 'industry': 'Food Products', 'marginalCost': 0.013853571784092618,
         'advPercentage': 4e-06, 'notional': -458.55435248914205, 'price': 40.8, 'weight': -0.009652446852352158,
         'borrowCost': 40},
        {'country': 'United States', 'name': 'Iron Mountain Inc', 'transactionCost': 2.417732357978821,
         'sector': 'Real Estate', 'shares': -5.0810349313170065, 'assetId': 'MA4B66MW5E27UAJQF4M', 'bbid': 'IRM UN',
         'currency': 'USD', 'industry': 'Equity Real Estate Investment Trusts (REITs)',
         'marginalCost': 0.011447654789702045, 'advPercentage': 3e-06, 'notional': -224.93741640940388, 'price': 44.27,
         'weight': -0.004734872638786235, 'borrowCost': 40},
        {'country': 'United States', 'name': 'JPMorgan Chase & Co', 'transactionCost': 1.2586397729172192,
         'sector': 'Financials', 'shares': -12.604086651115832, 'assetId': 'MA4B66MW5E27UAKHZFD', 'bbid': 'JPM UN',
         'currency': 'USD', 'industry': 'Banks', 'marginalCost': 0.054444447777798256, 'advPercentage': 1e-06,
         'notional': -2054.970287597925, 'price': 163.04, 'weight': -0.043256576622880225, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Kroger Co', 'transactionCost': 1.2731897830963135,
         'sector': 'Consumer Staples', 'shares': -1.730011893560012, 'assetId': 'MA4B66MW5E27UAKNZNV', 'bbid': 'KR UN',
         'currency': 'USD', 'industry': 'Food & Staples Retailing', 'marginalCost': 0.0018536665905637035,
         'advPercentage': 0, 'notional': -69.16587550452927, 'price': 39.98, 'weight': -0.001455923237190695,
         'borrowCost': 40}, {'country': 'United States', 'name': 'Mosaic Co/the', 'transactionCost': 2.1279181241989136,
                             'sector': 'Materials', 'shares': -5.192035694429817, 'assetId': 'MA4B66MW5E27UAL9SLW',
                             'bbid': 'MOS UN', 'currency': 'USD', 'industry': 'Chemicals',
                             'marginalCost': 0.008339681547933048, 'advPercentage': 2e-06,
                             'notional': -186.18640000225324, 'price': 35.86, 'weight': -0.003919174075869411,
                             'borrowCost': 40},
        {'country': 'United States', 'name': 'Morgan Stanley', 'transactionCost': 2.3784881788491172,
         'sector': 'Financials', 'shares': -100.16368860962515, 'assetId': 'MA4B66MW5E27UAL9STW', 'bbid': 'MS UN',
         'currency': 'USD', 'industry': 'Capital Markets', 'marginalCost': 0.5160781640859926, 'advPercentage': 1.6e-05,
         'notional': -10307.845194816524, 'price': 102.91, 'weight': -0.2169773928982519, 'borrowCost': 40},
        {'country': 'United States', 'name': 'MSCI Inc', 'transactionCost': 7.908167362213135, 'sector': 'Financials',
         'shares': -0.5740039461869635, 'assetId': 'MA4B66MW5E27UAL9SUH', 'bbid': 'MSCI UN', 'currency': 'USD',
         'industry': 'Capital Markets', 'marginalCost': 0.06319486932947428, 'advPercentage': 2e-06,
         'notional': -379.628989889672, 'price': 661.37, 'weight': -0.007991089014053052, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Nucor Corp', 'transactionCost': 3.182479500770569, 'sector': 'Materials',
         'shares': -0.7970054792874738, 'assetId': 'MA4B66MW5E27UALNB48', 'bbid': 'NUE UN', 'currency': 'USD',
         'industry': 'Metals & Mining', 'marginalCost': 0.005388287534627193, 'advPercentage': 0,
         'notional': -80.43379296969185, 'price': 100.92, 'weight': -0.001693109895388968, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Paypal Holdings Inc', 'transactionCost': 1.4358487129211426,
         'sector': 'Information Technology', 'shares': -0.5480037674398188, 'assetId': 'MA4B66MW5E27UAM94N9',
         'bbid': 'PYPL UW', 'currency': 'USD', 'industry': 'IT Services', 'marginalCost': 0.004606334069169853,
         'advPercentage': 0, 'notional': -152.40532776268802, 'price': 278.11, 'weight': -0.0032080915125093927,
         'borrowCost': 40}, {'country': 'United States', 'name': 'Qualcomm Inc', 'transactionCost': 1.0424676537513733,
                             'sector': 'Information Technology', 'shares': -0.6250042968063627,
                             'assetId': 'MA4B66MW5E27UAM94Q4', 'bbid': 'QCOM UW', 'currency': 'USD',
                             'industry': 'Semiconductors & Semiconductor Equipment',
                             'marginalCost': 0.001836148888424059, 'advPercentage': 0, 'notional': -83.67557525643583,
                             'price': 133.88, 'weight': -0.0017613485481459143, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Tractor Supply Company', 'transactionCost': 3.904104232788086,
         'sector': 'Consumer Discretionary', 'shares': -0.49000336869618827, 'assetId': 'MA4B66MW5E27UANEQ5C',
         'bbid': 'TSCO UW', 'currency': 'USD', 'industry': 'Specialty Retail', 'marginalCost': 0.00848540990065989,
         'advPercentage': 1e-06, 'notional': -103.2535098516608, 'price': 210.72, 'weight': -0.002173458851174191,
         'borrowCost': 40}, {'country': 'United States', 'name': 'Twitter Inc', 'transactionCost': 1.2658634781837463,
                             'sector': 'Communication Services', 'shares': -8.874061007775461,
                             'assetId': 'MA4B66MW5E27UANLXU9', 'bbid': 'TWTR UN', 'currency': 'USD',
                             'industry': 'Interactive Media & Services', 'marginalCost': 0.015894775099317016,
                             'advPercentage': 1e-06, 'notional': -596.5143809426665, 'price': 67.22,
                             'weight': -0.012556468666054534, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Wells Fargo & Co', 'transactionCost': 1.3822112533240394,
         'sector': 'Financials', 'shares': -43.79430107894055, 'assetId': 'MA4B66MW5E27UANT8X5', 'bbid': 'WFC UN',
         'currency': 'USD', 'industry': 'Banks', 'marginalCost': 0.061059807755110544, 'advPercentage': 2e-06,
         'notional': -2098.622907702831, 'price': 47.92, 'weight': -0.044175452636686034, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Dentsply Sirona Inc', 'transactionCost': 2.9051536321640015,
         'sector': 'Health Care', 'shares': -5.308036491917078, 'assetId': 'MA4B66MW5E27UANZH4M', 'bbid': 'XRAY UW',
         'currency': 'USD', 'industry': 'Health Care Equipment & Supplies', 'marginalCost': 0.01947929477213156,
         'advPercentage': 5e-06, 'notional': -318.5352698799438, 'price': 60.01, 'weight': -0.006705082497692817,
         'borrowCost': 40},
        {'country': 'United States', 'name': 'Meta Platforms Inc-Class A', 'transactionCost': 0.8238705992698669,
         'sector': 'Communication Services', 'shares': -0.7130049017966985, 'assetId': 'MA4B66MW5E3VLSECN',
         'bbid': 'FB UW', 'currency': 'USD', 'industry': 'Interactive Media & Services',
         'marginalCost': 0.004364390584540722, 'advPercentage': 0, 'notional': -251.6622101381627, 'price': 352.96,
         'weight': -0.005297422420958517, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Tapestry Inc', 'transactionCost': 2.314427137374878,
         'sector': 'Consumer Discretionary', 'shares': -7.397050853562664, 'assetId': 'MAAHJ4JYCKZ6P025',
         'bbid': 'TPR UN', 'currency': 'USD', 'industry': 'Textiles, Apparel & Luxury Goods',
         'marginalCost': 0.014220203034272804, 'advPercentage': 2e-06, 'notional': -291.88762668158273, 'price': 39.46,
         'weight': -0.006144156713614223, 'borrowCost': 40},
        {'country': 'United States', 'name': 'Lumen Technologies Inc', 'transactionCost': 3.95284104347229,
         'sector': 'Communication Services', 'shares': -11.81608123370237, 'assetId': 'MAQQM1QHGJDFAVKN',
         'bbid': 'LUMN UN', 'currency': 'USD', 'industry': 'Diversified Telecommunication Services',
         'marginalCost': 0.012712411491036973, 'advPercentage': 1e-06, 'notional': -152.78193035177165, 'price': 12.93,
         'weight': -0.003216018896593429, 'borrowCost': 40}], 'transactionCost': 2.5770571473071144},
    'hedge': {'transactionCost': 2.2604819652681694, 'correlation': 0.936758446681233,
              'backtestPerformance': [['2020-09-24', 1], ['2020-09-25', 1.0104116399850593],
                                      ['2020-09-28', 1.0307855197014755], ['2020-09-29', 1.0163931905275039],
                                      ['2020-09-30', 1.0303780678487708], ['2020-10-01', 1.02803072573049],
                                      ['2020-10-02', 1.0338706383971734], ['2020-10-05', 1.052525377568271],
                                      ['2020-10-06', 1.0340650510786302], ['2020-10-07', 1.0508356048581615],
                                      ['2020-10-08', 1.0603036151113474], ['2020-10-09', 1.060588304786846],
                                      ['2020-10-12', 1.0868635890594514], ['2020-10-13', 1.0747102379748288],
                                      ['2020-10-14', 1.0671267966260976], ['2020-10-15', 1.074639084395838],
                                      ['2020-10-16', 1.0765144407834903], ['2020-10-19', 1.0626904612955628],
                                      ['2020-10-20', 1.0698992568123844], ['2020-10-21', 1.0633001027846625],
                                      ['2020-10-22', 1.080365958503925], ['2020-10-23', 1.0836535809584429],
                                      ['2020-10-26', 1.0599791557462024], ['2020-10-27', 1.0398109665270256],
                                      ['2020-10-28', 1.013939716813292], ['2020-10-29', 1.025285647916773],
                                      ['2020-10-30', 1.0162452634880497], ['2020-11-02', 1.0361270021554296],
                                      ['2020-11-03', 1.0628292713233702], ['2020-11-04', 1.0643748693020345],
                                      ['2020-11-05', 1.0870688878363275], ['2020-11-06', 1.075680915811229],
                                      ['2020-11-09', 1.1310152350427867], ['2020-11-10', 1.1365085766625056],
                                      ['2020-11-11', 1.1456684425171284], ['2020-11-12', 1.1324848780700123],
                                      ['2020-11-13', 1.1496769513131484], ['2020-11-16', 1.174024423737768],
                                      ['2020-11-17', 1.1786976021533382], ['2020-11-18', 1.172198105516616],
                                      ['2020-11-19', 1.1796894313970685], ['2020-11-20', 1.1720675902607598],
                                      ['2020-11-23', 1.2042568842777668], ['2020-11-24', 1.2478109612205204],
                                      ['2020-11-25', 1.2465964960297171], ['2020-11-26', 1.2465964960297171],
                                      ['2020-11-27', 1.2482807167565497], ['2020-11-30', 1.2240604489911184],
                                      ['2020-12-01', 1.2414716222521844], ['2020-12-02', 1.2555764585251266],
                                      ['2020-12-03', 1.2530206749134576], ['2020-12-04', 1.2726021013511315],
                                      ['2020-12-07', 1.2651506324580064], ['2020-12-08', 1.2642771975229015],
                                      ['2020-12-09', 1.2678474010781646], ['2020-12-10', 1.2736979737616583],
                                      ['2020-12-11', 1.2573160543347301], ['2020-12-14', 1.244303488883378],
                                      ['2020-12-15', 1.2742786174980252], ['2020-12-16', 1.2779195844041837],
                                      ['2020-12-17', 1.283302631746248], ['2020-12-18', 1.276354699607117],
                                      ['2020-12-21', 1.3125686927823437], ['2020-12-22', 1.296299249328958],
                                      ['2020-12-23', 1.3187779432834859], ['2020-12-24', 1.3162583329954654],
                                      ['2020-12-25', 1.3162583329954654], ['2020-12-28', 1.3185892862798951],
                                      ['2020-12-29', 1.3111756560815606], ['2020-12-30', 1.3144825720696882],
                                      ['2020-12-31', 1.3268030683678376], ['2021-01-01', 1.3268030683678376],
                                      ['2021-01-04', 1.3159923682994483], ['2021-01-05', 1.3340647632947369],
                                      ['2021-01-06', 1.3909576803980703], ['2021-01-07', 1.4152280361405745],
                                      ['2021-01-08', 1.4174405809398316], ['2021-01-11', 1.4231526927862412],
                                      ['2021-01-12', 1.4293977756277825], ['2021-01-13', 1.4234850492339033],
                                      ['2021-01-14', 1.4397514671138192], ['2021-01-15', 1.409001702900938],
                                      ['2021-01-18', 1.409001702900938], ['2021-01-19', 1.4109828849695718],
                                      ['2021-01-20', 1.4115393763475617], ['2021-01-21', 1.4044664175144592],
                                      ['2021-01-22', 1.3987852008396073], ['2021-01-25', 1.3860808014247046],
                                      ['2021-01-26', 1.381350320662177], ['2021-01-27', 1.3454054796675197],
                                      ['2021-01-28', 1.3501857783066038], ['2021-01-29', 1.3175753005863033],
                                      ['2021-02-01', 1.3310146449999998], ['2021-02-02', 1.370111970146903],
                                      ['2021-02-03', 1.369846444923827], ['2021-02-04', 1.3936530582244067],
                                      ['2021-02-05', 1.4039277423247092], ['2021-02-08', 1.4268063574012315],
                                      ['2021-02-09', 1.4283534342175326], ['2021-02-10', 1.4357594389261352],
                                      ['2021-02-11', 1.428374052139035], ['2021-02-12', 1.4429251243112822],
                                      ['2021-02-15', 1.4429251243112822], ['2021-02-16', 1.461542741076252],
                                      ['2021-02-17', 1.4591638016742965], ['2021-02-18', 1.4472594444672997],
                                      ['2021-02-19', 1.4707489985599904], ['2021-02-22', 1.4755439199336886],
                                      ['2021-02-23', 1.4820692085583076], ['2021-02-24', 1.511687900368849],
                                      ['2021-02-25', 1.486336535951723], ['2021-02-26', 1.4617866716883874],
                                      ['2021-03-01', 1.5001983608496483], ['2021-03-02', 1.5085260984949034],
                                      ['2021-03-03', 1.5167425010055402], ['2021-03-04', 1.4954468749220593],
                                      ['2021-03-05', 1.5048325007869152], ['2021-03-08', 1.5144817178954568],
                                      ['2021-03-09', 1.5136338082053342], ['2021-03-10', 1.5471387857165224],
                                      ['2021-03-11', 1.552032591486371], ['2021-03-12', 1.5716887223548588],
                                      ['2021-03-15', 1.570807534341104], ['2021-03-16', 1.5528662067408492],
                                      ['2021-03-17', 1.5663385974304973], ['2021-03-18', 1.5673612323097021],
                                      ['2021-03-19', 1.5525802635601895], ['2021-03-22', 1.5409068482642276],
                                      ['2021-03-23', 1.507406937003066], ['2021-03-24', 1.5012740563038809],
                                      ['2021-03-25', 1.5192040583357755], ['2021-03-26', 1.529957344137103],
                                      ['2021-03-29', 1.5047630491396355], ['2021-03-30', 1.5222775022723902],
                                      ['2021-03-31', 1.508553987492476], ['2021-04-01', 1.5207815572746632],
                                      ['2021-04-02', 1.5207815572746632], ['2021-04-05', 1.5252366638449892],
                                      ['2021-04-06', 1.537238350504828], ['2021-04-07', 1.5392951360957752],
                                      ['2021-04-08', 1.5490368365166685], ['2021-04-09', 1.557915030807923],
                                      ['2021-04-12', 1.5565394043984706], ['2021-04-13', 1.5460141095481092],
                                      ['2021-04-14', 1.5595020548937684], ['2021-04-15', 1.565231199487692],
                                      ['2021-04-16', 1.5557047184416664], ['2021-04-19', 1.5616881940098946],
                                      ['2021-04-20', 1.5263160854925413], ['2021-04-21', 1.5522763213884536],
                                      ['2021-04-22', 1.5350915789121093], ['2021-04-23', 1.57158539249219],
                                      ['2021-04-26', 1.5810581974026183], ['2021-04-27', 1.5900787413814923],
                                      ['2021-04-28', 1.5955846620747325], ['2021-04-29', 1.6137105295110301],
                                      ['2021-04-30', 1.5845767863905935], ['2021-05-03', 1.5863705380999724],
                                      ['2021-05-04', 1.5882125781111578], ['2021-05-05', 1.6065603704288025],
                                      ['2021-05-06', 1.6344953097116117], ['2021-05-07', 1.6495251089353995],
                                      ['2021-05-10', 1.636644671135531], ['2021-05-11', 1.6146185343277637],
                                      ['2021-05-12', 1.5897950933090927], ['2021-05-13', 1.6122368879515665],
                                      ['2021-05-14', 1.6439450665420194], ['2021-05-17', 1.6545198576851718],
                                      ['2021-05-18', 1.6353279676761365], ['2021-05-19', 1.6209690936595618],
                                      ['2021-05-20', 1.6294848988625292], ['2021-05-21', 1.6477823771244906],
                                      ['2021-05-24', 1.665391178904659], ['2021-05-25', 1.6543811334627772],
                                      ['2021-05-26', 1.6631885248580318], ['2021-05-27', 1.6784653130973213],
                                      ['2021-05-28', 1.6828566766917903], ['2021-05-31', 1.6828566766917903],
                                      ['2021-06-01', 1.69991088376666], ['2021-06-02', 1.7039576789378863],
                                      ['2021-06-03', 1.7075602408335289], ['2021-06-04', 1.7186255598839562],
                                      ['2021-06-07', 1.712635392985795], ['2021-06-08', 1.7097444780540265],
                                      ['2021-06-09', 1.7005645001567697], ['2021-06-10', 1.6846521736086526],
                                      ['2021-06-11', 1.6913655615016792], ['2021-06-14', 1.6741903605872415],
                                      ['2021-06-15', 1.6671331966653065], ['2021-06-16', 1.6608467705374614],
                                      ['2021-06-17', 1.6182529345083716], ['2021-06-18', 1.5716734295918893],
                                      ['2021-06-21', 1.6025210119753992], ['2021-06-22', 1.6036761759261928],
                                      ['2021-06-23', 1.6088186017605215], ['2021-06-24', 1.6298499404572735],
                                      ['2021-06-25', 1.6475608618707231], ['2021-06-28', 1.6436992303035847],
                                      ['2021-06-29', 1.6583865823631618], ['2021-06-30', 1.6717505836553197],
                                      ['2021-07-01', 1.6772597783846594], ['2021-07-02', 1.6765190560701135],
                                      ['2021-07-05', 1.6765190560701135], ['2021-07-06', 1.6472838625986161],
                                      ['2021-07-07', 1.6456960834251377], ['2021-07-08', 1.6125483519004047],
                                      ['2021-07-09', 1.6558213788094323], ['2021-07-12', 1.683903334102053],
                                      ['2021-07-13', 1.6760296033419682], ['2021-07-14', 1.6751081114066049],
                                      ['2021-07-15', 1.6761821265670138], ['2021-07-16', 1.6519994975324561],
                                      ['2021-07-19', 1.6185386068423806], ['2021-07-20', 1.6608158082138411],
                                      ['2021-07-21', 1.6977232240293918], ['2021-07-22', 1.6910789251625107],
                                      ['2021-07-23', 1.6882778604361217], ['2021-07-26', 1.7079461771654998],
                                      ['2021-07-27', 1.705316911290549], ['2021-07-28', 1.7065513855574908],
                                      ['2021-07-29', 1.7147564423541488], ['2021-07-30', 1.7078630854421146],
                                      ['2021-08-02', 1.7098846370921508], ['2021-08-03', 1.7212246073309094],
                                      ['2021-08-04', 1.71284744352946], ['2021-08-05', 1.7319984849390486],
                                      ['2021-08-06', 1.7610784608955359], ['2021-08-09', 1.7685063176313183],
                                      ['2021-08-10', 1.788487648029903], ['2021-08-11', 1.8132548730727573],
                                      ['2021-08-12', 1.8211088797799007], ['2021-08-13', 1.80763324042271],
                                      ['2021-08-16', 1.7990148335838823], ['2021-08-17', 1.7821201492173437],
                                      ['2021-08-18', 1.7595999866259955], ['2021-08-19', 1.7402030612253945],
                                      ['2021-08-20', 1.75394804825027], ['2021-08-23', 1.774564369295308],
                                      ['2021-08-24', 1.791036747026845], ['2021-08-25', 1.808387370019545],
                                      ['2021-08-26', 1.7990128100684075], ['2021-08-27', 1.8230267889371115],
                                      ['2021-08-30', 1.8066029024558345], ['2021-08-31', 1.8011083700062123],
                                      ['2021-09-01', 1.7952270192942026], ['2021-09-02', 1.8042111959545828],
                                      ['2021-09-03', 1.7956456571882038], ['2021-09-06', 1.7956456571882038],
                                      ['2021-09-07', 1.7906973619966717], ['2021-09-08', 1.7790846820103143],
                                      ['2021-09-09', 1.782974909163946], ['2021-09-10', 1.774210004132321],
                                      ['2021-09-13', 1.7863371703894837], ['2021-09-14', 1.7607086022595286],
                                      ['2021-09-15', 1.7733155737318977], ['2021-09-16', 1.7661953659616862],
                                      ['2021-09-17', 1.75552495625101], ['2021-09-20', 1.7073319409830758],
                                      ['2021-09-21', 1.7036755701399784], ['2021-09-22', 1.7353221001527805],
                                      ['2021-09-23', 1.7749324312405845], ['2021-09-24', 1.772300109946803]],
              'cashWeight': 0, 'rSquared': 0.8279135592848923, 'annualizedReturn': 0.77299493701611,
              'annualizedVolatility': 0.19788814828229934, 'hedgeRatio': 1, 'ridgeWeight': 0,
              'backtestCorrelation': [['2020-11-26', 0.9015925151077675], ['2020-11-27', 0.8995307601350195],
                                      ['2020-11-30', 0.8976193597009464], ['2020-12-01', 0.899134905548527],
                                      ['2020-12-02', 0.8968844291011409], ['2020-12-03', 0.8983210353924714],
                                      ['2020-12-04', 0.8983135812975858], ['2020-12-07', 0.8981598956869762],
                                      ['2020-12-08', 0.896541180905539], ['2020-12-09', 0.896342085151086],
                                      ['2020-12-10', 0.8960079549884281], ['2020-12-11', 0.9022159150284723],
                                      ['2020-12-14', 0.9020984285750759], ['2020-12-15', 0.9108756715722117],
                                      ['2020-12-16', 0.9216167275658368], ['2020-12-17', 0.9283890799097579],
                                      ['2020-12-18', 0.9282606242969395], ['2020-12-21', 0.9168926673056201],
                                      ['2020-12-22', 0.9235486508155735], ['2020-12-23', 0.9276013093341673],
                                      ['2020-12-24', 0.9283372838050917], ['2020-12-25', 0.928171587486031],
                                      ['2020-12-28', 0.9116851149928049], ['2020-12-29', 0.9056422674201283],
                                      ['2020-12-30', 0.9059781317532566], ['2020-12-31', 0.9052396831652074],
                                      ['2021-01-01', 0.9155947769421426], ['2021-01-04', 0.9111654399535882],
                                      ['2021-01-05', 0.9125433947950563], ['2021-01-06', 0.9209363905792434],
                                      ['2021-01-07', 0.9201318271791072], ['2021-01-08', 0.9084929198870123],
                                      ['2021-01-11', 0.9086559298840635], ['2021-01-12', 0.8875612269095221],
                                      ['2021-01-13', 0.8789265648137641], ['2021-01-14', 0.8783291410335801],
                                      ['2021-01-15', 0.8943005663624369], ['2021-01-18', 0.8945248751426272],
                                      ['2021-01-19', 0.8705151985771736], ['2021-01-20', 0.8708271027477481],
                                      ['2021-01-21', 0.8650473745733117], ['2021-01-22', 0.8748613614663985],
                                      ['2021-01-25', 0.8725792954791373], ['2021-01-26', 0.873175463509665],
                                      ['2021-01-27', 0.8864366140951857], ['2021-01-28', 0.8845759397275269],
                                      ['2021-01-29', 0.8898805771751356], ['2021-02-01', 0.8920000543343564],
                                      ['2021-02-02', 0.9019976775814598], ['2021-02-03', 0.9029180582695069],
                                      ['2021-02-04', 0.9070217939463278], ['2021-02-05', 0.9007086970184902],
                                      ['2021-02-08', 0.9030258129623466], ['2021-02-09', 0.9032264783085702],
                                      ['2021-02-10', 0.9030829600702234], ['2021-02-11', 0.9010523188673754],
                                      ['2021-02-12', 0.9001497414661194], ['2021-02-15', 0.8972232205299802],
                                      ['2021-02-16', 0.897594089152695], ['2021-02-17', 0.8982148727150193],
                                      ['2021-02-18', 0.8998472164172846], ['2021-02-19', 0.8982607278993444],
                                      ['2021-02-22', 0.8921722036271721], ['2021-02-23', 0.8898626754094953],
                                      ['2021-02-24', 0.8947739256523193], ['2021-02-25', 0.8987596973059994],
                                      ['2021-02-26', 0.9134643435214955], ['2021-03-01', 0.918993929754835],
                                      ['2021-03-02', 0.9157408336361909], ['2021-03-03', 0.915275687497752],
                                      ['2021-03-04', 0.9186455889944436], ['2021-03-05', 0.9145426609376325],
                                      ['2021-03-08', 0.9134714758069424], ['2021-03-09', 0.9086630053014179],
                                      ['2021-03-10', 0.9120223954384556], ['2021-03-11', 0.9130148169582306],
                                      ['2021-03-12', 0.914739719013808], ['2021-03-15', 0.928463943323836],
                                      ['2021-03-16', 0.933583077072683], ['2021-03-17', 0.9330716807868986],
                                      ['2021-03-18', 0.9288147179435885], ['2021-03-19', 0.9303048507822332],
                                      ['2021-03-22', 0.9503491605860712], ['2021-03-23', 0.9543301426608973],
                                      ['2021-03-24', 0.9562100276004051], ['2021-03-25', 0.9558902159462764],
                                      ['2021-03-26', 0.9421183812187457], ['2021-03-29', 0.9304297698582624],
                                      ['2021-03-30', 0.9255377724225964], ['2021-03-31', 0.9288788520748432],
                                      ['2021-04-01', 0.9255245811924869], ['2021-04-02', 0.9253057356272613],
                                      ['2021-04-05', 0.9110845996065523], ['2021-04-06', 0.9125537209614435],
                                      ['2021-04-07', 0.9092805473148023], ['2021-04-08', 0.9106842967282306],
                                      ['2021-04-09', 0.9065743602103377], ['2021-04-12', 0.9064120996162333],
                                      ['2021-04-13', 0.9080039410233919], ['2021-04-14', 0.9058324442791906],
                                      ['2021-04-15', 0.9012633679437755], ['2021-04-16', 0.8817266337950646],
                                      ['2021-04-19', 0.879870971242904], ['2021-04-20', 0.8941573383350782],
                                      ['2021-04-21', 0.887962814825184], ['2021-04-22', 0.8883257914187292],
                                      ['2021-04-23', 0.8982033834669962], ['2021-04-26', 0.8978600104298144],
                                      ['2021-04-27', 0.8927525434765888], ['2021-04-28', 0.8906790878648955],
                                      ['2021-04-29', 0.8850838636802095], ['2021-04-30', 0.8752084867429241],
                                      ['2021-05-03', 0.8772331412633768], ['2021-05-04', 0.8720331661943858],
                                      ['2021-05-05', 0.8671463406412616], ['2021-05-06', 0.8823932789430973],
                                      ['2021-05-07', 0.8839329350180696], ['2021-05-10', 0.8866611547123624],
                                      ['2021-05-11', 0.8809173134162849], ['2021-05-12', 0.8872869281730444],
                                      ['2021-05-13', 0.8869823508564784], ['2021-05-14', 0.8953095635961708],
                                      ['2021-05-17', 0.8900795744712166], ['2021-05-18', 0.8932618180743701],
                                      ['2021-05-19', 0.8948100995042912], ['2021-05-20', 0.8934110525145609],
                                      ['2021-05-21', 0.894275704465274], ['2021-05-24', 0.8862129378804093],
                                      ['2021-05-25', 0.8887466640145859], ['2021-05-26', 0.8922999893294049],
                                      ['2021-05-27', 0.9071416941600038], ['2021-05-28', 0.9203476398072666],
                                      ['2021-05-31', 0.9190730350667695], ['2021-06-01', 0.9102728877414129],
                                      ['2021-06-02', 0.9132534478383805], ['2021-06-03', 0.9088133196000899],
                                      ['2021-06-04', 0.9156681278113125], ['2021-06-07', 0.9156223123920523],
                                      ['2021-06-08', 0.9145856716019339], ['2021-06-09', 0.9168585582176089],
                                      ['2021-06-10', 0.9163403851492076], ['2021-06-11', 0.9144967572849609],
                                      ['2021-06-14', 0.9141431719872722], ['2021-06-15', 0.9147777043798121],
                                      ['2021-06-16', 0.915538259640843], ['2021-06-17', 0.9303937239900952],
                                      ['2021-06-18', 0.9390592485374359], ['2021-06-21', 0.9373116830433493],
                                      ['2021-06-22', 0.9427449880436689], ['2021-06-23', 0.9407084724464195],
                                      ['2021-06-24', 0.9394464162725222], ['2021-06-25', 0.9280066991265317],
                                      ['2021-06-28', 0.9265038781758507], ['2021-06-29', 0.9275818290399418],
                                      ['2021-06-30', 0.9255991162602577], ['2021-07-01', 0.9138966034117193],
                                      ['2021-07-02', 0.9146142973869088], ['2021-07-05', 0.9181022970358077],
                                      ['2021-07-06', 0.9074933619483999], ['2021-07-07', 0.902025125731612],
                                      ['2021-07-08', 0.907076026609854], ['2021-07-09', 0.9174277412353735],
                                      ['2021-07-12', 0.9192217122691708], ['2021-07-13', 0.9155688050636652],
                                      ['2021-07-14', 0.914511919994974], ['2021-07-15', 0.9072827624461118],
                                      ['2021-07-16', 0.9147251729875863], ['2021-07-19', 0.9193336264588486],
                                      ['2021-07-20', 0.925798773703205], ['2021-07-21', 0.9267409583789746],
                                      ['2021-07-22', 0.9246635419626583], ['2021-07-23', 0.9235962637255246],
                                      ['2021-07-26', 0.9187195464946155], ['2021-07-27', 0.9179631491889088],
                                      ['2021-07-28', 0.9169395326411997], ['2021-07-29', 0.9174199380790581],
                                      ['2021-07-30', 0.9176683013254561], ['2021-08-02', 0.92034668699813],
                                      ['2021-08-03', 0.9207308184465794], ['2021-08-04', 0.9241614525891176],
                                      ['2021-08-05', 0.9252544039117194], ['2021-08-06', 0.9257068761979128],
                                      ['2021-08-09', 0.9269338494497388], ['2021-08-10', 0.9279078169690388],
                                      ['2021-08-11', 0.9320239670516519], ['2021-08-12', 0.9336249338456267],
                                      ['2021-08-13', 0.9340825531336873], ['2021-08-16', 0.9337740851496074],
                                      ['2021-08-17', 0.9352358574622675], ['2021-08-18', 0.9372444096991827],
                                      ['2021-08-19', 0.9298764811116637], ['2021-08-20', 0.9262131482920518],
                                      ['2021-08-23', 0.9276585645717137], ['2021-08-24', 0.92856395669229],
                                      ['2021-08-25', 0.9271659353349381], ['2021-08-26', 0.9366798112705848],
                                      ['2021-08-27', 0.939469558627736], ['2021-08-30', 0.939741517191791],
                                      ['2021-08-31', 0.9416728966796483], ['2021-09-01', 0.9523441724282465],
                                      ['2021-09-02', 0.9517066086773255], ['2021-09-03', 0.9520676724175039],
                                      ['2021-09-06', 0.9609901628723267], ['2021-09-07', 0.9600864061003563],
                                      ['2021-09-08', 0.9558863980743179], ['2021-09-09', 0.948472236169008],
                                      ['2021-09-10', 0.946294665243798], ['2021-09-13', 0.9452172483227433],
                                      ['2021-09-14', 0.9466756455002099], ['2021-09-15', 0.937395558117138],
                                      ['2021-09-16', 0.931622601567483], ['2021-09-17', 0.9210569221798822],
                                      ['2021-09-20', 0.9284521728561184], ['2021-09-21', 0.9272930667016914],
                                      ['2021-09-22', 0.9352279628015158], ['2021-09-23', 0.9315300597142235],
                                      ['2021-09-24', 0.936758446681233]], 'trackingError': 0.09724809864706382,
              'lassoWeight': 0,
              'constituents': [
                  {'country': 'United States', 'name': 'Dentsply Sirona Inc', 'transactionCost': 2.9051536321640015,
                   'sector': 'Health Care', 'correlation': 0.16678359890783784, 'shares': -5.308036491917078,
                   'assetId': 'MA4B66MW5E27UANZH4M', 'bbid': 'XRAY UW', 'currency': 'USD',
                   'industry': 'Health Care Equipment & Supplies', 'marginalCost': 0.03895858954426313,
                   'advPercentage': 5e-06, 'notional': -318.5352698799438, 'price': 60.01,
                   'weight': 0.013410164995385637,
                   'borrowCost': 40},
                  {'country': 'United States', 'name': 'Extra Space Storage Inc', 'transactionCost': 3.9990124702453613,
                   'sector': 'Real Estate', 'correlation': 0.06540203064772898, 'shares': -3.1030213327842304,
                   'assetId': 'MA4B66MW5E27UAFU2CS', 'bbid': 'EXR UN', 'currency': 'USD',
                   'industry': 'Equity Real Estate Investment Trusts (REITs)', 'marginalCost': 0.09017373674086719,
                   'advPercentage': 5e-06, 'notional': -535.6125122518861, 'price': 172.61,
                   'weight': 0.02254900113760699,
                   'borrowCost': 40},
                  {'country': 'United States', 'name': 'Kroger Co', 'transactionCost': 1.2731897830963135,
                   'sector': 'Consumer Staples', 'correlation': 0.12350867819558603,
                   'shares': -1.730011893560012, 'assetId': 'MA4B66MW5E27UAKNZNV', 'bbid': 'KR UN',
                   'currency': 'USD', 'industry': 'Food & Staples Retailing',
                   'marginalCost': 0.003707333181127408, 'advPercentage': 0,
                   'notional': -69.16587550452927, 'price': 39.98, 'weight': 0.002911846474381391,
                   'borrowCost': 40},
                  {'country': 'United States', 'name': 'MSCI Inc', 'transactionCost': 7.908167362213135,
                   'sector': 'Financials', 'correlation': 0.24284241634131032, 'shares': -0.5740039461869635,
                   'assetId': 'MA4B66MW5E27UAL9SUH', 'bbid': 'MSCI UN', 'currency': 'USD',
                   'industry': 'Capital Markets',
                   'marginalCost': 0.1263897386589486, 'advPercentage': 2e-06, 'notional': -379.628989889672,
                   'price': 661.37,
                   'weight': 0.01598217802810611, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'General Motors Co', 'transactionCost': 1.0103281140327454,
                   'sector': 'Consumer Discretionary', 'correlation': 0.5028570129890573, 'shares': -3.0290208240423557,
                   'assetId': 'MA4B66MW5E27UAGYYVE', 'bbid': 'GM UN', 'currency': 'USD', 'industry': 'Automobiles',
                   'marginalCost': 0.006729167173415375, 'advPercentage': 0, 'notional': -158.20575763973224,
                   'price': 52.23,
                   'weight': 0.0066603780296242265, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Mosaic Co/the', 'transactionCost': 2.1279181241989136,
                   'sector': 'Materials', 'correlation': 0.6130275473664366, 'shares': -5.192035694429817,
                   'assetId': 'MA4B66MW5E27UAL9SLW', 'bbid': 'MOS UN', 'currency': 'USD', 'industry': 'Chemicals',
                   'marginalCost': 0.016679363095866095, 'advPercentage': 2e-06, 'notional': -186.18640000225324,
                   'price': 35.86, 'weight': 0.007838348151738823, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Meta Platforms Inc-Class A',
                   'transactionCost': 0.8238705992698669,
                   'sector': 'Communication Services', 'correlation': 0.12666374147291945,
                   'shares': -0.7130049017966985,
                   'assetId': 'MA4B66MW5E3VLSECN', 'bbid': 'FB UW', 'currency': 'USD',
                   'industry': 'Interactive Media & Services', 'marginalCost': 0.008728781169081446, 'advPercentage': 0,
                   'notional': -251.6622101381627, 'price': 352.96, 'weight': 0.010594844841917037, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Twitter Inc', 'transactionCost': 1.2658634781837463,
                   'sector': 'Communication Services', 'correlation': 0.15422853187220908, 'shares': -8.874061007775461,
                   'assetId': 'MA4B66MW5E27UANLXU9', 'bbid': 'TWTR UN', 'currency': 'USD',
                   'industry': 'Interactive Media & Services', 'marginalCost': 0.03178955019863404,
                   'advPercentage': 1e-06,
                   'notional': -596.5143809426665, 'price': 67.22, 'weight': 0.025112937332109075, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Paypal Holdings Inc', 'transactionCost': 1.4358487129211426,
                   'sector': 'Information Technology', 'correlation': 0.22583565660778615,
                   'shares': -0.5480037674398188,
                   'assetId': 'MA4B66MW5E27UAM94N9', 'bbid': 'PYPL UW', 'currency': 'USD', 'industry': 'IT Services',
                   'marginalCost': 0.009212668138339708, 'advPercentage': 0, 'notional': -152.40532776268802,
                   'price': 278.11,
                   'weight': 0.006416183025018788, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Hormel Foods Corp', 'transactionCost': 1.4352393746376038,
                   'sector': 'Consumer Staples', 'correlation': -0.03313295634963935, 'shares': -11.239077266890737,
                   'assetId': 'MA4B66MW5E27UAJ5XEZ', 'bbid': 'HRL UN', 'currency': 'USD', 'industry': 'Food Products',
                   'marginalCost': 0.027707143568185242, 'advPercentage': 4e-06, 'notional': -458.55435248914205,
                   'price': 40.8, 'weight': 0.019304893704704323, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Nucor Corp', 'transactionCost': 3.182479500770569,
                   'sector': 'Materials', 'correlation': 0.556129972455637, 'shares': -0.7970054792874738,
                   'assetId': 'MA4B66MW5E27UALNB48', 'bbid': 'NUE UN', 'currency': 'USD', 'industry': 'Metals & Mining',
                   'marginalCost': 0.010776575069254387, 'advPercentage': 0, 'notional': -80.43379296969185,
                   'price': 100.92,
                   'weight': 0.0033862197907779373, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Wells Fargo & Co', 'transactionCost': 1.3822112533240394,
                   'sector': 'Financials', 'correlation': 0.6178643696685713, 'shares': -43.79430107894055,
                   'assetId': 'MA4B66MW5E27UANT8X5', 'bbid': 'WFC UN', 'currency': 'USD', 'industry': 'Banks',
                   'marginalCost': 0.12211961551022109, 'advPercentage': 2e-06, 'notional': -2098.622907702831,
                   'price': 47.92, 'weight': 0.0883509052733721, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Cummins Inc', 'transactionCost': 3.3661617040634155,
                   'sector': 'Industrials', 'correlation': 0.6412824675287682, 'shares': -0.4130028393296445,
                   'assetId': 'MA4B66MW5E27UACX6RZ', 'bbid': 'CMI UN', 'currency': 'USD', 'industry': 'Machinery',
                   'marginalCost': 0.013324512800464238, 'advPercentage': 0, 'notional': -94.02422640178686,
                   'price': 227.66,
                   'weight': 0.003958369790845086, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'JPMorgan Chase & Co', 'transactionCost': 1.2586397729172192,
                   'sector': 'Financials', 'correlation': 0.8505015474586123, 'shares': -12.604086651115832,
                   'assetId': 'MA4B66MW5E27UAKHZFD', 'bbid': 'JPM UN', 'currency': 'USD', 'industry': 'Banks',
                   'marginalCost': 0.10888889555559653, 'advPercentage': 1e-06, 'notional': -2054.970287597925,
                   'price': 163.04, 'weight': 0.08651315324576048, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Lumen Technologies Inc', 'transactionCost': 3.95284104347229,
                   'sector': 'Communication Services', 'correlation': 0.35956668091011157, 'shares': -11.81608123370237,
                   'assetId': 'MAQQM1QHGJDFAVKN', 'bbid': 'LUMN UN', 'currency': 'USD',
                   'industry': 'Diversified Telecommunication Services', 'marginalCost': 0.02542482298207395,
                   'advPercentage': 1e-06, 'notional': -152.78193035177165, 'price': 12.93,
                   'weight': 0.00643203779318686,
                   'borrowCost': 40},
                  {'country': 'United States', 'name': 'Advanced Micro Devices', 'transactionCost': 0.5830498039722443,
                   'sector': 'Information Technology', 'correlation': 0.12884947696795268,
                   'shares': -0.8120055824108264,
                   'assetId': 'MA4B66MW5E27U9YGMB9', 'bbid': 'AMD UW', 'currency': 'USD',
                   'industry': 'Semiconductors & Semiconductor Equipment', 'marginalCost': 0.0021087589119167267,
                   'advPercentage': 0, 'notional': -85.91019061906543, 'price': 105.8, 'weight': 0.003616773211396386,
                   'borrowCost': 40},
                  {'country': 'United States', 'name': 'Morgan Stanley', 'transactionCost': 2.3784881788491172,
                   'sector': 'Financials', 'correlation': 0.9121008220093567, 'shares': -100.16368860962515,
                   'assetId': 'MA4B66MW5E27UAL9STW', 'bbid': 'MS UN', 'currency': 'USD', 'industry': 'Capital Markets',
                   'marginalCost': 1.0321563281719852, 'advPercentage': 1.6e-05, 'notional': -10307.845194816524,
                   'price': 102.91, 'weight': 0.43395478579650393, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Citigroup Inc', 'transactionCost': 1.4510516652072596,
                   'sector': 'Financials', 'correlation': 0.8189307897328992, 'shares': -27.227187182634943,
                   'assetId': 'MA4B66MW5E27UA4ZCWT', 'bbid': 'C UN', 'currency': 'USD', 'industry': 'Banks',
                   'marginalCost': 0.11839142047698586, 'advPercentage': 2e-06, 'notional': -1938.0311836599553,
                   'price': 71.18, 'weight': 0.08159007933054924, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Duke Realty Corp', 'transactionCost': 1.3627572059631348,
                   'sector': 'Real Estate', 'correlation': 0.1248871579141672, 'shares': -8.864060939026558,
                   'assetId': 'MA4B66MW5E27UAEP46J', 'bbid': 'DRE UN', 'currency': 'USD',
                   'industry': 'Equity Real Estate Investment Trusts (REITs)', 'marginalCost': 0.02484233322743233,
                   'advPercentage': 5e-06, 'notional': -433.0093768714474, 'price': 48.85, 'weight': 0.0182294638536693,
                   'borrowCost': 40},
                  {'country': 'United States', 'name': 'Electronic Arts Inc', 'transactionCost': 2.1669615507125854,
                   'sector': 'Communication Services', 'correlation': 0.18457789391303997, 'shares': -6.899047429867354,
                   'assetId': 'MA4B66MW5E27UAEP4H9', 'bbid': 'EA UW', 'currency': 'USD', 'industry': 'Entertainment',
                   'marginalCost': 0.08175721364539484, 'advPercentage': 3e-06, 'notional': -896.1862611397693,
                   'price': 129.9, 'weight': 0.037728963681201336, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Qualcomm Inc', 'transactionCost': 1.0424676537513733,
                   'sector': 'Information Technology', 'correlation': 0.37498752971441385,
                   'shares': -0.6250042968063627,
                   'assetId': 'MA4B66MW5E27UAM94Q4', 'bbid': 'QCOM UW', 'currency': 'USD',
                   'industry': 'Semiconductors & Semiconductor Equipment', 'marginalCost': 0.0036722977768481185,
                   'advPercentage': 0, 'notional': -83.67557525643583, 'price': 133.88, 'weight': 0.00352269709629183,
                   'borrowCost': 40},
                  {'country': 'United States', 'name': 'Albemarle Corp', 'transactionCost': 5.661775350570679,
                   'sector': 'Materials', 'correlation': 0.572692690460937, 'shares': -2.9210200815542167,
                   'assetId': 'MA4B66MW5E27U9XPVYM', 'bbid': 'ALB UN', 'currency': 'USD', 'industry': 'Chemicals',
                   'marginalCost': 0.157630478243818, 'advPercentage': 2e-06, 'notional': -661.3189464638747,
                   'price': 226.4,
                   'weight': 0.027841174981965627, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Tractor Supply Company', 'transactionCost': 3.904104232788086,
                   'sector': 'Consumer Discretionary', 'correlation': 0.07218103540747003,
                   'shares': -0.49000336869618827,
                   'assetId': 'MA4B66MW5E27UANEQ5C', 'bbid': 'TSCO UW', 'currency': 'USD',
                   'industry': 'Specialty Retail',
                   'marginalCost': 0.016970819801319783, 'advPercentage': 1e-06, 'notional': -103.2535098516608,
                   'price': 210.72, 'weight': 0.004346917702348384, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Davita Inc', 'transactionCost': 3.084942579269409,
                   'sector': 'Health Care', 'correlation': 0.20287653627709595, 'shares': -3.4880239796169494,
                   'assetId': 'MA4B66MW5E27UAEP4D8', 'bbid': 'DVA UN', 'currency': 'USD',
                   'industry': 'Health Care Providers & Services', 'marginalCost': 0.05481362341943657,
                   'advPercentage': 6e-06, 'notional': -422.05090153365086, 'price': 121, 'weight': 0.01776811788581744,
                   'borrowCost': 40},
                  {'country': 'United States', 'name': 'Citrix Systems Inc', 'transactionCost': 2.754676938056946,
                   'sector': 'Information Technology', 'correlation': -0.014004050045478335,
                   'shares': -2.204015152257958,
                   'assetId': 'MA4B66MW5E27UAE4LLL', 'bbid': 'CTXS UW', 'currency': 'USD', 'industry': 'Software',
                   'marginalCost': 0.028164628476876532, 'advPercentage': 2e-06, 'notional': -242.86042962730437,
                   'price': 110.19, 'weight': 0.010224294576170117, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Best Buy Co Inc', 'transactionCost': 2.401727557182312,
                   'sector': 'Consumer Discretionary', 'correlation': 0.45583415490693957, 'shares': -4.535031177626968,
                   'assetId': 'MA4B66MW5E27UA39J2L', 'bbid': 'BBY UN', 'currency': 'USD',
                   'industry': 'Specialty Retail',
                   'marginalCost': 0.04802785408186685, 'advPercentage': 2e-06, 'notional': -474.99916554464863,
                   'price': 104.74, 'weight': 0.019997211564750816, 'borrowCost': 40},
                  {'country': 'United States', 'name': 'Iron Mountain Inc', 'transactionCost': 2.417732357978821,
                   'sector': 'Real Estate', 'correlation': 0.4856832268445906, 'shares': -5.0810349313170065,
                   'assetId': 'MA4B66MW5E27UAJQF4M', 'bbid': 'IRM UN', 'currency': 'USD',
                   'industry': 'Equity Real Estate Investment Trusts (REITs)', 'marginalCost': 0.02289530957940409,
                   'advPercentage': 3e-06, 'notional': -224.93741640940388, 'price': 44.27,
                   'weight': 0.009469745277572472,
                   'borrowCost': 40},
                  {'country': 'United States', 'name': 'Tapestry Inc', 'transactionCost': 2.314427137374878,
                   'sector': 'Consumer Discretionary', 'correlation': 0.6555947816398136, 'shares': -7.397050853562664,
                   'assetId': 'MAAHJ4JYCKZ6P025', 'bbid': 'TPR UN', 'currency': 'USD',
                   'industry': 'Textiles, Apparel & Luxury Goods', 'marginalCost': 0.02844040606854561,
                   'advPercentage': 2e-06, 'notional': -291.88762668158273, 'price': 39.46,
                   'weight': 0.01228831342722845,
                   'borrowCost': 40}], 'holdingError': 0.0744447922751884}, 'benchmarks': [],
    'target': {'annualizedVolatility': 0.2245953385486387,
               'backtestPerformance': [['2020-09-24', 1], ['2020-09-25', 1.0076306394460186],
                                       ['2020-09-28', 1.0295511006061422], ['2020-09-29', 1.0186692133468813],
                                       ['2020-09-30', 1.0388739557814626], ['2020-10-01', 1.0312010109422116],
                                       ['2020-10-02', 1.028915736274446], ['2020-10-05', 1.04359570772614],
                                       ['2020-10-06', 1.0339555621015752], ['2020-10-07', 1.0478951891716997],
                                       ['2020-10-08', 1.0651714582747391], ['2020-10-09', 1.067487286837617],
                                       ['2020-10-12', 1.1089121011443612], ['2020-10-13', 1.0889651082352152],
                                       ['2020-10-14', 1.0908265455374473], ['2020-10-15', 1.0793406312748108],
                                       ['2020-10-16', 1.066348958386379], ['2020-10-19', 1.0580790374426237],
                                       ['2020-10-20', 1.070545026648481], ['2020-10-21', 1.0487843858627914],
                                       ['2020-10-22', 1.0564518466695865], ['2020-10-23', 1.0535672455976932],
                                       ['2020-10-26', 1.0380051283537797], ['2020-10-27', 1.0193468830718104],
                                       ['2020-10-28', 0.9847340205087146], ['2020-10-29', 0.9938053936242638],
                                       ['2020-10-30', 0.977050891037759], ['2020-11-02', 0.9815023585256727],
                                       ['2020-11-03', 1.0157893128742363], ['2020-11-04', 1.0247361201097123],
                                       ['2020-11-05', 1.053383922227019], ['2020-11-06', 1.0458990013576899],
                                       ['2020-11-09', 1.0956900988927742], ['2020-11-10', 1.1051257684500482],
                                       ['2020-11-11', 1.114613144599051], ['2020-11-12', 1.0998987020862043],
                                       ['2020-11-13', 1.118260026182338], ['2020-11-16', 1.133563610467608],
                                       ['2020-11-17', 1.1407798137465894], ['2020-11-18', 1.1366111656467677],
                                       ['2020-11-19', 1.1389324782421015], ['2020-11-20', 1.1314099525787882],
                                       ['2020-11-23', 1.1461964709467716], ['2020-11-24', 1.1835262798752466],
                                       ['2020-11-25', 1.1814423475419396], ['2020-11-26', 1.1814423475419396],
                                       ['2020-11-27', 1.1780281456214312], ['2020-11-30', 1.163780629300559],
                                       ['2020-12-01', 1.1772494130126692], ['2020-12-02', 1.2002376936353105],
                                       ['2020-12-03', 1.191242313540938], ['2020-12-04', 1.2062583778388682],
                                       ['2020-12-07', 1.2047988417723452], ['2020-12-08', 1.207640354017798],
                                       ['2020-12-09', 1.2182464727878393], ['2020-12-10', 1.2275332900355913],
                                       ['2020-12-11', 1.2082224448913497], ['2020-12-14', 1.1981490607027552],
                                       ['2020-12-15', 1.2291134748161479], ['2020-12-16', 1.2343248725158311],
                                       ['2020-12-17', 1.2387747731373286], ['2020-12-18', 1.2254195872403797],
                                       ['2020-12-21', 1.287961060235829], ['2020-12-22', 1.2678667818835767],
                                       ['2020-12-23', 1.2914042491850333], ['2020-12-24', 1.292302847074621],
                                       ['2020-12-25', 1.292302847074621], ['2020-12-28', 1.315621736511042],
                                       ['2020-12-29', 1.3056016257805925], ['2020-12-30', 1.3090126939682685],
                                       ['2020-12-31', 1.3239355297144455], ['2021-01-01', 1.3239355297144455],
                                       ['2021-01-04', 1.3224086183920336], ['2021-01-05', 1.3493610710472062],
                                       ['2021-01-06', 1.3987925727398136], ['2021-01-07', 1.4319647016333785],
                                       ['2021-01-08', 1.4279934787019752], ['2021-01-11', 1.4367232749388321],
                                       ['2021-01-12', 1.469838996641421], ['2021-01-13', 1.4770128945271697],
                                       ['2021-01-14', 1.4926776415213325], ['2021-01-15', 1.4616630876826273],
                                       ['2021-01-18', 1.4616630876826273], ['2021-01-19', 1.4358591481103977],
                                       ['2021-01-20', 1.4295109888258917], ['2021-01-21', 1.4349746520185538],
                                       ['2021-01-22', 1.439535800155589], ['2021-01-25', 1.4220064821263625],
                                       ['2021-01-26', 1.4173810924662704], ['2021-01-27', 1.3814583295793816],
                                       ['2021-01-28', 1.3780872164853137], ['2021-01-29', 1.3522550733175958],
                                       ['2021-02-01', 1.3709195860652295], ['2021-02-02', 1.4215560080317566],
                                       ['2021-02-03', 1.4257301401640343], ['2021-02-04', 1.4535341847163137],
                                       ['2021-02-05', 1.4512520437813807], ['2021-02-08', 1.4781277199821679],
                                       ['2021-02-09', 1.4775330941772888], ['2021-02-10', 1.4915330456044296],
                                       ['2021-02-11', 1.4831722464085457], ['2021-02-12', 1.4996431461737505],
                                       ['2021-02-15', 1.4996431461737505], ['2021-02-16', 1.5177373195459527],
                                       ['2021-02-17', 1.5160670399464755], ['2021-02-18', 1.5024180665965226],
                                       ['2021-02-19', 1.5255982883551262], ['2021-02-22', 1.5227097701171932],
                                       ['2021-02-23', 1.5317740923338705], ['2021-02-24', 1.5764039318945835],
                                       ['2021-02-25', 1.5560158660893277], ['2021-02-26', 1.5234830186934991],
                                       ['2021-03-01', 1.5784972654263867], ['2021-03-02', 1.577134091644449],
                                       ['2021-03-03', 1.5848454247108927], ['2021-03-04', 1.56037723875832],
                                       ['2021-03-05', 1.5553334957651503], ['2021-03-08', 1.5722760223215777],
                                       ['2021-03-09', 1.5675166655829158], ['2021-03-10', 1.6109345339708374],
                                       ['2021-03-11', 1.6152872888745418], ['2021-03-12', 1.6402028151888879],
                                       ['2021-03-15', 1.6352045113217835], ['2021-03-16', 1.6210823443141926],
                                       ['2021-03-17', 1.6323778843072827], ['2021-03-18', 1.6359479894361848],
                                       ['2021-03-19', 1.619665113640902], ['2021-03-22', 1.6071325326123638],
                                       ['2021-03-23', 1.5751950944546225], ['2021-03-24', 1.5577386357137408],
                                       ['2021-03-25', 1.5663485666697723], ['2021-03-26', 1.5549856514207931],
                                       ['2021-03-29', 1.5487197526231282], ['2021-03-30', 1.5707765311614452],
                                       ['2021-03-31', 1.5553421135304377], ['2021-04-01', 1.5596306269110851],
                                       ['2021-04-02', 1.5596306269110851], ['2021-04-05', 1.5491561249199899],
                                       ['2021-04-06', 1.5638517650358437], ['2021-04-07', 1.565256460777806],
                                       ['2021-04-08', 1.5886066875425475], ['2021-04-09', 1.5926554703615445],
                                       ['2021-04-12', 1.593196039275071], ['2021-04-13', 1.5830725153611647],
                                       ['2021-04-14', 1.608829448940914], ['2021-04-15', 1.6266462869574803],
                                       ['2021-04-16', 1.6409768471984019], ['2021-04-19', 1.6454784544116277],
                                       ['2021-04-20', 1.5971649119068507], ['2021-04-21', 1.61150408991306],
                                       ['2021-04-22', 1.5906663334464066], ['2021-04-23', 1.6294760477048125],
                                       ['2021-04-26', 1.6469520922758942], ['2021-04-27', 1.6587059406956703],
                                       ['2021-04-28', 1.6629693842136615], ['2021-04-29', 1.6821838670733185],
                                       ['2021-04-30', 1.6600095735537992], ['2021-05-03', 1.6690417750089481],
                                       ['2021-05-04', 1.6582100274749996], ['2021-05-05', 1.6898043218876324],
                                       ['2021-05-06', 1.726507384249699], ['2021-05-07', 1.7471226456852775],
                                       ['2021-05-10', 1.7314484974926188], ['2021-05-11', 1.6945331247311817],
                                       ['2021-05-12', 1.6660819643490854], ['2021-05-13', 1.6881833985802592],
                                       ['2021-05-14', 1.7330302491395915], ['2021-05-17', 1.7325445205506251],
                                       ['2021-05-18', 1.7109131462442573], ['2021-05-19', 1.6858949901796618],
                                       ['2021-05-20', 1.6968254502978186], ['2021-05-21', 1.7188869294353843],
                                       ['2021-05-24', 1.730399480427093], ['2021-05-25', 1.7148890697749082],
                                       ['2021-05-26', 1.7263342455107282], ['2021-05-27', 1.738998443318212],
                                       ['2021-05-28', 1.7402307837544118], ['2021-05-31', 1.7402307837544118],
                                       ['2021-06-01', 1.7811918056020137], ['2021-06-02', 1.7867761175087098],
                                       ['2021-06-03', 1.8047762788959507], ['2021-06-04', 1.820470796352018],
                                       ['2021-06-07', 1.8073459398182243], ['2021-06-08', 1.795232495555971],
                                       ['2021-06-09', 1.7883555188560583], ['2021-06-10', 1.750957551238487],
                                       ['2021-06-11', 1.7699048833742117], ['2021-06-14', 1.7557834997998292],
                                       ['2021-06-15', 1.7475997565089554], ['2021-06-16', 1.7474399361345212],
                                       ['2021-06-17', 1.7128231564053855], ['2021-06-18', 1.6594909407700957],
                                       ['2021-06-21', 1.698039771770234], ['2021-06-22', 1.7014218529292136],
                                       ['2021-06-23', 1.71491570650398], ['2021-06-24', 1.7450904199436985],
                                       ['2021-06-25', 1.7445592522286677], ['2021-06-28', 1.7477211886561963],
                                       ['2021-06-29', 1.7665008660854071], ['2021-06-30', 1.795393099363613],
                                       ['2021-07-01', 1.7778849340310026], ['2021-07-02', 1.7800479931183184],
                                       ['2021-07-05', 1.7800479931183184], ['2021-07-06', 1.7670633711287582],
                                       ['2021-07-07', 1.7635073677976], ['2021-07-08', 1.7259174590440662],
                                       ['2021-07-09', 1.7809489413075301], ['2021-07-12', 1.8146271680534696],
                                       ['2021-07-13', 1.798889561770962], ['2021-07-14', 1.7997262684371165],
                                       ['2021-07-15', 1.7941662429598688], ['2021-07-16', 1.75574746187226],
                                       ['2021-07-19', 1.7074472377320196], ['2021-07-20', 1.755098779176028],
                                       ['2021-07-21', 1.7884918362342517], ['2021-07-22', 1.7881870807163354],
                                       ['2021-07-23', 1.7971260536197318], ['2021-07-26', 1.8053936242638626],
                                       ['2021-07-27', 1.7966364078647248], ['2021-07-28', 1.790553049004526],
                                       ['2021-07-29', 1.805162511467499], ['2021-07-30', 1.7949426252690068],
                                       ['2021-08-02', 1.807475206297545], ['2021-08-03', 1.8198934060777137],
                                       ['2021-08-04', 1.8090694928758457], ['2021-08-05', 1.835024635057221],
                                       ['2021-08-06', 1.8874496350376353], ['2021-08-09', 1.895298852348689],
                                       ['2021-08-10', 1.9266244291709742], ['2021-08-11', 1.9508074454358313],
                                       ['2021-08-12', 1.9614143476390804], ['2021-08-13', 1.9449810526678597],
                                       ['2021-08-16', 1.939386556129459], ['2021-08-17', 1.9239873929928122],
                                       ['2021-08-18', 1.8915336723509921], ['2021-08-19', 1.8713297133496192],
                                       ['2021-08-20', 1.8835544051274093], ['2021-08-23', 1.9089454753990176],
                                       ['2021-08-24', 1.937170223583999], ['2021-08-25', 1.952823219080041],
                                       ['2021-08-26', 1.9483161278343588], ['2021-08-27', 1.9795625779026347],
                                       ['2021-08-30', 1.964436832955583], ['2021-08-31', 1.96144960213344],
                                       ['2021-09-01', 1.9634340384493298], ['2021-09-02', 1.969112362340987],
                                       ['2021-09-03', 1.9576906896014072], ['2021-09-06', 1.9576906896014072],
                                       ['2021-09-07', 1.958603389288739], ['2021-09-08', 1.9341289358705023],
                                       ['2021-09-09', 1.9303324185444852], ['2021-09-10', 1.915549033909334],
                                       ['2021-09-13', 1.939824495292736], ['2021-09-14', 1.9146567034854105],
                                       ['2021-09-15', 1.9095581201676801], ['2021-09-16', 1.8880129235141936],
                                       ['2021-09-17', 1.8615955557400916], ['2021-09-20', 1.8019802057765602],
                                       ['2021-09-21', 1.7938285832472152], ['2021-09-22', 1.8372347001370162],
                                       ['2021-09-23', 1.8647621927668683], ['2021-09-24', 1.8609100516830828]],
               'constituents': [{'country': 'United States', 'name': 'Apple Inc', 'transactionCost': 1.1936100899058002,
                                 'sector': 'Information Technology', 'shares': 26, 'assetId': 'MA4B66MW5E27U9VBB94',
                                 'bbid': 'AAPL UW', 'currency': 'USD',
                                 'industry': 'Technology Hardware, Storage & Peripherals',
                                 'marginalCost': 0.19195231034013271, 'advPercentage': 0,
                                 'notional': 3819.9199999999996, 'price': 146.92, 'weight': 0.16081659493619194,
                                 'borrowCost': 40},
                                {'country': 'United States', 'name': 'The Goldman Sachs Group, Inc.',
                                 'transactionCost': 3.2194154492372298, 'sector': 'Financials', 'shares': 51,
                                 'assetId': 'MA4B66MW5E27UAHKG34', 'bbid': 'GS UN', 'currency': 'USD',
                                 'industry': 'Capital Markets', 'marginalCost': 2.701680019005928,
                                 'advPercentage': 2.3e-05, 'notional': 19933.350000000002, 'price': 390.85,
                                 'weight': 0.8391834050638082, 'borrowCost': 40}], 'assetId': '',
               'transactionCost': 2.893632329346061, 'annualizedReturn': 0.861701827815391}}

mock_results = {'Portfolio': {'Annualized Volatility': 0.2245953385486387,
                              'Backtest Performance': [['2020-09-24', 1], ['2020-09-25', 1.0076306394460186],
                                                       ['2020-09-28', 1.0295511006061422],
                                                       ['2020-09-29', 1.0186692133468813],
                                                       ['2020-09-30', 1.0388739557814626],
                                                       ['2020-10-01', 1.0312010109422116],
                                                       ['2020-10-02', 1.028915736274446],
                                                       ['2020-10-05', 1.04359570772614],
                                                       ['2020-10-06', 1.0339555621015752],
                                                       ['2020-10-07', 1.0478951891716997],
                                                       ['2020-10-08', 1.0651714582747391],
                                                       ['2020-10-09', 1.067487286837617],
                                                       ['2020-10-12', 1.1089121011443612],
                                                       ['2020-10-13', 1.0889651082352152],
                                                       ['2020-10-14', 1.0908265455374473],
                                                       ['2020-10-15', 1.0793406312748108],
                                                       ['2020-10-16', 1.066348958386379],
                                                       ['2020-10-19', 1.0580790374426237],
                                                       ['2020-10-20', 1.070545026648481],
                                                       ['2020-10-21', 1.0487843858627914],
                                                       ['2020-10-22', 1.0564518466695865],
                                                       ['2020-10-23', 1.0535672455976932],
                                                       ['2020-10-26', 1.0380051283537797],
                                                       ['2020-10-27', 1.0193468830718104],
                                                       ['2020-10-28', 0.9847340205087146],
                                                       ['2020-10-29', 0.9938053936242638],
                                                       ['2020-10-30', 0.977050891037759],
                                                       ['2020-11-02', 0.9815023585256727],
                                                       ['2020-11-03', 1.0157893128742363],
                                                       ['2020-11-04', 1.0247361201097123],
                                                       ['2020-11-05', 1.053383922227019],
                                                       ['2020-11-06', 1.0458990013576899],
                                                       ['2020-11-09', 1.0956900988927742],
                                                       ['2020-11-10', 1.1051257684500482],
                                                       ['2020-11-11', 1.114613144599051],
                                                       ['2020-11-12', 1.0998987020862043],
                                                       ['2020-11-13', 1.118260026182338],
                                                       ['2020-11-16', 1.133563610467608],
                                                       ['2020-11-17', 1.1407798137465894],
                                                       ['2020-11-18', 1.1366111656467677],
                                                       ['2020-11-19', 1.1389324782421015],
                                                       ['2020-11-20', 1.1314099525787882],
                                                       ['2020-11-23', 1.1461964709467716],
                                                       ['2020-11-24', 1.1835262798752466],
                                                       ['2020-11-25', 1.1814423475419396],
                                                       ['2020-11-26', 1.1814423475419396],
                                                       ['2020-11-27', 1.1780281456214312],
                                                       ['2020-11-30', 1.163780629300559],
                                                       ['2020-12-01', 1.1772494130126692],
                                                       ['2020-12-02', 1.2002376936353105],
                                                       ['2020-12-03', 1.191242313540938],
                                                       ['2020-12-04', 1.2062583778388682],
                                                       ['2020-12-07', 1.2047988417723452],
                                                       ['2020-12-08', 1.207640354017798],
                                                       ['2020-12-09', 1.2182464727878393],
                                                       ['2020-12-10', 1.2275332900355913],
                                                       ['2020-12-11', 1.2082224448913497],
                                                       ['2020-12-14', 1.1981490607027552],
                                                       ['2020-12-15', 1.2291134748161479],
                                                       ['2020-12-16', 1.2343248725158311],
                                                       ['2020-12-17', 1.2387747731373286],
                                                       ['2020-12-18', 1.2254195872403797],
                                                       ['2020-12-21', 1.287961060235829],
                                                       ['2020-12-22', 1.2678667818835767],
                                                       ['2020-12-23', 1.2914042491850333],
                                                       ['2020-12-24', 1.292302847074621],
                                                       ['2020-12-25', 1.292302847074621],
                                                       ['2020-12-28', 1.315621736511042],
                                                       ['2020-12-29', 1.3056016257805925],
                                                       ['2020-12-30', 1.3090126939682685],
                                                       ['2020-12-31', 1.3239355297144455],
                                                       ['2021-01-01', 1.3239355297144455],
                                                       ['2021-01-04', 1.3224086183920336],
                                                       ['2021-01-05', 1.3493610710472062],
                                                       ['2021-01-06', 1.3987925727398136],
                                                       ['2021-01-07', 1.4319647016333785],
                                                       ['2021-01-08', 1.4279934787019752],
                                                       ['2021-01-11', 1.4367232749388321],
                                                       ['2021-01-12', 1.469838996641421],
                                                       ['2021-01-13', 1.4770128945271697],
                                                       ['2021-01-14', 1.4926776415213325],
                                                       ['2021-01-15', 1.4616630876826273],
                                                       ['2021-01-18', 1.4616630876826273],
                                                       ['2021-01-19', 1.4358591481103977],
                                                       ['2021-01-20', 1.4295109888258917],
                                                       ['2021-01-21', 1.4349746520185538],
                                                       ['2021-01-22', 1.439535800155589],
                                                       ['2021-01-25', 1.4220064821263625],
                                                       ['2021-01-26', 1.4173810924662704],
                                                       ['2021-01-27', 1.3814583295793816],
                                                       ['2021-01-28', 1.3780872164853137],
                                                       ['2021-01-29', 1.3522550733175958],
                                                       ['2021-02-01', 1.3709195860652295],
                                                       ['2021-02-02', 1.4215560080317566],
                                                       ['2021-02-03', 1.4257301401640343],
                                                       ['2021-02-04', 1.4535341847163137],
                                                       ['2021-02-05', 1.4512520437813807],
                                                       ['2021-02-08', 1.4781277199821679],
                                                       ['2021-02-09', 1.4775330941772888],
                                                       ['2021-02-10', 1.4915330456044296],
                                                       ['2021-02-11', 1.4831722464085457],
                                                       ['2021-02-12', 1.4996431461737505],
                                                       ['2021-02-15', 1.4996431461737505],
                                                       ['2021-02-16', 1.5177373195459527],
                                                       ['2021-02-17', 1.5160670399464755],
                                                       ['2021-02-18', 1.5024180665965226],
                                                       ['2021-02-19', 1.5255982883551262],
                                                       ['2021-02-22', 1.5227097701171932],
                                                       ['2021-02-23', 1.5317740923338705],
                                                       ['2021-02-24', 1.5764039318945835],
                                                       ['2021-02-25', 1.5560158660893277],
                                                       ['2021-02-26', 1.5234830186934991],
                                                       ['2021-03-01', 1.5784972654263867],
                                                       ['2021-03-02', 1.577134091644449],
                                                       ['2021-03-03', 1.5848454247108927],
                                                       ['2021-03-04', 1.56037723875832],
                                                       ['2021-03-05', 1.5553334957651503],
                                                       ['2021-03-08', 1.5722760223215777],
                                                       ['2021-03-09', 1.5675166655829158],
                                                       ['2021-03-10', 1.6109345339708374],
                                                       ['2021-03-11', 1.6152872888745418],
                                                       ['2021-03-12', 1.6402028151888879],
                                                       ['2021-03-15', 1.6352045113217835],
                                                       ['2021-03-16', 1.6210823443141926],
                                                       ['2021-03-17', 1.6323778843072827],
                                                       ['2021-03-18', 1.6359479894361848],
                                                       ['2021-03-19', 1.619665113640902],
                                                       ['2021-03-22', 1.6071325326123638],
                                                       ['2021-03-23', 1.5751950944546225],
                                                       ['2021-03-24', 1.5577386357137408],
                                                       ['2021-03-25', 1.5663485666697723],
                                                       ['2021-03-26', 1.5549856514207931],
                                                       ['2021-03-29', 1.5487197526231282],
                                                       ['2021-03-30', 1.5707765311614452],
                                                       ['2021-03-31', 1.5553421135304377],
                                                       ['2021-04-01', 1.5596306269110851],
                                                       ['2021-04-02', 1.5596306269110851],
                                                       ['2021-04-05', 1.5491561249199899],
                                                       ['2021-04-06', 1.5638517650358437],
                                                       ['2021-04-07', 1.565256460777806],
                                                       ['2021-04-08', 1.5886066875425475],
                                                       ['2021-04-09', 1.5926554703615445],
                                                       ['2021-04-12', 1.593196039275071],
                                                       ['2021-04-13', 1.5830725153611647],
                                                       ['2021-04-14', 1.608829448940914],
                                                       ['2021-04-15', 1.6266462869574803],
                                                       ['2021-04-16', 1.6409768471984019],
                                                       ['2021-04-19', 1.6454784544116277],
                                                       ['2021-04-20', 1.5971649119068507],
                                                       ['2021-04-21', 1.61150408991306],
                                                       ['2021-04-22', 1.5906663334464066],
                                                       ['2021-04-23', 1.6294760477048125],
                                                       ['2021-04-26', 1.6469520922758942],
                                                       ['2021-04-27', 1.6587059406956703],
                                                       ['2021-04-28', 1.6629693842136615],
                                                       ['2021-04-29', 1.6821838670733185],
                                                       ['2021-04-30', 1.6600095735537992],
                                                       ['2021-05-03', 1.6690417750089481],
                                                       ['2021-05-04', 1.6582100274749996],
                                                       ['2021-05-05', 1.6898043218876324],
                                                       ['2021-05-06', 1.726507384249699],
                                                       ['2021-05-07', 1.7471226456852775],
                                                       ['2021-05-10', 1.7314484974926188],
                                                       ['2021-05-11', 1.6945331247311817],
                                                       ['2021-05-12', 1.6660819643490854],
                                                       ['2021-05-13', 1.6881833985802592],
                                                       ['2021-05-14', 1.7330302491395915],
                                                       ['2021-05-17', 1.7325445205506251],
                                                       ['2021-05-18', 1.7109131462442573],
                                                       ['2021-05-19', 1.6858949901796618],
                                                       ['2021-05-20', 1.6968254502978186],
                                                       ['2021-05-21', 1.7188869294353843],
                                                       ['2021-05-24', 1.730399480427093],
                                                       ['2021-05-25', 1.7148890697749082],
                                                       ['2021-05-26', 1.7263342455107282],
                                                       ['2021-05-27', 1.738998443318212],
                                                       ['2021-05-28', 1.7402307837544118],
                                                       ['2021-05-31', 1.7402307837544118],
                                                       ['2021-06-01', 1.7811918056020137],
                                                       ['2021-06-02', 1.7867761175087098],
                                                       ['2021-06-03', 1.8047762788959507],
                                                       ['2021-06-04', 1.820470796352018],
                                                       ['2021-06-07', 1.8073459398182243],
                                                       ['2021-06-08', 1.795232495555971],
                                                       ['2021-06-09', 1.7883555188560583],
                                                       ['2021-06-10', 1.750957551238487],
                                                       ['2021-06-11', 1.7699048833742117],
                                                       ['2021-06-14', 1.7557834997998292],
                                                       ['2021-06-15', 1.7475997565089554],
                                                       ['2021-06-16', 1.7474399361345212],
                                                       ['2021-06-17', 1.7128231564053855],
                                                       ['2021-06-18', 1.6594909407700957],
                                                       ['2021-06-21', 1.698039771770234],
                                                       ['2021-06-22', 1.7014218529292136],
                                                       ['2021-06-23', 1.71491570650398],
                                                       ['2021-06-24', 1.7450904199436985],
                                                       ['2021-06-25', 1.7445592522286677],
                                                       ['2021-06-28', 1.7477211886561963],
                                                       ['2021-06-29', 1.7665008660854071],
                                                       ['2021-06-30', 1.795393099363613],
                                                       ['2021-07-01', 1.7778849340310026],
                                                       ['2021-07-02', 1.7800479931183184],
                                                       ['2021-07-05', 1.7800479931183184],
                                                       ['2021-07-06', 1.7670633711287582],
                                                       ['2021-07-07', 1.7635073677976],
                                                       ['2021-07-08', 1.7259174590440662],
                                                       ['2021-07-09', 1.7809489413075301],
                                                       ['2021-07-12', 1.8146271680534696],
                                                       ['2021-07-13', 1.798889561770962],
                                                       ['2021-07-14', 1.7997262684371165],
                                                       ['2021-07-15', 1.7941662429598688],
                                                       ['2021-07-16', 1.75574746187226],
                                                       ['2021-07-19', 1.7074472377320196],
                                                       ['2021-07-20', 1.755098779176028],
                                                       ['2021-07-21', 1.7884918362342517],
                                                       ['2021-07-22', 1.7881870807163354],
                                                       ['2021-07-23', 1.7971260536197318],
                                                       ['2021-07-26', 1.8053936242638626],
                                                       ['2021-07-27', 1.7966364078647248],
                                                       ['2021-07-28', 1.790553049004526],
                                                       ['2021-07-29', 1.805162511467499],
                                                       ['2021-07-30', 1.7949426252690068],
                                                       ['2021-08-02', 1.807475206297545],
                                                       ['2021-08-03', 1.8198934060777137],
                                                       ['2021-08-04', 1.8090694928758457],
                                                       ['2021-08-05', 1.835024635057221],
                                                       ['2021-08-06', 1.8874496350376353],
                                                       ['2021-08-09', 1.895298852348689],
                                                       ['2021-08-10', 1.9266244291709742],
                                                       ['2021-08-11', 1.9508074454358313],
                                                       ['2021-08-12', 1.9614143476390804],
                                                       ['2021-08-13', 1.9449810526678597],
                                                       ['2021-08-16', 1.939386556129459],
                                                       ['2021-08-17', 1.9239873929928122],
                                                       ['2021-08-18', 1.8915336723509921],
                                                       ['2021-08-19', 1.8713297133496192],
                                                       ['2021-08-20', 1.8835544051274093],
                                                       ['2021-08-23', 1.9089454753990176],
                                                       ['2021-08-24', 1.937170223583999],
                                                       ['2021-08-25', 1.952823219080041],
                                                       ['2021-08-26', 1.9483161278343588],
                                                       ['2021-08-27', 1.9795625779026347],
                                                       ['2021-08-30', 1.964436832955583],
                                                       ['2021-08-31', 1.96144960213344],
                                                       ['2021-09-01', 1.9634340384493298],
                                                       ['2021-09-02', 1.969112362340987],
                                                       ['2021-09-03', 1.9576906896014072],
                                                       ['2021-09-06', 1.9576906896014072],
                                                       ['2021-09-07', 1.958603389288739],
                                                       ['2021-09-08', 1.9341289358705023],
                                                       ['2021-09-09', 1.9303324185444852],
                                                       ['2021-09-10', 1.915549033909334],
                                                       ['2021-09-13', 1.939824495292736],
                                                       ['2021-09-14', 1.9146567034854105],
                                                       ['2021-09-15', 1.9095581201676801],
                                                       ['2021-09-16', 1.8880129235141936],
                                                       ['2021-09-17', 1.8615955557400916],
                                                       ['2021-09-20', 1.8019802057765602],
                                                       ['2021-09-21', 1.7938285832472152],
                                                       ['2021-09-22', 1.8372347001370162],
                                                       ['2021-09-23', 1.8647621927668683],
                                                       ['2021-09-24', 1.8609100516830828]],
                              'Constituents': [
                                  {'country': 'United States', 'name': 'Apple Inc',
                                   'transactionCost': 1.1936100899058002,
                                   'sector': 'Information Technology', 'shares': 26, 'assetId': 'MA4B66MW5E27U9VBB94',
                                   'bbid': 'AAPL UW',
                                   'currency': 'USD', 'industry': 'Technology Hardware, Storage & Peripherals',
                                   'marginalCost': 0.19195231034013271, 'advPercentage': 0,
                                   'notional': 3819.9199999999996, 'price': 146.92,
                                   'weight': 0.16081659493619194, 'borrowCost': 40},
                                  {'country': 'United States', 'name': 'The Goldman Sachs Group, Inc.',
                                   'transactionCost': 3.2194154492372298,
                                   'sector': 'Financials', 'shares': 51, 'assetId': 'MA4B66MW5E27UAHKG34',
                                   'bbid': 'GS UN', 'currency': 'USD',
                                   'industry': 'Capital Markets', 'marginalCost': 2.701680019005928,
                                   'advPercentage': 2.3e-05,
                                   'notional': 19933.350000000002, 'price': 390.85, 'weight': 0.8391834050638082,
                                   'borrowCost': 40}],
                              'Asset Id': '', 'Transaction Cost': 2.893632329346061,
                              'Annualized Return': 0.861701827815391},
                'Hedge': {'Transaction Cost': 2.2604819652681694, 'Correlation': 0.936758446681233,
                          'Backtest Performance': [['2020-09-24', 1], ['2020-09-25', 1.0104116399850593],
                                                   ['2020-09-28', 1.0307855197014755],
                                                   ['2020-09-29', 1.0163931905275039],
                                                   ['2020-09-30', 1.0303780678487708], ['2020-10-01', 1.02803072573049],
                                                   ['2020-10-02', 1.0338706383971734],
                                                   ['2020-10-05', 1.052525377568271],
                                                   ['2020-10-06', 1.0340650510786302],
                                                   ['2020-10-07', 1.0508356048581615],
                                                   ['2020-10-08', 1.0603036151113474],
                                                   ['2020-10-09', 1.060588304786846],
                                                   ['2020-10-12', 1.0868635890594514],
                                                   ['2020-10-13', 1.0747102379748288],
                                                   ['2020-10-14', 1.0671267966260976],
                                                   ['2020-10-15', 1.074639084395838],
                                                   ['2020-10-16', 1.0765144407834903],
                                                   ['2020-10-19', 1.0626904612955628],
                                                   ['2020-10-20', 1.0698992568123844],
                                                   ['2020-10-21', 1.0633001027846625],
                                                   ['2020-10-22', 1.080365958503925],
                                                   ['2020-10-23', 1.0836535809584429],
                                                   ['2020-10-26', 1.0599791557462024],
                                                   ['2020-10-27', 1.0398109665270256],
                                                   ['2020-10-28', 1.013939716813292], ['2020-10-29', 1.025285647916773],
                                                   ['2020-10-30', 1.0162452634880497],
                                                   ['2020-11-02', 1.0361270021554296],
                                                   ['2020-11-03', 1.0628292713233702],
                                                   ['2020-11-04', 1.0643748693020345],
                                                   ['2020-11-05', 1.0870688878363275],
                                                   ['2020-11-06', 1.075680915811229],
                                                   ['2020-11-09', 1.1310152350427867],
                                                   ['2020-11-10', 1.1365085766625056],
                                                   ['2020-11-11', 1.1456684425171284],
                                                   ['2020-11-12', 1.1324848780700123],
                                                   ['2020-11-13', 1.1496769513131484],
                                                   ['2020-11-16', 1.174024423737768],
                                                   ['2020-11-17', 1.1786976021533382],
                                                   ['2020-11-18', 1.172198105516616],
                                                   ['2020-11-19', 1.1796894313970685],
                                                   ['2020-11-20', 1.1720675902607598],
                                                   ['2020-11-23', 1.2042568842777668],
                                                   ['2020-11-24', 1.2478109612205204],
                                                   ['2020-11-25', 1.2465964960297171],
                                                   ['2020-11-26', 1.2465964960297171],
                                                   ['2020-11-27', 1.2482807167565497],
                                                   ['2020-11-30', 1.2240604489911184],
                                                   ['2020-12-01', 1.2414716222521844],
                                                   ['2020-12-02', 1.2555764585251266],
                                                   ['2020-12-03', 1.2530206749134576],
                                                   ['2020-12-04', 1.2726021013511315],
                                                   ['2020-12-07', 1.2651506324580064],
                                                   ['2020-12-08', 1.2642771975229015],
                                                   ['2020-12-09', 1.2678474010781646],
                                                   ['2020-12-10', 1.2736979737616583],
                                                   ['2020-12-11', 1.2573160543347301],
                                                   ['2020-12-14', 1.244303488883378],
                                                   ['2020-12-15', 1.2742786174980252],
                                                   ['2020-12-16', 1.2779195844041837],
                                                   ['2020-12-17', 1.283302631746248], ['2020-12-18', 1.276354699607117],
                                                   ['2020-12-21', 1.3125686927823437],
                                                   ['2020-12-22', 1.296299249328958],
                                                   ['2020-12-23', 1.3187779432834859],
                                                   ['2020-12-24', 1.3162583329954654],
                                                   ['2020-12-25', 1.3162583329954654],
                                                   ['2020-12-28', 1.3185892862798951],
                                                   ['2020-12-29', 1.3111756560815606],
                                                   ['2020-12-30', 1.3144825720696882],
                                                   ['2020-12-31', 1.3268030683678376],
                                                   ['2021-01-01', 1.3268030683678376],
                                                   ['2021-01-04', 1.3159923682994483],
                                                   ['2021-01-05', 1.3340647632947369],
                                                   ['2021-01-06', 1.3909576803980703],
                                                   ['2021-01-07', 1.4152280361405745],
                                                   ['2021-01-08', 1.4174405809398316],
                                                   ['2021-01-11', 1.4231526927862412],
                                                   ['2021-01-12', 1.4293977756277825],
                                                   ['2021-01-13', 1.4234850492339033],
                                                   ['2021-01-14', 1.4397514671138192],
                                                   ['2021-01-15', 1.409001702900938], ['2021-01-18', 1.409001702900938],
                                                   ['2021-01-19', 1.4109828849695718],
                                                   ['2021-01-20', 1.4115393763475617],
                                                   ['2021-01-21', 1.4044664175144592],
                                                   ['2021-01-22', 1.3987852008396073],
                                                   ['2021-01-25', 1.3860808014247046],
                                                   ['2021-01-26', 1.381350320662177],
                                                   ['2021-01-27', 1.3454054796675197],
                                                   ['2021-01-28', 1.3501857783066038],
                                                   ['2021-01-29', 1.3175753005863033],
                                                   ['2021-02-01', 1.3310146449999998],
                                                   ['2021-02-02', 1.370111970146903], ['2021-02-03', 1.369846444923827],
                                                   ['2021-02-04', 1.3936530582244067],
                                                   ['2021-02-05', 1.4039277423247092],
                                                   ['2021-02-08', 1.4268063574012315],
                                                   ['2021-02-09', 1.4283534342175326],
                                                   ['2021-02-10', 1.4357594389261352],
                                                   ['2021-02-11', 1.428374052139035],
                                                   ['2021-02-12', 1.4429251243112822],
                                                   ['2021-02-15', 1.4429251243112822],
                                                   ['2021-02-16', 1.461542741076252],
                                                   ['2021-02-17', 1.4591638016742965],
                                                   ['2021-02-18', 1.4472594444672997],
                                                   ['2021-02-19', 1.4707489985599904],
                                                   ['2021-02-22', 1.4755439199336886],
                                                   ['2021-02-23', 1.4820692085583076],
                                                   ['2021-02-24', 1.511687900368849], ['2021-02-25', 1.486336535951723],
                                                   ['2021-02-26', 1.4617866716883874],
                                                   ['2021-03-01', 1.5001983608496483],
                                                   ['2021-03-02', 1.5085260984949034],
                                                   ['2021-03-03', 1.5167425010055402],
                                                   ['2021-03-04', 1.4954468749220593],
                                                   ['2021-03-05', 1.5048325007869152],
                                                   ['2021-03-08', 1.5144817178954568],
                                                   ['2021-03-09', 1.5136338082053342],
                                                   ['2021-03-10', 1.5471387857165224],
                                                   ['2021-03-11', 1.552032591486371],
                                                   ['2021-03-12', 1.5716887223548588],
                                                   ['2021-03-15', 1.570807534341104],
                                                   ['2021-03-16', 1.5528662067408492],
                                                   ['2021-03-17', 1.5663385974304973],
                                                   ['2021-03-18', 1.5673612323097021],
                                                   ['2021-03-19', 1.5525802635601895],
                                                   ['2021-03-22', 1.5409068482642276],
                                                   ['2021-03-23', 1.507406937003066],
                                                   ['2021-03-24', 1.5012740563038809],
                                                   ['2021-03-25', 1.5192040583357755],
                                                   ['2021-03-26', 1.529957344137103],
                                                   ['2021-03-29', 1.5047630491396355],
                                                   ['2021-03-30', 1.5222775022723902],
                                                   ['2021-03-31', 1.508553987492476],
                                                   ['2021-04-01', 1.5207815572746632],
                                                   ['2021-04-02', 1.5207815572746632],
                                                   ['2021-04-05', 1.5252366638449892],
                                                   ['2021-04-06', 1.537238350504828],
                                                   ['2021-04-07', 1.5392951360957752],
                                                   ['2021-04-08', 1.5490368365166685],
                                                   ['2021-04-09', 1.557915030807923],
                                                   ['2021-04-12', 1.5565394043984706],
                                                   ['2021-04-13', 1.5460141095481092],
                                                   ['2021-04-14', 1.5595020548937684],
                                                   ['2021-04-15', 1.565231199487692],
                                                   ['2021-04-16', 1.5557047184416664],
                                                   ['2021-04-19', 1.5616881940098946],
                                                   ['2021-04-20', 1.5263160854925413],
                                                   ['2021-04-21', 1.5522763213884536],
                                                   ['2021-04-22', 1.5350915789121093], ['2021-04-23', 1.57158539249219],
                                                   ['2021-04-26', 1.5810581974026183],
                                                   ['2021-04-27', 1.5900787413814923],
                                                   ['2021-04-28', 1.5955846620747325],
                                                   ['2021-04-29', 1.6137105295110301],
                                                   ['2021-04-30', 1.5845767863905935],
                                                   ['2021-05-03', 1.5863705380999724],
                                                   ['2021-05-04', 1.5882125781111578],
                                                   ['2021-05-05', 1.6065603704288025],
                                                   ['2021-05-06', 1.6344953097116117],
                                                   ['2021-05-07', 1.6495251089353995],
                                                   ['2021-05-10', 1.636644671135531],
                                                   ['2021-05-11', 1.6146185343277637],
                                                   ['2021-05-12', 1.5897950933090927],
                                                   ['2021-05-13', 1.6122368879515665],
                                                   ['2021-05-14', 1.6439450665420194],
                                                   ['2021-05-17', 1.6545198576851718],
                                                   ['2021-05-18', 1.6353279676761365],
                                                   ['2021-05-19', 1.6209690936595618],
                                                   ['2021-05-20', 1.6294848988625292],
                                                   ['2021-05-21', 1.6477823771244906],
                                                   ['2021-05-24', 1.665391178904659],
                                                   ['2021-05-25', 1.6543811334627772],
                                                   ['2021-05-26', 1.6631885248580318],
                                                   ['2021-05-27', 1.6784653130973213],
                                                   ['2021-05-28', 1.6828566766917903],
                                                   ['2021-05-31', 1.6828566766917903], ['2021-06-01', 1.69991088376666],
                                                   ['2021-06-02', 1.7039576789378863],
                                                   ['2021-06-03', 1.7075602408335289],
                                                   ['2021-06-04', 1.7186255598839562],
                                                   ['2021-06-07', 1.712635392985795],
                                                   ['2021-06-08', 1.7097444780540265],
                                                   ['2021-06-09', 1.7005645001567697],
                                                   ['2021-06-10', 1.6846521736086526],
                                                   ['2021-06-11', 1.6913655615016792],
                                                   ['2021-06-14', 1.6741903605872415],
                                                   ['2021-06-15', 1.6671331966653065],
                                                   ['2021-06-16', 1.6608467705374614],
                                                   ['2021-06-17', 1.6182529345083716],
                                                   ['2021-06-18', 1.5716734295918893],
                                                   ['2021-06-21', 1.6025210119753992],
                                                   ['2021-06-22', 1.6036761759261928],
                                                   ['2021-06-23', 1.6088186017605215],
                                                   ['2021-06-24', 1.6298499404572735],
                                                   ['2021-06-25', 1.6475608618707231],
                                                   ['2021-06-28', 1.6436992303035847],
                                                   ['2021-06-29', 1.6583865823631618],
                                                   ['2021-06-30', 1.6717505836553197],
                                                   ['2021-07-01', 1.6772597783846594],
                                                   ['2021-07-02', 1.6765190560701135],
                                                   ['2021-07-05', 1.6765190560701135],
                                                   ['2021-07-06', 1.6472838625986161],
                                                   ['2021-07-07', 1.6456960834251377],
                                                   ['2021-07-08', 1.6125483519004047],
                                                   ['2021-07-09', 1.6558213788094323],
                                                   ['2021-07-12', 1.683903334102053],
                                                   ['2021-07-13', 1.6760296033419682],
                                                   ['2021-07-14', 1.6751081114066049],
                                                   ['2021-07-15', 1.6761821265670138],
                                                   ['2021-07-16', 1.6519994975324561],
                                                   ['2021-07-19', 1.6185386068423806],
                                                   ['2021-07-20', 1.6608158082138411],
                                                   ['2021-07-21', 1.6977232240293918],
                                                   ['2021-07-22', 1.6910789251625107],
                                                   ['2021-07-23', 1.6882778604361217],
                                                   ['2021-07-26', 1.7079461771654998],
                                                   ['2021-07-27', 1.705316911290549],
                                                   ['2021-07-28', 1.7065513855574908],
                                                   ['2021-07-29', 1.7147564423541488],
                                                   ['2021-07-30', 1.7078630854421146],
                                                   ['2021-08-02', 1.7098846370921508],
                                                   ['2021-08-03', 1.7212246073309094], ['2021-08-04', 1.71284744352946],
                                                   ['2021-08-05', 1.7319984849390486],
                                                   ['2021-08-06', 1.7610784608955359],
                                                   ['2021-08-09', 1.7685063176313183],
                                                   ['2021-08-10', 1.788487648029903],
                                                   ['2021-08-11', 1.8132548730727573],
                                                   ['2021-08-12', 1.8211088797799007], ['2021-08-13', 1.80763324042271],
                                                   ['2021-08-16', 1.7990148335838823],
                                                   ['2021-08-17', 1.7821201492173437],
                                                   ['2021-08-18', 1.7595999866259955],
                                                   ['2021-08-19', 1.7402030612253945], ['2021-08-20', 1.75394804825027],
                                                   ['2021-08-23', 1.774564369295308], ['2021-08-24', 1.791036747026845],
                                                   ['2021-08-25', 1.808387370019545],
                                                   ['2021-08-26', 1.7990128100684075],
                                                   ['2021-08-27', 1.8230267889371115],
                                                   ['2021-08-30', 1.8066029024558345],
                                                   ['2021-08-31', 1.8011083700062123],
                                                   ['2021-09-01', 1.7952270192942026],
                                                   ['2021-09-02', 1.8042111959545828],
                                                   ['2021-09-03', 1.7956456571882038],
                                                   ['2021-09-06', 1.7956456571882038],
                                                   ['2021-09-07', 1.7906973619966717],
                                                   ['2021-09-08', 1.7790846820103143],
                                                   ['2021-09-09', 1.782974909163946], ['2021-09-10', 1.774210004132321],
                                                   ['2021-09-13', 1.7863371703894837],
                                                   ['2021-09-14', 1.7607086022595286],
                                                   ['2021-09-15', 1.7733155737318977],
                                                   ['2021-09-16', 1.7661953659616862], ['2021-09-17', 1.75552495625101],
                                                   ['2021-09-20', 1.7073319409830758],
                                                   ['2021-09-21', 1.7036755701399784],
                                                   ['2021-09-22', 1.7353221001527805],
                                                   ['2021-09-23', 1.7749324312405845],
                                                   ['2021-09-24', 1.772300109946803]], 'Cash Weight': 0,
                          'R Squared': 0.8279135592848923, 'Annualized Return': 0.77299493701611,
                          'Annualized Volatility': 0.19788814828229934, 'Hedge Ratio': 1, 'Ridge Weight': 0,
                          'Backtest Correlation': [['2020-11-26', 0.9015925151077675],
                                                   ['2020-11-27', 0.8995307601350195],
                                                   ['2020-11-30', 0.8976193597009464],
                                                   ['2020-12-01', 0.899134905548527],
                                                   ['2020-12-02', 0.8968844291011409],
                                                   ['2020-12-03', 0.8983210353924714],
                                                   ['2020-12-04', 0.8983135812975858],
                                                   ['2020-12-07', 0.8981598956869762],
                                                   ['2020-12-08', 0.896541180905539], ['2020-12-09', 0.896342085151086],
                                                   ['2020-12-10', 0.8960079549884281],
                                                   ['2020-12-11', 0.9022159150284723],
                                                   ['2020-12-14', 0.9020984285750759],
                                                   ['2020-12-15', 0.9108756715722117],
                                                   ['2020-12-16', 0.9216167275658368],
                                                   ['2020-12-17', 0.9283890799097579],
                                                   ['2020-12-18', 0.9282606242969395],
                                                   ['2020-12-21', 0.9168926673056201],
                                                   ['2020-12-22', 0.9235486508155735],
                                                   ['2020-12-23', 0.9276013093341673],
                                                   ['2020-12-24', 0.9283372838050917],
                                                   ['2020-12-25', 0.928171587486031],
                                                   ['2020-12-28', 0.9116851149928049],
                                                   ['2020-12-29', 0.9056422674201283],
                                                   ['2020-12-30', 0.9059781317532566],
                                                   ['2020-12-31', 0.9052396831652074],
                                                   ['2021-01-01', 0.9155947769421426],
                                                   ['2021-01-04', 0.9111654399535882],
                                                   ['2021-01-05', 0.9125433947950563],
                                                   ['2021-01-06', 0.9209363905792434],
                                                   ['2021-01-07', 0.9201318271791072],
                                                   ['2021-01-08', 0.9084929198870123],
                                                   ['2021-01-11', 0.9086559298840635],
                                                   ['2021-01-12', 0.8875612269095221],
                                                   ['2021-01-13', 0.8789265648137641],
                                                   ['2021-01-14', 0.8783291410335801],
                                                   ['2021-01-15', 0.8943005663624369],
                                                   ['2021-01-18', 0.8945248751426272],
                                                   ['2021-01-19', 0.8705151985771736],
                                                   ['2021-01-20', 0.8708271027477481],
                                                   ['2021-01-21', 0.8650473745733117],
                                                   ['2021-01-22', 0.8748613614663985],
                                                   ['2021-01-25', 0.8725792954791373],
                                                   ['2021-01-26', 0.873175463509665],
                                                   ['2021-01-27', 0.8864366140951857],
                                                   ['2021-01-28', 0.8845759397275269],
                                                   ['2021-01-29', 0.8898805771751356],
                                                   ['2021-02-01', 0.8920000543343564],
                                                   ['2021-02-02', 0.9019976775814598],
                                                   ['2021-02-03', 0.9029180582695069],
                                                   ['2021-02-04', 0.9070217939463278],
                                                   ['2021-02-05', 0.9007086970184902],
                                                   ['2021-02-08', 0.9030258129623466],
                                                   ['2021-02-09', 0.9032264783085702],
                                                   ['2021-02-10', 0.9030829600702234],
                                                   ['2021-02-11', 0.9010523188673754],
                                                   ['2021-02-12', 0.9001497414661194],
                                                   ['2021-02-15', 0.8972232205299802],
                                                   ['2021-02-16', 0.897594089152695],
                                                   ['2021-02-17', 0.8982148727150193],
                                                   ['2021-02-18', 0.8998472164172846],
                                                   ['2021-02-19', 0.8982607278993444],
                                                   ['2021-02-22', 0.8921722036271721],
                                                   ['2021-02-23', 0.8898626754094953],
                                                   ['2021-02-24', 0.8947739256523193],
                                                   ['2021-02-25', 0.8987596973059994],
                                                   ['2021-02-26', 0.9134643435214955],
                                                   ['2021-03-01', 0.918993929754835],
                                                   ['2021-03-02', 0.9157408336361909],
                                                   ['2021-03-03', 0.915275687497752],
                                                   ['2021-03-04', 0.9186455889944436],
                                                   ['2021-03-05', 0.9145426609376325],
                                                   ['2021-03-08', 0.9134714758069424],
                                                   ['2021-03-09', 0.9086630053014179],
                                                   ['2021-03-10', 0.9120223954384556],
                                                   ['2021-03-11', 0.9130148169582306],
                                                   ['2021-03-12', 0.914739719013808], ['2021-03-15', 0.928463943323836],
                                                   ['2021-03-16', 0.933583077072683],
                                                   ['2021-03-17', 0.9330716807868986],
                                                   ['2021-03-18', 0.9288147179435885],
                                                   ['2021-03-19', 0.9303048507822332],
                                                   ['2021-03-22', 0.9503491605860712],
                                                   ['2021-03-23', 0.9543301426608973],
                                                   ['2021-03-24', 0.9562100276004051],
                                                   ['2021-03-25', 0.9558902159462764],
                                                   ['2021-03-26', 0.9421183812187457],
                                                   ['2021-03-29', 0.9304297698582624],
                                                   ['2021-03-30', 0.9255377724225964],
                                                   ['2021-03-31', 0.9288788520748432],
                                                   ['2021-04-01', 0.9255245811924869],
                                                   ['2021-04-02', 0.9253057356272613],
                                                   ['2021-04-05', 0.9110845996065523],
                                                   ['2021-04-06', 0.9125537209614435],
                                                   ['2021-04-07', 0.9092805473148023],
                                                   ['2021-04-08', 0.9106842967282306],
                                                   ['2021-04-09', 0.9065743602103377],
                                                   ['2021-04-12', 0.9064120996162333],
                                                   ['2021-04-13', 0.9080039410233919],
                                                   ['2021-04-14', 0.9058324442791906],
                                                   ['2021-04-15', 0.9012633679437755],
                                                   ['2021-04-16', 0.8817266337950646],
                                                   ['2021-04-19', 0.879870971242904],
                                                   ['2021-04-20', 0.8941573383350782],
                                                   ['2021-04-21', 0.887962814825184],
                                                   ['2021-04-22', 0.8883257914187292],
                                                   ['2021-04-23', 0.8982033834669962],
                                                   ['2021-04-26', 0.8978600104298144],
                                                   ['2021-04-27', 0.8927525434765888],
                                                   ['2021-04-28', 0.8906790878648955],
                                                   ['2021-04-29', 0.8850838636802095],
                                                   ['2021-04-30', 0.8752084867429241],
                                                   ['2021-05-03', 0.8772331412633768],
                                                   ['2021-05-04', 0.8720331661943858],
                                                   ['2021-05-05', 0.8671463406412616],
                                                   ['2021-05-06', 0.8823932789430973],
                                                   ['2021-05-07', 0.8839329350180696],
                                                   ['2021-05-10', 0.8866611547123624],
                                                   ['2021-05-11', 0.8809173134162849],
                                                   ['2021-05-12', 0.8872869281730444],
                                                   ['2021-05-13', 0.8869823508564784],
                                                   ['2021-05-14', 0.8953095635961708],
                                                   ['2021-05-17', 0.8900795744712166],
                                                   ['2021-05-18', 0.8932618180743701],
                                                   ['2021-05-19', 0.8948100995042912],
                                                   ['2021-05-20', 0.8934110525145609],
                                                   ['2021-05-21', 0.894275704465274],
                                                   ['2021-05-24', 0.8862129378804093],
                                                   ['2021-05-25', 0.8887466640145859],
                                                   ['2021-05-26', 0.8922999893294049],
                                                   ['2021-05-27', 0.9071416941600038],
                                                   ['2021-05-28', 0.9203476398072666],
                                                   ['2021-05-31', 0.9190730350667695],
                                                   ['2021-06-01', 0.9102728877414129],
                                                   ['2021-06-02', 0.9132534478383805],
                                                   ['2021-06-03', 0.9088133196000899],
                                                   ['2021-06-04', 0.9156681278113125],
                                                   ['2021-06-07', 0.9156223123920523],
                                                   ['2021-06-08', 0.9145856716019339],
                                                   ['2021-06-09', 0.9168585582176089],
                                                   ['2021-06-10', 0.9163403851492076],
                                                   ['2021-06-11', 0.9144967572849609],
                                                   ['2021-06-14', 0.9141431719872722],
                                                   ['2021-06-15', 0.9147777043798121],
                                                   ['2021-06-16', 0.915538259640843],
                                                   ['2021-06-17', 0.9303937239900952],
                                                   ['2021-06-18', 0.9390592485374359],
                                                   ['2021-06-21', 0.9373116830433493],
                                                   ['2021-06-22', 0.9427449880436689],
                                                   ['2021-06-23', 0.9407084724464195],
                                                   ['2021-06-24', 0.9394464162725222],
                                                   ['2021-06-25', 0.9280066991265317],
                                                   ['2021-06-28', 0.9265038781758507],
                                                   ['2021-06-29', 0.9275818290399418],
                                                   ['2021-06-30', 0.9255991162602577],
                                                   ['2021-07-01', 0.9138966034117193],
                                                   ['2021-07-02', 0.9146142973869088],
                                                   ['2021-07-05', 0.9181022970358077],
                                                   ['2021-07-06', 0.9074933619483999],
                                                   ['2021-07-07', 0.902025125731612], ['2021-07-08', 0.907076026609854],
                                                   ['2021-07-09', 0.9174277412353735],
                                                   ['2021-07-12', 0.9192217122691708],
                                                   ['2021-07-13', 0.9155688050636652],
                                                   ['2021-07-14', 0.914511919994974],
                                                   ['2021-07-15', 0.9072827624461118],
                                                   ['2021-07-16', 0.9147251729875863],
                                                   ['2021-07-19', 0.9193336264588486],
                                                   ['2021-07-20', 0.925798773703205],
                                                   ['2021-07-21', 0.9267409583789746],
                                                   ['2021-07-22', 0.9246635419626583],
                                                   ['2021-07-23', 0.9235962637255246],
                                                   ['2021-07-26', 0.9187195464946155],
                                                   ['2021-07-27', 0.9179631491889088],
                                                   ['2021-07-28', 0.9169395326411997],
                                                   ['2021-07-29', 0.9174199380790581],
                                                   ['2021-07-30', 0.9176683013254561], ['2021-08-02', 0.92034668699813],
                                                   ['2021-08-03', 0.9207308184465794],
                                                   ['2021-08-04', 0.9241614525891176],
                                                   ['2021-08-05', 0.9252544039117194],
                                                   ['2021-08-06', 0.9257068761979128],
                                                   ['2021-08-09', 0.9269338494497388],
                                                   ['2021-08-10', 0.9279078169690388],
                                                   ['2021-08-11', 0.9320239670516519],
                                                   ['2021-08-12', 0.9336249338456267],
                                                   ['2021-08-13', 0.9340825531336873],
                                                   ['2021-08-16', 0.9337740851496074],
                                                   ['2021-08-17', 0.9352358574622675],
                                                   ['2021-08-18', 0.9372444096991827],
                                                   ['2021-08-19', 0.9298764811116637],
                                                   ['2021-08-20', 0.9262131482920518],
                                                   ['2021-08-23', 0.9276585645717137], ['2021-08-24', 0.92856395669229],
                                                   ['2021-08-25', 0.9271659353349381],
                                                   ['2021-08-26', 0.9366798112705848],
                                                   ['2021-08-27', 0.939469558627736], ['2021-08-30', 0.939741517191791],
                                                   ['2021-08-31', 0.9416728966796483],
                                                   ['2021-09-01', 0.9523441724282465],
                                                   ['2021-09-02', 0.9517066086773255],
                                                   ['2021-09-03', 0.9520676724175039],
                                                   ['2021-09-06', 0.9609901628723267],
                                                   ['2021-09-07', 0.9600864061003563],
                                                   ['2021-09-08', 0.9558863980743179],
                                                   ['2021-09-09', 0.948472236169008], ['2021-09-10', 0.946294665243798],
                                                   ['2021-09-13', 0.9452172483227433],
                                                   ['2021-09-14', 0.9466756455002099],
                                                   ['2021-09-15', 0.937395558117138], ['2021-09-16', 0.931622601567483],
                                                   ['2021-09-17', 0.9210569221798822],
                                                   ['2021-09-20', 0.9284521728561184],
                                                   ['2021-09-21', 0.9272930667016914],
                                                   ['2021-09-22', 0.9352279628015158],
                                                   ['2021-09-23', 0.9315300597142235],
                                                   ['2021-09-24', 0.936758446681233]],
                          'Tracking Error': 0.09724809864706382,
                          'Lasso Weight': 0,
                          'Constituents': [
                              {'country': 'United States', 'name': 'Dentsply Sirona Inc',
                               'transactionCost': 2.9051536321640015, 'sector': 'Health Care',
                               'correlation': 0.16678359890783784, 'shares': -5.308036491917078,
                               'assetId': 'MA4B66MW5E27UANZH4M', 'bbid': 'XRAY UW', 'currency': 'USD',
                               'industry': 'Health Care Equipment & Supplies', 'marginalCost': 0.03895858954426313,
                               'advPercentage': 5e-06, 'notional': -318.5352698799438, 'price': 60.01,
                               'weight': 0.013410164995385637, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Extra Space Storage Inc',
                               'transactionCost': 3.9990124702453613, 'sector': 'Real Estate',
                               'correlation': 0.06540203064772898, 'shares': -3.1030213327842304,
                               'assetId': 'MA4B66MW5E27UAFU2CS', 'bbid': 'EXR UN', 'currency': 'USD',
                               'industry': 'Equity Real Estate Investment Trusts (REITs)',
                               'marginalCost': 0.09017373674086719, 'advPercentage': 5e-06,
                               'notional': -535.6125122518861,
                               'price': 172.61, 'weight': 0.02254900113760699, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Kroger Co', 'transactionCost': 1.2731897830963135,
                               'sector': 'Consumer Staples', 'correlation': 0.12350867819558603,
                               'shares': -1.730011893560012,
                               'assetId': 'MA4B66MW5E27UAKNZNV', 'bbid': 'KR UN', 'currency': 'USD',
                               'industry': 'Food & Staples Retailing', 'marginalCost': 0.003707333181127408,
                               'advPercentage': 0, 'notional': -69.16587550452927, 'price': 39.98,
                               'weight': 0.002911846474381391, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'MSCI Inc', 'transactionCost': 7.908167362213135,
                               'sector': 'Financials', 'correlation': 0.24284241634131032,
                               'shares': -0.5740039461869635,
                               'assetId': 'MA4B66MW5E27UAL9SUH', 'bbid': 'MSCI UN', 'currency': 'USD',
                               'industry': 'Capital Markets', 'marginalCost': 0.1263897386589486,
                               'advPercentage': 2e-06,
                               'notional': -379.628989889672, 'price': 661.37, 'weight': 0.01598217802810611,
                               'borrowCost': 40},
                              {'country': 'United States', 'name': 'General Motors Co',
                               'transactionCost': 1.0103281140327454,
                               'sector': 'Consumer Discretionary', 'correlation': 0.5028570129890573,
                               'shares': -3.0290208240423557, 'assetId': 'MA4B66MW5E27UAGYYVE', 'bbid': 'GM UN',
                               'currency': 'USD', 'industry': 'Automobiles', 'marginalCost': 0.006729167173415375,
                               'advPercentage': 0, 'notional': -158.20575763973224, 'price': 52.23,
                               'weight': 0.0066603780296242265, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Mosaic Co/the',
                               'transactionCost': 2.1279181241989136,
                               'sector': 'Materials', 'correlation': 0.6130275473664366, 'shares': -5.192035694429817,
                               'assetId': 'MA4B66MW5E27UAL9SLW', 'bbid': 'MOS UN', 'currency': 'USD',
                               'industry': 'Chemicals',
                               'marginalCost': 0.016679363095866095, 'advPercentage': 2e-06,
                               'notional': -186.18640000225324,
                               'price': 35.86, 'weight': 0.007838348151738823, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Meta Platforms Inc-Class A',
                               'transactionCost': 0.8238705992698669, 'sector': 'Communication Services',
                               'correlation': 0.12666374147291945, 'shares': -0.7130049017966985,
                               'assetId': 'MA4B66MW5E3VLSECN', 'bbid': 'FB UW', 'currency': 'USD',
                               'industry': 'Interactive Media & Services', 'marginalCost': 0.008728781169081446,
                               'advPercentage': 0, 'notional': -251.6622101381627, 'price': 352.96,
                               'weight': 0.010594844841917037, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Twitter Inc', 'transactionCost': 1.2658634781837463,
                               'sector': 'Communication Services', 'correlation': 0.15422853187220908,
                               'shares': -8.874061007775461, 'assetId': 'MA4B66MW5E27UANLXU9', 'bbid': 'TWTR UN',
                               'currency': 'USD', 'industry': 'Interactive Media & Services',
                               'marginalCost': 0.03178955019863404, 'advPercentage': 1e-06,
                               'notional': -596.5143809426665,
                               'price': 67.22, 'weight': 0.025112937332109075, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Paypal Holdings Inc',
                               'transactionCost': 1.4358487129211426, 'sector': 'Information Technology',
                               'correlation': 0.22583565660778615, 'shares': -0.5480037674398188,
                               'assetId': 'MA4B66MW5E27UAM94N9', 'bbid': 'PYPL UW', 'currency': 'USD',
                               'industry': 'IT Services', 'marginalCost': 0.009212668138339708, 'advPercentage': 0,
                               'notional': -152.40532776268802, 'price': 278.11, 'weight': 0.006416183025018788,
                               'borrowCost': 40},
                              {'country': 'United States', 'name': 'Hormel Foods Corp',
                               'transactionCost': 1.4352393746376038,
                               'sector': 'Consumer Staples', 'correlation': -0.03313295634963935,
                               'shares': -11.239077266890737, 'assetId': 'MA4B66MW5E27UAJ5XEZ', 'bbid': 'HRL UN',
                               'currency': 'USD', 'industry': 'Food Products', 'marginalCost': 0.027707143568185242,
                               'advPercentage': 4e-06, 'notional': -458.55435248914205, 'price': 40.8,
                               'weight': 0.019304893704704323, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Nucor Corp', 'transactionCost': 3.182479500770569,
                               'sector': 'Materials', 'correlation': 0.556129972455637, 'shares': -0.7970054792874738,
                               'assetId': 'MA4B66MW5E27UALNB48', 'bbid': 'NUE UN', 'currency': 'USD',
                               'industry': 'Metals & Mining', 'marginalCost': 0.010776575069254387, 'advPercentage': 0,
                               'notional': -80.43379296969185, 'price': 100.92, 'weight': 0.0033862197907779373,
                               'borrowCost': 40},
                              {'country': 'United States', 'name': 'Wells Fargo & Co',
                               'transactionCost': 1.3822112533240394,
                               'sector': 'Financials', 'correlation': 0.6178643696685713, 'shares': -43.79430107894055,
                               'assetId': 'MA4B66MW5E27UANT8X5', 'bbid': 'WFC UN', 'currency': 'USD',
                               'industry': 'Banks',
                               'marginalCost': 0.12211961551022109, 'advPercentage': 2e-06,
                               'notional': -2098.622907702831,
                               'price': 47.92, 'weight': 0.0883509052733721, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Cummins Inc', 'transactionCost': 3.3661617040634155,
                               'sector': 'Industrials', 'correlation': 0.6412824675287682,
                               'shares': -0.4130028393296445,
                               'assetId': 'MA4B66MW5E27UACX6RZ', 'bbid': 'CMI UN', 'currency': 'USD',
                               'industry': 'Machinery',
                               'marginalCost': 0.013324512800464238, 'advPercentage': 0, 'notional': -94.02422640178686,
                               'price': 227.66, 'weight': 0.003958369790845086, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'JPMorgan Chase & Co',
                               'transactionCost': 1.2586397729172192, 'sector': 'Financials',
                               'correlation': 0.8505015474586123, 'shares': -12.604086651115832,
                               'assetId': 'MA4B66MW5E27UAKHZFD', 'bbid': 'JPM UN', 'currency': 'USD',
                               'industry': 'Banks',
                               'marginalCost': 0.10888889555559653, 'advPercentage': 1e-06,
                               'notional': -2054.970287597925,
                               'price': 163.04, 'weight': 0.08651315324576048, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Lumen Technologies Inc',
                               'transactionCost': 3.95284104347229, 'sector': 'Communication Services',
                               'correlation': 0.35956668091011157, 'shares': -11.81608123370237,
                               'assetId': 'MAQQM1QHGJDFAVKN', 'bbid': 'LUMN UN', 'currency': 'USD',
                               'industry': 'Diversified Telecommunication Services',
                               'marginalCost': 0.02542482298207395,
                               'advPercentage': 1e-06, 'notional': -152.78193035177165, 'price': 12.93,
                               'weight': 0.00643203779318686, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Advanced Micro Devices',
                               'transactionCost': 0.5830498039722443, 'sector': 'Information Technology',
                               'correlation': 0.12884947696795268, 'shares': -0.8120055824108264,
                               'assetId': 'MA4B66MW5E27U9YGMB9', 'bbid': 'AMD UW', 'currency': 'USD',
                               'industry': 'Semiconductors & Semiconductor Equipment',
                               'marginalCost': 0.0021087589119167267,
                               'advPercentage': 0, 'notional': -85.91019061906543, 'price': 105.8,
                               'weight': 0.003616773211396386, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Morgan Stanley',
                               'transactionCost': 2.3784881788491172,
                               'sector': 'Financials', 'correlation': 0.9121008220093567, 'shares': -100.16368860962515,
                               'assetId': 'MA4B66MW5E27UAL9STW', 'bbid': 'MS UN', 'currency': 'USD',
                               'industry': 'Capital Markets', 'marginalCost': 1.0321563281719852,
                               'advPercentage': 1.6e-05,
                               'notional': -10307.845194816524, 'price': 102.91, 'weight': 0.43395478579650393,
                               'borrowCost': 40},
                              {'country': 'United States', 'name': 'Citigroup Inc',
                               'transactionCost': 1.4510516652072596,
                               'sector': 'Financials', 'correlation': 0.8189307897328992, 'shares': -27.227187182634943,
                               'assetId': 'MA4B66MW5E27UA4ZCWT', 'bbid': 'C UN', 'currency': 'USD', 'industry': 'Banks',
                               'marginalCost': 0.11839142047698586, 'advPercentage': 2e-06,
                               'notional': -1938.0311836599553,
                               'price': 71.18, 'weight': 0.08159007933054924, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Duke Realty Corp',
                               'transactionCost': 1.3627572059631348,
                               'sector': 'Real Estate', 'correlation': 0.1248871579141672, 'shares': -8.864060939026558,
                               'assetId': 'MA4B66MW5E27UAEP46J', 'bbid': 'DRE UN', 'currency': 'USD',
                               'industry': 'Equity Real Estate Investment Trusts (REITs)',
                               'marginalCost': 0.02484233322743233, 'advPercentage': 5e-06,
                               'notional': -433.0093768714474,
                               'price': 48.85, 'weight': 0.0182294638536693, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Electronic Arts Inc',
                               'transactionCost': 2.1669615507125854, 'sector': 'Communication Services',
                               'correlation': 0.18457789391303997, 'shares': -6.899047429867354,
                               'assetId': 'MA4B66MW5E27UAEP4H9', 'bbid': 'EA UW', 'currency': 'USD',
                               'industry': 'Entertainment', 'marginalCost': 0.08175721364539484, 'advPercentage': 3e-06,
                               'notional': -896.1862611397693, 'price': 129.9, 'weight': 0.037728963681201336,
                               'borrowCost': 40},
                              {'country': 'United States', 'name': 'Qualcomm Inc',
                               'transactionCost': 1.0424676537513733,
                               'sector': 'Information Technology', 'correlation': 0.37498752971441385,
                               'shares': -0.6250042968063627, 'assetId': 'MA4B66MW5E27UAM94Q4', 'bbid': 'QCOM UW',
                               'currency': 'USD', 'industry': 'Semiconductors & Semiconductor Equipment',
                               'marginalCost': 0.0036722977768481185, 'advPercentage': 0,
                               'notional': -83.67557525643583,
                               'price': 133.88, 'weight': 0.00352269709629183, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Albemarle Corp',
                               'transactionCost': 5.661775350570679,
                               'sector': 'Materials', 'correlation': 0.572692690460937, 'shares': -2.9210200815542167,
                               'assetId': 'MA4B66MW5E27U9XPVYM', 'bbid': 'ALB UN', 'currency': 'USD',
                               'industry': 'Chemicals',
                               'marginalCost': 0.157630478243818, 'advPercentage': 2e-06,
                               'notional': -661.3189464638747,
                               'price': 226.4, 'weight': 0.027841174981965627, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Tractor Supply Company',
                               'transactionCost': 3.904104232788086, 'sector': 'Consumer Discretionary',
                               'correlation': 0.07218103540747003, 'shares': -0.49000336869618827,
                               'assetId': 'MA4B66MW5E27UANEQ5C', 'bbid': 'TSCO UW', 'currency': 'USD',
                               'industry': 'Specialty Retail', 'marginalCost': 0.016970819801319783,
                               'advPercentage': 1e-06,
                               'notional': -103.2535098516608, 'price': 210.72, 'weight': 0.004346917702348384,
                               'borrowCost': 40},
                              {'country': 'United States', 'name': 'Davita Inc', 'transactionCost': 3.084942579269409,
                               'sector': 'Health Care', 'correlation': 0.20287653627709595,
                               'shares': -3.4880239796169494,
                               'assetId': 'MA4B66MW5E27UAEP4D8', 'bbid': 'DVA UN', 'currency': 'USD',
                               'industry': 'Health Care Providers & Services', 'marginalCost': 0.05481362341943657,
                               'advPercentage': 6e-06, 'notional': -422.05090153365086, 'price': 121,
                               'weight': 0.01776811788581744, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Citrix Systems Inc',
                               'transactionCost': 2.754676938056946,
                               'sector': 'Information Technology', 'correlation': -0.014004050045478335,
                               'shares': -2.204015152257958, 'assetId': 'MA4B66MW5E27UAE4LLL', 'bbid': 'CTXS UW',
                               'currency': 'USD', 'industry': 'Software', 'marginalCost': 0.028164628476876532,
                               'advPercentage': 2e-06, 'notional': -242.86042962730437, 'price': 110.19,
                               'weight': 0.010224294576170117, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Best Buy Co Inc',
                               'transactionCost': 2.401727557182312,
                               'sector': 'Consumer Discretionary', 'correlation': 0.45583415490693957,
                               'shares': -4.535031177626968, 'assetId': 'MA4B66MW5E27UA39J2L', 'bbid': 'BBY UN',
                               'currency': 'USD', 'industry': 'Specialty Retail', 'marginalCost': 0.04802785408186685,
                               'advPercentage': 2e-06, 'notional': -474.99916554464863, 'price': 104.74,
                               'weight': 0.019997211564750816, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Iron Mountain Inc',
                               'transactionCost': 2.417732357978821,
                               'sector': 'Real Estate', 'correlation': 0.4856832268445906,
                               'shares': -5.0810349313170065,
                               'assetId': 'MA4B66MW5E27UAJQF4M', 'bbid': 'IRM UN', 'currency': 'USD',
                               'industry': 'Equity Real Estate Investment Trusts (REITs)',
                               'marginalCost': 0.02289530957940409, 'advPercentage': 3e-06,
                               'notional': -224.93741640940388,
                               'price': 44.27, 'weight': 0.009469745277572472, 'borrowCost': 40},
                              {'country': 'United States', 'name': 'Tapestry Inc', 'transactionCost': 2.314427137374878,
                               'sector': 'Consumer Discretionary', 'correlation': 0.6555947816398136,
                               'shares': -7.397050853562664, 'assetId': 'MAAHJ4JYCKZ6P025', 'bbid': 'TPR UN',
                               'currency': 'USD', 'industry': 'Textiles, Apparel & Luxury Goods',
                               'marginalCost': 0.02844040606854561, 'advPercentage': 2e-06,
                               'notional': -291.88762668158273,
                               'price': 39.46, 'weight': 0.01228831342722845, 'borrowCost': 40}],
                          'Holding Error': 0.0744447922751884},
                'Hedged Portfolio': {
                    'Constituents': [
                        {'country': 'United States', 'name': 'Apple Inc', 'transactionCost': 1.1936100899058002,
                         'sector': 'Information Technology', 'shares': 26, 'assetId': 'MA4B66MW5E27U9VBB94',
                         'bbid': 'AAPL UW',
                         'currency': 'USD', 'industry': 'Technology Hardware, Storage & Peripherals',
                         'marginalCost': 0.09597615517006632, 'advPercentage': 0, 'notional': 3819.9199999999996,
                         'price': 146.92,
                         'weight': 0.08040829746809594, 'borrowCost': 40},
                        {'country': 'United States', 'name': 'Albemarle Corp', 'transactionCost': 5.661775350570679,
                         'sector': 'Materials', 'shares': -2.9210200815542167, 'assetId': 'MA4B66MW5E27U9XPVYM',
                         'bbid': 'ALB UN',
                         'currency': 'USD', 'industry': 'Chemicals', 'marginalCost': 0.078815239121909,
                         'advPercentage': 2e-06,
                         'notional': -661.3189464638747, 'price': 226.4, 'weight': -0.01392058749098281,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Advanced Micro Devices',
                         'transactionCost': 0.5830498039722443,
                         'sector': 'Information Technology', 'shares': -0.8120055824108264,
                         'assetId': 'MA4B66MW5E27U9YGMB9',
                         'bbid': 'AMD UW', 'currency': 'USD', 'industry': 'Semiconductors & Semiconductor Equipment',
                         'marginalCost': 0.0010543794559583631, 'advPercentage': 0, 'notional': -85.91019061906543,
                         'price': 105.8,
                         'weight': -0.0018083866056981923, 'borrowCost': 40},
                        {'country': 'United States', 'name': 'Best Buy Co Inc', 'transactionCost': 2.401727557182312,
                         'sector': 'Consumer Discretionary', 'shares': -4.535031177626968,
                         'assetId': 'MA4B66MW5E27UA39J2L',
                         'bbid': 'BBY UN', 'currency': 'USD', 'industry': 'Specialty Retail',
                         'marginalCost': 0.02401392704093342,
                         'advPercentage': 2e-06, 'notional': -474.99916554464863, 'price': 104.74,
                         'weight': -0.009998605782375405,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Citigroup Inc', 'transactionCost': 1.4510516652072596,
                         'sector': 'Financials', 'shares': -27.227187182634943, 'assetId': 'MA4B66MW5E27UA4ZCWT',
                         'bbid': 'C UN', 'currency': 'USD', 'industry': 'Banks',
                         'marginalCost': 0.05919571023849292, 'advPercentage': 2e-06,
                         'notional': -1938.0311836599553, 'price': 71.18, 'weight': -0.040795039665274604,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Cummins Inc', 'transactionCost': 3.3661617040634155,
                         'sector': 'Industrials', 'shares': -0.4130028393296445, 'assetId': 'MA4B66MW5E27UACX6RZ',
                         'bbid': 'CMI UN',
                         'currency': 'USD', 'industry': 'Machinery', 'marginalCost': 0.006662256400232119,
                         'advPercentage': 0,
                         'notional': -94.02422640178686, 'price': 227.66, 'weight': -0.0019791848954225427,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Citrix Systems Inc', 'transactionCost': 2.754676938056946,
                         'sector': 'Information Technology', 'shares': -2.204015152257958,
                         'assetId': 'MA4B66MW5E27UAE4LLL',
                         'bbid': 'CTXS UW', 'currency': 'USD', 'industry': 'Software',
                         'marginalCost': 0.014082314238438266,
                         'advPercentage': 2e-06, 'notional': -242.86042962730437, 'price': 110.19,
                         'weight': -0.005112147288085058,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Duke Realty Corp', 'transactionCost': 1.3627572059631348,
                         'sector': 'Real Estate', 'shares': -8.864060939026558, 'assetId': 'MA4B66MW5E27UAEP46J',
                         'bbid': 'DRE UN',
                         'currency': 'USD', 'industry': 'Equity Real Estate Investment Trusts (REITs)',
                         'marginalCost': 0.012421166613716166, 'advPercentage': 5e-06, 'notional': -433.0093768714474,
                         'price': 48.85,
                         'weight': -0.009114731926834648, 'borrowCost': 40},
                        {'country': 'United States', 'name': 'Davita Inc', 'transactionCost': 3.084942579269409,
                         'sector': 'Health Care', 'shares': -3.4880239796169494, 'assetId': 'MA4B66MW5E27UAEP4D8',
                         'bbid': 'DVA UN',
                         'currency': 'USD', 'industry': 'Health Care Providers & Services',
                         'marginalCost': 0.027406811709718284,
                         'advPercentage': 6e-06, 'notional': -422.05090153365086, 'price': 121,
                         'weight': -0.008884058942908718,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Electronic Arts Inc',
                         'transactionCost': 2.1669615507125854,
                         'sector': 'Communication Services', 'shares': -6.899047429867354,
                         'assetId': 'MA4B66MW5E27UAEP4H9',
                         'bbid': 'EA UW', 'currency': 'USD', 'industry': 'Entertainment',
                         'marginalCost': 0.040878606822697415,
                         'advPercentage': 3e-06, 'notional': -896.1862611397693, 'price': 129.9,
                         'weight': -0.01886448184060066,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Extra Space Storage Inc',
                         'transactionCost': 3.9990124702453613,
                         'sector': 'Real Estate', 'shares': -3.1030213327842304, 'assetId': 'MA4B66MW5E27UAFU2CS',
                         'bbid': 'EXR UN',
                         'currency': 'USD', 'industry': 'Equity Real Estate Investment Trusts (REITs)',
                         'marginalCost': 0.04508686837043359, 'advPercentage': 5e-06, 'notional': -535.6125122518861,
                         'price': 172.61,
                         'weight': -0.011274500568803494, 'borrowCost': 40},
                        {'country': 'United States', 'name': 'General Motors Co', 'transactionCost': 1.0103281140327454,
                         'sector': 'Consumer Discretionary', 'shares': -3.0290208240423557,
                         'assetId': 'MA4B66MW5E27UAGYYVE',
                         'bbid': 'GM UN', 'currency': 'USD', 'industry': 'Automobiles',
                         'marginalCost': 0.003364583586707687,
                         'advPercentage': 0, 'notional': -158.20575763973224, 'price': 52.23,
                         'weight': -0.003330189014812112,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'The Goldman Sachs Group, Inc.',
                         'transactionCost': 3.2194154492372298,
                         'sector': 'Financials', 'shares': 51, 'assetId': 'MA4B66MW5E27UAHKG34', 'bbid': 'GS UN',
                         'currency': 'USD',
                         'industry': 'Capital Markets', 'marginalCost': 1.3508400095029636, 'advPercentage': 2.3e-05,
                         'notional': 19933.350000000002, 'price': 390.85, 'weight': 0.4195917025319039,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Hormel Foods Corp', 'transactionCost': 1.4352393746376038,
                         'sector': 'Consumer Staples', 'shares': -11.239077266890737, 'assetId': 'MA4B66MW5E27UAJ5XEZ',
                         'bbid': 'HRL UN', 'currency': 'USD', 'industry': 'Food Products',
                         'marginalCost': 0.013853571784092618,
                         'advPercentage': 4e-06, 'notional': -458.55435248914205, 'price': 40.8,
                         'weight': -0.009652446852352158,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Iron Mountain Inc', 'transactionCost': 2.417732357978821,
                         'sector': 'Real Estate', 'shares': -5.0810349313170065, 'assetId': 'MA4B66MW5E27UAJQF4M',
                         'bbid': 'IRM UN',
                         'currency': 'USD', 'industry': 'Equity Real Estate Investment Trusts (REITs)',
                         'marginalCost': 0.011447654789702045, 'advPercentage': 3e-06, 'notional': -224.93741640940388,
                         'price': 44.27,
                         'weight': -0.004734872638786235, 'borrowCost': 40},
                        {'country': 'United States', 'name': 'JPMorgan Chase & Co',
                         'transactionCost': 1.2586397729172192,
                         'sector': 'Financials', 'shares': -12.604086651115832, 'assetId': 'MA4B66MW5E27UAKHZFD',
                         'bbid': 'JPM UN',
                         'currency': 'USD', 'industry': 'Banks', 'marginalCost': 0.054444447777798256,
                         'advPercentage': 1e-06,
                         'notional': -2054.970287597925, 'price': 163.04, 'weight': -0.043256576622880225,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Kroger Co', 'transactionCost': 1.2731897830963135,
                         'sector': 'Consumer Staples', 'shares': -1.730011893560012, 'assetId': 'MA4B66MW5E27UAKNZNV',
                         'bbid': 'KR UN',
                         'currency': 'USD', 'industry': 'Food & Staples Retailing',
                         'marginalCost': 0.0018536665905637035,
                         'advPercentage': 0, 'notional': -69.16587550452927, 'price': 39.98,
                         'weight': -0.001455923237190695,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Mosaic Co/the', 'transactionCost': 2.1279181241989136,
                         'sector': 'Materials', 'shares': -5.192035694429817, 'assetId': 'MA4B66MW5E27UAL9SLW',
                         'bbid': 'MOS UN', 'currency': 'USD', 'industry': 'Chemicals',
                         'marginalCost': 0.008339681547933048, 'advPercentage': 2e-06,
                         'notional': -186.18640000225324, 'price': 35.86, 'weight': -0.003919174075869411,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Morgan Stanley', 'transactionCost': 2.3784881788491172,
                         'sector': 'Financials', 'shares': -100.16368860962515, 'assetId': 'MA4B66MW5E27UAL9STW',
                         'bbid': 'MS UN',
                         'currency': 'USD', 'industry': 'Capital Markets', 'marginalCost': 0.5160781640859926,
                         'advPercentage': 1.6e-05,
                         'notional': -10307.845194816524, 'price': 102.91, 'weight': -0.2169773928982519,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'MSCI Inc', 'transactionCost': 7.908167362213135,
                         'sector': 'Financials',
                         'shares': -0.5740039461869635, 'assetId': 'MA4B66MW5E27UAL9SUH', 'bbid': 'MSCI UN',
                         'currency': 'USD',
                         'industry': 'Capital Markets', 'marginalCost': 0.06319486932947428, 'advPercentage': 2e-06,
                         'notional': -379.628989889672, 'price': 661.37, 'weight': -0.007991089014053052,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Nucor Corp', 'transactionCost': 3.182479500770569,
                         'sector': 'Materials',
                         'shares': -0.7970054792874738, 'assetId': 'MA4B66MW5E27UALNB48', 'bbid': 'NUE UN',
                         'currency': 'USD',
                         'industry': 'Metals & Mining', 'marginalCost': 0.005388287534627193, 'advPercentage': 0,
                         'notional': -80.43379296969185, 'price': 100.92, 'weight': -0.001693109895388968,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Paypal Holdings Inc',
                         'transactionCost': 1.4358487129211426,
                         'sector': 'Information Technology', 'shares': -0.5480037674398188,
                         'assetId': 'MA4B66MW5E27UAM94N9',
                         'bbid': 'PYPL UW', 'currency': 'USD', 'industry': 'IT Services',
                         'marginalCost': 0.004606334069169853,
                         'advPercentage': 0, 'notional': -152.40532776268802, 'price': 278.11,
                         'weight': -0.0032080915125093927,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Qualcomm Inc', 'transactionCost': 1.0424676537513733,
                         'sector': 'Information Technology', 'shares': -0.6250042968063627,
                         'assetId': 'MA4B66MW5E27UAM94Q4', 'bbid': 'QCOM UW', 'currency': 'USD',
                         'industry': 'Semiconductors & Semiconductor Equipment',
                         'marginalCost': 0.001836148888424059, 'advPercentage': 0, 'notional': -83.67557525643583,
                         'price': 133.88, 'weight': -0.0017613485481459143, 'borrowCost': 40},
                        {'country': 'United States', 'name': 'Tractor Supply Company',
                         'transactionCost': 3.904104232788086,
                         'sector': 'Consumer Discretionary', 'shares': -0.49000336869618827,
                         'assetId': 'MA4B66MW5E27UANEQ5C',
                         'bbid': 'TSCO UW', 'currency': 'USD', 'industry': 'Specialty Retail',
                         'marginalCost': 0.00848540990065989,
                         'advPercentage': 1e-06, 'notional': -103.2535098516608, 'price': 210.72,
                         'weight': -0.002173458851174191,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Twitter Inc', 'transactionCost': 1.2658634781837463,
                         'sector': 'Communication Services', 'shares': -8.874061007775461,
                         'assetId': 'MA4B66MW5E27UANLXU9', 'bbid': 'TWTR UN', 'currency': 'USD',
                         'industry': 'Interactive Media & Services', 'marginalCost': 0.015894775099317016,
                         'advPercentage': 1e-06, 'notional': -596.5143809426665, 'price': 67.22,
                         'weight': -0.012556468666054534, 'borrowCost': 40},
                        {'country': 'United States', 'name': 'Wells Fargo & Co', 'transactionCost': 1.3822112533240394,
                         'sector': 'Financials', 'shares': -43.79430107894055, 'assetId': 'MA4B66MW5E27UANT8X5',
                         'bbid': 'WFC UN',
                         'currency': 'USD', 'industry': 'Banks', 'marginalCost': 0.061059807755110544,
                         'advPercentage': 2e-06,
                         'notional': -2098.622907702831, 'price': 47.92, 'weight': -0.044175452636686034,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Dentsply Sirona Inc',
                         'transactionCost': 2.9051536321640015,
                         'sector': 'Health Care', 'shares': -5.308036491917078, 'assetId': 'MA4B66MW5E27UANZH4M',
                         'bbid': 'XRAY UW',
                         'currency': 'USD', 'industry': 'Health Care Equipment & Supplies',
                         'marginalCost': 0.01947929477213156,
                         'advPercentage': 5e-06, 'notional': -318.5352698799438, 'price': 60.01,
                         'weight': -0.006705082497692817,
                         'borrowCost': 40},
                        {'country': 'United States', 'name': 'Meta Platforms Inc-Class A',
                         'transactionCost': 0.8238705992698669,
                         'sector': 'Communication Services', 'shares': -0.7130049017966985,
                         'assetId': 'MA4B66MW5E3VLSECN',
                         'bbid': 'FB UW', 'currency': 'USD', 'industry': 'Interactive Media & Services',
                         'marginalCost': 0.004364390584540722, 'advPercentage': 0, 'notional': -251.6622101381627,
                         'price': 352.96,
                         'weight': -0.005297422420958517, 'borrowCost': 40},
                        {'country': 'United States', 'name': 'Tapestry Inc', 'transactionCost': 2.314427137374878,
                         'sector': 'Consumer Discretionary', 'shares': -7.397050853562664,
                         'assetId': 'MAAHJ4JYCKZ6P025',
                         'bbid': 'TPR UN', 'currency': 'USD', 'industry': 'Textiles, Apparel & Luxury Goods',
                         'marginalCost': 0.014220203034272804, 'advPercentage': 2e-06, 'notional': -291.88762668158273,
                         'price': 39.46,
                         'weight': -0.006144156713614223, 'borrowCost': 40},
                        {'country': 'United States', 'name': 'Lumen Technologies Inc',
                         'transactionCost': 3.95284104347229,
                         'sector': 'Communication Services', 'shares': -11.81608123370237,
                         'assetId': 'MAQQM1QHGJDFAVKN',
                         'bbid': 'LUMN UN', 'currency': 'USD', 'industry': 'Diversified Telecommunication Services',
                         'marginalCost': 0.012712411491036973, 'advPercentage': 1e-06, 'notional': -152.78193035177165,
                         'price': 12.93,
                         'weight': -0.003216018896593429, 'borrowCost': 40}], 'Transaction Cost': 2.5770571473071144}}


def test_hedge_exclusions_to_dict():
    exclusions = HedgeExclusions(assets=['GS UN'],
                                 countries=['Mexico'],
                                 regions=['Europe'],
                                 sectors=['Utilities'],
                                 industries=['Airlines'])

    assert exclusions.to_dict() == {
        'classificationConstraints': [{
            'name': 'Mexico', 'min': 0, 'max': 0, 'type': 'Country'},
            {'name': 'Europe', 'min': 0, 'max': 0, 'type': 'Region'},
            {'name': 'Utilities', 'min': 0, 'max': 0, 'type': 'Sector'},
            {'name': 'Airlines', 'min': 0, 'max': 0, 'type': 'Industry'}],
        'assetConstraints': [{'min': 0, 'max': 0, 'assetId': 'GS UN'}]}


def test_hedge_constraints_to_dict():
    constraints = HedgeConstraints(sectors=[Constraint(constraint_name='Software', minimum=0, maximum=20)],
                                   esg=[Constraint(constraint_name='gPercentile', minimum=75, maximum=100)])
    assert constraints.to_dict() == {
        'classificationConstraints': [
            {
                'name': 'Software',
                'min': 0,
                'max': 20,
                'type': 'Sector'
            }
        ],
        'esgConstraints': [
            {'name': 'gPercentile',
             'min': 75,
             'max': 100
             }
        ]
    }


def test_format_hedge_calculate_results():
    assert Hedge._format_hedge_calculate_results(calculation_results) == mock_results


def get_mock_hedge(mocker):
    mocker.patch.object(PerformanceHedgeParameters, 'to_dict', return_value={})
    mocker.patch.object(PerformanceHedgeParameters, 'resolve_identifiers_in_payload', return_value={})
    mocker.patch.object(GsHedgeApi, 'calculate_hedge', return_value={'result': calculation_results})
    hedge = PerformanceHedge(parameters=PerformanceHedgeParameters(
        initial_portfolio=PositionSet(positions=[Position(asset_id='fakeId', identifier='fakeId', quantity=1)],
                                      date=dt.date(2020, 1, 1)),
        universe=[],
        exclusions=HedgeExclusions(),
        constraints=HedgeConstraints()
    ))
    hedge.calculate()
    return hedge


def test_get_constituents(mocker):
    hedge = get_mock_hedge(mocker)
    constituents = hedge.get_constituents()
    assert constituents.shape == (28, 16)


def test_get_statistics(mocker):
    hedge = get_mock_hedge(mocker)
    constituents = hedge.get_statistics()
    assert constituents.shape == (7, 3)


def test_get_backtest_performance(mocker):
    hedge = get_mock_hedge(mocker)
    constituents = hedge.get_backtest_performance()
    assert constituents.shape == (262, 2)


if __name__ == '__main__':
    pytest.main(args=[__file__])
