# API Reference

**Classes**

Name|Description
----|-----------
[Config](#cdktf-provider-docker-config)|Represents a {@link https://www.terraform.io/docs/providers/docker/r/config docker_config}.
[Container](#cdktf-provider-docker-container)|Represents a {@link https://www.terraform.io/docs/providers/docker/r/container docker_container}.
[ContainerCapabilitiesOutputReference](#cdktf-provider-docker-containercapabilitiesoutputreference)|*No description*
[ContainerHealthcheckOutputReference](#cdktf-provider-docker-containerhealthcheckoutputreference)|*No description*
[ContainerMountsBindOptionsOutputReference](#cdktf-provider-docker-containermountsbindoptionsoutputreference)|*No description*
[ContainerMountsTmpfsOptionsOutputReference](#cdktf-provider-docker-containermountstmpfsoptionsoutputreference)|*No description*
[ContainerMountsVolumeOptionsOutputReference](#cdktf-provider-docker-containermountsvolumeoptionsoutputreference)|*No description*
[ContainerNetworkData](#cdktf-provider-docker-containernetworkdata)|*No description*
[DataDockerImage](#cdktf-provider-docker-datadockerimage)|Represents a {@link https://www.terraform.io/docs/providers/docker/d/image docker_image}.
[DataDockerNetwork](#cdktf-provider-docker-datadockernetwork)|Represents a {@link https://www.terraform.io/docs/providers/docker/d/network docker_network}.
[DataDockerNetworkIpamConfig](#cdktf-provider-docker-datadockernetworkipamconfig)|*No description*
[DataDockerPlugin](#cdktf-provider-docker-datadockerplugin)|Represents a {@link https://www.terraform.io/docs/providers/docker/d/plugin docker_plugin}.
[DataDockerRegistryImage](#cdktf-provider-docker-datadockerregistryimage)|Represents a {@link https://www.terraform.io/docs/providers/docker/d/registry_image docker_registry_image}.
[DockerProvider](#cdktf-provider-docker-dockerprovider)|Represents a {@link https://www.terraform.io/docs/providers/docker docker}.
[Image](#cdktf-provider-docker-image)|Represents a {@link https://www.terraform.io/docs/providers/docker/r/image docker_image}.
[ImageBuildOutputReference](#cdktf-provider-docker-imagebuildoutputreference)|*No description*
[Network](#cdktf-provider-docker-network)|Represents a {@link https://www.terraform.io/docs/providers/docker/r/network docker_network}.
[Plugin](#cdktf-provider-docker-plugin)|Represents a {@link https://www.terraform.io/docs/providers/docker/r/plugin docker_plugin}.
[RegistryImage](#cdktf-provider-docker-registryimage)|Represents a {@link https://www.terraform.io/docs/providers/docker/r/registry_image docker_registry_image}.
[RegistryImageBuildOutputReference](#cdktf-provider-docker-registryimagebuildoutputreference)|*No description*
[Secret](#cdktf-provider-docker-secret)|Represents a {@link https://www.terraform.io/docs/providers/docker/r/secret docker_secret}.
[Service](#cdktf-provider-docker-service)|Represents a {@link https://www.terraform.io/docs/providers/docker/r/service docker_service}.
[ServiceAuthOutputReference](#cdktf-provider-docker-serviceauthoutputreference)|*No description*
[ServiceConvergeConfigOutputReference](#cdktf-provider-docker-serviceconvergeconfigoutputreference)|*No description*
[ServiceEndpointSpecOutputReference](#cdktf-provider-docker-serviceendpointspecoutputreference)|*No description*
[ServiceModeOutputReference](#cdktf-provider-docker-servicemodeoutputreference)|*No description*
[ServiceModeReplicatedOutputReference](#cdktf-provider-docker-servicemodereplicatedoutputreference)|*No description*
[ServiceRollbackConfigOutputReference](#cdktf-provider-docker-servicerollbackconfigoutputreference)|*No description*
[ServiceTaskSpecContainerSpecDnsConfigOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecdnsconfigoutputreference)|*No description*
[ServiceTaskSpecContainerSpecHealthcheckOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspechealthcheckoutputreference)|*No description*
[ServiceTaskSpecContainerSpecMountsBindOptionsOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecmountsbindoptionsoutputreference)|*No description*
[ServiceTaskSpecContainerSpecMountsTmpfsOptionsOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecmountstmpfsoptionsoutputreference)|*No description*
[ServiceTaskSpecContainerSpecMountsVolumeOptionsOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptionsoutputreference)|*No description*
[ServiceTaskSpecContainerSpecOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecoutputreference)|*No description*
[ServiceTaskSpecContainerSpecPrivilegesCredentialSpecOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspecoutputreference)|*No description*
[ServiceTaskSpecContainerSpecPrivilegesOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegesoutputreference)|*No description*
[ServiceTaskSpecContainerSpecPrivilegesSeLinuxContextOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontextoutputreference)|*No description*
[ServiceTaskSpecLogDriverOutputReference](#cdktf-provider-docker-servicetaskspeclogdriveroutputreference)|*No description*
[ServiceTaskSpecOutputReference](#cdktf-provider-docker-servicetaskspecoutputreference)|*No description*
[ServiceTaskSpecPlacementOutputReference](#cdktf-provider-docker-servicetaskspecplacementoutputreference)|*No description*
[ServiceTaskSpecResourcesLimitsOutputReference](#cdktf-provider-docker-servicetaskspecresourceslimitsoutputreference)|*No description*
[ServiceTaskSpecResourcesOutputReference](#cdktf-provider-docker-servicetaskspecresourcesoutputreference)|*No description*
[ServiceTaskSpecResourcesReservationGenericResourcesOutputReference](#cdktf-provider-docker-servicetaskspecresourcesreservationgenericresourcesoutputreference)|*No description*
[ServiceTaskSpecResourcesReservationOutputReference](#cdktf-provider-docker-servicetaskspecresourcesreservationoutputreference)|*No description*
[ServiceTaskSpecRestartPolicyOutputReference](#cdktf-provider-docker-servicetaskspecrestartpolicyoutputreference)|*No description*
[ServiceUpdateConfigOutputReference](#cdktf-provider-docker-serviceupdateconfigoutputreference)|*No description*
[Volume](#cdktf-provider-docker-volume)|Represents a {@link https://www.terraform.io/docs/providers/docker/r/volume docker_volume}.


**Structs**

Name|Description
----|-----------
[ConfigConfig](#cdktf-provider-docker-configconfig)|*No description*
[ContainerCapabilities](#cdktf-provider-docker-containercapabilities)|*No description*
[ContainerConfig](#cdktf-provider-docker-containerconfig)|*No description*
[ContainerDevices](#cdktf-provider-docker-containerdevices)|*No description*
[ContainerHealthcheck](#cdktf-provider-docker-containerhealthcheck)|*No description*
[ContainerHost](#cdktf-provider-docker-containerhost)|*No description*
[ContainerLabels](#cdktf-provider-docker-containerlabels)|*No description*
[ContainerMounts](#cdktf-provider-docker-containermounts)|*No description*
[ContainerMountsBindOptions](#cdktf-provider-docker-containermountsbindoptions)|*No description*
[ContainerMountsTmpfsOptions](#cdktf-provider-docker-containermountstmpfsoptions)|*No description*
[ContainerMountsVolumeOptions](#cdktf-provider-docker-containermountsvolumeoptions)|*No description*
[ContainerMountsVolumeOptionsLabels](#cdktf-provider-docker-containermountsvolumeoptionslabels)|*No description*
[ContainerNetworksAdvanced](#cdktf-provider-docker-containernetworksadvanced)|*No description*
[ContainerPorts](#cdktf-provider-docker-containerports)|*No description*
[ContainerUlimit](#cdktf-provider-docker-containerulimit)|*No description*
[ContainerUpload](#cdktf-provider-docker-containerupload)|*No description*
[ContainerVolumes](#cdktf-provider-docker-containervolumes)|*No description*
[DataDockerImageConfig](#cdktf-provider-docker-datadockerimageconfig)|*No description*
[DataDockerNetworkConfig](#cdktf-provider-docker-datadockernetworkconfig)|*No description*
[DataDockerPluginConfig](#cdktf-provider-docker-datadockerpluginconfig)|*No description*
[DataDockerRegistryImageConfig](#cdktf-provider-docker-datadockerregistryimageconfig)|*No description*
[DockerProviderConfig](#cdktf-provider-docker-dockerproviderconfig)|*No description*
[DockerProviderRegistryAuth](#cdktf-provider-docker-dockerproviderregistryauth)|*No description*
[ImageBuild](#cdktf-provider-docker-imagebuild)|*No description*
[ImageConfig](#cdktf-provider-docker-imageconfig)|*No description*
[NetworkConfig](#cdktf-provider-docker-networkconfig)|*No description*
[NetworkIpamConfig](#cdktf-provider-docker-networkipamconfig)|*No description*
[NetworkLabels](#cdktf-provider-docker-networklabels)|*No description*
[PluginConfig](#cdktf-provider-docker-pluginconfig)|*No description*
[PluginGrantPermissions](#cdktf-provider-docker-plugingrantpermissions)|*No description*
[RegistryImageBuild](#cdktf-provider-docker-registryimagebuild)|*No description*
[RegistryImageBuildAuthConfig](#cdktf-provider-docker-registryimagebuildauthconfig)|*No description*
[RegistryImageBuildUlimit](#cdktf-provider-docker-registryimagebuildulimit)|*No description*
[RegistryImageConfig](#cdktf-provider-docker-registryimageconfig)|*No description*
[SecretConfig](#cdktf-provider-docker-secretconfig)|*No description*
[SecretLabels](#cdktf-provider-docker-secretlabels)|*No description*
[ServiceAuth](#cdktf-provider-docker-serviceauth)|*No description*
[ServiceConfig](#cdktf-provider-docker-serviceconfig)|*No description*
[ServiceConvergeConfig](#cdktf-provider-docker-serviceconvergeconfig)|*No description*
[ServiceEndpointSpec](#cdktf-provider-docker-serviceendpointspec)|*No description*
[ServiceEndpointSpecPorts](#cdktf-provider-docker-serviceendpointspecports)|*No description*
[ServiceLabels](#cdktf-provider-docker-servicelabels)|*No description*
[ServiceMode](#cdktf-provider-docker-servicemode)|*No description*
[ServiceModeReplicated](#cdktf-provider-docker-servicemodereplicated)|*No description*
[ServiceRollbackConfig](#cdktf-provider-docker-servicerollbackconfig)|*No description*
[ServiceTaskSpec](#cdktf-provider-docker-servicetaskspec)|*No description*
[ServiceTaskSpecContainerSpec](#cdktf-provider-docker-servicetaskspeccontainerspec)|*No description*
[ServiceTaskSpecContainerSpecConfigs](#cdktf-provider-docker-servicetaskspeccontainerspecconfigs)|*No description*
[ServiceTaskSpecContainerSpecDnsConfig](#cdktf-provider-docker-servicetaskspeccontainerspecdnsconfig)|*No description*
[ServiceTaskSpecContainerSpecHealthcheck](#cdktf-provider-docker-servicetaskspeccontainerspechealthcheck)|*No description*
[ServiceTaskSpecContainerSpecHosts](#cdktf-provider-docker-servicetaskspeccontainerspechosts)|*No description*
[ServiceTaskSpecContainerSpecLabels](#cdktf-provider-docker-servicetaskspeccontainerspeclabels)|*No description*
[ServiceTaskSpecContainerSpecMounts](#cdktf-provider-docker-servicetaskspeccontainerspecmounts)|*No description*
[ServiceTaskSpecContainerSpecMountsBindOptions](#cdktf-provider-docker-servicetaskspeccontainerspecmountsbindoptions)|*No description*
[ServiceTaskSpecContainerSpecMountsTmpfsOptions](#cdktf-provider-docker-servicetaskspeccontainerspecmountstmpfsoptions)|*No description*
[ServiceTaskSpecContainerSpecMountsVolumeOptions](#cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptions)|*No description*
[ServiceTaskSpecContainerSpecMountsVolumeOptionsLabels](#cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptionslabels)|*No description*
[ServiceTaskSpecContainerSpecPrivileges](#cdktf-provider-docker-servicetaskspeccontainerspecprivileges)|*No description*
[ServiceTaskSpecContainerSpecPrivilegesCredentialSpec](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspec)|*No description*
[ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontext)|*No description*
[ServiceTaskSpecContainerSpecSecrets](#cdktf-provider-docker-servicetaskspeccontainerspecsecrets)|*No description*
[ServiceTaskSpecLogDriver](#cdktf-provider-docker-servicetaskspeclogdriver)|*No description*
[ServiceTaskSpecPlacement](#cdktf-provider-docker-servicetaskspecplacement)|*No description*
[ServiceTaskSpecPlacementPlatforms](#cdktf-provider-docker-servicetaskspecplacementplatforms)|*No description*
[ServiceTaskSpecResources](#cdktf-provider-docker-servicetaskspecresources)|*No description*
[ServiceTaskSpecResourcesLimits](#cdktf-provider-docker-servicetaskspecresourceslimits)|*No description*
[ServiceTaskSpecResourcesReservation](#cdktf-provider-docker-servicetaskspecresourcesreservation)|*No description*
[ServiceTaskSpecResourcesReservationGenericResources](#cdktf-provider-docker-servicetaskspecresourcesreservationgenericresources)|*No description*
[ServiceTaskSpecRestartPolicy](#cdktf-provider-docker-servicetaskspecrestartpolicy)|*No description*
[ServiceUpdateConfig](#cdktf-provider-docker-serviceupdateconfig)|*No description*
[VolumeConfig](#cdktf-provider-docker-volumeconfig)|*No description*
[VolumeLabels](#cdktf-provider-docker-volumelabels)|*No description*



## class Config  <a id="cdktf-provider-docker-config"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/r/config docker_config}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/r/config docker_config} Resource.

```ts
new Config(scope: Construct, id: string, config: ConfigConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[ConfigConfig](#cdktf-provider-docker-configconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **data** (<code>string</code>)  Base64-url-safe-encoded config data. 
  * **name** (<code>string</code>)  User-defined name of the config. 



### Properties


Name | Type | Description 
-----|------|-------------
**data** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**dataInput**? | <code>string</code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-docker-config-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class Container  <a id="cdktf-provider-docker-container"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/r/container docker_container}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/r/container docker_container} Resource.

```ts
new Container(scope: Construct, id: string, config: ContainerConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[ContainerConfig](#cdktf-provider-docker-containerconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **image** (<code>string</code>)  The ID of the image to back this container. 
  * **name** (<code>string</code>)  The name of the container. 
  * **attach** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true` attach to the container after its creation and waits the end of its execution. Defaults to `false`. __*Optional*__
  * **capabilities** (<code>[ContainerCapabilities](#cdktf-provider-docker-containercapabilities)</code>)  capabilities block. __*Optional*__
  * **command** (<code>Array<string></code>)  The command to use to start the container. __*Optional*__
  * **cpuSet** (<code>string</code>)  A comma-separated list or hyphen-separated range of CPUs a container can use, e.g. `0-1`. __*Optional*__
  * **cpuShares** (<code>number</code>)  CPU shares (relative weight) for the container. __*Optional*__
  * **destroyGraceSeconds** (<code>number</code>)  If defined will attempt to stop the container before destroying. __*Optional*__
  * **devices** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerDevices](#cdktf-provider-docker-containerdevices)></code>)  devices block. __*Optional*__
  * **dns** (<code>Array<string></code>)  DNS servers to use. __*Optional*__
  * **dnsOpts** (<code>Array<string></code>)  DNS options used by the DNS provider(s), see `resolv.conf` documentation for valid list of options. __*Optional*__
  * **dnsSearch** (<code>Array<string></code>)  DNS search domains that are used when bare unqualified hostnames are used inside of the container. __*Optional*__
  * **domainname** (<code>string</code>)  Domain name of the container. __*Optional*__
  * **entrypoint** (<code>Array<string></code>)  The command to use as the Entrypoint for the container. __*Optional*__
  * **env** (<code>Array<string></code>)  Environment variables to set in the form of `KEY=VALUE`, e.g. `DEBUG=0`. __*Optional*__
  * **groupAdd** (<code>Array<string></code>)  Additional groups for the container user. __*Optional*__
  * **healthcheck** (<code>[ContainerHealthcheck](#cdktf-provider-docker-containerhealthcheck)</code>)  healthcheck block. __*Optional*__
  * **host** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerHost](#cdktf-provider-docker-containerhost)></code>)  host block. __*Optional*__
  * **hostname** (<code>string</code>)  Hostname of the container. __*Optional*__
  * **init** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Configured whether an init process should be injected for this container. __*Optional*__
  * **ipcMode** (<code>string</code>)  IPC sharing mode for the container. Possible values are: `none`, `private`, `shareable`, `container:<name|id>` or `host`. __*Optional*__
  * **labels** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerLabels](#cdktf-provider-docker-containerlabels)></code>)  labels block. __*Optional*__
  * **links** (<code>Array<string></code>)  Set of links for link based connectivity between containers that are running on the same host. __*Optional*__
  * **logDriver** (<code>string</code>)  The logging driver to use for the container. __*Optional*__
  * **logOpts** (<code>Map<string, string></code>)  Key/value pairs to use as options for the logging driver. __*Optional*__
  * **logs** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Save the container logs (`attach` must be enabled). Defaults to `false`. __*Optional*__
  * **maxRetryCount** (<code>number</code>)  The maximum amount of times to an attempt a restart when `restart` is set to 'on-failure'. __*Optional*__
  * **memory** (<code>number</code>)  The memory limit for the container in MBs. __*Optional*__
  * **memorySwap** (<code>number</code>)  The total memory limit (memory + swap) for the container in MBs. __*Optional*__
  * **mounts** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerMounts](#cdktf-provider-docker-containermounts)></code>)  mounts block. __*Optional*__
  * **mustRun** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true`, then the Docker container will be kept running. __*Optional*__
  * **networkAlias** (<code>Array<string></code>)  Set an alias for the container in all specified networks. __*Optional*__
  * **networkMode** (<code>string</code>)  Network mode of the container. __*Optional*__
  * **networks** (<code>Array<string></code>)  ID of the networks in which the container is. __*Optional*__
  * **networksAdvanced** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerNetworksAdvanced](#cdktf-provider-docker-containernetworksadvanced)></code>)  networks_advanced block. __*Optional*__
  * **pidMode** (<code>string</code>)  he PID (Process) Namespace mode for the container. Either `container:<name|id>` or `host`. __*Optional*__
  * **ports** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerPorts](#cdktf-provider-docker-containerports)></code>)  ports block. __*Optional*__
  * **privileged** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true`, the container runs in privileged mode. __*Optional*__
  * **publishAllPorts** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Publish all ports of the container. __*Optional*__
  * **readOnly** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true`, the container will be started as readonly. Defaults to `false`. __*Optional*__
  * **removeVolumes** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true`, it will remove anonymous volumes associated with the container. Defaults to `true`. __*Optional*__
  * **restart** (<code>string</code>)  The restart policy for the container. Must be one of 'no', 'on-failure', 'always', 'unless-stopped'. Defaults to `no`. __*Optional*__
  * **rm** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true`, then the container will be automatically removed when it exits. Defaults to `false`. __*Optional*__
  * **securityOpts** (<code>Array<string></code>)  List of string values to customize labels for MLS systems, such as SELinux. See https://docs.docker.com/engine/reference/run/#security-configuration. __*Optional*__
  * **shmSize** (<code>number</code>)  Size of `/dev/shm` in MBs. __*Optional*__
  * **start** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true`, then the Docker container will be started after creation. __*Optional*__
  * **stdinOpen** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true`, keep STDIN open even if not attached (`docker run -i`). Defaults to `false`. __*Optional*__
  * **storageOpts** (<code>Map<string, string></code>)  Key/value pairs for the storage driver options, e.g. `size`: `120G`. __*Optional*__
  * **sysctls** (<code>Map<string, string></code>)  A map of kernel parameters (sysctls) to set in the container. __*Optional*__
  * **tmpfs** (<code>Map<string, string></code>)  A map of container directories which should be replaced by `tmpfs mounts`, and their corresponding mount options. __*Optional*__
  * **tty** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true`, allocate a pseudo-tty (`docker run -t`). Defaults to `false`. __*Optional*__
  * **ulimit** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerUlimit](#cdktf-provider-docker-containerulimit)></code>)  ulimit block. __*Optional*__
  * **upload** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerUpload](#cdktf-provider-docker-containerupload)></code>)  upload block. __*Optional*__
  * **user** (<code>string</code>)  User used for run the first process. __*Optional*__
  * **usernsMode** (<code>string</code>)  Sets the usernamespace mode for the container when usernamespace remapping option is enabled. __*Optional*__
  * **volumes** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerVolumes](#cdktf-provider-docker-containervolumes)></code>)  volumes block. __*Optional*__
  * **workingDir** (<code>string</code>)  The working directory for commands to run in. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**attach** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**bridge** | <code>string</code> | <span></span>
**capabilities** | <code>[ContainerCapabilitiesOutputReference](#cdktf-provider-docker-containercapabilitiesoutputreference)</code> | <span></span>
**command** | <code>Array<string></code> | <span></span>
**containerLogs** | <code>string</code> | <span></span>
**cpuSet** | <code>string</code> | <span></span>
**cpuShares** | <code>number</code> | <span></span>
**destroyGraceSeconds** | <code>number</code> | <span></span>
**devices** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerDevices](#cdktf-provider-docker-containerdevices)></code> | <span></span>
**dns** | <code>Array<string></code> | <span></span>
**dnsOpts** | <code>Array<string></code> | <span></span>
**dnsSearch** | <code>Array<string></code> | <span></span>
**domainname** | <code>string</code> | <span></span>
**entrypoint** | <code>Array<string></code> | <span></span>
**env** | <code>Array<string></code> | <span></span>
**exitCode** | <code>number</code> | <span></span>
**gateway** | <code>string</code> | <span></span>
**groupAdd** | <code>Array<string></code> | <span></span>
**healthcheck** | <code>[ContainerHealthcheckOutputReference](#cdktf-provider-docker-containerhealthcheckoutputreference)</code> | <span></span>
**host** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerHost](#cdktf-provider-docker-containerhost)></code> | <span></span>
**hostname** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**image** | <code>string</code> | <span></span>
**init** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**ipAddress** | <code>string</code> | <span></span>
**ipPrefixLength** | <code>number</code> | <span></span>
**ipcMode** | <code>string</code> | <span></span>
**labels** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerLabels](#cdktf-provider-docker-containerlabels)></code> | <span></span>
**links** | <code>Array<string></code> | <span></span>
**logDriver** | <code>string</code> | <span></span>
**logOpts** | <code>Map<string, string></code> | <span></span>
**logs** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**maxRetryCount** | <code>number</code> | <span></span>
**memory** | <code>number</code> | <span></span>
**memorySwap** | <code>number</code> | <span></span>
**mounts** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerMounts](#cdktf-provider-docker-containermounts)></code> | <span></span>
**mustRun** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**name** | <code>string</code> | <span></span>
**networkAlias** | <code>Array<string></code> | <span></span>
**networkMode** | <code>string</code> | <span></span>
**networks** | <code>Array<string></code> | <span></span>
**networksAdvanced** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerNetworksAdvanced](#cdktf-provider-docker-containernetworksadvanced)></code> | <span></span>
**pidMode** | <code>string</code> | <span></span>
**ports** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerPorts](#cdktf-provider-docker-containerports)></code> | <span></span>
**privileged** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**publishAllPorts** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**readOnly** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**removeVolumes** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**restart** | <code>string</code> | <span></span>
**rm** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**securityOpts** | <code>Array<string></code> | <span></span>
**shmSize** | <code>number</code> | <span></span>
**start** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**stdinOpen** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**storageOpts** | <code>Map<string, string></code> | <span></span>
**sysctls** | <code>Map<string, string></code> | <span></span>
**tmpfs** | <code>Map<string, string></code> | <span></span>
**tty** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**ulimit** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerUlimit](#cdktf-provider-docker-containerulimit)></code> | <span></span>
**upload** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerUpload](#cdktf-provider-docker-containerupload)></code> | <span></span>
**user** | <code>string</code> | <span></span>
**usernsMode** | <code>string</code> | <span></span>
**volumes** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerVolumes](#cdktf-provider-docker-containervolumes)></code> | <span></span>
**workingDir** | <code>string</code> | <span></span>
**attachInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**capabilitiesInput**? | <code>[ContainerCapabilities](#cdktf-provider-docker-containercapabilities)</code> | __*Optional*__
**commandInput**? | <code>Array<string></code> | __*Optional*__
**cpuSetInput**? | <code>string</code> | __*Optional*__
**cpuSharesInput**? | <code>number</code> | __*Optional*__
**destroyGraceSecondsInput**? | <code>number</code> | __*Optional*__
**devicesInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerDevices](#cdktf-provider-docker-containerdevices)></code> | __*Optional*__
**dnsInput**? | <code>Array<string></code> | __*Optional*__
**dnsOptsInput**? | <code>Array<string></code> | __*Optional*__
**dnsSearchInput**? | <code>Array<string></code> | __*Optional*__
**domainnameInput**? | <code>string</code> | __*Optional*__
**entrypointInput**? | <code>Array<string></code> | __*Optional*__
**envInput**? | <code>Array<string></code> | __*Optional*__
**groupAddInput**? | <code>Array<string></code> | __*Optional*__
**healthcheckInput**? | <code>[ContainerHealthcheck](#cdktf-provider-docker-containerhealthcheck)</code> | __*Optional*__
**hostInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerHost](#cdktf-provider-docker-containerhost)></code> | __*Optional*__
**hostnameInput**? | <code>string</code> | __*Optional*__
**imageInput**? | <code>string</code> | __*Optional*__
**initInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**ipcModeInput**? | <code>string</code> | __*Optional*__
**labelsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerLabels](#cdktf-provider-docker-containerlabels)></code> | __*Optional*__
**linksInput**? | <code>Array<string></code> | __*Optional*__
**logDriverInput**? | <code>string</code> | __*Optional*__
**logOptsInput**? | <code>Map<string, string></code> | __*Optional*__
**logsInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**maxRetryCountInput**? | <code>number</code> | __*Optional*__
**memoryInput**? | <code>number</code> | __*Optional*__
**memorySwapInput**? | <code>number</code> | __*Optional*__
**mountsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerMounts](#cdktf-provider-docker-containermounts)></code> | __*Optional*__
**mustRunInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
**networkAliasInput**? | <code>Array<string></code> | __*Optional*__
**networkModeInput**? | <code>string</code> | __*Optional*__
**networksAdvancedInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerNetworksAdvanced](#cdktf-provider-docker-containernetworksadvanced)></code> | __*Optional*__
**networksInput**? | <code>Array<string></code> | __*Optional*__
**pidModeInput**? | <code>string</code> | __*Optional*__
**portsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerPorts](#cdktf-provider-docker-containerports)></code> | __*Optional*__
**privilegedInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**publishAllPortsInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**readOnlyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**removeVolumesInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**restartInput**? | <code>string</code> | __*Optional*__
**rmInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**securityOptsInput**? | <code>Array<string></code> | __*Optional*__
**shmSizeInput**? | <code>number</code> | __*Optional*__
**startInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**stdinOpenInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**storageOptsInput**? | <code>Map<string, string></code> | __*Optional*__
**sysctlsInput**? | <code>Map<string, string></code> | __*Optional*__
**tmpfsInput**? | <code>Map<string, string></code> | __*Optional*__
**ttyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**ulimitInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerUlimit](#cdktf-provider-docker-containerulimit)></code> | __*Optional*__
**uploadInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerUpload](#cdktf-provider-docker-containerupload)></code> | __*Optional*__
**userInput**? | <code>string</code> | __*Optional*__
**usernsModeInput**? | <code>string</code> | __*Optional*__
**volumesInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerVolumes](#cdktf-provider-docker-containervolumes)></code> | __*Optional*__
**workingDirInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### networkData(index) <a id="cdktf-provider-docker-container-networkdata"></a>



```ts
networkData(index: string): ContainerNetworkData
```

* **index** (<code>string</code>)  *No description*

__Returns__:
* <code>[ContainerNetworkData](#cdktf-provider-docker-containernetworkdata)</code>

#### putCapabilities(value) <a id="cdktf-provider-docker-container-putcapabilities"></a>



```ts
putCapabilities(value: ContainerCapabilities): void
```

* **value** (<code>[ContainerCapabilities](#cdktf-provider-docker-containercapabilities)</code>)  *No description*
  * **add** (<code>Array<string></code>)  List of linux capabilities to add. __*Optional*__
  * **drop** (<code>Array<string></code>)  List of linux capabilities to drop. __*Optional*__




#### putHealthcheck(value) <a id="cdktf-provider-docker-container-puthealthcheck"></a>



```ts
putHealthcheck(value: ContainerHealthcheck): void
```

* **value** (<code>[ContainerHealthcheck](#cdktf-provider-docker-containerhealthcheck)</code>)  *No description*
  * **test** (<code>Array<string></code>)  Command to run to check health. 
  * **interval** (<code>string</code>)  Time between running the check (ms|s|m|h). Defaults to `0s`. __*Optional*__
  * **retries** (<code>number</code>)  Consecutive failures needed to report unhealthy. Defaults to `0`. __*Optional*__
  * **startPeriod** (<code>string</code>)  Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`. __*Optional*__
  * **timeout** (<code>string</code>)  Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`. __*Optional*__




#### resetAttach() <a id="cdktf-provider-docker-container-resetattach"></a>



```ts
resetAttach(): void
```





#### resetCapabilities() <a id="cdktf-provider-docker-container-resetcapabilities"></a>



```ts
resetCapabilities(): void
```





#### resetCommand() <a id="cdktf-provider-docker-container-resetcommand"></a>



```ts
resetCommand(): void
```





#### resetCpuSet() <a id="cdktf-provider-docker-container-resetcpuset"></a>



```ts
resetCpuSet(): void
```





#### resetCpuShares() <a id="cdktf-provider-docker-container-resetcpushares"></a>



```ts
resetCpuShares(): void
```





#### resetDestroyGraceSeconds() <a id="cdktf-provider-docker-container-resetdestroygraceseconds"></a>



```ts
resetDestroyGraceSeconds(): void
```





#### resetDevices() <a id="cdktf-provider-docker-container-resetdevices"></a>



```ts
resetDevices(): void
```





#### resetDns() <a id="cdktf-provider-docker-container-resetdns"></a>



```ts
resetDns(): void
```





#### resetDnsOpts() <a id="cdktf-provider-docker-container-resetdnsopts"></a>



```ts
resetDnsOpts(): void
```





#### resetDnsSearch() <a id="cdktf-provider-docker-container-resetdnssearch"></a>



```ts
resetDnsSearch(): void
```





#### resetDomainname() <a id="cdktf-provider-docker-container-resetdomainname"></a>



```ts
resetDomainname(): void
```





#### resetEntrypoint() <a id="cdktf-provider-docker-container-resetentrypoint"></a>



```ts
resetEntrypoint(): void
```





#### resetEnv() <a id="cdktf-provider-docker-container-resetenv"></a>



```ts
resetEnv(): void
```





#### resetGroupAdd() <a id="cdktf-provider-docker-container-resetgroupadd"></a>



```ts
resetGroupAdd(): void
```





#### resetHealthcheck() <a id="cdktf-provider-docker-container-resethealthcheck"></a>



```ts
resetHealthcheck(): void
```





#### resetHost() <a id="cdktf-provider-docker-container-resethost"></a>



```ts
resetHost(): void
```





#### resetHostname() <a id="cdktf-provider-docker-container-resethostname"></a>



```ts
resetHostname(): void
```





#### resetInit() <a id="cdktf-provider-docker-container-resetinit"></a>



```ts
resetInit(): void
```





#### resetIpcMode() <a id="cdktf-provider-docker-container-resetipcmode"></a>



```ts
resetIpcMode(): void
```





#### resetLabels() <a id="cdktf-provider-docker-container-resetlabels"></a>



```ts
resetLabels(): void
```





#### resetLinks() <a id="cdktf-provider-docker-container-resetlinks"></a>



```ts
resetLinks(): void
```





#### resetLogDriver() <a id="cdktf-provider-docker-container-resetlogdriver"></a>



```ts
resetLogDriver(): void
```





#### resetLogOpts() <a id="cdktf-provider-docker-container-resetlogopts"></a>



```ts
resetLogOpts(): void
```





#### resetLogs() <a id="cdktf-provider-docker-container-resetlogs"></a>



```ts
resetLogs(): void
```





#### resetMaxRetryCount() <a id="cdktf-provider-docker-container-resetmaxretrycount"></a>



```ts
resetMaxRetryCount(): void
```





#### resetMemory() <a id="cdktf-provider-docker-container-resetmemory"></a>



```ts
resetMemory(): void
```





#### resetMemorySwap() <a id="cdktf-provider-docker-container-resetmemoryswap"></a>



```ts
resetMemorySwap(): void
```





#### resetMounts() <a id="cdktf-provider-docker-container-resetmounts"></a>



```ts
resetMounts(): void
```





#### resetMustRun() <a id="cdktf-provider-docker-container-resetmustrun"></a>



```ts
resetMustRun(): void
```





#### resetNetworkAlias() <a id="cdktf-provider-docker-container-resetnetworkalias"></a>



```ts
resetNetworkAlias(): void
```





#### resetNetworkMode() <a id="cdktf-provider-docker-container-resetnetworkmode"></a>



```ts
resetNetworkMode(): void
```





#### resetNetworks() <a id="cdktf-provider-docker-container-resetnetworks"></a>



```ts
resetNetworks(): void
```





#### resetNetworksAdvanced() <a id="cdktf-provider-docker-container-resetnetworksadvanced"></a>



```ts
resetNetworksAdvanced(): void
```





#### resetPidMode() <a id="cdktf-provider-docker-container-resetpidmode"></a>



```ts
resetPidMode(): void
```





#### resetPorts() <a id="cdktf-provider-docker-container-resetports"></a>



```ts
resetPorts(): void
```





#### resetPrivileged() <a id="cdktf-provider-docker-container-resetprivileged"></a>



```ts
resetPrivileged(): void
```





#### resetPublishAllPorts() <a id="cdktf-provider-docker-container-resetpublishallports"></a>



```ts
resetPublishAllPorts(): void
```





#### resetReadOnly() <a id="cdktf-provider-docker-container-resetreadonly"></a>



```ts
resetReadOnly(): void
```





#### resetRemoveVolumes() <a id="cdktf-provider-docker-container-resetremovevolumes"></a>



```ts
resetRemoveVolumes(): void
```





#### resetRestart() <a id="cdktf-provider-docker-container-resetrestart"></a>



```ts
resetRestart(): void
```





#### resetRm() <a id="cdktf-provider-docker-container-resetrm"></a>



```ts
resetRm(): void
```





#### resetSecurityOpts() <a id="cdktf-provider-docker-container-resetsecurityopts"></a>



```ts
resetSecurityOpts(): void
```





#### resetShmSize() <a id="cdktf-provider-docker-container-resetshmsize"></a>



```ts
resetShmSize(): void
```





#### resetStart() <a id="cdktf-provider-docker-container-resetstart"></a>



```ts
resetStart(): void
```





#### resetStdinOpen() <a id="cdktf-provider-docker-container-resetstdinopen"></a>



```ts
resetStdinOpen(): void
```





#### resetStorageOpts() <a id="cdktf-provider-docker-container-resetstorageopts"></a>



```ts
resetStorageOpts(): void
```





#### resetSysctls() <a id="cdktf-provider-docker-container-resetsysctls"></a>



```ts
resetSysctls(): void
```





#### resetTmpfs() <a id="cdktf-provider-docker-container-resettmpfs"></a>



```ts
resetTmpfs(): void
```





#### resetTty() <a id="cdktf-provider-docker-container-resettty"></a>



```ts
resetTty(): void
```





#### resetUlimit() <a id="cdktf-provider-docker-container-resetulimit"></a>



```ts
resetUlimit(): void
```





#### resetUpload() <a id="cdktf-provider-docker-container-resetupload"></a>



```ts
resetUpload(): void
```





#### resetUser() <a id="cdktf-provider-docker-container-resetuser"></a>



```ts
resetUser(): void
```





#### resetUsernsMode() <a id="cdktf-provider-docker-container-resetusernsmode"></a>



```ts
resetUsernsMode(): void
```





#### resetVolumes() <a id="cdktf-provider-docker-container-resetvolumes"></a>



```ts
resetVolumes(): void
```





#### resetWorkingDir() <a id="cdktf-provider-docker-container-resetworkingdir"></a>



```ts
resetWorkingDir(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-docker-container-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class ContainerCapabilitiesOutputReference  <a id="cdktf-provider-docker-containercapabilitiesoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ContainerCapabilitiesOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**add** | <code>Array<string></code> | <span></span>
**drop** | <code>Array<string></code> | <span></span>
**addInput**? | <code>Array<string></code> | __*Optional*__
**dropInput**? | <code>Array<string></code> | __*Optional*__
**internalValue**? | <code>[ContainerCapabilities](#cdktf-provider-docker-containercapabilities)</code> | __*Optional*__

### Methods


#### resetAdd() <a id="cdktf-provider-docker-containercapabilitiesoutputreference-resetadd"></a>



```ts
resetAdd(): void
```





#### resetDrop() <a id="cdktf-provider-docker-containercapabilitiesoutputreference-resetdrop"></a>



```ts
resetDrop(): void
```







## class ContainerHealthcheckOutputReference  <a id="cdktf-provider-docker-containerhealthcheckoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ContainerHealthcheckOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**interval** | <code>string</code> | <span></span>
**retries** | <code>number</code> | <span></span>
**startPeriod** | <code>string</code> | <span></span>
**test** | <code>Array<string></code> | <span></span>
**timeout** | <code>string</code> | <span></span>
**internalValue**? | <code>[ContainerHealthcheck](#cdktf-provider-docker-containerhealthcheck)</code> | __*Optional*__
**intervalInput**? | <code>string</code> | __*Optional*__
**retriesInput**? | <code>number</code> | __*Optional*__
**startPeriodInput**? | <code>string</code> | __*Optional*__
**testInput**? | <code>Array<string></code> | __*Optional*__
**timeoutInput**? | <code>string</code> | __*Optional*__

### Methods


#### resetInterval() <a id="cdktf-provider-docker-containerhealthcheckoutputreference-resetinterval"></a>



```ts
resetInterval(): void
```





#### resetRetries() <a id="cdktf-provider-docker-containerhealthcheckoutputreference-resetretries"></a>



```ts
resetRetries(): void
```





#### resetStartPeriod() <a id="cdktf-provider-docker-containerhealthcheckoutputreference-resetstartperiod"></a>



```ts
resetStartPeriod(): void
```





#### resetTimeout() <a id="cdktf-provider-docker-containerhealthcheckoutputreference-resettimeout"></a>



```ts
resetTimeout(): void
```







## class ContainerMountsBindOptionsOutputReference  <a id="cdktf-provider-docker-containermountsbindoptionsoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ContainerMountsBindOptionsOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**propagation** | <code>string</code> | <span></span>
**internalValue**? | <code>[ContainerMountsBindOptions](#cdktf-provider-docker-containermountsbindoptions)</code> | __*Optional*__
**propagationInput**? | <code>string</code> | __*Optional*__

### Methods


#### resetPropagation() <a id="cdktf-provider-docker-containermountsbindoptionsoutputreference-resetpropagation"></a>



```ts
resetPropagation(): void
```







## class ContainerMountsTmpfsOptionsOutputReference  <a id="cdktf-provider-docker-containermountstmpfsoptionsoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ContainerMountsTmpfsOptionsOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**mode** | <code>number</code> | <span></span>
**sizeBytes** | <code>number</code> | <span></span>
**internalValue**? | <code>[ContainerMountsTmpfsOptions](#cdktf-provider-docker-containermountstmpfsoptions)</code> | __*Optional*__
**modeInput**? | <code>number</code> | __*Optional*__
**sizeBytesInput**? | <code>number</code> | __*Optional*__

### Methods


#### resetMode() <a id="cdktf-provider-docker-containermountstmpfsoptionsoutputreference-resetmode"></a>



```ts
resetMode(): void
```





#### resetSizeBytes() <a id="cdktf-provider-docker-containermountstmpfsoptionsoutputreference-resetsizebytes"></a>



```ts
resetSizeBytes(): void
```







## class ContainerMountsVolumeOptionsOutputReference  <a id="cdktf-provider-docker-containermountsvolumeoptionsoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ContainerMountsVolumeOptionsOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**driverName** | <code>string</code> | <span></span>
**driverOptions** | <code>Map<string, string></code> | <span></span>
**labels** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerMountsVolumeOptionsLabels](#cdktf-provider-docker-containermountsvolumeoptionslabels)></code> | <span></span>
**noCopy** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**driverNameInput**? | <code>string</code> | __*Optional*__
**driverOptionsInput**? | <code>Map<string, string></code> | __*Optional*__
**internalValue**? | <code>[ContainerMountsVolumeOptions](#cdktf-provider-docker-containermountsvolumeoptions)</code> | __*Optional*__
**labelsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerMountsVolumeOptionsLabels](#cdktf-provider-docker-containermountsvolumeoptionslabels)></code> | __*Optional*__
**noCopyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__

### Methods


#### resetDriverName() <a id="cdktf-provider-docker-containermountsvolumeoptionsoutputreference-resetdrivername"></a>



```ts
resetDriverName(): void
```





#### resetDriverOptions() <a id="cdktf-provider-docker-containermountsvolumeoptionsoutputreference-resetdriveroptions"></a>



```ts
resetDriverOptions(): void
```





#### resetLabels() <a id="cdktf-provider-docker-containermountsvolumeoptionsoutputreference-resetlabels"></a>



```ts
resetLabels(): void
```





#### resetNoCopy() <a id="cdktf-provider-docker-containermountsvolumeoptionsoutputreference-resetnocopy"></a>



```ts
resetNoCopy(): void
```







## class ContainerNetworkData  <a id="cdktf-provider-docker-containernetworkdata"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexComputedList](#cdktf-complexcomputedlist)

### Initializer




```ts
new ContainerNetworkData(terraformResource: IInterpolatingParent, terraformAttribute: string, complexComputedListIndex: string, wrapsSet?: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  *No description*
* **terraformAttribute** (<code>string</code>)  *No description*
* **complexComputedListIndex** (<code>string</code>)  *No description*
* **wrapsSet** (<code>boolean</code>)  *No description*



### Properties


Name | Type | Description 
-----|------|-------------
**gateway** | <code>string</code> | <span></span>
**globalIpv6Address** | <code>string</code> | <span></span>
**globalIpv6PrefixLength** | <code>number</code> | <span></span>
**ipAddress** | <code>string</code> | <span></span>
**ipPrefixLength** | <code>number</code> | <span></span>
**ipv6Gateway** | <code>string</code> | <span></span>
**networkName** | <code>string</code> | <span></span>



## class DataDockerImage  <a id="cdktf-provider-docker-datadockerimage"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/d/image docker_image}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/d/image docker_image} Data Source.

```ts
new DataDockerImage(scope: Construct, id: string, config: DataDockerImageConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataDockerImageConfig](#cdktf-provider-docker-datadockerimageconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  The name of the Docker image, including any tags or SHA256 repo digests. 



### Properties


Name | Type | Description 
-----|------|-------------
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**repoDigest** | <code>string</code> | <span></span>
**nameInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-docker-datadockerimage-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataDockerNetwork  <a id="cdktf-provider-docker-datadockernetwork"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/d/network docker_network}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/d/network docker_network} Data Source.

```ts
new DataDockerNetwork(scope: Construct, id: string, config: DataDockerNetworkConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataDockerNetworkConfig](#cdktf-provider-docker-datadockernetworkconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  The name of the Docker network. 



### Properties


Name | Type | Description 
-----|------|-------------
**driver** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**internal** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**name** | <code>string</code> | <span></span>
**scope** | <code>string</code> | <span></span>
**nameInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### ipamConfig(index) <a id="cdktf-provider-docker-datadockernetwork-ipamconfig"></a>



```ts
ipamConfig(index: string): DataDockerNetworkIpamConfig
```

* **index** (<code>string</code>)  *No description*

__Returns__:
* <code>[DataDockerNetworkIpamConfig](#cdktf-provider-docker-datadockernetworkipamconfig)</code>

#### options(key) <a id="cdktf-provider-docker-datadockernetwork-options"></a>



```ts
options(key: string): string &#124; IResolvable
```

* **key** (<code>string</code>)  *No description*

__Returns__:
* <code>string &#124; [IResolvable](#cdktf-iresolvable)</code>

#### protected synthesizeAttributes() <a id="cdktf-provider-docker-datadockernetwork-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataDockerNetworkIpamConfig  <a id="cdktf-provider-docker-datadockernetworkipamconfig"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexComputedList](#cdktf-complexcomputedlist)

### Initializer




```ts
new DataDockerNetworkIpamConfig(terraformResource: IInterpolatingParent, terraformAttribute: string, complexComputedListIndex: string, wrapsSet?: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  *No description*
* **terraformAttribute** (<code>string</code>)  *No description*
* **complexComputedListIndex** (<code>string</code>)  *No description*
* **wrapsSet** (<code>boolean</code>)  *No description*



### Properties


Name | Type | Description 
-----|------|-------------
**auxAddress** | <code>Map<string, string></code> | <span></span>
**gateway** | <code>string</code> | <span></span>
**ipRange** | <code>string</code> | <span></span>
**subnet** | <code>string</code> | <span></span>



## class DataDockerPlugin  <a id="cdktf-provider-docker-datadockerplugin"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/d/plugin docker_plugin}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/d/plugin docker_plugin} Data Source.

```ts
new DataDockerPlugin(scope: Construct, id: string, config?: DataDockerPluginConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataDockerPluginConfig](#cdktf-provider-docker-datadockerpluginconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **alias** (<code>string</code>)  The alias of the Docker plugin. If the tag is omitted, `:latest` is complemented to the attribute value. __*Optional*__
  * **id** (<code>string</code>)  The ID of the plugin, which has precedence over the `alias` of both are given. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**alias** | <code>string</code> | <span></span>
**enabled** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**env** | <code>Array<string></code> | <span></span>
**grantAllPermissions** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**pluginReference** | <code>string</code> | <span></span>
**aliasInput**? | <code>string</code> | __*Optional*__
**idInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetAlias() <a id="cdktf-provider-docker-datadockerplugin-resetalias"></a>



```ts
resetAlias(): void
```





#### resetId() <a id="cdktf-provider-docker-datadockerplugin-resetid"></a>



```ts
resetId(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-docker-datadockerplugin-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataDockerRegistryImage  <a id="cdktf-provider-docker-datadockerregistryimage"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/d/registry_image docker_registry_image}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/d/registry_image docker_registry_image} Data Source.

```ts
new DataDockerRegistryImage(scope: Construct, id: string, config: DataDockerRegistryImageConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataDockerRegistryImageConfig](#cdktf-provider-docker-datadockerregistryimageconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  The name of the Docker image, including any tags. e.g. `alpine:latest`. 
  * **insecureSkipVerify** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**id** | <code>string</code> | <span></span>
**insecureSkipVerify** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**name** | <code>string</code> | <span></span>
**sha256Digest** | <code>string</code> | <span></span>
**insecureSkipVerifyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetInsecureSkipVerify() <a id="cdktf-provider-docker-datadockerregistryimage-resetinsecureskipverify"></a>



```ts
resetInsecureSkipVerify(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-docker-datadockerregistryimage-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DockerProvider  <a id="cdktf-provider-docker-dockerprovider"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker docker}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Extends__: [TerraformProvider](#cdktf-terraformprovider)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker docker} Resource.

```ts
new DockerProvider(scope: Construct, id: string, config?: DockerProviderConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DockerProviderConfig](#cdktf-provider-docker-dockerproviderconfig)</code>)  *No description*
  * **alias** (<code>string</code>)  Alias name. __*Optional*__
  * **caMaterial** (<code>string</code>)  PEM-encoded content of Docker host CA certificate. __*Optional*__
  * **certMaterial** (<code>string</code>)  PEM-encoded content of Docker client certificate. __*Optional*__
  * **certPath** (<code>string</code>)  Path to directory with Docker TLS config. __*Optional*__
  * **host** (<code>string</code>)  The Docker daemon address. __*Optional*__
  * **keyMaterial** (<code>string</code>)  PEM-encoded content of Docker client private key. __*Optional*__
  * **registryAuth** (<code>[DockerProviderRegistryAuth](#cdktf-provider-docker-dockerproviderregistryauth)</code>)  registry_auth block. __*Optional*__
  * **sshOpts** (<code>Array<string></code>)  Additional SSH option flags to be appended when using `ssh://` protocol. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**alias**? | <code>string</code> | __*Optional*__
**aliasInput**? | <code>string</code> | __*Optional*__
**caMaterial**? | <code>string</code> | __*Optional*__
**caMaterialInput**? | <code>string</code> | __*Optional*__
**certMaterial**? | <code>string</code> | __*Optional*__
**certMaterialInput**? | <code>string</code> | __*Optional*__
**certPath**? | <code>string</code> | __*Optional*__
**certPathInput**? | <code>string</code> | __*Optional*__
**host**? | <code>string</code> | __*Optional*__
**hostInput**? | <code>string</code> | __*Optional*__
**keyMaterial**? | <code>string</code> | __*Optional*__
**keyMaterialInput**? | <code>string</code> | __*Optional*__
**registryAuth**? | <code>[DockerProviderRegistryAuth](#cdktf-provider-docker-dockerproviderregistryauth)</code> | __*Optional*__
**registryAuthInput**? | <code>[DockerProviderRegistryAuth](#cdktf-provider-docker-dockerproviderregistryauth)</code> | __*Optional*__
**sshOpts**? | <code>Array<string></code> | __*Optional*__
**sshOptsInput**? | <code>Array<string></code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetAlias() <a id="cdktf-provider-docker-dockerprovider-resetalias"></a>



```ts
resetAlias(): void
```





#### resetCaMaterial() <a id="cdktf-provider-docker-dockerprovider-resetcamaterial"></a>



```ts
resetCaMaterial(): void
```





#### resetCertMaterial() <a id="cdktf-provider-docker-dockerprovider-resetcertmaterial"></a>



```ts
resetCertMaterial(): void
```





#### resetCertPath() <a id="cdktf-provider-docker-dockerprovider-resetcertpath"></a>



```ts
resetCertPath(): void
```





#### resetHost() <a id="cdktf-provider-docker-dockerprovider-resethost"></a>



```ts
resetHost(): void
```





#### resetKeyMaterial() <a id="cdktf-provider-docker-dockerprovider-resetkeymaterial"></a>



```ts
resetKeyMaterial(): void
```





#### resetRegistryAuth() <a id="cdktf-provider-docker-dockerprovider-resetregistryauth"></a>



```ts
resetRegistryAuth(): void
```





#### resetSshOpts() <a id="cdktf-provider-docker-dockerprovider-resetsshopts"></a>



```ts
resetSshOpts(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-docker-dockerprovider-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class Image  <a id="cdktf-provider-docker-image"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/r/image docker_image}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/r/image docker_image} Resource.

```ts
new Image(scope: Construct, id: string, config: ImageConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[ImageConfig](#cdktf-provider-docker-imageconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  The name of the Docker image, including any tags or SHA256 repo digests. 
  * **buildAttribute** (<code>[ImageBuild](#cdktf-provider-docker-imagebuild)</code>)  build block. __*Optional*__
  * **forceRemove** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If true, then the image is removed forcibly when the resource is destroyed. __*Optional*__
  * **keepLocally** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If true, then the Docker image won't be deleted on destroy operation. __*Optional*__
  * **pullTrigger** (<code>string</code>)  A value which cause an image pull when changed. __*Optional*__
  * **pullTriggers** (<code>Array<string></code>)  List of values which cause an image pull when changed. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**buildAttribute** | <code>[ImageBuildOutputReference](#cdktf-provider-docker-imagebuildoutputreference)</code> | <span></span>
**forceRemove** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**id** | <code>string</code> | <span></span>
**keepLocally** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**latest** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**output** | <code>string</code> | <span></span>
**pullTrigger** | <code>string</code> | <span></span>
**pullTriggers** | <code>Array<string></code> | <span></span>
**repoDigest** | <code>string</code> | <span></span>
**buildAttributeInput**? | <code>[ImageBuild](#cdktf-provider-docker-imagebuild)</code> | __*Optional*__
**forceRemoveInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**keepLocallyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
**pullTriggerInput**? | <code>string</code> | __*Optional*__
**pullTriggersInput**? | <code>Array<string></code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### putBuildAttribute(value) <a id="cdktf-provider-docker-image-putbuildattribute"></a>



```ts
putBuildAttribute(value: ImageBuild): void
```

* **value** (<code>[ImageBuild](#cdktf-provider-docker-imagebuild)</code>)  *No description*
  * **path** (<code>string</code>)  Context path. 
  * **buildArg** (<code>Map<string, string></code>)  Set build-time variables. __*Optional*__
  * **dockerfile** (<code>string</code>)  Name of the Dockerfile. Defaults to `Dockerfile`. __*Optional*__
  * **forceRemove** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Always remove intermediate containers. __*Optional*__
  * **label** (<code>Map<string, string></code>)  Set metadata for an image. __*Optional*__
  * **noCache** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Do not use cache when building the image. __*Optional*__
  * **remove** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Remove intermediate containers after a successful build. Defaults to  `true`. __*Optional*__
  * **tag** (<code>Array<string></code>)  Name and optionally a tag in the 'name:tag' format. __*Optional*__
  * **target** (<code>string</code>)  Set the target build stage to build. __*Optional*__




#### resetBuildAttribute() <a id="cdktf-provider-docker-image-resetbuildattribute"></a>



```ts
resetBuildAttribute(): void
```





#### resetForceRemove() <a id="cdktf-provider-docker-image-resetforceremove"></a>



```ts
resetForceRemove(): void
```





#### resetKeepLocally() <a id="cdktf-provider-docker-image-resetkeeplocally"></a>



```ts
resetKeepLocally(): void
```





#### resetPullTrigger() <a id="cdktf-provider-docker-image-resetpulltrigger"></a>



```ts
resetPullTrigger(): void
```





#### resetPullTriggers() <a id="cdktf-provider-docker-image-resetpulltriggers"></a>



```ts
resetPullTriggers(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-docker-image-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class ImageBuildOutputReference  <a id="cdktf-provider-docker-imagebuildoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ImageBuildOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**buildArg** | <code>Map<string, string></code> | <span></span>
**dockerfile** | <code>string</code> | <span></span>
**forceRemove** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**label** | <code>Map<string, string></code> | <span></span>
**noCache** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**path** | <code>string</code> | <span></span>
**remove** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**tag** | <code>Array<string></code> | <span></span>
**target** | <code>string</code> | <span></span>
**buildArgInput**? | <code>Map<string, string></code> | __*Optional*__
**dockerfileInput**? | <code>string</code> | __*Optional*__
**forceRemoveInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**internalValue**? | <code>[ImageBuild](#cdktf-provider-docker-imagebuild)</code> | __*Optional*__
**labelInput**? | <code>Map<string, string></code> | __*Optional*__
**noCacheInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**pathInput**? | <code>string</code> | __*Optional*__
**removeInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**tagInput**? | <code>Array<string></code> | __*Optional*__
**targetInput**? | <code>string</code> | __*Optional*__

### Methods


#### resetBuildArg() <a id="cdktf-provider-docker-imagebuildoutputreference-resetbuildarg"></a>



```ts
resetBuildArg(): void
```





#### resetDockerfile() <a id="cdktf-provider-docker-imagebuildoutputreference-resetdockerfile"></a>



```ts
resetDockerfile(): void
```





#### resetForceRemove() <a id="cdktf-provider-docker-imagebuildoutputreference-resetforceremove"></a>



```ts
resetForceRemove(): void
```





#### resetLabel() <a id="cdktf-provider-docker-imagebuildoutputreference-resetlabel"></a>



```ts
resetLabel(): void
```





#### resetNoCache() <a id="cdktf-provider-docker-imagebuildoutputreference-resetnocache"></a>



```ts
resetNoCache(): void
```





#### resetRemove() <a id="cdktf-provider-docker-imagebuildoutputreference-resetremove"></a>



```ts
resetRemove(): void
```





#### resetTag() <a id="cdktf-provider-docker-imagebuildoutputreference-resettag"></a>



```ts
resetTag(): void
```





#### resetTarget() <a id="cdktf-provider-docker-imagebuildoutputreference-resettarget"></a>



```ts
resetTarget(): void
```







## class Network  <a id="cdktf-provider-docker-network"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/r/network docker_network}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/r/network docker_network} Resource.

```ts
new Network(scope: Construct, id: string, config: NetworkConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[NetworkConfig](#cdktf-provider-docker-networkconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  The name of the Docker network. 
  * **attachable** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Enable manual container attachment to the network. __*Optional*__
  * **checkDuplicate** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Requests daemon to check for networks with same name. __*Optional*__
  * **driver** (<code>string</code>)  The driver of the Docker network. Possible values are `bridge`, `host`, `overlay`, `macvlan`. See [network docs](https://docs.docker.com/network/#network-drivers) for more details. __*Optional*__
  * **ingress** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Create swarm routing-mesh network. Defaults to `false`. __*Optional*__
  * **internal** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Whether the network is internal. __*Optional*__
  * **ipamConfig** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[NetworkIpamConfig](#cdktf-provider-docker-networkipamconfig)></code>)  ipam_config block. __*Optional*__
  * **ipamDriver** (<code>string</code>)  Driver used by the custom IP scheme of the network. Defaults to `default`. __*Optional*__
  * **ipv6** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Enable IPv6 networking. Defaults to `false`. __*Optional*__
  * **labels** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[NetworkLabels](#cdktf-provider-docker-networklabels)></code>)  labels block. __*Optional*__
  * **options** (<code>Map<string, string></code>)  Only available with bridge networks. See [bridge options docs](https://docs.docker.com/engine/reference/commandline/network_create/#bridge-driver-options) for more details. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**attachable** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**checkDuplicate** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**driver** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**ingress** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**internal** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**ipamConfig** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[NetworkIpamConfig](#cdktf-provider-docker-networkipamconfig)></code> | <span></span>
**ipamDriver** | <code>string</code> | <span></span>
**ipv6** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**labels** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[NetworkLabels](#cdktf-provider-docker-networklabels)></code> | <span></span>
**name** | <code>string</code> | <span></span>
**options** | <code>Map<string, string></code> | <span></span>
**scope** | <code>string</code> | <span></span>
**attachableInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**checkDuplicateInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**driverInput**? | <code>string</code> | __*Optional*__
**ingressInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**internalInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**ipamConfigInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[NetworkIpamConfig](#cdktf-provider-docker-networkipamconfig)></code> | __*Optional*__
**ipamDriverInput**? | <code>string</code> | __*Optional*__
**ipv6Input**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**labelsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[NetworkLabels](#cdktf-provider-docker-networklabels)></code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
**optionsInput**? | <code>Map<string, string></code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetAttachable() <a id="cdktf-provider-docker-network-resetattachable"></a>



```ts
resetAttachable(): void
```





#### resetCheckDuplicate() <a id="cdktf-provider-docker-network-resetcheckduplicate"></a>



```ts
resetCheckDuplicate(): void
```





#### resetDriver() <a id="cdktf-provider-docker-network-resetdriver"></a>



```ts
resetDriver(): void
```





#### resetIngress() <a id="cdktf-provider-docker-network-resetingress"></a>



```ts
resetIngress(): void
```





#### resetInternal() <a id="cdktf-provider-docker-network-resetinternal"></a>



```ts
resetInternal(): void
```





#### resetIpamConfig() <a id="cdktf-provider-docker-network-resetipamconfig"></a>



```ts
resetIpamConfig(): void
```





#### resetIpamDriver() <a id="cdktf-provider-docker-network-resetipamdriver"></a>



```ts
resetIpamDriver(): void
```





#### resetIpv6() <a id="cdktf-provider-docker-network-resetipv6"></a>



```ts
resetIpv6(): void
```





#### resetLabels() <a id="cdktf-provider-docker-network-resetlabels"></a>



```ts
resetLabels(): void
```





#### resetOptions() <a id="cdktf-provider-docker-network-resetoptions"></a>



```ts
resetOptions(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-docker-network-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class Plugin  <a id="cdktf-provider-docker-plugin"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/r/plugin docker_plugin}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/r/plugin docker_plugin} Resource.

```ts
new Plugin(scope: Construct, id: string, config: PluginConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[PluginConfig](#cdktf-provider-docker-pluginconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  Docker Plugin name. 
  * **alias** (<code>string</code>)  Docker Plugin alias. __*Optional*__
  * **enabled** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true` the plugin is enabled. Defaults to `true`. __*Optional*__
  * **enableTimeout** (<code>number</code>)  HTTP client timeout to enable the plugin. __*Optional*__
  * **env** (<code>Array<string></code>)  The environment variables in the form of `KEY=VALUE`, e.g. `DEBUG=0`. __*Optional*__
  * **forceDestroy** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If true, then the plugin is destroyed forcibly. __*Optional*__
  * **forceDisable** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If true, then the plugin is disabled forcibly. __*Optional*__
  * **grantAllPermissions** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If true, grant all permissions necessary to run the plugin. __*Optional*__
  * **grantPermissions** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[PluginGrantPermissions](#cdktf-provider-docker-plugingrantpermissions)></code>)  grant_permissions block. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**alias** | <code>string</code> | <span></span>
**enableTimeout** | <code>number</code> | <span></span>
**enabled** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**env** | <code>Array<string></code> | <span></span>
**forceDestroy** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**forceDisable** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**grantAllPermissions** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**grantPermissions** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[PluginGrantPermissions](#cdktf-provider-docker-plugingrantpermissions)></code> | <span></span>
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**pluginReference** | <code>string</code> | <span></span>
**aliasInput**? | <code>string</code> | __*Optional*__
**enableTimeoutInput**? | <code>number</code> | __*Optional*__
**enabledInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**envInput**? | <code>Array<string></code> | __*Optional*__
**forceDestroyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**forceDisableInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**grantAllPermissionsInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**grantPermissionsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[PluginGrantPermissions](#cdktf-provider-docker-plugingrantpermissions)></code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetAlias() <a id="cdktf-provider-docker-plugin-resetalias"></a>



```ts
resetAlias(): void
```





#### resetEnableTimeout() <a id="cdktf-provider-docker-plugin-resetenabletimeout"></a>



```ts
resetEnableTimeout(): void
```





#### resetEnabled() <a id="cdktf-provider-docker-plugin-resetenabled"></a>



```ts
resetEnabled(): void
```





#### resetEnv() <a id="cdktf-provider-docker-plugin-resetenv"></a>



```ts
resetEnv(): void
```





#### resetForceDestroy() <a id="cdktf-provider-docker-plugin-resetforcedestroy"></a>



```ts
resetForceDestroy(): void
```





#### resetForceDisable() <a id="cdktf-provider-docker-plugin-resetforcedisable"></a>



```ts
resetForceDisable(): void
```





#### resetGrantAllPermissions() <a id="cdktf-provider-docker-plugin-resetgrantallpermissions"></a>



```ts
resetGrantAllPermissions(): void
```





#### resetGrantPermissions() <a id="cdktf-provider-docker-plugin-resetgrantpermissions"></a>



```ts
resetGrantPermissions(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-docker-plugin-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class RegistryImage  <a id="cdktf-provider-docker-registryimage"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/r/registry_image docker_registry_image}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/r/registry_image docker_registry_image} Resource.

```ts
new RegistryImage(scope: Construct, id: string, config: RegistryImageConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[RegistryImageConfig](#cdktf-provider-docker-registryimageconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  The name of the Docker image. 
  * **buildAttribute** (<code>[RegistryImageBuild](#cdktf-provider-docker-registryimagebuild)</code>)  build block. __*Optional*__
  * **insecureSkipVerify** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`. __*Optional*__
  * **keepRemotely** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If true, then the Docker image won't be deleted on destroy operation. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**buildAttribute** | <code>[RegistryImageBuildOutputReference](#cdktf-provider-docker-registryimagebuildoutputreference)</code> | <span></span>
**id** | <code>string</code> | <span></span>
**insecureSkipVerify** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**keepRemotely** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**name** | <code>string</code> | <span></span>
**sha256Digest** | <code>string</code> | <span></span>
**buildAttributeInput**? | <code>[RegistryImageBuild](#cdktf-provider-docker-registryimagebuild)</code> | __*Optional*__
**insecureSkipVerifyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**keepRemotelyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### putBuildAttribute(value) <a id="cdktf-provider-docker-registryimage-putbuildattribute"></a>



```ts
putBuildAttribute(value: RegistryImageBuild): void
```

* **value** (<code>[RegistryImageBuild](#cdktf-provider-docker-registryimagebuild)</code>)  *No description*
  * **context** (<code>string</code>)  The absolute path to the context folder. You can use the helper function '${path.cwd}/context-dir'. 
  * **authConfig** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[RegistryImageBuildAuthConfig](#cdktf-provider-docker-registryimagebuildauthconfig)></code>)  auth_config block. __*Optional*__
  * **buildArgs** (<code>Map<string, string></code>)  Pairs for build-time variables in the form TODO. __*Optional*__
  * **buildId** (<code>string</code>)  BuildID is an optional identifier that can be passed together with the build request. __*Optional*__
  * **cacheFrom** (<code>Array<string></code>)  Images to consider as cache sources. __*Optional*__
  * **cgroupParent** (<code>string</code>)  Optional parent cgroup for the container. __*Optional*__
  * **cpuPeriod** (<code>number</code>)  The length of a CPU period in microseconds. __*Optional*__
  * **cpuQuota** (<code>number</code>)  Microseconds of CPU time that the container can get in a CPU period. __*Optional*__
  * **cpuSetCpus** (<code>string</code>)  CPUs in which to allow execution (e.g., `0-3`, `0`, `1`). __*Optional*__
  * **cpuSetMems** (<code>string</code>)  MEMs in which to allow execution (`0-3`, `0`, `1`). __*Optional*__
  * **cpuShares** (<code>number</code>)  CPU shares (relative weight). __*Optional*__
  * **dockerfile** (<code>string</code>)  Dockerfile file. Defaults to `Dockerfile`. __*Optional*__
  * **extraHosts** (<code>Array<string></code>)  A list of hostnames/IP mappings to add to the container’s /etc/hosts file. Specified in the form ["hostname:IP"]. __*Optional*__
  * **forceRemove** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Always remove intermediate containers. __*Optional*__
  * **isolation** (<code>string</code>)  Isolation represents the isolation technology of a container. The supported values are. __*Optional*__
  * **labels** (<code>Map<string, string></code>)  User-defined key/value metadata. __*Optional*__
  * **memory** (<code>number</code>)  Set memory limit for build. __*Optional*__
  * **memorySwap** (<code>number</code>)  Total memory (memory + swap), -1 to enable unlimited swap. __*Optional*__
  * **networkMode** (<code>string</code>)  Set the networking mode for the RUN instructions during build. __*Optional*__
  * **noCache** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Do not use the cache when building the image. __*Optional*__
  * **platform** (<code>string</code>)  Set platform if server is multi-platform capable. __*Optional*__
  * **pullParent** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Attempt to pull the image even if an older image exists locally. __*Optional*__
  * **remoteContext** (<code>string</code>)  A Git repository URI or HTTP/HTTPS context URI. __*Optional*__
  * **remove** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Remove intermediate containers after a successful build (default behavior). __*Optional*__
  * **securityOpt** (<code>Array<string></code>)  The security options. __*Optional*__
  * **sessionId** (<code>string</code>)  Set an ID for the build session. __*Optional*__
  * **shmSize** (<code>number</code>)  Size of /dev/shm in bytes. The size must be greater than 0. __*Optional*__
  * **squash** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  If true the new layers are squashed into a new image with a single new layer. __*Optional*__
  * **suppressOutput** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Suppress the build output and print image ID on success. __*Optional*__
  * **target** (<code>string</code>)  Set the target build stage to build. __*Optional*__
  * **ulimit** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[RegistryImageBuildUlimit](#cdktf-provider-docker-registryimagebuildulimit)></code>)  ulimit block. __*Optional*__
  * **version** (<code>string</code>)  Version of the underlying builder to use. __*Optional*__




#### resetBuildAttribute() <a id="cdktf-provider-docker-registryimage-resetbuildattribute"></a>



```ts
resetBuildAttribute(): void
```





#### resetInsecureSkipVerify() <a id="cdktf-provider-docker-registryimage-resetinsecureskipverify"></a>



```ts
resetInsecureSkipVerify(): void
```





#### resetKeepRemotely() <a id="cdktf-provider-docker-registryimage-resetkeepremotely"></a>



```ts
resetKeepRemotely(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-docker-registryimage-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class RegistryImageBuildOutputReference  <a id="cdktf-provider-docker-registryimagebuildoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new RegistryImageBuildOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**authConfig** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[RegistryImageBuildAuthConfig](#cdktf-provider-docker-registryimagebuildauthconfig)></code> | <span></span>
**buildArgs** | <code>Map<string, string></code> | <span></span>
**buildId** | <code>string</code> | <span></span>
**cacheFrom** | <code>Array<string></code> | <span></span>
**cgroupParent** | <code>string</code> | <span></span>
**context** | <code>string</code> | <span></span>
**cpuPeriod** | <code>number</code> | <span></span>
**cpuQuota** | <code>number</code> | <span></span>
**cpuSetCpus** | <code>string</code> | <span></span>
**cpuSetMems** | <code>string</code> | <span></span>
**cpuShares** | <code>number</code> | <span></span>
**dockerfile** | <code>string</code> | <span></span>
**extraHosts** | <code>Array<string></code> | <span></span>
**forceRemove** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**isolation** | <code>string</code> | <span></span>
**labels** | <code>Map<string, string></code> | <span></span>
**memory** | <code>number</code> | <span></span>
**memorySwap** | <code>number</code> | <span></span>
**networkMode** | <code>string</code> | <span></span>
**noCache** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**platform** | <code>string</code> | <span></span>
**pullParent** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**remoteContext** | <code>string</code> | <span></span>
**remove** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**securityOpt** | <code>Array<string></code> | <span></span>
**sessionId** | <code>string</code> | <span></span>
**shmSize** | <code>number</code> | <span></span>
**squash** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**suppressOutput** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**target** | <code>string</code> | <span></span>
**ulimit** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[RegistryImageBuildUlimit](#cdktf-provider-docker-registryimagebuildulimit)></code> | <span></span>
**version** | <code>string</code> | <span></span>
**authConfigInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[RegistryImageBuildAuthConfig](#cdktf-provider-docker-registryimagebuildauthconfig)></code> | __*Optional*__
**buildArgsInput**? | <code>Map<string, string></code> | __*Optional*__
**buildIdInput**? | <code>string</code> | __*Optional*__
**cacheFromInput**? | <code>Array<string></code> | __*Optional*__
**cgroupParentInput**? | <code>string</code> | __*Optional*__
**contextInput**? | <code>string</code> | __*Optional*__
**cpuPeriodInput**? | <code>number</code> | __*Optional*__
**cpuQuotaInput**? | <code>number</code> | __*Optional*__
**cpuSetCpusInput**? | <code>string</code> | __*Optional*__
**cpuSetMemsInput**? | <code>string</code> | __*Optional*__
**cpuSharesInput**? | <code>number</code> | __*Optional*__
**dockerfileInput**? | <code>string</code> | __*Optional*__
**extraHostsInput**? | <code>Array<string></code> | __*Optional*__
**forceRemoveInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**internalValue**? | <code>[RegistryImageBuild](#cdktf-provider-docker-registryimagebuild)</code> | __*Optional*__
**isolationInput**? | <code>string</code> | __*Optional*__
**labelsInput**? | <code>Map<string, string></code> | __*Optional*__
**memoryInput**? | <code>number</code> | __*Optional*__
**memorySwapInput**? | <code>number</code> | __*Optional*__
**networkModeInput**? | <code>string</code> | __*Optional*__
**noCacheInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**platformInput**? | <code>string</code> | __*Optional*__
**pullParentInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**remoteContextInput**? | <code>string</code> | __*Optional*__
**removeInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**securityOptInput**? | <code>Array<string></code> | __*Optional*__
**sessionIdInput**? | <code>string</code> | __*Optional*__
**shmSizeInput**? | <code>number</code> | __*Optional*__
**squashInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**suppressOutputInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**targetInput**? | <code>string</code> | __*Optional*__
**ulimitInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[RegistryImageBuildUlimit](#cdktf-provider-docker-registryimagebuildulimit)></code> | __*Optional*__
**versionInput**? | <code>string</code> | __*Optional*__

### Methods


#### resetAuthConfig() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetauthconfig"></a>



```ts
resetAuthConfig(): void
```





#### resetBuildArgs() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetbuildargs"></a>



```ts
resetBuildArgs(): void
```





#### resetBuildId() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetbuildid"></a>



```ts
resetBuildId(): void
```





#### resetCacheFrom() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetcachefrom"></a>



```ts
resetCacheFrom(): void
```





#### resetCgroupParent() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetcgroupparent"></a>



```ts
resetCgroupParent(): void
```





#### resetCpuPeriod() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetcpuperiod"></a>



```ts
resetCpuPeriod(): void
```





#### resetCpuQuota() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetcpuquota"></a>



```ts
resetCpuQuota(): void
```





#### resetCpuSetCpus() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetcpusetcpus"></a>



```ts
resetCpuSetCpus(): void
```





#### resetCpuSetMems() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetcpusetmems"></a>



```ts
resetCpuSetMems(): void
```





#### resetCpuShares() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetcpushares"></a>



```ts
resetCpuShares(): void
```





#### resetDockerfile() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetdockerfile"></a>



```ts
resetDockerfile(): void
```





#### resetExtraHosts() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetextrahosts"></a>



```ts
resetExtraHosts(): void
```





#### resetForceRemove() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetforceremove"></a>



```ts
resetForceRemove(): void
```





#### resetIsolation() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetisolation"></a>



```ts
resetIsolation(): void
```





#### resetLabels() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetlabels"></a>



```ts
resetLabels(): void
```





#### resetMemory() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetmemory"></a>



```ts
resetMemory(): void
```





#### resetMemorySwap() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetmemoryswap"></a>



```ts
resetMemorySwap(): void
```





#### resetNetworkMode() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetnetworkmode"></a>



```ts
resetNetworkMode(): void
```





#### resetNoCache() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetnocache"></a>



```ts
resetNoCache(): void
```





#### resetPlatform() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetplatform"></a>



```ts
resetPlatform(): void
```





#### resetPullParent() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetpullparent"></a>



```ts
resetPullParent(): void
```





#### resetRemoteContext() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetremotecontext"></a>



```ts
resetRemoteContext(): void
```





#### resetRemove() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetremove"></a>



```ts
resetRemove(): void
```





#### resetSecurityOpt() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetsecurityopt"></a>



```ts
resetSecurityOpt(): void
```





#### resetSessionId() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetsessionid"></a>



```ts
resetSessionId(): void
```





#### resetShmSize() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetshmsize"></a>



```ts
resetShmSize(): void
```





#### resetSquash() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetsquash"></a>



```ts
resetSquash(): void
```





#### resetSuppressOutput() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetsuppressoutput"></a>



```ts
resetSuppressOutput(): void
```





#### resetTarget() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resettarget"></a>



```ts
resetTarget(): void
```





#### resetUlimit() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetulimit"></a>



```ts
resetUlimit(): void
```





#### resetVersion() <a id="cdktf-provider-docker-registryimagebuildoutputreference-resetversion"></a>



```ts
resetVersion(): void
```







## class Secret  <a id="cdktf-provider-docker-secret"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/r/secret docker_secret}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/r/secret docker_secret} Resource.

```ts
new Secret(scope: Construct, id: string, config: SecretConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[SecretConfig](#cdktf-provider-docker-secretconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **data** (<code>string</code>)  Base64-url-safe-encoded secret data. 
  * **name** (<code>string</code>)  User-defined name of the secret. 
  * **labels** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[SecretLabels](#cdktf-provider-docker-secretlabels)></code>)  labels block. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**data** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**labels** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[SecretLabels](#cdktf-provider-docker-secretlabels)></code> | <span></span>
**name** | <code>string</code> | <span></span>
**dataInput**? | <code>string</code> | __*Optional*__
**labelsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[SecretLabels](#cdktf-provider-docker-secretlabels)></code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetLabels() <a id="cdktf-provider-docker-secret-resetlabels"></a>



```ts
resetLabels(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-docker-secret-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class Service  <a id="cdktf-provider-docker-service"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/r/service docker_service}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/r/service docker_service} Resource.

```ts
new Service(scope: Construct, id: string, config: ServiceConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[ServiceConfig](#cdktf-provider-docker-serviceconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  Name of the service. 
  * **taskSpec** (<code>[ServiceTaskSpec](#cdktf-provider-docker-servicetaskspec)</code>)  task_spec block. 
  * **auth** (<code>[ServiceAuth](#cdktf-provider-docker-serviceauth)</code>)  auth block. __*Optional*__
  * **convergeConfig** (<code>[ServiceConvergeConfig](#cdktf-provider-docker-serviceconvergeconfig)</code>)  converge_config block. __*Optional*__
  * **endpointSpec** (<code>[ServiceEndpointSpec](#cdktf-provider-docker-serviceendpointspec)</code>)  endpoint_spec block. __*Optional*__
  * **labels** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceLabels](#cdktf-provider-docker-servicelabels)></code>)  labels block. __*Optional*__
  * **mode** (<code>[ServiceMode](#cdktf-provider-docker-servicemode)</code>)  mode block. __*Optional*__
  * **rollbackConfig** (<code>[ServiceRollbackConfig](#cdktf-provider-docker-servicerollbackconfig)</code>)  rollback_config block. __*Optional*__
  * **updateConfig** (<code>[ServiceUpdateConfig](#cdktf-provider-docker-serviceupdateconfig)</code>)  update_config block. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**auth** | <code>[ServiceAuthOutputReference](#cdktf-provider-docker-serviceauthoutputreference)</code> | <span></span>
**convergeConfig** | <code>[ServiceConvergeConfigOutputReference](#cdktf-provider-docker-serviceconvergeconfigoutputreference)</code> | <span></span>
**endpointSpec** | <code>[ServiceEndpointSpecOutputReference](#cdktf-provider-docker-serviceendpointspecoutputreference)</code> | <span></span>
**id** | <code>string</code> | <span></span>
**labels** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceLabels](#cdktf-provider-docker-servicelabels)></code> | <span></span>
**mode** | <code>[ServiceModeOutputReference](#cdktf-provider-docker-servicemodeoutputreference)</code> | <span></span>
**name** | <code>string</code> | <span></span>
**rollbackConfig** | <code>[ServiceRollbackConfigOutputReference](#cdktf-provider-docker-servicerollbackconfigoutputreference)</code> | <span></span>
**taskSpec** | <code>[ServiceTaskSpecOutputReference](#cdktf-provider-docker-servicetaskspecoutputreference)</code> | <span></span>
**updateConfig** | <code>[ServiceUpdateConfigOutputReference](#cdktf-provider-docker-serviceupdateconfigoutputreference)</code> | <span></span>
**authInput**? | <code>[ServiceAuth](#cdktf-provider-docker-serviceauth)</code> | __*Optional*__
**convergeConfigInput**? | <code>[ServiceConvergeConfig](#cdktf-provider-docker-serviceconvergeconfig)</code> | __*Optional*__
**endpointSpecInput**? | <code>[ServiceEndpointSpec](#cdktf-provider-docker-serviceendpointspec)</code> | __*Optional*__
**labelsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceLabels](#cdktf-provider-docker-servicelabels)></code> | __*Optional*__
**modeInput**? | <code>[ServiceMode](#cdktf-provider-docker-servicemode)</code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
**rollbackConfigInput**? | <code>[ServiceRollbackConfig](#cdktf-provider-docker-servicerollbackconfig)</code> | __*Optional*__
**taskSpecInput**? | <code>[ServiceTaskSpec](#cdktf-provider-docker-servicetaskspec)</code> | __*Optional*__
**updateConfigInput**? | <code>[ServiceUpdateConfig](#cdktf-provider-docker-serviceupdateconfig)</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### putAuth(value) <a id="cdktf-provider-docker-service-putauth"></a>



```ts
putAuth(value: ServiceAuth): void
```

* **value** (<code>[ServiceAuth](#cdktf-provider-docker-serviceauth)</code>)  *No description*
  * **serverAddress** (<code>string</code>)  The address of the server for the authentication. 
  * **password** (<code>string</code>)  The password. __*Optional*__
  * **username** (<code>string</code>)  The username. __*Optional*__




#### putConvergeConfig(value) <a id="cdktf-provider-docker-service-putconvergeconfig"></a>



```ts
putConvergeConfig(value: ServiceConvergeConfig): void
```

* **value** (<code>[ServiceConvergeConfig](#cdktf-provider-docker-serviceconvergeconfig)</code>)  *No description*
  * **delay** (<code>string</code>)  The interval to check if the desired state is reached `(ms|s)`. Defaults to `7s`. __*Optional*__
  * **timeout** (<code>string</code>)  The timeout of the service to reach the desired state `(s|m)`. Defaults to `3m`. __*Optional*__




#### putEndpointSpec(value) <a id="cdktf-provider-docker-service-putendpointspec"></a>



```ts
putEndpointSpec(value: ServiceEndpointSpec): void
```

* **value** (<code>[ServiceEndpointSpec](#cdktf-provider-docker-serviceendpointspec)</code>)  *No description*
  * **mode** (<code>string</code>)  The mode of resolution to use for internal load balancing between tasks. __*Optional*__
  * **ports** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceEndpointSpecPorts](#cdktf-provider-docker-serviceendpointspecports)></code>)  ports block. __*Optional*__




#### putMode(value) <a id="cdktf-provider-docker-service-putmode"></a>



```ts
putMode(value: ServiceMode): void
```

* **value** (<code>[ServiceMode](#cdktf-provider-docker-servicemode)</code>)  *No description*
  * **global** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  The global service mode. Defaults to `false`. __*Optional*__
  * **replicated** (<code>[ServiceModeReplicated](#cdktf-provider-docker-servicemodereplicated)</code>)  replicated block. __*Optional*__




#### putRollbackConfig(value) <a id="cdktf-provider-docker-service-putrollbackconfig"></a>



```ts
putRollbackConfig(value: ServiceRollbackConfig): void
```

* **value** (<code>[ServiceRollbackConfig](#cdktf-provider-docker-servicerollbackconfig)</code>)  *No description*
  * **delay** (<code>string</code>)  Delay between task rollbacks (ns|us|ms|s|m|h). Defaults to `0s`. __*Optional*__
  * **failureAction** (<code>string</code>)  Action on rollback failure: pause | continue. Defaults to `pause`. __*Optional*__
  * **maxFailureRatio** (<code>string</code>)  Failure rate to tolerate during a rollback. Defaults to `0.0`. __*Optional*__
  * **monitor** (<code>string</code>)  Duration after each task rollback to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`. __*Optional*__
  * **order** (<code>string</code>)  Rollback order: either 'stop-first' or 'start-first'. Defaults to `stop-first`. __*Optional*__
  * **parallelism** (<code>number</code>)  Maximum number of tasks to be rollbacked in one iteration. Defaults to `1`. __*Optional*__




#### putTaskSpec(value) <a id="cdktf-provider-docker-service-puttaskspec"></a>



```ts
putTaskSpec(value: ServiceTaskSpec): void
```

* **value** (<code>[ServiceTaskSpec](#cdktf-provider-docker-servicetaskspec)</code>)  *No description*
  * **containerSpec** (<code>[ServiceTaskSpecContainerSpec](#cdktf-provider-docker-servicetaskspeccontainerspec)</code>)  container_spec block. 
  * **forceUpdate** (<code>number</code>)  A counter that triggers an update even if no relevant parameters have been changed. See the [spec](https://github.com/docker/swarmkit/blob/master/api/specs.proto#L126). __*Optional*__
  * **logDriver** (<code>[ServiceTaskSpecLogDriver](#cdktf-provider-docker-servicetaskspeclogdriver)</code>)  log_driver block. __*Optional*__
  * **networks** (<code>Array<string></code>)  Ids of the networks in which the  container will be put in. __*Optional*__
  * **placement** (<code>[ServiceTaskSpecPlacement](#cdktf-provider-docker-servicetaskspecplacement)</code>)  placement block. __*Optional*__
  * **resources** (<code>[ServiceTaskSpecResources](#cdktf-provider-docker-servicetaskspecresources)</code>)  resources block. __*Optional*__
  * **restartPolicy** (<code>[ServiceTaskSpecRestartPolicy](#cdktf-provider-docker-servicetaskspecrestartpolicy)</code>)  restart_policy block. __*Optional*__
  * **runtime** (<code>string</code>)  Runtime is the type of runtime specified for the task executor. See the [types](https://github.com/moby/moby/blob/master/api/types/swarm/runtime.go). __*Optional*__




#### putUpdateConfig(value) <a id="cdktf-provider-docker-service-putupdateconfig"></a>



```ts
putUpdateConfig(value: ServiceUpdateConfig): void
```

* **value** (<code>[ServiceUpdateConfig](#cdktf-provider-docker-serviceupdateconfig)</code>)  *No description*
  * **delay** (<code>string</code>)  Delay between task updates `(ns|us|ms|s|m|h)`. Defaults to `0s`. __*Optional*__
  * **failureAction** (<code>string</code>)  Action on update failure: `pause`, `continue` or `rollback`. Defaults to `pause`. __*Optional*__
  * **maxFailureRatio** (<code>string</code>)  Failure rate to tolerate during an update. Defaults to `0.0`. __*Optional*__
  * **monitor** (<code>string</code>)  Duration after each task update to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`. __*Optional*__
  * **order** (<code>string</code>)  Update order: either 'stop-first' or 'start-first'. Defaults to `stop-first`. __*Optional*__
  * **parallelism** (<code>number</code>)  Maximum number of tasks to be updated in one iteration. Defaults to `1`. __*Optional*__




#### resetAuth() <a id="cdktf-provider-docker-service-resetauth"></a>



```ts
resetAuth(): void
```





#### resetConvergeConfig() <a id="cdktf-provider-docker-service-resetconvergeconfig"></a>



```ts
resetConvergeConfig(): void
```





#### resetEndpointSpec() <a id="cdktf-provider-docker-service-resetendpointspec"></a>



```ts
resetEndpointSpec(): void
```





#### resetLabels() <a id="cdktf-provider-docker-service-resetlabels"></a>



```ts
resetLabels(): void
```





#### resetMode() <a id="cdktf-provider-docker-service-resetmode"></a>



```ts
resetMode(): void
```





#### resetRollbackConfig() <a id="cdktf-provider-docker-service-resetrollbackconfig"></a>



```ts
resetRollbackConfig(): void
```





#### resetUpdateConfig() <a id="cdktf-provider-docker-service-resetupdateconfig"></a>



```ts
resetUpdateConfig(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-docker-service-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class ServiceAuthOutputReference  <a id="cdktf-provider-docker-serviceauthoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceAuthOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**password** | <code>string</code> | <span></span>
**serverAddress** | <code>string</code> | <span></span>
**username** | <code>string</code> | <span></span>
**internalValue**? | <code>[ServiceAuth](#cdktf-provider-docker-serviceauth)</code> | __*Optional*__
**passwordInput**? | <code>string</code> | __*Optional*__
**serverAddressInput**? | <code>string</code> | __*Optional*__
**usernameInput**? | <code>string</code> | __*Optional*__

### Methods


#### resetPassword() <a id="cdktf-provider-docker-serviceauthoutputreference-resetpassword"></a>



```ts
resetPassword(): void
```





#### resetUsername() <a id="cdktf-provider-docker-serviceauthoutputreference-resetusername"></a>



```ts
resetUsername(): void
```







## class ServiceConvergeConfigOutputReference  <a id="cdktf-provider-docker-serviceconvergeconfigoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceConvergeConfigOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**delay** | <code>string</code> | <span></span>
**timeout** | <code>string</code> | <span></span>
**delayInput**? | <code>string</code> | __*Optional*__
**internalValue**? | <code>[ServiceConvergeConfig](#cdktf-provider-docker-serviceconvergeconfig)</code> | __*Optional*__
**timeoutInput**? | <code>string</code> | __*Optional*__

### Methods


#### resetDelay() <a id="cdktf-provider-docker-serviceconvergeconfigoutputreference-resetdelay"></a>



```ts
resetDelay(): void
```





#### resetTimeout() <a id="cdktf-provider-docker-serviceconvergeconfigoutputreference-resettimeout"></a>



```ts
resetTimeout(): void
```







## class ServiceEndpointSpecOutputReference  <a id="cdktf-provider-docker-serviceendpointspecoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceEndpointSpecOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**mode** | <code>string</code> | <span></span>
**ports** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceEndpointSpecPorts](#cdktf-provider-docker-serviceendpointspecports)></code> | <span></span>
**internalValue**? | <code>[ServiceEndpointSpec](#cdktf-provider-docker-serviceendpointspec)</code> | __*Optional*__
**modeInput**? | <code>string</code> | __*Optional*__
**portsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceEndpointSpecPorts](#cdktf-provider-docker-serviceendpointspecports)></code> | __*Optional*__

### Methods


#### resetMode() <a id="cdktf-provider-docker-serviceendpointspecoutputreference-resetmode"></a>



```ts
resetMode(): void
```





#### resetPorts() <a id="cdktf-provider-docker-serviceendpointspecoutputreference-resetports"></a>



```ts
resetPorts(): void
```







## class ServiceModeOutputReference  <a id="cdktf-provider-docker-servicemodeoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceModeOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**global** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**replicated** | <code>[ServiceModeReplicatedOutputReference](#cdktf-provider-docker-servicemodereplicatedoutputreference)</code> | <span></span>
**globalInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**internalValue**? | <code>[ServiceMode](#cdktf-provider-docker-servicemode)</code> | __*Optional*__
**replicatedInput**? | <code>[ServiceModeReplicated](#cdktf-provider-docker-servicemodereplicated)</code> | __*Optional*__

### Methods


#### putReplicated(value) <a id="cdktf-provider-docker-servicemodeoutputreference-putreplicated"></a>



```ts
putReplicated(value: ServiceModeReplicated): void
```

* **value** (<code>[ServiceModeReplicated](#cdktf-provider-docker-servicemodereplicated)</code>)  *No description*
  * **replicas** (<code>number</code>)  The amount of replicas of the service. Defaults to `1`. __*Optional*__




#### resetGlobal() <a id="cdktf-provider-docker-servicemodeoutputreference-resetglobal"></a>



```ts
resetGlobal(): void
```





#### resetReplicated() <a id="cdktf-provider-docker-servicemodeoutputreference-resetreplicated"></a>



```ts
resetReplicated(): void
```







## class ServiceModeReplicatedOutputReference  <a id="cdktf-provider-docker-servicemodereplicatedoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceModeReplicatedOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**replicas** | <code>number</code> | <span></span>
**internalValue**? | <code>[ServiceModeReplicated](#cdktf-provider-docker-servicemodereplicated)</code> | __*Optional*__
**replicasInput**? | <code>number</code> | __*Optional*__

### Methods


#### resetReplicas() <a id="cdktf-provider-docker-servicemodereplicatedoutputreference-resetreplicas"></a>



```ts
resetReplicas(): void
```







## class ServiceRollbackConfigOutputReference  <a id="cdktf-provider-docker-servicerollbackconfigoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceRollbackConfigOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**delay** | <code>string</code> | <span></span>
**failureAction** | <code>string</code> | <span></span>
**maxFailureRatio** | <code>string</code> | <span></span>
**monitor** | <code>string</code> | <span></span>
**order** | <code>string</code> | <span></span>
**parallelism** | <code>number</code> | <span></span>
**delayInput**? | <code>string</code> | __*Optional*__
**failureActionInput**? | <code>string</code> | __*Optional*__
**internalValue**? | <code>[ServiceRollbackConfig](#cdktf-provider-docker-servicerollbackconfig)</code> | __*Optional*__
**maxFailureRatioInput**? | <code>string</code> | __*Optional*__
**monitorInput**? | <code>string</code> | __*Optional*__
**orderInput**? | <code>string</code> | __*Optional*__
**parallelismInput**? | <code>number</code> | __*Optional*__

### Methods


#### resetDelay() <a id="cdktf-provider-docker-servicerollbackconfigoutputreference-resetdelay"></a>



```ts
resetDelay(): void
```





#### resetFailureAction() <a id="cdktf-provider-docker-servicerollbackconfigoutputreference-resetfailureaction"></a>



```ts
resetFailureAction(): void
```





#### resetMaxFailureRatio() <a id="cdktf-provider-docker-servicerollbackconfigoutputreference-resetmaxfailureratio"></a>



```ts
resetMaxFailureRatio(): void
```





#### resetMonitor() <a id="cdktf-provider-docker-servicerollbackconfigoutputreference-resetmonitor"></a>



```ts
resetMonitor(): void
```





#### resetOrder() <a id="cdktf-provider-docker-servicerollbackconfigoutputreference-resetorder"></a>



```ts
resetOrder(): void
```





#### resetParallelism() <a id="cdktf-provider-docker-servicerollbackconfigoutputreference-resetparallelism"></a>



```ts
resetParallelism(): void
```







## class ServiceTaskSpecContainerSpecDnsConfigOutputReference  <a id="cdktf-provider-docker-servicetaskspeccontainerspecdnsconfigoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecContainerSpecDnsConfigOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**nameservers** | <code>Array<string></code> | <span></span>
**options** | <code>Array<string></code> | <span></span>
**search** | <code>Array<string></code> | <span></span>
**internalValue**? | <code>[ServiceTaskSpecContainerSpecDnsConfig](#cdktf-provider-docker-servicetaskspeccontainerspecdnsconfig)</code> | __*Optional*__
**nameserversInput**? | <code>Array<string></code> | __*Optional*__
**optionsInput**? | <code>Array<string></code> | __*Optional*__
**searchInput**? | <code>Array<string></code> | __*Optional*__

### Methods


#### resetOptions() <a id="cdktf-provider-docker-servicetaskspeccontainerspecdnsconfigoutputreference-resetoptions"></a>



```ts
resetOptions(): void
```





#### resetSearch() <a id="cdktf-provider-docker-servicetaskspeccontainerspecdnsconfigoutputreference-resetsearch"></a>



```ts
resetSearch(): void
```







## class ServiceTaskSpecContainerSpecHealthcheckOutputReference  <a id="cdktf-provider-docker-servicetaskspeccontainerspechealthcheckoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecContainerSpecHealthcheckOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**interval** | <code>string</code> | <span></span>
**retries** | <code>number</code> | <span></span>
**startPeriod** | <code>string</code> | <span></span>
**test** | <code>Array<string></code> | <span></span>
**timeout** | <code>string</code> | <span></span>
**internalValue**? | <code>[ServiceTaskSpecContainerSpecHealthcheck](#cdktf-provider-docker-servicetaskspeccontainerspechealthcheck)</code> | __*Optional*__
**intervalInput**? | <code>string</code> | __*Optional*__
**retriesInput**? | <code>number</code> | __*Optional*__
**startPeriodInput**? | <code>string</code> | __*Optional*__
**testInput**? | <code>Array<string></code> | __*Optional*__
**timeoutInput**? | <code>string</code> | __*Optional*__

### Methods


#### resetInterval() <a id="cdktf-provider-docker-servicetaskspeccontainerspechealthcheckoutputreference-resetinterval"></a>



```ts
resetInterval(): void
```





#### resetRetries() <a id="cdktf-provider-docker-servicetaskspeccontainerspechealthcheckoutputreference-resetretries"></a>



```ts
resetRetries(): void
```





#### resetStartPeriod() <a id="cdktf-provider-docker-servicetaskspeccontainerspechealthcheckoutputreference-resetstartperiod"></a>



```ts
resetStartPeriod(): void
```





#### resetTimeout() <a id="cdktf-provider-docker-servicetaskspeccontainerspechealthcheckoutputreference-resettimeout"></a>



```ts
resetTimeout(): void
```







## class ServiceTaskSpecContainerSpecMountsBindOptionsOutputReference  <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountsbindoptionsoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecContainerSpecMountsBindOptionsOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**propagation** | <code>string</code> | <span></span>
**internalValue**? | <code>[ServiceTaskSpecContainerSpecMountsBindOptions](#cdktf-provider-docker-servicetaskspeccontainerspecmountsbindoptions)</code> | __*Optional*__
**propagationInput**? | <code>string</code> | __*Optional*__

### Methods


#### resetPropagation() <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountsbindoptionsoutputreference-resetpropagation"></a>



```ts
resetPropagation(): void
```







## class ServiceTaskSpecContainerSpecMountsTmpfsOptionsOutputReference  <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountstmpfsoptionsoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecContainerSpecMountsTmpfsOptionsOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**mode** | <code>number</code> | <span></span>
**sizeBytes** | <code>number</code> | <span></span>
**internalValue**? | <code>[ServiceTaskSpecContainerSpecMountsTmpfsOptions](#cdktf-provider-docker-servicetaskspeccontainerspecmountstmpfsoptions)</code> | __*Optional*__
**modeInput**? | <code>number</code> | __*Optional*__
**sizeBytesInput**? | <code>number</code> | __*Optional*__

### Methods


#### resetMode() <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountstmpfsoptionsoutputreference-resetmode"></a>



```ts
resetMode(): void
```





#### resetSizeBytes() <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountstmpfsoptionsoutputreference-resetsizebytes"></a>



```ts
resetSizeBytes(): void
```







## class ServiceTaskSpecContainerSpecMountsVolumeOptionsOutputReference  <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptionsoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecContainerSpecMountsVolumeOptionsOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**driverName** | <code>string</code> | <span></span>
**driverOptions** | <code>Map<string, string></code> | <span></span>
**labels** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecMountsVolumeOptionsLabels](#cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptionslabels)></code> | <span></span>
**noCopy** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**driverNameInput**? | <code>string</code> | __*Optional*__
**driverOptionsInput**? | <code>Map<string, string></code> | __*Optional*__
**internalValue**? | <code>[ServiceTaskSpecContainerSpecMountsVolumeOptions](#cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptions)</code> | __*Optional*__
**labelsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecMountsVolumeOptionsLabels](#cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptionslabels)></code> | __*Optional*__
**noCopyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__

### Methods


#### resetDriverName() <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptionsoutputreference-resetdrivername"></a>



```ts
resetDriverName(): void
```





#### resetDriverOptions() <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptionsoutputreference-resetdriveroptions"></a>



```ts
resetDriverOptions(): void
```





#### resetLabels() <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptionsoutputreference-resetlabels"></a>



```ts
resetLabels(): void
```





#### resetNoCopy() <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptionsoutputreference-resetnocopy"></a>



```ts
resetNoCopy(): void
```







## class ServiceTaskSpecContainerSpecOutputReference  <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecContainerSpecOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**args** | <code>Array<string></code> | <span></span>
**command** | <code>Array<string></code> | <span></span>
**configs** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecConfigs](#cdktf-provider-docker-servicetaskspeccontainerspecconfigs)></code> | <span></span>
**dir** | <code>string</code> | <span></span>
**dnsConfig** | <code>[ServiceTaskSpecContainerSpecDnsConfigOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecdnsconfigoutputreference)</code> | <span></span>
**env** | <code>Map<string, string></code> | <span></span>
**groups** | <code>Array<string></code> | <span></span>
**healthcheck** | <code>[ServiceTaskSpecContainerSpecHealthcheckOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspechealthcheckoutputreference)</code> | <span></span>
**hostname** | <code>string</code> | <span></span>
**hosts** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecHosts](#cdktf-provider-docker-servicetaskspeccontainerspechosts)></code> | <span></span>
**image** | <code>string</code> | <span></span>
**isolation** | <code>string</code> | <span></span>
**labels** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecLabels](#cdktf-provider-docker-servicetaskspeccontainerspeclabels)></code> | <span></span>
**mounts** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecMounts](#cdktf-provider-docker-servicetaskspeccontainerspecmounts)></code> | <span></span>
**privileges** | <code>[ServiceTaskSpecContainerSpecPrivilegesOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegesoutputreference)</code> | <span></span>
**readOnly** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**secrets** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecSecrets](#cdktf-provider-docker-servicetaskspeccontainerspecsecrets)></code> | <span></span>
**stopGracePeriod** | <code>string</code> | <span></span>
**stopSignal** | <code>string</code> | <span></span>
**user** | <code>string</code> | <span></span>
**argsInput**? | <code>Array<string></code> | __*Optional*__
**commandInput**? | <code>Array<string></code> | __*Optional*__
**configsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecConfigs](#cdktf-provider-docker-servicetaskspeccontainerspecconfigs)></code> | __*Optional*__
**dirInput**? | <code>string</code> | __*Optional*__
**dnsConfigInput**? | <code>[ServiceTaskSpecContainerSpecDnsConfig](#cdktf-provider-docker-servicetaskspeccontainerspecdnsconfig)</code> | __*Optional*__
**envInput**? | <code>Map<string, string></code> | __*Optional*__
**groupsInput**? | <code>Array<string></code> | __*Optional*__
**healthcheckInput**? | <code>[ServiceTaskSpecContainerSpecHealthcheck](#cdktf-provider-docker-servicetaskspeccontainerspechealthcheck)</code> | __*Optional*__
**hostnameInput**? | <code>string</code> | __*Optional*__
**hostsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecHosts](#cdktf-provider-docker-servicetaskspeccontainerspechosts)></code> | __*Optional*__
**imageInput**? | <code>string</code> | __*Optional*__
**internalValue**? | <code>[ServiceTaskSpecContainerSpec](#cdktf-provider-docker-servicetaskspeccontainerspec)</code> | __*Optional*__
**isolationInput**? | <code>string</code> | __*Optional*__
**labelsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecLabels](#cdktf-provider-docker-servicetaskspeccontainerspeclabels)></code> | __*Optional*__
**mountsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecMounts](#cdktf-provider-docker-servicetaskspeccontainerspecmounts)></code> | __*Optional*__
**privilegesInput**? | <code>[ServiceTaskSpecContainerSpecPrivileges](#cdktf-provider-docker-servicetaskspeccontainerspecprivileges)</code> | __*Optional*__
**readOnlyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**secretsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecSecrets](#cdktf-provider-docker-servicetaskspeccontainerspecsecrets)></code> | __*Optional*__
**stopGracePeriodInput**? | <code>string</code> | __*Optional*__
**stopSignalInput**? | <code>string</code> | __*Optional*__
**userInput**? | <code>string</code> | __*Optional*__

### Methods


#### putDnsConfig(value) <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-putdnsconfig"></a>



```ts
putDnsConfig(value: ServiceTaskSpecContainerSpecDnsConfig): void
```

* **value** (<code>[ServiceTaskSpecContainerSpecDnsConfig](#cdktf-provider-docker-servicetaskspeccontainerspecdnsconfig)</code>)  *No description*
  * **nameservers** (<code>Array<string></code>)  The IP addresses of the name servers. 
  * **options** (<code>Array<string></code>)  A list of internal resolver variables to be modified (e.g., `debug`, `ndots:3`, etc.). __*Optional*__
  * **search** (<code>Array<string></code>)  A search list for host-name lookup. __*Optional*__




#### putHealthcheck(value) <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-puthealthcheck"></a>



```ts
putHealthcheck(value: ServiceTaskSpecContainerSpecHealthcheck): void
```

* **value** (<code>[ServiceTaskSpecContainerSpecHealthcheck](#cdktf-provider-docker-servicetaskspeccontainerspechealthcheck)</code>)  *No description*
  * **test** (<code>Array<string></code>)  The test to perform as list. 
  * **interval** (<code>string</code>)  Time between running the check (ms|s|m|h). Defaults to `0s`. __*Optional*__
  * **retries** (<code>number</code>)  Consecutive failures needed to report unhealthy. Defaults to `0`. __*Optional*__
  * **startPeriod** (<code>string</code>)  Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`. __*Optional*__
  * **timeout** (<code>string</code>)  Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`. __*Optional*__




#### putPrivileges(value) <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-putprivileges"></a>



```ts
putPrivileges(value: ServiceTaskSpecContainerSpecPrivileges): void
```

* **value** (<code>[ServiceTaskSpecContainerSpecPrivileges](#cdktf-provider-docker-servicetaskspeccontainerspecprivileges)</code>)  *No description*
  * **credentialSpec** (<code>[ServiceTaskSpecContainerSpecPrivilegesCredentialSpec](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspec)</code>)  credential_spec block. __*Optional*__
  * **seLinuxContext** (<code>[ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontext)</code>)  se_linux_context block. __*Optional*__




#### resetArgs() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetargs"></a>



```ts
resetArgs(): void
```





#### resetCommand() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetcommand"></a>



```ts
resetCommand(): void
```





#### resetConfigs() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetconfigs"></a>



```ts
resetConfigs(): void
```





#### resetDir() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetdir"></a>



```ts
resetDir(): void
```





#### resetDnsConfig() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetdnsconfig"></a>



```ts
resetDnsConfig(): void
```





#### resetEnv() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetenv"></a>



```ts
resetEnv(): void
```





#### resetGroups() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetgroups"></a>



```ts
resetGroups(): void
```





#### resetHealthcheck() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resethealthcheck"></a>



```ts
resetHealthcheck(): void
```





#### resetHostname() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resethostname"></a>



```ts
resetHostname(): void
```





#### resetHosts() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resethosts"></a>



```ts
resetHosts(): void
```





#### resetIsolation() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetisolation"></a>



```ts
resetIsolation(): void
```





#### resetLabels() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetlabels"></a>



```ts
resetLabels(): void
```





#### resetMounts() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetmounts"></a>



```ts
resetMounts(): void
```





#### resetPrivileges() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetprivileges"></a>



```ts
resetPrivileges(): void
```





#### resetReadOnly() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetreadonly"></a>



```ts
resetReadOnly(): void
```





#### resetSecrets() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetsecrets"></a>



```ts
resetSecrets(): void
```





#### resetStopGracePeriod() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetstopgraceperiod"></a>



```ts
resetStopGracePeriod(): void
```





#### resetStopSignal() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetstopsignal"></a>



```ts
resetStopSignal(): void
```





#### resetUser() <a id="cdktf-provider-docker-servicetaskspeccontainerspecoutputreference-resetuser"></a>



```ts
resetUser(): void
```







## class ServiceTaskSpecContainerSpecPrivilegesCredentialSpecOutputReference  <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspecoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecContainerSpecPrivilegesCredentialSpecOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**file** | <code>string</code> | <span></span>
**registry** | <code>string</code> | <span></span>
**fileInput**? | <code>string</code> | __*Optional*__
**internalValue**? | <code>[ServiceTaskSpecContainerSpecPrivilegesCredentialSpec](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspec)</code> | __*Optional*__
**registryInput**? | <code>string</code> | __*Optional*__

### Methods


#### resetFile() <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspecoutputreference-resetfile"></a>



```ts
resetFile(): void
```





#### resetRegistry() <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspecoutputreference-resetregistry"></a>



```ts
resetRegistry(): void
```







## class ServiceTaskSpecContainerSpecPrivilegesOutputReference  <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecContainerSpecPrivilegesOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**credentialSpec** | <code>[ServiceTaskSpecContainerSpecPrivilegesCredentialSpecOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspecoutputreference)</code> | <span></span>
**seLinuxContext** | <code>[ServiceTaskSpecContainerSpecPrivilegesSeLinuxContextOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontextoutputreference)</code> | <span></span>
**credentialSpecInput**? | <code>[ServiceTaskSpecContainerSpecPrivilegesCredentialSpec](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspec)</code> | __*Optional*__
**internalValue**? | <code>[ServiceTaskSpecContainerSpecPrivileges](#cdktf-provider-docker-servicetaskspeccontainerspecprivileges)</code> | __*Optional*__
**seLinuxContextInput**? | <code>[ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontext)</code> | __*Optional*__

### Methods


#### putCredentialSpec(value) <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesoutputreference-putcredentialspec"></a>



```ts
putCredentialSpec(value: ServiceTaskSpecContainerSpecPrivilegesCredentialSpec): void
```

* **value** (<code>[ServiceTaskSpecContainerSpecPrivilegesCredentialSpec](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspec)</code>)  *No description*
  * **file** (<code>string</code>)  Load credential spec from this file. __*Optional*__
  * **registry** (<code>string</code>)  Load credential spec from this value in the Windows registry. __*Optional*__




#### putSeLinuxContext(value) <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesoutputreference-putselinuxcontext"></a>



```ts
putSeLinuxContext(value: ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext): void
```

* **value** (<code>[ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontext)</code>)  *No description*
  * **disable** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Disable SELinux. __*Optional*__
  * **level** (<code>string</code>)  SELinux level label. __*Optional*__
  * **role** (<code>string</code>)  SELinux role label. __*Optional*__
  * **type** (<code>string</code>)  SELinux type label. __*Optional*__
  * **user** (<code>string</code>)  SELinux user label. __*Optional*__




#### resetCredentialSpec() <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesoutputreference-resetcredentialspec"></a>



```ts
resetCredentialSpec(): void
```





#### resetSeLinuxContext() <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesoutputreference-resetselinuxcontext"></a>



```ts
resetSeLinuxContext(): void
```







## class ServiceTaskSpecContainerSpecPrivilegesSeLinuxContextOutputReference  <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontextoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecContainerSpecPrivilegesSeLinuxContextOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**disable** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**level** | <code>string</code> | <span></span>
**role** | <code>string</code> | <span></span>
**type** | <code>string</code> | <span></span>
**user** | <code>string</code> | <span></span>
**disableInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**internalValue**? | <code>[ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontext)</code> | __*Optional*__
**levelInput**? | <code>string</code> | __*Optional*__
**roleInput**? | <code>string</code> | __*Optional*__
**typeInput**? | <code>string</code> | __*Optional*__
**userInput**? | <code>string</code> | __*Optional*__

### Methods


#### resetDisable() <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontextoutputreference-resetdisable"></a>



```ts
resetDisable(): void
```





#### resetLevel() <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontextoutputreference-resetlevel"></a>



```ts
resetLevel(): void
```





#### resetRole() <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontextoutputreference-resetrole"></a>



```ts
resetRole(): void
```





#### resetType() <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontextoutputreference-resettype"></a>



```ts
resetType(): void
```





#### resetUser() <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontextoutputreference-resetuser"></a>



```ts
resetUser(): void
```







## class ServiceTaskSpecLogDriverOutputReference  <a id="cdktf-provider-docker-servicetaskspeclogdriveroutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecLogDriverOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | <span></span>
**options** | <code>Map<string, string></code> | <span></span>
**internalValue**? | <code>[ServiceTaskSpecLogDriver](#cdktf-provider-docker-servicetaskspeclogdriver)</code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
**optionsInput**? | <code>Map<string, string></code> | __*Optional*__

### Methods


#### resetOptions() <a id="cdktf-provider-docker-servicetaskspeclogdriveroutputreference-resetoptions"></a>



```ts
resetOptions(): void
```







## class ServiceTaskSpecOutputReference  <a id="cdktf-provider-docker-servicetaskspecoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**containerSpec** | <code>[ServiceTaskSpecContainerSpecOutputReference](#cdktf-provider-docker-servicetaskspeccontainerspecoutputreference)</code> | <span></span>
**forceUpdate** | <code>number</code> | <span></span>
**logDriver** | <code>[ServiceTaskSpecLogDriverOutputReference](#cdktf-provider-docker-servicetaskspeclogdriveroutputreference)</code> | <span></span>
**networks** | <code>Array<string></code> | <span></span>
**placement** | <code>[ServiceTaskSpecPlacementOutputReference](#cdktf-provider-docker-servicetaskspecplacementoutputreference)</code> | <span></span>
**resources** | <code>[ServiceTaskSpecResourcesOutputReference](#cdktf-provider-docker-servicetaskspecresourcesoutputreference)</code> | <span></span>
**restartPolicy** | <code>[ServiceTaskSpecRestartPolicyOutputReference](#cdktf-provider-docker-servicetaskspecrestartpolicyoutputreference)</code> | <span></span>
**runtime** | <code>string</code> | <span></span>
**containerSpecInput**? | <code>[ServiceTaskSpecContainerSpec](#cdktf-provider-docker-servicetaskspeccontainerspec)</code> | __*Optional*__
**forceUpdateInput**? | <code>number</code> | __*Optional*__
**internalValue**? | <code>[ServiceTaskSpec](#cdktf-provider-docker-servicetaskspec)</code> | __*Optional*__
**logDriverInput**? | <code>[ServiceTaskSpecLogDriver](#cdktf-provider-docker-servicetaskspeclogdriver)</code> | __*Optional*__
**networksInput**? | <code>Array<string></code> | __*Optional*__
**placementInput**? | <code>[ServiceTaskSpecPlacement](#cdktf-provider-docker-servicetaskspecplacement)</code> | __*Optional*__
**resourcesInput**? | <code>[ServiceTaskSpecResources](#cdktf-provider-docker-servicetaskspecresources)</code> | __*Optional*__
**restartPolicyInput**? | <code>[ServiceTaskSpecRestartPolicy](#cdktf-provider-docker-servicetaskspecrestartpolicy)</code> | __*Optional*__
**runtimeInput**? | <code>string</code> | __*Optional*__

### Methods


#### putContainerSpec(value) <a id="cdktf-provider-docker-servicetaskspecoutputreference-putcontainerspec"></a>



```ts
putContainerSpec(value: ServiceTaskSpecContainerSpec): void
```

* **value** (<code>[ServiceTaskSpecContainerSpec](#cdktf-provider-docker-servicetaskspeccontainerspec)</code>)  *No description*
  * **image** (<code>string</code>)  The image name to use for the containers of the service, like `nginx:1.17.6`. Also use the data-source or resource of `docker_image` with the `repo_digest` or `docker_registry_image` with the `name` attribute for this, as shown in the examples. 
  * **args** (<code>Array<string></code>)  Arguments to the command. __*Optional*__
  * **command** (<code>Array<string></code>)  The command/entrypoint to be run in the image. __*Optional*__
  * **configs** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecConfigs](#cdktf-provider-docker-servicetaskspeccontainerspecconfigs)></code>)  configs block. __*Optional*__
  * **dir** (<code>string</code>)  The working directory for commands to run in. __*Optional*__
  * **dnsConfig** (<code>[ServiceTaskSpecContainerSpecDnsConfig](#cdktf-provider-docker-servicetaskspeccontainerspecdnsconfig)</code>)  dns_config block. __*Optional*__
  * **env** (<code>Map<string, string></code>)  A list of environment variables in the form VAR="value". __*Optional*__
  * **groups** (<code>Array<string></code>)  A list of additional groups that the container process will run as. __*Optional*__
  * **healthcheck** (<code>[ServiceTaskSpecContainerSpecHealthcheck](#cdktf-provider-docker-servicetaskspeccontainerspechealthcheck)</code>)  healthcheck block. __*Optional*__
  * **hostname** (<code>string</code>)  The hostname to use for the container, as a valid RFC 1123 hostname. __*Optional*__
  * **hosts** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecHosts](#cdktf-provider-docker-servicetaskspeccontainerspechosts)></code>)  hosts block. __*Optional*__
  * **isolation** (<code>string</code>)  Isolation technology of the containers running the service. (Windows only). Defaults to `default`. __*Optional*__
  * **labels** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecLabels](#cdktf-provider-docker-servicetaskspeccontainerspeclabels)></code>)  labels block. __*Optional*__
  * **mounts** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecMounts](#cdktf-provider-docker-servicetaskspeccontainerspecmounts)></code>)  mounts block. __*Optional*__
  * **privileges** (<code>[ServiceTaskSpecContainerSpecPrivileges](#cdktf-provider-docker-servicetaskspeccontainerspecprivileges)</code>)  privileges block. __*Optional*__
  * **readOnly** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Mount the container's root filesystem as read only. __*Optional*__
  * **secrets** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecSecrets](#cdktf-provider-docker-servicetaskspeccontainerspecsecrets)></code>)  secrets block. __*Optional*__
  * **stopGracePeriod** (<code>string</code>)  Amount of time to wait for the container to terminate before forcefully removing it (ms|s|m|h). __*Optional*__
  * **stopSignal** (<code>string</code>)  Signal to stop the container. __*Optional*__
  * **user** (<code>string</code>)  The user inside the container. __*Optional*__




#### putLogDriver(value) <a id="cdktf-provider-docker-servicetaskspecoutputreference-putlogdriver"></a>



```ts
putLogDriver(value: ServiceTaskSpecLogDriver): void
```

* **value** (<code>[ServiceTaskSpecLogDriver](#cdktf-provider-docker-servicetaskspeclogdriver)</code>)  *No description*
  * **name** (<code>string</code>)  The logging driver to use. 
  * **options** (<code>Map<string, string></code>)  The options for the logging driver. __*Optional*__




#### putPlacement(value) <a id="cdktf-provider-docker-servicetaskspecoutputreference-putplacement"></a>



```ts
putPlacement(value: ServiceTaskSpecPlacement): void
```

* **value** (<code>[ServiceTaskSpecPlacement](#cdktf-provider-docker-servicetaskspecplacement)</code>)  *No description*
  * **constraints** (<code>Array<string></code>)  An array of constraints. e.g.: `node.role==manager`. __*Optional*__
  * **maxReplicas** (<code>number</code>)  Maximum number of replicas for per node (default value is `0`, which is unlimited). __*Optional*__
  * **platforms** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecPlacementPlatforms](#cdktf-provider-docker-servicetaskspecplacementplatforms)></code>)  platforms block. __*Optional*__
  * **prefs** (<code>Array<string></code>)  Preferences provide a way to make the scheduler aware of factors such as topology. __*Optional*__




#### putResources(value) <a id="cdktf-provider-docker-servicetaskspecoutputreference-putresources"></a>



```ts
putResources(value: ServiceTaskSpecResources): void
```

* **value** (<code>[ServiceTaskSpecResources](#cdktf-provider-docker-servicetaskspecresources)</code>)  *No description*
  * **limits** (<code>[ServiceTaskSpecResourcesLimits](#cdktf-provider-docker-servicetaskspecresourceslimits)</code>)  limits block. __*Optional*__
  * **reservation** (<code>[ServiceTaskSpecResourcesReservation](#cdktf-provider-docker-servicetaskspecresourcesreservation)</code>)  reservation block. __*Optional*__




#### putRestartPolicy(value) <a id="cdktf-provider-docker-servicetaskspecoutputreference-putrestartpolicy"></a>



```ts
putRestartPolicy(value: ServiceTaskSpecRestartPolicy): void
```

* **value** (<code>[ServiceTaskSpecRestartPolicy](#cdktf-provider-docker-servicetaskspecrestartpolicy)</code>)  *No description*
  * **condition** (<code>string</code>)  Condition for restart. __*Optional*__
  * **delay** (<code>string</code>)  Delay between restart attempts (ms|s|m|h). __*Optional*__
  * **maxAttempts** (<code>number</code>)  Maximum attempts to restart a given container before giving up (default value is `0`, which is ignored). __*Optional*__
  * **window** (<code>string</code>)  The time window used to evaluate the restart policy (default value is `0`, which is unbounded) (ms|s|m|h). __*Optional*__




#### resetForceUpdate() <a id="cdktf-provider-docker-servicetaskspecoutputreference-resetforceupdate"></a>



```ts
resetForceUpdate(): void
```





#### resetLogDriver() <a id="cdktf-provider-docker-servicetaskspecoutputreference-resetlogdriver"></a>



```ts
resetLogDriver(): void
```





#### resetNetworks() <a id="cdktf-provider-docker-servicetaskspecoutputreference-resetnetworks"></a>



```ts
resetNetworks(): void
```





#### resetPlacement() <a id="cdktf-provider-docker-servicetaskspecoutputreference-resetplacement"></a>



```ts
resetPlacement(): void
```





#### resetResources() <a id="cdktf-provider-docker-servicetaskspecoutputreference-resetresources"></a>



```ts
resetResources(): void
```





#### resetRestartPolicy() <a id="cdktf-provider-docker-servicetaskspecoutputreference-resetrestartpolicy"></a>



```ts
resetRestartPolicy(): void
```





#### resetRuntime() <a id="cdktf-provider-docker-servicetaskspecoutputreference-resetruntime"></a>



```ts
resetRuntime(): void
```







## class ServiceTaskSpecPlacementOutputReference  <a id="cdktf-provider-docker-servicetaskspecplacementoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecPlacementOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**constraints** | <code>Array<string></code> | <span></span>
**maxReplicas** | <code>number</code> | <span></span>
**platforms** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecPlacementPlatforms](#cdktf-provider-docker-servicetaskspecplacementplatforms)></code> | <span></span>
**prefs** | <code>Array<string></code> | <span></span>
**constraintsInput**? | <code>Array<string></code> | __*Optional*__
**internalValue**? | <code>[ServiceTaskSpecPlacement](#cdktf-provider-docker-servicetaskspecplacement)</code> | __*Optional*__
**maxReplicasInput**? | <code>number</code> | __*Optional*__
**platformsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecPlacementPlatforms](#cdktf-provider-docker-servicetaskspecplacementplatforms)></code> | __*Optional*__
**prefsInput**? | <code>Array<string></code> | __*Optional*__

### Methods


#### resetConstraints() <a id="cdktf-provider-docker-servicetaskspecplacementoutputreference-resetconstraints"></a>



```ts
resetConstraints(): void
```





#### resetMaxReplicas() <a id="cdktf-provider-docker-servicetaskspecplacementoutputreference-resetmaxreplicas"></a>



```ts
resetMaxReplicas(): void
```





#### resetPlatforms() <a id="cdktf-provider-docker-servicetaskspecplacementoutputreference-resetplatforms"></a>



```ts
resetPlatforms(): void
```





#### resetPrefs() <a id="cdktf-provider-docker-servicetaskspecplacementoutputreference-resetprefs"></a>



```ts
resetPrefs(): void
```







## class ServiceTaskSpecResourcesLimitsOutputReference  <a id="cdktf-provider-docker-servicetaskspecresourceslimitsoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecResourcesLimitsOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**memoryBytes** | <code>number</code> | <span></span>
**nanoCpus** | <code>number</code> | <span></span>
**internalValue**? | <code>[ServiceTaskSpecResourcesLimits](#cdktf-provider-docker-servicetaskspecresourceslimits)</code> | __*Optional*__
**memoryBytesInput**? | <code>number</code> | __*Optional*__
**nanoCpusInput**? | <code>number</code> | __*Optional*__

### Methods


#### resetMemoryBytes() <a id="cdktf-provider-docker-servicetaskspecresourceslimitsoutputreference-resetmemorybytes"></a>



```ts
resetMemoryBytes(): void
```





#### resetNanoCpus() <a id="cdktf-provider-docker-servicetaskspecresourceslimitsoutputreference-resetnanocpus"></a>



```ts
resetNanoCpus(): void
```







## class ServiceTaskSpecResourcesOutputReference  <a id="cdktf-provider-docker-servicetaskspecresourcesoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecResourcesOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**limits** | <code>[ServiceTaskSpecResourcesLimitsOutputReference](#cdktf-provider-docker-servicetaskspecresourceslimitsoutputreference)</code> | <span></span>
**reservation** | <code>[ServiceTaskSpecResourcesReservationOutputReference](#cdktf-provider-docker-servicetaskspecresourcesreservationoutputreference)</code> | <span></span>
**internalValue**? | <code>[ServiceTaskSpecResources](#cdktf-provider-docker-servicetaskspecresources)</code> | __*Optional*__
**limitsInput**? | <code>[ServiceTaskSpecResourcesLimits](#cdktf-provider-docker-servicetaskspecresourceslimits)</code> | __*Optional*__
**reservationInput**? | <code>[ServiceTaskSpecResourcesReservation](#cdktf-provider-docker-servicetaskspecresourcesreservation)</code> | __*Optional*__

### Methods


#### putLimits(value) <a id="cdktf-provider-docker-servicetaskspecresourcesoutputreference-putlimits"></a>



```ts
putLimits(value: ServiceTaskSpecResourcesLimits): void
```

* **value** (<code>[ServiceTaskSpecResourcesLimits](#cdktf-provider-docker-servicetaskspecresourceslimits)</code>)  *No description*
  * **memoryBytes** (<code>number</code>)  The amounf of memory in bytes the container allocates. __*Optional*__
  * **nanoCpus** (<code>number</code>)  CPU shares in units of `1/1e9` (or `10^-9`) of the CPU. Should be at least `1000000`. __*Optional*__




#### putReservation(value) <a id="cdktf-provider-docker-servicetaskspecresourcesoutputreference-putreservation"></a>



```ts
putReservation(value: ServiceTaskSpecResourcesReservation): void
```

* **value** (<code>[ServiceTaskSpecResourcesReservation](#cdktf-provider-docker-servicetaskspecresourcesreservation)</code>)  *No description*
  * **genericResources** (<code>[ServiceTaskSpecResourcesReservationGenericResources](#cdktf-provider-docker-servicetaskspecresourcesreservationgenericresources)</code>)  generic_resources block. __*Optional*__
  * **memoryBytes** (<code>number</code>)  The amounf of memory in bytes the container allocates. __*Optional*__
  * **nanoCpus** (<code>number</code>)  CPU shares in units of 1/1e9 (or 10^-9) of the CPU. Should be at least `1000000`. __*Optional*__




#### resetLimits() <a id="cdktf-provider-docker-servicetaskspecresourcesoutputreference-resetlimits"></a>



```ts
resetLimits(): void
```





#### resetReservation() <a id="cdktf-provider-docker-servicetaskspecresourcesoutputreference-resetreservation"></a>



```ts
resetReservation(): void
```







## class ServiceTaskSpecResourcesReservationGenericResourcesOutputReference  <a id="cdktf-provider-docker-servicetaskspecresourcesreservationgenericresourcesoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecResourcesReservationGenericResourcesOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**discreteResourcesSpec** | <code>Array<string></code> | <span></span>
**namedResourcesSpec** | <code>Array<string></code> | <span></span>
**discreteResourcesSpecInput**? | <code>Array<string></code> | __*Optional*__
**internalValue**? | <code>[ServiceTaskSpecResourcesReservationGenericResources](#cdktf-provider-docker-servicetaskspecresourcesreservationgenericresources)</code> | __*Optional*__
**namedResourcesSpecInput**? | <code>Array<string></code> | __*Optional*__

### Methods


#### resetDiscreteResourcesSpec() <a id="cdktf-provider-docker-servicetaskspecresourcesreservationgenericresourcesoutputreference-resetdiscreteresourcesspec"></a>



```ts
resetDiscreteResourcesSpec(): void
```





#### resetNamedResourcesSpec() <a id="cdktf-provider-docker-servicetaskspecresourcesreservationgenericresourcesoutputreference-resetnamedresourcesspec"></a>



```ts
resetNamedResourcesSpec(): void
```







## class ServiceTaskSpecResourcesReservationOutputReference  <a id="cdktf-provider-docker-servicetaskspecresourcesreservationoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecResourcesReservationOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**genericResources** | <code>[ServiceTaskSpecResourcesReservationGenericResourcesOutputReference](#cdktf-provider-docker-servicetaskspecresourcesreservationgenericresourcesoutputreference)</code> | <span></span>
**memoryBytes** | <code>number</code> | <span></span>
**nanoCpus** | <code>number</code> | <span></span>
**genericResourcesInput**? | <code>[ServiceTaskSpecResourcesReservationGenericResources](#cdktf-provider-docker-servicetaskspecresourcesreservationgenericresources)</code> | __*Optional*__
**internalValue**? | <code>[ServiceTaskSpecResourcesReservation](#cdktf-provider-docker-servicetaskspecresourcesreservation)</code> | __*Optional*__
**memoryBytesInput**? | <code>number</code> | __*Optional*__
**nanoCpusInput**? | <code>number</code> | __*Optional*__

### Methods


#### putGenericResources(value) <a id="cdktf-provider-docker-servicetaskspecresourcesreservationoutputreference-putgenericresources"></a>



```ts
putGenericResources(value: ServiceTaskSpecResourcesReservationGenericResources): void
```

* **value** (<code>[ServiceTaskSpecResourcesReservationGenericResources](#cdktf-provider-docker-servicetaskspecresourcesreservationgenericresources)</code>)  *No description*
  * **discreteResourcesSpec** (<code>Array<string></code>)  The Integer resources. __*Optional*__
  * **namedResourcesSpec** (<code>Array<string></code>)  The String resources. __*Optional*__




#### resetGenericResources() <a id="cdktf-provider-docker-servicetaskspecresourcesreservationoutputreference-resetgenericresources"></a>



```ts
resetGenericResources(): void
```





#### resetMemoryBytes() <a id="cdktf-provider-docker-servicetaskspecresourcesreservationoutputreference-resetmemorybytes"></a>



```ts
resetMemoryBytes(): void
```





#### resetNanoCpus() <a id="cdktf-provider-docker-servicetaskspecresourcesreservationoutputreference-resetnanocpus"></a>



```ts
resetNanoCpus(): void
```







## class ServiceTaskSpecRestartPolicyOutputReference  <a id="cdktf-provider-docker-servicetaskspecrestartpolicyoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceTaskSpecRestartPolicyOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**condition** | <code>string</code> | <span></span>
**delay** | <code>string</code> | <span></span>
**maxAttempts** | <code>number</code> | <span></span>
**window** | <code>string</code> | <span></span>
**conditionInput**? | <code>string</code> | __*Optional*__
**delayInput**? | <code>string</code> | __*Optional*__
**internalValue**? | <code>[ServiceTaskSpecRestartPolicy](#cdktf-provider-docker-servicetaskspecrestartpolicy)</code> | __*Optional*__
**maxAttemptsInput**? | <code>number</code> | __*Optional*__
**windowInput**? | <code>string</code> | __*Optional*__

### Methods


#### resetCondition() <a id="cdktf-provider-docker-servicetaskspecrestartpolicyoutputreference-resetcondition"></a>



```ts
resetCondition(): void
```





#### resetDelay() <a id="cdktf-provider-docker-servicetaskspecrestartpolicyoutputreference-resetdelay"></a>



```ts
resetDelay(): void
```





#### resetMaxAttempts() <a id="cdktf-provider-docker-servicetaskspecrestartpolicyoutputreference-resetmaxattempts"></a>



```ts
resetMaxAttempts(): void
```





#### resetWindow() <a id="cdktf-provider-docker-servicetaskspecrestartpolicyoutputreference-resetwindow"></a>



```ts
resetWindow(): void
```







## class ServiceUpdateConfigOutputReference  <a id="cdktf-provider-docker-serviceupdateconfigoutputreference"></a>



__Implements__: [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [ComplexObject](#cdktf-complexobject)

### Initializer




```ts
new ServiceUpdateConfigOutputReference(terraformResource: IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean)
```

* **terraformResource** (<code>[IInterpolatingParent](#cdktf-iinterpolatingparent)</code>)  The parent resource.
* **terraformAttribute** (<code>string</code>)  The attribute on the parent resource this class is referencing.
* **isSingleItem** (<code>boolean</code>)  True if this is a block, false if it's a list.



### Properties


Name | Type | Description 
-----|------|-------------
**delay** | <code>string</code> | <span></span>
**failureAction** | <code>string</code> | <span></span>
**maxFailureRatio** | <code>string</code> | <span></span>
**monitor** | <code>string</code> | <span></span>
**order** | <code>string</code> | <span></span>
**parallelism** | <code>number</code> | <span></span>
**delayInput**? | <code>string</code> | __*Optional*__
**failureActionInput**? | <code>string</code> | __*Optional*__
**internalValue**? | <code>[ServiceUpdateConfig](#cdktf-provider-docker-serviceupdateconfig)</code> | __*Optional*__
**maxFailureRatioInput**? | <code>string</code> | __*Optional*__
**monitorInput**? | <code>string</code> | __*Optional*__
**orderInput**? | <code>string</code> | __*Optional*__
**parallelismInput**? | <code>number</code> | __*Optional*__

### Methods


#### resetDelay() <a id="cdktf-provider-docker-serviceupdateconfigoutputreference-resetdelay"></a>



```ts
resetDelay(): void
```





#### resetFailureAction() <a id="cdktf-provider-docker-serviceupdateconfigoutputreference-resetfailureaction"></a>



```ts
resetFailureAction(): void
```





#### resetMaxFailureRatio() <a id="cdktf-provider-docker-serviceupdateconfigoutputreference-resetmaxfailureratio"></a>



```ts
resetMaxFailureRatio(): void
```





#### resetMonitor() <a id="cdktf-provider-docker-serviceupdateconfigoutputreference-resetmonitor"></a>



```ts
resetMonitor(): void
```





#### resetOrder() <a id="cdktf-provider-docker-serviceupdateconfigoutputreference-resetorder"></a>



```ts
resetOrder(): void
```





#### resetParallelism() <a id="cdktf-provider-docker-serviceupdateconfigoutputreference-resetparallelism"></a>



```ts
resetParallelism(): void
```







## class Volume  <a id="cdktf-provider-docker-volume"></a>

Represents a {@link https://www.terraform.io/docs/providers/docker/r/volume docker_volume}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable), [ITerraformAddressable](#cdktf-iterraformaddressable), [IInterpolatingParent](#cdktf-iinterpolatingparent)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/docker/r/volume docker_volume} Resource.

```ts
new Volume(scope: Construct, id: string, config?: VolumeConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[VolumeConfig](#cdktf-provider-docker-volumeconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **driver** (<code>string</code>)  Driver type for the volume. Defaults to `local`. __*Optional*__
  * **driverOpts** (<code>Map<string, string></code>)  Options specific to the driver. __*Optional*__
  * **labels** (<code>[IResolvable](#cdktf-iresolvable) &#124; Array<[VolumeLabels](#cdktf-provider-docker-volumelabels)></code>)  labels block. __*Optional*__
  * **name** (<code>string</code>)  The name of the Docker volume (will be generated if not provided). __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**driver** | <code>string</code> | <span></span>
**driverOpts** | <code>Map<string, string></code> | <span></span>
**id** | <code>string</code> | <span></span>
**labels** | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[VolumeLabels](#cdktf-provider-docker-volumelabels)></code> | <span></span>
**mountpoint** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**driverInput**? | <code>string</code> | __*Optional*__
**driverOptsInput**? | <code>Map<string, string></code> | __*Optional*__
**labelsInput**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[VolumeLabels](#cdktf-provider-docker-volumelabels)></code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetDriver() <a id="cdktf-provider-docker-volume-resetdriver"></a>



```ts
resetDriver(): void
```





#### resetDriverOpts() <a id="cdktf-provider-docker-volume-resetdriveropts"></a>



```ts
resetDriverOpts(): void
```





#### resetLabels() <a id="cdktf-provider-docker-volume-resetlabels"></a>



```ts
resetLabels(): void
```





#### resetName() <a id="cdktf-provider-docker-volume-resetname"></a>



```ts
resetName(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-docker-volume-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## struct ConfigConfig  <a id="cdktf-provider-docker-configconfig"></a>






Name | Type | Description 
-----|------|-------------
**data** | <code>string</code> | Base64-url-safe-encoded config data.
**name** | <code>string</code> | User-defined name of the config.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct ContainerCapabilities  <a id="cdktf-provider-docker-containercapabilities"></a>






Name | Type | Description 
-----|------|-------------
**add**? | <code>Array<string></code> | List of linux capabilities to add.<br/>__*Optional*__
**drop**? | <code>Array<string></code> | List of linux capabilities to drop.<br/>__*Optional*__



## struct ContainerConfig  <a id="cdktf-provider-docker-containerconfig"></a>






Name | Type | Description 
-----|------|-------------
**image** | <code>string</code> | The ID of the image to back this container.
**name** | <code>string</code> | The name of the container.
**attach**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true` attach to the container after its creation and waits the end of its execution. Defaults to `false`.<br/>__*Optional*__
**capabilities**? | <code>[ContainerCapabilities](#cdktf-provider-docker-containercapabilities)</code> | capabilities block.<br/>__*Optional*__
**command**? | <code>Array<string></code> | The command to use to start the container.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**cpuSet**? | <code>string</code> | A comma-separated list or hyphen-separated range of CPUs a container can use, e.g. `0-1`.<br/>__*Optional*__
**cpuShares**? | <code>number</code> | CPU shares (relative weight) for the container.<br/>__*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**destroyGraceSeconds**? | <code>number</code> | If defined will attempt to stop the container before destroying.<br/>__*Optional*__
**devices**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerDevices](#cdktf-provider-docker-containerdevices)></code> | devices block.<br/>__*Optional*__
**dns**? | <code>Array<string></code> | DNS servers to use.<br/>__*Optional*__
**dnsOpts**? | <code>Array<string></code> | DNS options used by the DNS provider(s), see `resolv.conf` documentation for valid list of options.<br/>__*Optional*__
**dnsSearch**? | <code>Array<string></code> | DNS search domains that are used when bare unqualified hostnames are used inside of the container.<br/>__*Optional*__
**domainname**? | <code>string</code> | Domain name of the container.<br/>__*Optional*__
**entrypoint**? | <code>Array<string></code> | The command to use as the Entrypoint for the container.<br/>__*Optional*__
**env**? | <code>Array<string></code> | Environment variables to set in the form of `KEY=VALUE`, e.g. `DEBUG=0`.<br/>__*Optional*__
**groupAdd**? | <code>Array<string></code> | Additional groups for the container user.<br/>__*Optional*__
**healthcheck**? | <code>[ContainerHealthcheck](#cdktf-provider-docker-containerhealthcheck)</code> | healthcheck block.<br/>__*Optional*__
**host**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerHost](#cdktf-provider-docker-containerhost)></code> | host block.<br/>__*Optional*__
**hostname**? | <code>string</code> | Hostname of the container.<br/>__*Optional*__
**init**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Configured whether an init process should be injected for this container.<br/>__*Optional*__
**ipcMode**? | <code>string</code> | IPC sharing mode for the container. Possible values are: `none`, `private`, `shareable`, `container:<name|id>` or `host`.<br/>__*Optional*__
**labels**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerLabels](#cdktf-provider-docker-containerlabels)></code> | labels block.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**links**? | <code>Array<string></code> | Set of links for link based connectivity between containers that are running on the same host.<br/>__*Optional*__
**logDriver**? | <code>string</code> | The logging driver to use for the container.<br/>__*Optional*__
**logOpts**? | <code>Map<string, string></code> | Key/value pairs to use as options for the logging driver.<br/>__*Optional*__
**logs**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Save the container logs (`attach` must be enabled). Defaults to `false`.<br/>__*Optional*__
**maxRetryCount**? | <code>number</code> | The maximum amount of times to an attempt a restart when `restart` is set to 'on-failure'.<br/>__*Optional*__
**memory**? | <code>number</code> | The memory limit for the container in MBs.<br/>__*Optional*__
**memorySwap**? | <code>number</code> | The total memory limit (memory + swap) for the container in MBs.<br/>__*Optional*__
**mounts**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerMounts](#cdktf-provider-docker-containermounts)></code> | mounts block.<br/>__*Optional*__
**mustRun**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, then the Docker container will be kept running.<br/>__*Optional*__
**networkAlias**? | <code>Array<string></code> | Set an alias for the container in all specified networks.<br/>__*Optional*__
**networkMode**? | <code>string</code> | Network mode of the container.<br/>__*Optional*__
**networks**? | <code>Array<string></code> | ID of the networks in which the container is.<br/>__*Optional*__
**networksAdvanced**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerNetworksAdvanced](#cdktf-provider-docker-containernetworksadvanced)></code> | networks_advanced block.<br/>__*Optional*__
**pidMode**? | <code>string</code> | he PID (Process) Namespace mode for the container. Either `container:<name|id>` or `host`.<br/>__*Optional*__
**ports**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerPorts](#cdktf-provider-docker-containerports)></code> | ports block.<br/>__*Optional*__
**privileged**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, the container runs in privileged mode.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**publishAllPorts**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Publish all ports of the container.<br/>__*Optional*__
**readOnly**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, the container will be started as readonly. Defaults to `false`.<br/>__*Optional*__
**removeVolumes**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, it will remove anonymous volumes associated with the container. Defaults to `true`.<br/>__*Optional*__
**restart**? | <code>string</code> | The restart policy for the container. Must be one of 'no', 'on-failure', 'always', 'unless-stopped'. Defaults to `no`.<br/>__*Optional*__
**rm**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, then the container will be automatically removed when it exits. Defaults to `false`.<br/>__*Optional*__
**securityOpts**? | <code>Array<string></code> | List of string values to customize labels for MLS systems, such as SELinux. See https://docs.docker.com/engine/reference/run/#security-configuration.<br/>__*Optional*__
**shmSize**? | <code>number</code> | Size of `/dev/shm` in MBs.<br/>__*Optional*__
**start**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, then the Docker container will be started after creation.<br/>__*Optional*__
**stdinOpen**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, keep STDIN open even if not attached (`docker run -i`). Defaults to `false`.<br/>__*Optional*__
**storageOpts**? | <code>Map<string, string></code> | Key/value pairs for the storage driver options, e.g. `size`: `120G`.<br/>__*Optional*__
**sysctls**? | <code>Map<string, string></code> | A map of kernel parameters (sysctls) to set in the container.<br/>__*Optional*__
**tmpfs**? | <code>Map<string, string></code> | A map of container directories which should be replaced by `tmpfs mounts`, and their corresponding mount options.<br/>__*Optional*__
**tty**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, allocate a pseudo-tty (`docker run -t`). Defaults to `false`.<br/>__*Optional*__
**ulimit**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerUlimit](#cdktf-provider-docker-containerulimit)></code> | ulimit block.<br/>__*Optional*__
**upload**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerUpload](#cdktf-provider-docker-containerupload)></code> | upload block.<br/>__*Optional*__
**user**? | <code>string</code> | User used for run the first process.<br/>__*Optional*__
**usernsMode**? | <code>string</code> | Sets the usernamespace mode for the container when usernamespace remapping option is enabled.<br/>__*Optional*__
**volumes**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerVolumes](#cdktf-provider-docker-containervolumes)></code> | volumes block.<br/>__*Optional*__
**workingDir**? | <code>string</code> | The working directory for commands to run in.<br/>__*Optional*__



## struct ContainerDevices  <a id="cdktf-provider-docker-containerdevices"></a>






Name | Type | Description 
-----|------|-------------
**hostPath** | <code>string</code> | The path on the host where the device is located.
**containerPath**? | <code>string</code> | The path in the container where the device will be bound.<br/>__*Optional*__
**permissions**? | <code>string</code> | The cgroup permissions given to the container to access the device. Defaults to `rwm`.<br/>__*Optional*__



## struct ContainerHealthcheck  <a id="cdktf-provider-docker-containerhealthcheck"></a>






Name | Type | Description 
-----|------|-------------
**test** | <code>Array<string></code> | Command to run to check health.
**interval**? | <code>string</code> | Time between running the check (ms|s|m|h). Defaults to `0s`.<br/>__*Optional*__
**retries**? | <code>number</code> | Consecutive failures needed to report unhealthy. Defaults to `0`.<br/>__*Optional*__
**startPeriod**? | <code>string</code> | Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`.<br/>__*Optional*__
**timeout**? | <code>string</code> | Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`.<br/>__*Optional*__



## struct ContainerHost  <a id="cdktf-provider-docker-containerhost"></a>






Name | Type | Description 
-----|------|-------------
**host** | <code>string</code> | Hostname to add.
**ip** | <code>string</code> | IP address this hostname should resolve to.



## struct ContainerLabels  <a id="cdktf-provider-docker-containerlabels"></a>






Name | Type | Description 
-----|------|-------------
**label** | <code>string</code> | Name of the label.
**value** | <code>string</code> | Value of the label.



## struct ContainerMounts  <a id="cdktf-provider-docker-containermounts"></a>






Name | Type | Description 
-----|------|-------------
**target** | <code>string</code> | Container path.
**type** | <code>string</code> | The mount type.
**bindOptions**? | <code>[ContainerMountsBindOptions](#cdktf-provider-docker-containermountsbindoptions)</code> | bind_options block.<br/>__*Optional*__
**readOnly**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Whether the mount should be read-only.<br/>__*Optional*__
**source**? | <code>string</code> | Mount source (e.g. a volume name, a host path).<br/>__*Optional*__
**tmpfsOptions**? | <code>[ContainerMountsTmpfsOptions](#cdktf-provider-docker-containermountstmpfsoptions)</code> | tmpfs_options block.<br/>__*Optional*__
**volumeOptions**? | <code>[ContainerMountsVolumeOptions](#cdktf-provider-docker-containermountsvolumeoptions)</code> | volume_options block.<br/>__*Optional*__



## struct ContainerMountsBindOptions  <a id="cdktf-provider-docker-containermountsbindoptions"></a>






Name | Type | Description 
-----|------|-------------
**propagation**? | <code>string</code> | A propagation mode with the value.<br/>__*Optional*__



## struct ContainerMountsTmpfsOptions  <a id="cdktf-provider-docker-containermountstmpfsoptions"></a>






Name | Type | Description 
-----|------|-------------
**mode**? | <code>number</code> | The permission mode for the tmpfs mount in an integer.<br/>__*Optional*__
**sizeBytes**? | <code>number</code> | The size for the tmpfs mount in bytes.<br/>__*Optional*__



## struct ContainerMountsVolumeOptions  <a id="cdktf-provider-docker-containermountsvolumeoptions"></a>






Name | Type | Description 
-----|------|-------------
**driverName**? | <code>string</code> | Name of the driver to use to create the volume.<br/>__*Optional*__
**driverOptions**? | <code>Map<string, string></code> | key/value map of driver specific options.<br/>__*Optional*__
**labels**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ContainerMountsVolumeOptionsLabels](#cdktf-provider-docker-containermountsvolumeoptionslabels)></code> | labels block.<br/>__*Optional*__
**noCopy**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Populate volume with data from the target.<br/>__*Optional*__



## struct ContainerMountsVolumeOptionsLabels  <a id="cdktf-provider-docker-containermountsvolumeoptionslabels"></a>






Name | Type | Description 
-----|------|-------------
**label** | <code>string</code> | Name of the label.
**value** | <code>string</code> | Value of the label.



## struct ContainerNetworksAdvanced  <a id="cdktf-provider-docker-containernetworksadvanced"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | The name of the network.
**aliases**? | <code>Array<string></code> | The network aliases of the container in the specific network.<br/>__*Optional*__
**ipv4Address**? | <code>string</code> | The IPV4 address of the container in the specific network.<br/>__*Optional*__
**ipv6Address**? | <code>string</code> | The IPV6 address of the container in the specific network.<br/>__*Optional*__



## struct ContainerPorts  <a id="cdktf-provider-docker-containerports"></a>






Name | Type | Description 
-----|------|-------------
**internal** | <code>number</code> | Port within the container.
**external**? | <code>number</code> | Port exposed out of the container. If not given a free random port `>= 32768` will be used.<br/>__*Optional*__
**ip**? | <code>string</code> | IP address/mask that can access this port. Defaults to `0.0.0.0`.<br/>__*Optional*__
**protocol**? | <code>string</code> | Protocol that can be used over this port. Defaults to `tcp`.<br/>__*Optional*__



## struct ContainerUlimit  <a id="cdktf-provider-docker-containerulimit"></a>






Name | Type | Description 
-----|------|-------------
**hard** | <code>number</code> | The hard limit.
**name** | <code>string</code> | The name of the ulimit.
**soft** | <code>number</code> | The soft limit.



## struct ContainerUpload  <a id="cdktf-provider-docker-containerupload"></a>






Name | Type | Description 
-----|------|-------------
**file** | <code>string</code> | Path to the file in the container where is upload goes to.
**content**? | <code>string</code> | Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.<br/>__*Optional*__
**contentBase64**? | <code>string</code> | Base64-encoded data that will be decoded and uploaded as raw bytes for the object content.<br/>__*Optional*__
**executable**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, the file will be uploaded with user executable permission. Defaults to `false`.<br/>__*Optional*__
**source**? | <code>string</code> | A filename that references a file which will be uploaded as the object content.<br/>__*Optional*__
**sourceHash**? | <code>string</code> | If using `source`, this will force an update if the file content has updated but the filename has not.<br/>__*Optional*__



## struct ContainerVolumes  <a id="cdktf-provider-docker-containervolumes"></a>






Name | Type | Description 
-----|------|-------------
**containerPath**? | <code>string</code> | The path in the container where the volume will be mounted.<br/>__*Optional*__
**fromContainer**? | <code>string</code> | The container where the volume is coming from.<br/>__*Optional*__
**hostPath**? | <code>string</code> | The path on the host where the volume is coming from.<br/>__*Optional*__
**readOnly**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, this volume will be readonly. Defaults to `false`.<br/>__*Optional*__
**volumeName**? | <code>string</code> | The name of the docker volume which should be mounted.<br/>__*Optional*__



## struct DataDockerImageConfig  <a id="cdktf-provider-docker-datadockerimageconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | The name of the Docker image, including any tags or SHA256 repo digests.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataDockerNetworkConfig  <a id="cdktf-provider-docker-datadockernetworkconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | The name of the Docker network.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataDockerPluginConfig  <a id="cdktf-provider-docker-datadockerpluginconfig"></a>






Name | Type | Description 
-----|------|-------------
**alias**? | <code>string</code> | The alias of the Docker plugin. If the tag is omitted, `:latest` is complemented to the attribute value.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**id**? | <code>string</code> | The ID of the plugin, which has precedence over the `alias` of both are given.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataDockerRegistryImageConfig  <a id="cdktf-provider-docker-datadockerregistryimageconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | The name of the Docker image, including any tags. e.g. `alpine:latest`.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**insecureSkipVerify**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DockerProviderConfig  <a id="cdktf-provider-docker-dockerproviderconfig"></a>






Name | Type | Description 
-----|------|-------------
**alias**? | <code>string</code> | Alias name.<br/>__*Optional*__
**caMaterial**? | <code>string</code> | PEM-encoded content of Docker host CA certificate.<br/>__*Optional*__
**certMaterial**? | <code>string</code> | PEM-encoded content of Docker client certificate.<br/>__*Optional*__
**certPath**? | <code>string</code> | Path to directory with Docker TLS config.<br/>__*Optional*__
**host**? | <code>string</code> | The Docker daemon address.<br/>__*Optional*__
**keyMaterial**? | <code>string</code> | PEM-encoded content of Docker client private key.<br/>__*Optional*__
**registryAuth**? | <code>[DockerProviderRegistryAuth](#cdktf-provider-docker-dockerproviderregistryauth)</code> | registry_auth block.<br/>__*Optional*__
**sshOpts**? | <code>Array<string></code> | Additional SSH option flags to be appended when using `ssh://` protocol.<br/>__*Optional*__



## struct DockerProviderRegistryAuth  <a id="cdktf-provider-docker-dockerproviderregistryauth"></a>






Name | Type | Description 
-----|------|-------------
**address** | <code>string</code> | Address of the registry.
**configFile**? | <code>string</code> | Path to docker json file for registry auth.<br/>__*Optional*__
**configFileContent**? | <code>string</code> | Plain content of the docker json file for registry auth.<br/>__*Optional*__
**password**? | <code>string</code> | Password for the registry.<br/>__*Optional*__
**username**? | <code>string</code> | Username for the registry.<br/>__*Optional*__



## struct ImageBuild  <a id="cdktf-provider-docker-imagebuild"></a>






Name | Type | Description 
-----|------|-------------
**path** | <code>string</code> | Context path.
**buildArg**? | <code>Map<string, string></code> | Set build-time variables.<br/>__*Optional*__
**dockerfile**? | <code>string</code> | Name of the Dockerfile. Defaults to `Dockerfile`.<br/>__*Optional*__
**forceRemove**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Always remove intermediate containers.<br/>__*Optional*__
**label**? | <code>Map<string, string></code> | Set metadata for an image.<br/>__*Optional*__
**noCache**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Do not use cache when building the image.<br/>__*Optional*__
**remove**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Remove intermediate containers after a successful build. Defaults to  `true`.<br/>__*Optional*__
**tag**? | <code>Array<string></code> | Name and optionally a tag in the 'name:tag' format.<br/>__*Optional*__
**target**? | <code>string</code> | Set the target build stage to build.<br/>__*Optional*__



## struct ImageConfig  <a id="cdktf-provider-docker-imageconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | The name of the Docker image, including any tags or SHA256 repo digests.
**buildAttribute**? | <code>[ImageBuild](#cdktf-provider-docker-imagebuild)</code> | build block.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**forceRemove**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If true, then the image is removed forcibly when the resource is destroyed.<br/>__*Optional*__
**keepLocally**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If true, then the Docker image won't be deleted on destroy operation.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**pullTrigger**? | <code>string</code> | A value which cause an image pull when changed.<br/>__*Optional*__
**pullTriggers**? | <code>Array<string></code> | List of values which cause an image pull when changed.<br/>__*Optional*__



## struct NetworkConfig  <a id="cdktf-provider-docker-networkconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | The name of the Docker network.
**attachable**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Enable manual container attachment to the network.<br/>__*Optional*__
**checkDuplicate**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Requests daemon to check for networks with same name.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**driver**? | <code>string</code> | The driver of the Docker network. Possible values are `bridge`, `host`, `overlay`, `macvlan`. See [network docs](https://docs.docker.com/network/#network-drivers) for more details.<br/>__*Optional*__
**ingress**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Create swarm routing-mesh network. Defaults to `false`.<br/>__*Optional*__
**internal**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Whether the network is internal.<br/>__*Optional*__
**ipamConfig**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[NetworkIpamConfig](#cdktf-provider-docker-networkipamconfig)></code> | ipam_config block.<br/>__*Optional*__
**ipamDriver**? | <code>string</code> | Driver used by the custom IP scheme of the network. Defaults to `default`.<br/>__*Optional*__
**ipv6**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Enable IPv6 networking. Defaults to `false`.<br/>__*Optional*__
**labels**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[NetworkLabels](#cdktf-provider-docker-networklabels)></code> | labels block.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**options**? | <code>Map<string, string></code> | Only available with bridge networks. See [bridge options docs](https://docs.docker.com/engine/reference/commandline/network_create/#bridge-driver-options) for more details.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct NetworkIpamConfig  <a id="cdktf-provider-docker-networkipamconfig"></a>






Name | Type | Description 
-----|------|-------------
**auxAddress**? | <code>Map<string, string></code> | Auxiliary IPv4 or IPv6 addresses used by Network driver.<br/>__*Optional*__
**gateway**? | <code>string</code> | The IP address of the gateway.<br/>__*Optional*__
**ipRange**? | <code>string</code> | The ip range in CIDR form.<br/>__*Optional*__
**subnet**? | <code>string</code> | The subnet in CIDR form.<br/>__*Optional*__



## struct NetworkLabels  <a id="cdktf-provider-docker-networklabels"></a>






Name | Type | Description 
-----|------|-------------
**label** | <code>string</code> | Name of the label.
**value** | <code>string</code> | Value of the label.



## struct PluginConfig  <a id="cdktf-provider-docker-pluginconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | Docker Plugin name.
**alias**? | <code>string</code> | Docker Plugin alias.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**enableTimeout**? | <code>number</code> | HTTP client timeout to enable the plugin.<br/>__*Optional*__
**enabled**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true` the plugin is enabled. Defaults to `true`.<br/>__*Optional*__
**env**? | <code>Array<string></code> | The environment variables in the form of `KEY=VALUE`, e.g. `DEBUG=0`.<br/>__*Optional*__
**forceDestroy**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If true, then the plugin is destroyed forcibly.<br/>__*Optional*__
**forceDisable**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If true, then the plugin is disabled forcibly.<br/>__*Optional*__
**grantAllPermissions**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If true, grant all permissions necessary to run the plugin.<br/>__*Optional*__
**grantPermissions**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[PluginGrantPermissions](#cdktf-provider-docker-plugingrantpermissions)></code> | grant_permissions block.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct PluginGrantPermissions  <a id="cdktf-provider-docker-plugingrantpermissions"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | The name of the permission.
**value** | <code>Array<string></code> | The value of the permission.



## struct RegistryImageBuild  <a id="cdktf-provider-docker-registryimagebuild"></a>






Name | Type | Description 
-----|------|-------------
**context** | <code>string</code> | The absolute path to the context folder. You can use the helper function '${path.cwd}/context-dir'.
**authConfig**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[RegistryImageBuildAuthConfig](#cdktf-provider-docker-registryimagebuildauthconfig)></code> | auth_config block.<br/>__*Optional*__
**buildArgs**? | <code>Map<string, string></code> | Pairs for build-time variables in the form TODO.<br/>__*Optional*__
**buildId**? | <code>string</code> | BuildID is an optional identifier that can be passed together with the build request.<br/>__*Optional*__
**cacheFrom**? | <code>Array<string></code> | Images to consider as cache sources.<br/>__*Optional*__
**cgroupParent**? | <code>string</code> | Optional parent cgroup for the container.<br/>__*Optional*__
**cpuPeriod**? | <code>number</code> | The length of a CPU period in microseconds.<br/>__*Optional*__
**cpuQuota**? | <code>number</code> | Microseconds of CPU time that the container can get in a CPU period.<br/>__*Optional*__
**cpuSetCpus**? | <code>string</code> | CPUs in which to allow execution (e.g., `0-3`, `0`, `1`).<br/>__*Optional*__
**cpuSetMems**? | <code>string</code> | MEMs in which to allow execution (`0-3`, `0`, `1`).<br/>__*Optional*__
**cpuShares**? | <code>number</code> | CPU shares (relative weight).<br/>__*Optional*__
**dockerfile**? | <code>string</code> | Dockerfile file. Defaults to `Dockerfile`.<br/>__*Optional*__
**extraHosts**? | <code>Array<string></code> | A list of hostnames/IP mappings to add to the container’s /etc/hosts file. Specified in the form ["hostname:IP"].<br/>__*Optional*__
**forceRemove**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Always remove intermediate containers.<br/>__*Optional*__
**isolation**? | <code>string</code> | Isolation represents the isolation technology of a container. The supported values are.<br/>__*Optional*__
**labels**? | <code>Map<string, string></code> | User-defined key/value metadata.<br/>__*Optional*__
**memory**? | <code>number</code> | Set memory limit for build.<br/>__*Optional*__
**memorySwap**? | <code>number</code> | Total memory (memory + swap), -1 to enable unlimited swap.<br/>__*Optional*__
**networkMode**? | <code>string</code> | Set the networking mode for the RUN instructions during build.<br/>__*Optional*__
**noCache**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Do not use the cache when building the image.<br/>__*Optional*__
**platform**? | <code>string</code> | Set platform if server is multi-platform capable.<br/>__*Optional*__
**pullParent**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Attempt to pull the image even if an older image exists locally.<br/>__*Optional*__
**remoteContext**? | <code>string</code> | A Git repository URI or HTTP/HTTPS context URI.<br/>__*Optional*__
**remove**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Remove intermediate containers after a successful build (default behavior).<br/>__*Optional*__
**securityOpt**? | <code>Array<string></code> | The security options.<br/>__*Optional*__
**sessionId**? | <code>string</code> | Set an ID for the build session.<br/>__*Optional*__
**shmSize**? | <code>number</code> | Size of /dev/shm in bytes. The size must be greater than 0.<br/>__*Optional*__
**squash**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If true the new layers are squashed into a new image with a single new layer.<br/>__*Optional*__
**suppressOutput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Suppress the build output and print image ID on success.<br/>__*Optional*__
**target**? | <code>string</code> | Set the target build stage to build.<br/>__*Optional*__
**ulimit**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[RegistryImageBuildUlimit](#cdktf-provider-docker-registryimagebuildulimit)></code> | ulimit block.<br/>__*Optional*__
**version**? | <code>string</code> | Version of the underlying builder to use.<br/>__*Optional*__



## struct RegistryImageBuildAuthConfig  <a id="cdktf-provider-docker-registryimagebuildauthconfig"></a>






Name | Type | Description 
-----|------|-------------
**hostName** | <code>string</code> | hostname of the registry.
**auth**? | <code>string</code> | the auth token.<br/>__*Optional*__
**email**? | <code>string</code> | the user emal.<br/>__*Optional*__
**identityToken**? | <code>string</code> | the identity token.<br/>__*Optional*__
**password**? | <code>string</code> | the registry password.<br/>__*Optional*__
**registryToken**? | <code>string</code> | the registry token.<br/>__*Optional*__
**serverAddress**? | <code>string</code> | the server address.<br/>__*Optional*__
**userName**? | <code>string</code> | the registry user name.<br/>__*Optional*__



## struct RegistryImageBuildUlimit  <a id="cdktf-provider-docker-registryimagebuildulimit"></a>






Name | Type | Description 
-----|------|-------------
**hard** | <code>number</code> | soft limit.
**name** | <code>string</code> | type of ulimit, e.g. `nofile`.
**soft** | <code>number</code> | hard limit.



## struct RegistryImageConfig  <a id="cdktf-provider-docker-registryimageconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | The name of the Docker image.
**buildAttribute**? | <code>[RegistryImageBuild](#cdktf-provider-docker-registryimagebuild)</code> | build block.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**insecureSkipVerify**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`.<br/>__*Optional*__
**keepRemotely**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | If true, then the Docker image won't be deleted on destroy operation.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct SecretConfig  <a id="cdktf-provider-docker-secretconfig"></a>






Name | Type | Description 
-----|------|-------------
**data** | <code>string</code> | Base64-url-safe-encoded secret data.
**name** | <code>string</code> | User-defined name of the secret.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**labels**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[SecretLabels](#cdktf-provider-docker-secretlabels)></code> | labels block.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct SecretLabels  <a id="cdktf-provider-docker-secretlabels"></a>






Name | Type | Description 
-----|------|-------------
**label** | <code>string</code> | Name of the label.
**value** | <code>string</code> | Value of the label.



## struct ServiceAuth  <a id="cdktf-provider-docker-serviceauth"></a>






Name | Type | Description 
-----|------|-------------
**serverAddress** | <code>string</code> | The address of the server for the authentication.
**password**? | <code>string</code> | The password.<br/>__*Optional*__
**username**? | <code>string</code> | The username.<br/>__*Optional*__



## struct ServiceConfig  <a id="cdktf-provider-docker-serviceconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | Name of the service.
**taskSpec** | <code>[ServiceTaskSpec](#cdktf-provider-docker-servicetaskspec)</code> | task_spec block.
**auth**? | <code>[ServiceAuth](#cdktf-provider-docker-serviceauth)</code> | auth block.<br/>__*Optional*__
**convergeConfig**? | <code>[ServiceConvergeConfig](#cdktf-provider-docker-serviceconvergeconfig)</code> | converge_config block.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**endpointSpec**? | <code>[ServiceEndpointSpec](#cdktf-provider-docker-serviceendpointspec)</code> | endpoint_spec block.<br/>__*Optional*__
**labels**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceLabels](#cdktf-provider-docker-servicelabels)></code> | labels block.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**mode**? | <code>[ServiceMode](#cdktf-provider-docker-servicemode)</code> | mode block.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**rollbackConfig**? | <code>[ServiceRollbackConfig](#cdktf-provider-docker-servicerollbackconfig)</code> | rollback_config block.<br/>__*Optional*__
**updateConfig**? | <code>[ServiceUpdateConfig](#cdktf-provider-docker-serviceupdateconfig)</code> | update_config block.<br/>__*Optional*__



## struct ServiceConvergeConfig  <a id="cdktf-provider-docker-serviceconvergeconfig"></a>






Name | Type | Description 
-----|------|-------------
**delay**? | <code>string</code> | The interval to check if the desired state is reached `(ms|s)`. Defaults to `7s`.<br/>__*Optional*__
**timeout**? | <code>string</code> | The timeout of the service to reach the desired state `(s|m)`. Defaults to `3m`.<br/>__*Optional*__



## struct ServiceEndpointSpec  <a id="cdktf-provider-docker-serviceendpointspec"></a>






Name | Type | Description 
-----|------|-------------
**mode**? | <code>string</code> | The mode of resolution to use for internal load balancing between tasks.<br/>__*Optional*__
**ports**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceEndpointSpecPorts](#cdktf-provider-docker-serviceendpointspecports)></code> | ports block.<br/>__*Optional*__



## struct ServiceEndpointSpecPorts  <a id="cdktf-provider-docker-serviceendpointspecports"></a>






Name | Type | Description 
-----|------|-------------
**targetPort** | <code>number</code> | The port inside the container.
**name**? | <code>string</code> | A random name for the port.<br/>__*Optional*__
**protocol**? | <code>string</code> | Rrepresents the protocol of a port: `tcp`, `udp` or `sctp`. Defaults to `tcp`.<br/>__*Optional*__
**publishMode**? | <code>string</code> | Represents the mode in which the port is to be published: 'ingress' or 'host'. Defaults to `ingress`.<br/>__*Optional*__
**publishedPort**? | <code>number</code> | The port on the swarm hosts.<br/>__*Optional*__



## struct ServiceLabels  <a id="cdktf-provider-docker-servicelabels"></a>






Name | Type | Description 
-----|------|-------------
**label** | <code>string</code> | Name of the label.
**value** | <code>string</code> | Value of the label.



## struct ServiceMode  <a id="cdktf-provider-docker-servicemode"></a>






Name | Type | Description 
-----|------|-------------
**global**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | The global service mode. Defaults to `false`.<br/>__*Optional*__
**replicated**? | <code>[ServiceModeReplicated](#cdktf-provider-docker-servicemodereplicated)</code> | replicated block.<br/>__*Optional*__



## struct ServiceModeReplicated  <a id="cdktf-provider-docker-servicemodereplicated"></a>






Name | Type | Description 
-----|------|-------------
**replicas**? | <code>number</code> | The amount of replicas of the service. Defaults to `1`.<br/>__*Optional*__



## struct ServiceRollbackConfig  <a id="cdktf-provider-docker-servicerollbackconfig"></a>






Name | Type | Description 
-----|------|-------------
**delay**? | <code>string</code> | Delay between task rollbacks (ns|us|ms|s|m|h). Defaults to `0s`.<br/>__*Optional*__
**failureAction**? | <code>string</code> | Action on rollback failure: pause | continue. Defaults to `pause`.<br/>__*Optional*__
**maxFailureRatio**? | <code>string</code> | Failure rate to tolerate during a rollback. Defaults to `0.0`.<br/>__*Optional*__
**monitor**? | <code>string</code> | Duration after each task rollback to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.<br/>__*Optional*__
**order**? | <code>string</code> | Rollback order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.<br/>__*Optional*__
**parallelism**? | <code>number</code> | Maximum number of tasks to be rollbacked in one iteration. Defaults to `1`.<br/>__*Optional*__



## struct ServiceTaskSpec  <a id="cdktf-provider-docker-servicetaskspec"></a>






Name | Type | Description 
-----|------|-------------
**containerSpec** | <code>[ServiceTaskSpecContainerSpec](#cdktf-provider-docker-servicetaskspeccontainerspec)</code> | container_spec block.
**forceUpdate**? | <code>number</code> | A counter that triggers an update even if no relevant parameters have been changed. See the [spec](https://github.com/docker/swarmkit/blob/master/api/specs.proto#L126).<br/>__*Optional*__
**logDriver**? | <code>[ServiceTaskSpecLogDriver](#cdktf-provider-docker-servicetaskspeclogdriver)</code> | log_driver block.<br/>__*Optional*__
**networks**? | <code>Array<string></code> | Ids of the networks in which the  container will be put in.<br/>__*Optional*__
**placement**? | <code>[ServiceTaskSpecPlacement](#cdktf-provider-docker-servicetaskspecplacement)</code> | placement block.<br/>__*Optional*__
**resources**? | <code>[ServiceTaskSpecResources](#cdktf-provider-docker-servicetaskspecresources)</code> | resources block.<br/>__*Optional*__
**restartPolicy**? | <code>[ServiceTaskSpecRestartPolicy](#cdktf-provider-docker-servicetaskspecrestartpolicy)</code> | restart_policy block.<br/>__*Optional*__
**runtime**? | <code>string</code> | Runtime is the type of runtime specified for the task executor. See the [types](https://github.com/moby/moby/blob/master/api/types/swarm/runtime.go).<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpec  <a id="cdktf-provider-docker-servicetaskspeccontainerspec"></a>






Name | Type | Description 
-----|------|-------------
**image** | <code>string</code> | The image name to use for the containers of the service, like `nginx:1.17.6`. Also use the data-source or resource of `docker_image` with the `repo_digest` or `docker_registry_image` with the `name` attribute for this, as shown in the examples.
**args**? | <code>Array<string></code> | Arguments to the command.<br/>__*Optional*__
**command**? | <code>Array<string></code> | The command/entrypoint to be run in the image.<br/>__*Optional*__
**configs**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecConfigs](#cdktf-provider-docker-servicetaskspeccontainerspecconfigs)></code> | configs block.<br/>__*Optional*__
**dir**? | <code>string</code> | The working directory for commands to run in.<br/>__*Optional*__
**dnsConfig**? | <code>[ServiceTaskSpecContainerSpecDnsConfig](#cdktf-provider-docker-servicetaskspeccontainerspecdnsconfig)</code> | dns_config block.<br/>__*Optional*__
**env**? | <code>Map<string, string></code> | A list of environment variables in the form VAR="value".<br/>__*Optional*__
**groups**? | <code>Array<string></code> | A list of additional groups that the container process will run as.<br/>__*Optional*__
**healthcheck**? | <code>[ServiceTaskSpecContainerSpecHealthcheck](#cdktf-provider-docker-servicetaskspeccontainerspechealthcheck)</code> | healthcheck block.<br/>__*Optional*__
**hostname**? | <code>string</code> | The hostname to use for the container, as a valid RFC 1123 hostname.<br/>__*Optional*__
**hosts**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecHosts](#cdktf-provider-docker-servicetaskspeccontainerspechosts)></code> | hosts block.<br/>__*Optional*__
**isolation**? | <code>string</code> | Isolation technology of the containers running the service. (Windows only). Defaults to `default`.<br/>__*Optional*__
**labels**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecLabels](#cdktf-provider-docker-servicetaskspeccontainerspeclabels)></code> | labels block.<br/>__*Optional*__
**mounts**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecMounts](#cdktf-provider-docker-servicetaskspeccontainerspecmounts)></code> | mounts block.<br/>__*Optional*__
**privileges**? | <code>[ServiceTaskSpecContainerSpecPrivileges](#cdktf-provider-docker-servicetaskspeccontainerspecprivileges)</code> | privileges block.<br/>__*Optional*__
**readOnly**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Mount the container's root filesystem as read only.<br/>__*Optional*__
**secrets**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecSecrets](#cdktf-provider-docker-servicetaskspeccontainerspecsecrets)></code> | secrets block.<br/>__*Optional*__
**stopGracePeriod**? | <code>string</code> | Amount of time to wait for the container to terminate before forcefully removing it (ms|s|m|h).<br/>__*Optional*__
**stopSignal**? | <code>string</code> | Signal to stop the container.<br/>__*Optional*__
**user**? | <code>string</code> | The user inside the container.<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpecConfigs  <a id="cdktf-provider-docker-servicetaskspeccontainerspecconfigs"></a>






Name | Type | Description 
-----|------|-------------
**configId** | <code>string</code> | ID of the specific config that we're referencing.
**fileName** | <code>string</code> | Represents the final filename in the filesystem.
**configName**? | <code>string</code> | Name of the config that this references, but this is just provided for lookup/display purposes.<br/>__*Optional*__
**fileGid**? | <code>string</code> | Represents the file GID. Defaults to `0`.<br/>__*Optional*__
**fileMode**? | <code>number</code> | Represents represents the FileMode of the file. Defaults to `0o444`.<br/>__*Optional*__
**fileUid**? | <code>string</code> | Represents the file UID. Defaults to `0`.<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpecDnsConfig  <a id="cdktf-provider-docker-servicetaskspeccontainerspecdnsconfig"></a>






Name | Type | Description 
-----|------|-------------
**nameservers** | <code>Array<string></code> | The IP addresses of the name servers.
**options**? | <code>Array<string></code> | A list of internal resolver variables to be modified (e.g., `debug`, `ndots:3`, etc.).<br/>__*Optional*__
**search**? | <code>Array<string></code> | A search list for host-name lookup.<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpecHealthcheck  <a id="cdktf-provider-docker-servicetaskspeccontainerspechealthcheck"></a>






Name | Type | Description 
-----|------|-------------
**test** | <code>Array<string></code> | The test to perform as list.
**interval**? | <code>string</code> | Time between running the check (ms|s|m|h). Defaults to `0s`.<br/>__*Optional*__
**retries**? | <code>number</code> | Consecutive failures needed to report unhealthy. Defaults to `0`.<br/>__*Optional*__
**startPeriod**? | <code>string</code> | Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`.<br/>__*Optional*__
**timeout**? | <code>string</code> | Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`.<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpecHosts  <a id="cdktf-provider-docker-servicetaskspeccontainerspechosts"></a>






Name | Type | Description 
-----|------|-------------
**host** | <code>string</code> | The name of the host.
**ip** | <code>string</code> | The ip of the host.



## struct ServiceTaskSpecContainerSpecLabels  <a id="cdktf-provider-docker-servicetaskspeccontainerspeclabels"></a>






Name | Type | Description 
-----|------|-------------
**label** | <code>string</code> | Name of the label.
**value** | <code>string</code> | Value of the label.



## struct ServiceTaskSpecContainerSpecMounts  <a id="cdktf-provider-docker-servicetaskspeccontainerspecmounts"></a>






Name | Type | Description 
-----|------|-------------
**target** | <code>string</code> | Container path.
**type** | <code>string</code> | The mount type.
**bindOptions**? | <code>[ServiceTaskSpecContainerSpecMountsBindOptions](#cdktf-provider-docker-servicetaskspeccontainerspecmountsbindoptions)</code> | bind_options block.<br/>__*Optional*__
**readOnly**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Whether the mount should be read-only.<br/>__*Optional*__
**source**? | <code>string</code> | Mount source (e.g. a volume name, a host path).<br/>__*Optional*__
**tmpfsOptions**? | <code>[ServiceTaskSpecContainerSpecMountsTmpfsOptions](#cdktf-provider-docker-servicetaskspeccontainerspecmountstmpfsoptions)</code> | tmpfs_options block.<br/>__*Optional*__
**volumeOptions**? | <code>[ServiceTaskSpecContainerSpecMountsVolumeOptions](#cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptions)</code> | volume_options block.<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpecMountsBindOptions  <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountsbindoptions"></a>






Name | Type | Description 
-----|------|-------------
**propagation**? | <code>string</code> | Bind propagation refers to whether or not mounts created within a given bind-mount or named volume can be propagated to replicas of that mount.<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpecMountsTmpfsOptions  <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountstmpfsoptions"></a>






Name | Type | Description 
-----|------|-------------
**mode**? | <code>number</code> | The permission mode for the tmpfs mount in an integer.<br/>__*Optional*__
**sizeBytes**? | <code>number</code> | The size for the tmpfs mount in bytes.<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpecMountsVolumeOptions  <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptions"></a>






Name | Type | Description 
-----|------|-------------
**driverName**? | <code>string</code> | Name of the driver to use to create the volume.<br/>__*Optional*__
**driverOptions**? | <code>Map<string, string></code> | key/value map of driver specific options.<br/>__*Optional*__
**labels**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecContainerSpecMountsVolumeOptionsLabels](#cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptionslabels)></code> | labels block.<br/>__*Optional*__
**noCopy**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Populate volume with data from the target.<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpecMountsVolumeOptionsLabels  <a id="cdktf-provider-docker-servicetaskspeccontainerspecmountsvolumeoptionslabels"></a>






Name | Type | Description 
-----|------|-------------
**label** | <code>string</code> | Name of the label.
**value** | <code>string</code> | Value of the label.



## struct ServiceTaskSpecContainerSpecPrivileges  <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivileges"></a>






Name | Type | Description 
-----|------|-------------
**credentialSpec**? | <code>[ServiceTaskSpecContainerSpecPrivilegesCredentialSpec](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspec)</code> | credential_spec block.<br/>__*Optional*__
**seLinuxContext**? | <code>[ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext](#cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontext)</code> | se_linux_context block.<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpecPrivilegesCredentialSpec  <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegescredentialspec"></a>






Name | Type | Description 
-----|------|-------------
**file**? | <code>string</code> | Load credential spec from this file.<br/>__*Optional*__
**registry**? | <code>string</code> | Load credential spec from this value in the Windows registry.<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext  <a id="cdktf-provider-docker-servicetaskspeccontainerspecprivilegesselinuxcontext"></a>






Name | Type | Description 
-----|------|-------------
**disable**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Disable SELinux.<br/>__*Optional*__
**level**? | <code>string</code> | SELinux level label.<br/>__*Optional*__
**role**? | <code>string</code> | SELinux role label.<br/>__*Optional*__
**type**? | <code>string</code> | SELinux type label.<br/>__*Optional*__
**user**? | <code>string</code> | SELinux user label.<br/>__*Optional*__



## struct ServiceTaskSpecContainerSpecSecrets  <a id="cdktf-provider-docker-servicetaskspeccontainerspecsecrets"></a>






Name | Type | Description 
-----|------|-------------
**fileName** | <code>string</code> | Represents the final filename in the filesystem.
**secretId** | <code>string</code> | ID of the specific secret that we're referencing.
**fileGid**? | <code>string</code> | Represents the file GID. Defaults to `0`.<br/>__*Optional*__
**fileMode**? | <code>number</code> | Represents represents the FileMode of the file. Defaults to `0o444`.<br/>__*Optional*__
**fileUid**? | <code>string</code> | Represents the file UID. Defaults to `0`.<br/>__*Optional*__
**secretName**? | <code>string</code> | Name of the secret that this references, but this is just provided for lookup/display purposes.<br/>__*Optional*__



## struct ServiceTaskSpecLogDriver  <a id="cdktf-provider-docker-servicetaskspeclogdriver"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | The logging driver to use.
**options**? | <code>Map<string, string></code> | The options for the logging driver.<br/>__*Optional*__



## struct ServiceTaskSpecPlacement  <a id="cdktf-provider-docker-servicetaskspecplacement"></a>






Name | Type | Description 
-----|------|-------------
**constraints**? | <code>Array<string></code> | An array of constraints. e.g.: `node.role==manager`.<br/>__*Optional*__
**maxReplicas**? | <code>number</code> | Maximum number of replicas for per node (default value is `0`, which is unlimited).<br/>__*Optional*__
**platforms**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[ServiceTaskSpecPlacementPlatforms](#cdktf-provider-docker-servicetaskspecplacementplatforms)></code> | platforms block.<br/>__*Optional*__
**prefs**? | <code>Array<string></code> | Preferences provide a way to make the scheduler aware of factors such as topology.<br/>__*Optional*__



## struct ServiceTaskSpecPlacementPlatforms  <a id="cdktf-provider-docker-servicetaskspecplacementplatforms"></a>






Name | Type | Description 
-----|------|-------------
**architecture** | <code>string</code> | The architecture, e.g. `amd64`.
**os** | <code>string</code> | The operation system, e.g. `linux`.



## struct ServiceTaskSpecResources  <a id="cdktf-provider-docker-servicetaskspecresources"></a>






Name | Type | Description 
-----|------|-------------
**limits**? | <code>[ServiceTaskSpecResourcesLimits](#cdktf-provider-docker-servicetaskspecresourceslimits)</code> | limits block.<br/>__*Optional*__
**reservation**? | <code>[ServiceTaskSpecResourcesReservation](#cdktf-provider-docker-servicetaskspecresourcesreservation)</code> | reservation block.<br/>__*Optional*__



## struct ServiceTaskSpecResourcesLimits  <a id="cdktf-provider-docker-servicetaskspecresourceslimits"></a>






Name | Type | Description 
-----|------|-------------
**memoryBytes**? | <code>number</code> | The amounf of memory in bytes the container allocates.<br/>__*Optional*__
**nanoCpus**? | <code>number</code> | CPU shares in units of `1/1e9` (or `10^-9`) of the CPU. Should be at least `1000000`.<br/>__*Optional*__



## struct ServiceTaskSpecResourcesReservation  <a id="cdktf-provider-docker-servicetaskspecresourcesreservation"></a>






Name | Type | Description 
-----|------|-------------
**genericResources**? | <code>[ServiceTaskSpecResourcesReservationGenericResources](#cdktf-provider-docker-servicetaskspecresourcesreservationgenericresources)</code> | generic_resources block.<br/>__*Optional*__
**memoryBytes**? | <code>number</code> | The amounf of memory in bytes the container allocates.<br/>__*Optional*__
**nanoCpus**? | <code>number</code> | CPU shares in units of 1/1e9 (or 10^-9) of the CPU. Should be at least `1000000`.<br/>__*Optional*__



## struct ServiceTaskSpecResourcesReservationGenericResources  <a id="cdktf-provider-docker-servicetaskspecresourcesreservationgenericresources"></a>






Name | Type | Description 
-----|------|-------------
**discreteResourcesSpec**? | <code>Array<string></code> | The Integer resources.<br/>__*Optional*__
**namedResourcesSpec**? | <code>Array<string></code> | The String resources.<br/>__*Optional*__



## struct ServiceTaskSpecRestartPolicy  <a id="cdktf-provider-docker-servicetaskspecrestartpolicy"></a>






Name | Type | Description 
-----|------|-------------
**condition**? | <code>string</code> | Condition for restart.<br/>__*Optional*__
**delay**? | <code>string</code> | Delay between restart attempts (ms|s|m|h).<br/>__*Optional*__
**maxAttempts**? | <code>number</code> | Maximum attempts to restart a given container before giving up (default value is `0`, which is ignored).<br/>__*Optional*__
**window**? | <code>string</code> | The time window used to evaluate the restart policy (default value is `0`, which is unbounded) (ms|s|m|h).<br/>__*Optional*__



## struct ServiceUpdateConfig  <a id="cdktf-provider-docker-serviceupdateconfig"></a>






Name | Type | Description 
-----|------|-------------
**delay**? | <code>string</code> | Delay between task updates `(ns|us|ms|s|m|h)`. Defaults to `0s`.<br/>__*Optional*__
**failureAction**? | <code>string</code> | Action on update failure: `pause`, `continue` or `rollback`. Defaults to `pause`.<br/>__*Optional*__
**maxFailureRatio**? | <code>string</code> | Failure rate to tolerate during an update. Defaults to `0.0`.<br/>__*Optional*__
**monitor**? | <code>string</code> | Duration after each task update to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.<br/>__*Optional*__
**order**? | <code>string</code> | Update order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.<br/>__*Optional*__
**parallelism**? | <code>number</code> | Maximum number of tasks to be updated in one iteration. Defaults to `1`.<br/>__*Optional*__



## struct VolumeConfig  <a id="cdktf-provider-docker-volumeconfig"></a>






Name | Type | Description 
-----|------|-------------
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**driver**? | <code>string</code> | Driver type for the volume. Defaults to `local`.<br/>__*Optional*__
**driverOpts**? | <code>Map<string, string></code> | Options specific to the driver.<br/>__*Optional*__
**labels**? | <code>[IResolvable](#cdktf-iresolvable) &#124; Array<[VolumeLabels](#cdktf-provider-docker-volumelabels)></code> | labels block.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**name**? | <code>string</code> | The name of the Docker volume (will be generated if not provided).<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct VolumeLabels  <a id="cdktf-provider-docker-volumelabels"></a>






Name | Type | Description 
-----|------|-------------
**label** | <code>string</code> | Name of the label.
**value** | <code>string</code> | Value of the label.



