import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Base64-url-safe-encoded config data
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/config#data Config#data}
    */
    readonly data: string;
    /**
    * User-defined name of the config
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/config#name Config#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker/r/config docker_config}
*/
export declare class Config extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker/r/config docker_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConfigConfig
    */
    constructor(scope: Construct, id: string, config: ConfigConfig);
    private _data?;
    get data(): string;
    set data(value: string);
    get dataInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
