import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerConfig extends cdktf.TerraformMetaArguments {
    /**
    * If `true` attach to the container after its creation and waits the end of its execution. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#attach Container#attach}
    */
    readonly attach?: boolean | cdktf.IResolvable;
    /**
    * The command to use to start the container. For example, to run `/usr/bin/myprogram -f baz.conf` set the command to be `["/usr/bin/myprogram","-","baz.con"]`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#command Container#command}
    */
    readonly command?: string[];
    /**
    * A comma-separated list or hyphen-separated range of CPUs a container can use, e.g. `0-1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#cpu_set Container#cpu_set}
    */
    readonly cpuSet?: string;
    /**
    * CPU shares (relative weight) for the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#cpu_shares Container#cpu_shares}
    */
    readonly cpuShares?: number;
    /**
    * If defined will attempt to stop the container before destroying. Container will be destroyed after `n` seconds or on successful stop.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#destroy_grace_seconds Container#destroy_grace_seconds}
    */
    readonly destroyGraceSeconds?: number;
    /**
    * DNS servers to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#dns Container#dns}
    */
    readonly dns?: string[];
    /**
    * DNS options used by the DNS provider(s), see `resolv.conf` documentation for valid list of options.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#dns_opts Container#dns_opts}
    */
    readonly dnsOpts?: string[];
    /**
    * DNS search domains that are used when bare unqualified hostnames are used inside of the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#dns_search Container#dns_search}
    */
    readonly dnsSearch?: string[];
    /**
    * Domain name of the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#domainname Container#domainname}
    */
    readonly domainname?: string;
    /**
    * The command to use as the Entrypoint for the container. The Entrypoint allows you to configure a container to run as an executable. For example, to run `/usr/bin/myprogram` when starting a container, set the entrypoint to be `"/usr/bin/myprogra"]`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#entrypoint Container#entrypoint}
    */
    readonly entrypoint?: string[];
    /**
    * Environment variables to set in the form of `KEY=VALUE`, e.g. `DEBUG=0`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#env Container#env}
    */
    readonly env?: string[];
    /**
    * Additional groups for the container user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#group_add Container#group_add}
    */
    readonly groupAdd?: string[];
    /**
    * Hostname of the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#hostname Container#hostname}
    */
    readonly hostname?: string;
    /**
    * The ID of the image to back this container. The easiest way to get this value is to use the `docker_image` resource as is shown in the example.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#image Container#image}
    */
    readonly image: string;
    /**
    * Configured whether an init process should be injected for this container. If unset this will default to the `dockerd` defaults.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#init Container#init}
    */
    readonly init?: boolean | cdktf.IResolvable;
    /**
    * IPC sharing mode for the container. Possible values are: `none`, `private`, `shareable`, `container:<name|id>` or `host`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#ipc_mode Container#ipc_mode}
    */
    readonly ipcMode?: string;
    /**
    * Set of links for link based connectivity between containers that are running on the same host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#links Container#links}
    */
    readonly links?: string[];
    /**
    * The logging driver to use for the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#log_driver Container#log_driver}
    */
    readonly logDriver?: string;
    /**
    * Key/value pairs to use as options for the logging driver.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#log_opts Container#log_opts}
    */
    readonly logOpts?: {
        [key: string]: string;
    };
    /**
    * Save the container logs (`attach` must be enabled). Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#logs Container#logs}
    */
    readonly logs?: boolean | cdktf.IResolvable;
    /**
    * The maximum amount of times to an attempt a restart when `restart` is set to 'on-failure'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#max_retry_count Container#max_retry_count}
    */
    readonly maxRetryCount?: number;
    /**
    * The memory limit for the container in MBs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#memory Container#memory}
    */
    readonly memory?: number;
    /**
    * The total memory limit (memory + swap) for the container in MBs. This setting may compute to `-1` after `terraform apply` if the target host doesn't support memory swap, when that is the case docker will use a soft limitation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#memory_swap Container#memory_swap}
    */
    readonly memorySwap?: number;
    /**
    * If `true`, then the Docker container will be kept running. If `false`, then as long as the container exists, Terraform assumes it is successful. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#must_run Container#must_run}
    */
    readonly mustRun?: boolean | cdktf.IResolvable;
    /**
    * The name of the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#name Container#name}
    */
    readonly name: string;
    /**
    * Set an alias for the container in all specified networks
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#network_alias Container#network_alias}
    */
    readonly networkAlias?: string[];
    /**
    * Network mode of the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#network_mode Container#network_mode}
    */
    readonly networkMode?: string;
    /**
    * ID of the networks in which the container is.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#networks Container#networks}
    */
    readonly networks?: string[];
    /**
    * he PID (Process) Namespace mode for the container. Either `container:<name|id>` or `host`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#pid_mode Container#pid_mode}
    */
    readonly pidMode?: string;
    /**
    * If `true`, the container runs in privileged mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#privileged Container#privileged}
    */
    readonly privileged?: boolean | cdktf.IResolvable;
    /**
    * Publish all ports of the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#publish_all_ports Container#publish_all_ports}
    */
    readonly publishAllPorts?: boolean | cdktf.IResolvable;
    /**
    * If `true`, the container will be started as readonly. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#read_only Container#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * If `true`, it will remove anonymous volumes associated with the container. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#remove_volumes Container#remove_volumes}
    */
    readonly removeVolumes?: boolean | cdktf.IResolvable;
    /**
    * The restart policy for the container. Must be one of 'no', 'on-failure', 'always', 'unless-stopped'. Defaults to `no`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#restart Container#restart}
    */
    readonly restart?: string;
    /**
    * If `true`, then the container will be automatically removed when it exits. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#rm Container#rm}
    */
    readonly rm?: boolean | cdktf.IResolvable;
    /**
    * List of string values to customize labels for MLS systems, such as SELinux. See https://docs.docker.com/engine/reference/run/#security-configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#security_opts Container#security_opts}
    */
    readonly securityOpts?: string[];
    /**
    * Size of `/dev/shm` in MBs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#shm_size Container#shm_size}
    */
    readonly shmSize?: number;
    /**
    * If `true`, then the Docker container will be started after creation. If `false`, then the container is only created. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#start Container#start}
    */
    readonly start?: boolean | cdktf.IResolvable;
    /**
    * If `true`, keep STDIN open even if not attached (`docker run -i`). Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#stdin_open Container#stdin_open}
    */
    readonly stdinOpen?: boolean | cdktf.IResolvable;
    /**
    * Key/value pairs for the storage driver options, e.g. `size`: `120G`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#storage_opts Container#storage_opts}
    */
    readonly storageOpts?: {
        [key: string]: string;
    };
    /**
    * A map of kernel parameters (sysctls) to set in the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#sysctls Container#sysctls}
    */
    readonly sysctls?: {
        [key: string]: string;
    };
    /**
    * A map of container directories which should be replaced by `tmpfs mounts`, and their corresponding mount options.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#tmpfs Container#tmpfs}
    */
    readonly tmpfs?: {
        [key: string]: string;
    };
    /**
    * If `true`, allocate a pseudo-tty (`docker run -t`). Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#tty Container#tty}
    */
    readonly tty?: boolean | cdktf.IResolvable;
    /**
    * User used for run the first process. Format is `user` or `user:group` which user and group can be passed literraly or by name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#user Container#user}
    */
    readonly user?: string;
    /**
    * Sets the usernamespace mode for the container when usernamespace remapping option is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#userns_mode Container#userns_mode}
    */
    readonly usernsMode?: string;
    /**
    * The working directory for commands to run in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#working_dir Container#working_dir}
    */
    readonly workingDir?: string;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#capabilities Container#capabilities}
    */
    readonly capabilities?: ContainerCapabilities;
    /**
    * devices block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#devices Container#devices}
    */
    readonly devices?: ContainerDevices[] | cdktf.IResolvable;
    /**
    * healthcheck block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#healthcheck Container#healthcheck}
    */
    readonly healthcheck?: ContainerHealthcheck;
    /**
    * host block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#host Container#host}
    */
    readonly host?: ContainerHost[] | cdktf.IResolvable;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#labels Container#labels}
    */
    readonly labels?: ContainerLabels[] | cdktf.IResolvable;
    /**
    * mounts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#mounts Container#mounts}
    */
    readonly mounts?: ContainerMounts[] | cdktf.IResolvable;
    /**
    * networks_advanced block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#networks_advanced Container#networks_advanced}
    */
    readonly networksAdvanced?: ContainerNetworksAdvanced[] | cdktf.IResolvable;
    /**
    * ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#ports Container#ports}
    */
    readonly ports?: ContainerPorts[] | cdktf.IResolvable;
    /**
    * ulimit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#ulimit Container#ulimit}
    */
    readonly ulimit?: ContainerUlimit[] | cdktf.IResolvable;
    /**
    * upload block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#upload Container#upload}
    */
    readonly upload?: ContainerUpload[] | cdktf.IResolvable;
    /**
    * volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#volumes Container#volumes}
    */
    readonly volumes?: ContainerVolumes[] | cdktf.IResolvable;
}
export declare class ContainerNetworkData extends cdktf.ComplexComputedList {
    get gateway(): string;
    get globalIpv6Address(): string;
    get globalIpv6PrefixLength(): number;
    get ipAddress(): string;
    get ipPrefixLength(): number;
    get ipv6Gateway(): string;
    get networkName(): string;
}
export interface ContainerCapabilities {
    /**
    * List of linux capabilities to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#add Container#add}
    */
    readonly add?: string[];
    /**
    * List of linux capabilities to drop.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#drop Container#drop}
    */
    readonly drop?: string[];
}
export declare function containerCapabilitiesToTerraform(struct?: ContainerCapabilitiesOutputReference | ContainerCapabilities | cdktf.IResolvable): any;
export declare class ContainerCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ContainerCapabilities | undefined;
    set internalValue(value: ContainerCapabilities | undefined);
    private _add?;
    get add(): string[];
    set add(value: string[]);
    resetAdd(): void;
    get addInput(): string[] | undefined;
    private _drop?;
    get drop(): string[];
    set drop(value: string[]);
    resetDrop(): void;
    get dropInput(): string[] | undefined;
}
export interface ContainerDevices {
    /**
    * The path in the container where the device will be bound.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#container_path Container#container_path}
    */
    readonly containerPath?: string;
    /**
    * The path on the host where the device is located.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#host_path Container#host_path}
    */
    readonly hostPath: string;
    /**
    * The cgroup permissions given to the container to access the device. Defaults to `rwm`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#permissions Container#permissions}
    */
    readonly permissions?: string;
}
export declare function containerDevicesToTerraform(struct?: ContainerDevices | cdktf.IResolvable): any;
export interface ContainerHealthcheck {
    /**
    * Time between running the check (ms|s|m|h). Defaults to `0s`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#interval Container#interval}
    */
    readonly interval?: string;
    /**
    * Consecutive failures needed to report unhealthy. Defaults to `0`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#retries Container#retries}
    */
    readonly retries?: number;
    /**
    * Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#start_period Container#start_period}
    */
    readonly startPeriod?: string;
    /**
    * Command to run to check health. For example, to run `curl -f localhost/health` set the command to be `["CMD", "curl", "-f", "localhost/health"]`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#test Container#test}
    */
    readonly test: string[];
    /**
    * Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#timeout Container#timeout}
    */
    readonly timeout?: string;
}
export declare function containerHealthcheckToTerraform(struct?: ContainerHealthcheckOutputReference | ContainerHealthcheck): any;
export declare class ContainerHealthcheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ContainerHealthcheck | undefined;
    set internalValue(value: ContainerHealthcheck | undefined);
    private _interval?;
    get interval(): string;
    set interval(value: string);
    resetInterval(): void;
    get intervalInput(): string | undefined;
    private _retries?;
    get retries(): number;
    set retries(value: number);
    resetRetries(): void;
    get retriesInput(): number | undefined;
    private _startPeriod?;
    get startPeriod(): string;
    set startPeriod(value: string);
    resetStartPeriod(): void;
    get startPeriodInput(): string | undefined;
    private _test?;
    get test(): string[];
    set test(value: string[]);
    get testInput(): string[] | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface ContainerHost {
    /**
    * Hostname to add
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#host Container#host}
    */
    readonly host: string;
    /**
    * IP address this hostname should resolve to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#ip Container#ip}
    */
    readonly ip: string;
}
export declare function containerHostToTerraform(struct?: ContainerHost | cdktf.IResolvable): any;
export interface ContainerLabels {
    /**
    * Name of the label
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#label Container#label}
    */
    readonly label: string;
    /**
    * Value of the label
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#value Container#value}
    */
    readonly value: string;
}
export declare function containerLabelsToTerraform(struct?: ContainerLabels | cdktf.IResolvable): any;
export interface ContainerMountsBindOptions {
    /**
    * A propagation mode with the value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#propagation Container#propagation}
    */
    readonly propagation?: string;
}
export declare function containerMountsBindOptionsToTerraform(struct?: ContainerMountsBindOptionsOutputReference | ContainerMountsBindOptions): any;
export declare class ContainerMountsBindOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ContainerMountsBindOptions | undefined;
    set internalValue(value: ContainerMountsBindOptions | undefined);
    private _propagation?;
    get propagation(): string;
    set propagation(value: string);
    resetPropagation(): void;
    get propagationInput(): string | undefined;
}
export interface ContainerMountsTmpfsOptions {
    /**
    * The permission mode for the tmpfs mount in an integer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#mode Container#mode}
    */
    readonly mode?: number;
    /**
    * The size for the tmpfs mount in bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#size_bytes Container#size_bytes}
    */
    readonly sizeBytes?: number;
}
export declare function containerMountsTmpfsOptionsToTerraform(struct?: ContainerMountsTmpfsOptionsOutputReference | ContainerMountsTmpfsOptions): any;
export declare class ContainerMountsTmpfsOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ContainerMountsTmpfsOptions | undefined;
    set internalValue(value: ContainerMountsTmpfsOptions | undefined);
    private _mode?;
    get mode(): number;
    set mode(value: number);
    resetMode(): void;
    get modeInput(): number | undefined;
    private _sizeBytes?;
    get sizeBytes(): number;
    set sizeBytes(value: number);
    resetSizeBytes(): void;
    get sizeBytesInput(): number | undefined;
}
export interface ContainerMountsVolumeOptionsLabels {
    /**
    * Name of the label
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#label Container#label}
    */
    readonly label: string;
    /**
    * Value of the label
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#value Container#value}
    */
    readonly value: string;
}
export declare function containerMountsVolumeOptionsLabelsToTerraform(struct?: ContainerMountsVolumeOptionsLabels | cdktf.IResolvable): any;
export interface ContainerMountsVolumeOptions {
    /**
    * Name of the driver to use to create the volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#driver_name Container#driver_name}
    */
    readonly driverName?: string;
    /**
    * key/value map of driver specific options.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#driver_options Container#driver_options}
    */
    readonly driverOptions?: {
        [key: string]: string;
    };
    /**
    * Populate volume with data from the target.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#no_copy Container#no_copy}
    */
    readonly noCopy?: boolean | cdktf.IResolvable;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#labels Container#labels}
    */
    readonly labels?: ContainerMountsVolumeOptionsLabels[] | cdktf.IResolvable;
}
export declare function containerMountsVolumeOptionsToTerraform(struct?: ContainerMountsVolumeOptionsOutputReference | ContainerMountsVolumeOptions): any;
export declare class ContainerMountsVolumeOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ContainerMountsVolumeOptions | undefined;
    set internalValue(value: ContainerMountsVolumeOptions | undefined);
    private _driverName?;
    get driverName(): string;
    set driverName(value: string);
    resetDriverName(): void;
    get driverNameInput(): string | undefined;
    private _driverOptions?;
    get driverOptions(): {
        [key: string]: string;
    };
    set driverOptions(value: {
        [key: string]: string;
    });
    resetDriverOptions(): void;
    get driverOptionsInput(): {
        [key: string]: string;
    } | undefined;
    private _noCopy?;
    get noCopy(): boolean | cdktf.IResolvable;
    set noCopy(value: boolean | cdktf.IResolvable);
    resetNoCopy(): void;
    get noCopyInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): ContainerMountsVolumeOptionsLabels[] | cdktf.IResolvable;
    set labels(value: ContainerMountsVolumeOptionsLabels[] | cdktf.IResolvable);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | ContainerMountsVolumeOptionsLabels[] | undefined;
}
export interface ContainerMounts {
    /**
    * Whether the mount should be read-only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#read_only Container#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Mount source (e.g. a volume name, a host path).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#source Container#source}
    */
    readonly source?: string;
    /**
    * Container path
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#target Container#target}
    */
    readonly target: string;
    /**
    * The mount type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#type Container#type}
    */
    readonly type: string;
    /**
    * bind_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#bind_options Container#bind_options}
    */
    readonly bindOptions?: ContainerMountsBindOptions;
    /**
    * tmpfs_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#tmpfs_options Container#tmpfs_options}
    */
    readonly tmpfsOptions?: ContainerMountsTmpfsOptions;
    /**
    * volume_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#volume_options Container#volume_options}
    */
    readonly volumeOptions?: ContainerMountsVolumeOptions;
}
export declare function containerMountsToTerraform(struct?: ContainerMounts | cdktf.IResolvable): any;
export interface ContainerNetworksAdvanced {
    /**
    * The network aliases of the container in the specific network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#aliases Container#aliases}
    */
    readonly aliases?: string[];
    /**
    * The IPV4 address of the container in the specific network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#ipv4_address Container#ipv4_address}
    */
    readonly ipv4Address?: string;
    /**
    * The IPV6 address of the container in the specific network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#ipv6_address Container#ipv6_address}
    */
    readonly ipv6Address?: string;
    /**
    * The name of the network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#name Container#name}
    */
    readonly name: string;
}
export declare function containerNetworksAdvancedToTerraform(struct?: ContainerNetworksAdvanced | cdktf.IResolvable): any;
export interface ContainerPorts {
    /**
    * Port exposed out of the container. If not given a free random port `>= 32768` will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#external Container#external}
    */
    readonly external?: number;
    /**
    * Port within the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#internal Container#internal}
    */
    readonly internal: number;
    /**
    * IP address/mask that can access this port. Defaults to `0.0.0.0`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#ip Container#ip}
    */
    readonly ip?: string;
    /**
    * Protocol that can be used over this port. Defaults to `tcp`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#protocol Container#protocol}
    */
    readonly protocol?: string;
}
export declare function containerPortsToTerraform(struct?: ContainerPorts | cdktf.IResolvable): any;
export interface ContainerUlimit {
    /**
    * The hard limit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#hard Container#hard}
    */
    readonly hard: number;
    /**
    * The name of the ulimit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#name Container#name}
    */
    readonly name: string;
    /**
    * The soft limit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#soft Container#soft}
    */
    readonly soft: number;
}
export declare function containerUlimitToTerraform(struct?: ContainerUlimit | cdktf.IResolvable): any;
export interface ContainerUpload {
    /**
    * Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `content_base64` & `source`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#content Container#content}
    */
    readonly content?: string;
    /**
    * Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for larger binary content such as the result of the `base64encode` interpolation function. See [here](https://github.com/terraform-providers/terraform-provider-docker/issues/48#issuecomment-374174588) for the reason. Conflicts with `content` & `source`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#content_base64 Container#content_base64}
    */
    readonly contentBase64?: string;
    /**
    * If `true`, the file will be uploaded with user executable permission. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#executable Container#executable}
    */
    readonly executable?: boolean | cdktf.IResolvable;
    /**
    * Path to the file in the container where is upload goes to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#file Container#file}
    */
    readonly file: string;
    /**
    * A filename that references a file which will be uploaded as the object content. This allows for large file uploads that do not get stored in state. Conflicts with `content` & `content_base64`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#source Container#source}
    */
    readonly source?: string;
    /**
    * If using `source`, this will force an update if the file content has updated but the filename has not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#source_hash Container#source_hash}
    */
    readonly sourceHash?: string;
}
export declare function containerUploadToTerraform(struct?: ContainerUpload | cdktf.IResolvable): any;
export interface ContainerVolumes {
    /**
    * The path in the container where the volume will be mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#container_path Container#container_path}
    */
    readonly containerPath?: string;
    /**
    * The container where the volume is coming from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#from_container Container#from_container}
    */
    readonly fromContainer?: string;
    /**
    * The path on the host where the volume is coming from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#host_path Container#host_path}
    */
    readonly hostPath?: string;
    /**
    * If `true`, this volume will be readonly. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#read_only Container#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * The name of the docker volume which should be mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/container#volume_name Container#volume_name}
    */
    readonly volumeName?: string;
}
export declare function containerVolumesToTerraform(struct?: ContainerVolumes | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker/r/container docker_container}
*/
export declare class Container extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker/r/container docker_container} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerConfig
    */
    constructor(scope: Construct, id: string, config: ContainerConfig);
    private _attach?;
    get attach(): boolean | cdktf.IResolvable;
    set attach(value: boolean | cdktf.IResolvable);
    resetAttach(): void;
    get attachInput(): boolean | cdktf.IResolvable | undefined;
    get bridge(): string;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    get containerLogs(): string;
    private _cpuSet?;
    get cpuSet(): string;
    set cpuSet(value: string);
    resetCpuSet(): void;
    get cpuSetInput(): string | undefined;
    private _cpuShares?;
    get cpuShares(): number;
    set cpuShares(value: number);
    resetCpuShares(): void;
    get cpuSharesInput(): number | undefined;
    private _destroyGraceSeconds?;
    get destroyGraceSeconds(): number;
    set destroyGraceSeconds(value: number);
    resetDestroyGraceSeconds(): void;
    get destroyGraceSecondsInput(): number | undefined;
    private _dns?;
    get dns(): string[];
    set dns(value: string[]);
    resetDns(): void;
    get dnsInput(): string[] | undefined;
    private _dnsOpts?;
    get dnsOpts(): string[];
    set dnsOpts(value: string[]);
    resetDnsOpts(): void;
    get dnsOptsInput(): string[] | undefined;
    private _dnsSearch?;
    get dnsSearch(): string[];
    set dnsSearch(value: string[]);
    resetDnsSearch(): void;
    get dnsSearchInput(): string[] | undefined;
    private _domainname?;
    get domainname(): string;
    set domainname(value: string);
    resetDomainname(): void;
    get domainnameInput(): string | undefined;
    private _entrypoint?;
    get entrypoint(): string[];
    set entrypoint(value: string[]);
    resetEntrypoint(): void;
    get entrypointInput(): string[] | undefined;
    private _env?;
    get env(): string[];
    set env(value: string[]);
    resetEnv(): void;
    get envInput(): string[] | undefined;
    get exitCode(): number;
    get gateway(): string;
    private _groupAdd?;
    get groupAdd(): string[];
    set groupAdd(value: string[]);
    resetGroupAdd(): void;
    get groupAddInput(): string[] | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    get id(): string;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _init?;
    get init(): boolean | cdktf.IResolvable;
    set init(value: boolean | cdktf.IResolvable);
    resetInit(): void;
    get initInput(): boolean | cdktf.IResolvable | undefined;
    get ipAddress(): string;
    get ipPrefixLength(): number;
    private _ipcMode?;
    get ipcMode(): string;
    set ipcMode(value: string);
    resetIpcMode(): void;
    get ipcModeInput(): string | undefined;
    private _links?;
    get links(): string[];
    set links(value: string[]);
    resetLinks(): void;
    get linksInput(): string[] | undefined;
    private _logDriver?;
    get logDriver(): string;
    set logDriver(value: string);
    resetLogDriver(): void;
    get logDriverInput(): string | undefined;
    private _logOpts?;
    get logOpts(): {
        [key: string]: string;
    };
    set logOpts(value: {
        [key: string]: string;
    });
    resetLogOpts(): void;
    get logOptsInput(): {
        [key: string]: string;
    } | undefined;
    private _logs?;
    get logs(): boolean | cdktf.IResolvable;
    set logs(value: boolean | cdktf.IResolvable);
    resetLogs(): void;
    get logsInput(): boolean | cdktf.IResolvable | undefined;
    private _maxRetryCount?;
    get maxRetryCount(): number;
    set maxRetryCount(value: number);
    resetMaxRetryCount(): void;
    get maxRetryCountInput(): number | undefined;
    private _memory?;
    get memory(): number;
    set memory(value: number);
    resetMemory(): void;
    get memoryInput(): number | undefined;
    private _memorySwap?;
    get memorySwap(): number;
    set memorySwap(value: number);
    resetMemorySwap(): void;
    get memorySwapInput(): number | undefined;
    private _mustRun?;
    get mustRun(): boolean | cdktf.IResolvable;
    set mustRun(value: boolean | cdktf.IResolvable);
    resetMustRun(): void;
    get mustRunInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkAlias?;
    get networkAlias(): string[];
    set networkAlias(value: string[]);
    resetNetworkAlias(): void;
    get networkAliasInput(): string[] | undefined;
    networkData(index: string): ContainerNetworkData;
    private _networkMode?;
    get networkMode(): string;
    set networkMode(value: string);
    resetNetworkMode(): void;
    get networkModeInput(): string | undefined;
    private _networks?;
    get networks(): string[];
    set networks(value: string[]);
    resetNetworks(): void;
    get networksInput(): string[] | undefined;
    private _pidMode?;
    get pidMode(): string;
    set pidMode(value: string);
    resetPidMode(): void;
    get pidModeInput(): string | undefined;
    private _privileged?;
    get privileged(): boolean | cdktf.IResolvable;
    set privileged(value: boolean | cdktf.IResolvable);
    resetPrivileged(): void;
    get privilegedInput(): boolean | cdktf.IResolvable | undefined;
    private _publishAllPorts?;
    get publishAllPorts(): boolean | cdktf.IResolvable;
    set publishAllPorts(value: boolean | cdktf.IResolvable);
    resetPublishAllPorts(): void;
    get publishAllPortsInput(): boolean | cdktf.IResolvable | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _removeVolumes?;
    get removeVolumes(): boolean | cdktf.IResolvable;
    set removeVolumes(value: boolean | cdktf.IResolvable);
    resetRemoveVolumes(): void;
    get removeVolumesInput(): boolean | cdktf.IResolvable | undefined;
    private _restart?;
    get restart(): string;
    set restart(value: string);
    resetRestart(): void;
    get restartInput(): string | undefined;
    private _rm?;
    get rm(): boolean | cdktf.IResolvable;
    set rm(value: boolean | cdktf.IResolvable);
    resetRm(): void;
    get rmInput(): boolean | cdktf.IResolvable | undefined;
    private _securityOpts?;
    get securityOpts(): string[];
    set securityOpts(value: string[]);
    resetSecurityOpts(): void;
    get securityOptsInput(): string[] | undefined;
    private _shmSize?;
    get shmSize(): number;
    set shmSize(value: number);
    resetShmSize(): void;
    get shmSizeInput(): number | undefined;
    private _start?;
    get start(): boolean | cdktf.IResolvable;
    set start(value: boolean | cdktf.IResolvable);
    resetStart(): void;
    get startInput(): boolean | cdktf.IResolvable | undefined;
    private _stdinOpen?;
    get stdinOpen(): boolean | cdktf.IResolvable;
    set stdinOpen(value: boolean | cdktf.IResolvable);
    resetStdinOpen(): void;
    get stdinOpenInput(): boolean | cdktf.IResolvable | undefined;
    private _storageOpts?;
    get storageOpts(): {
        [key: string]: string;
    };
    set storageOpts(value: {
        [key: string]: string;
    });
    resetStorageOpts(): void;
    get storageOptsInput(): {
        [key: string]: string;
    } | undefined;
    private _sysctls?;
    get sysctls(): {
        [key: string]: string;
    };
    set sysctls(value: {
        [key: string]: string;
    });
    resetSysctls(): void;
    get sysctlsInput(): {
        [key: string]: string;
    } | undefined;
    private _tmpfs?;
    get tmpfs(): {
        [key: string]: string;
    };
    set tmpfs(value: {
        [key: string]: string;
    });
    resetTmpfs(): void;
    get tmpfsInput(): {
        [key: string]: string;
    } | undefined;
    private _tty?;
    get tty(): boolean | cdktf.IResolvable;
    set tty(value: boolean | cdktf.IResolvable);
    resetTty(): void;
    get ttyInput(): boolean | cdktf.IResolvable | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _usernsMode?;
    get usernsMode(): string;
    set usernsMode(value: string);
    resetUsernsMode(): void;
    get usernsModeInput(): string | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _capabilities;
    get capabilities(): ContainerCapabilitiesOutputReference;
    putCapabilities(value: ContainerCapabilities): void;
    resetCapabilities(): void;
    get capabilitiesInput(): ContainerCapabilities | undefined;
    private _devices?;
    get devices(): ContainerDevices[] | cdktf.IResolvable;
    set devices(value: ContainerDevices[] | cdktf.IResolvable);
    resetDevices(): void;
    get devicesInput(): cdktf.IResolvable | ContainerDevices[] | undefined;
    private _healthcheck;
    get healthcheck(): ContainerHealthcheckOutputReference;
    putHealthcheck(value: ContainerHealthcheck): void;
    resetHealthcheck(): void;
    get healthcheckInput(): ContainerHealthcheck | undefined;
    private _host?;
    get host(): ContainerHost[] | cdktf.IResolvable;
    set host(value: ContainerHost[] | cdktf.IResolvable);
    resetHost(): void;
    get hostInput(): cdktf.IResolvable | ContainerHost[] | undefined;
    private _labels?;
    get labels(): ContainerLabels[] | cdktf.IResolvable;
    set labels(value: ContainerLabels[] | cdktf.IResolvable);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | ContainerLabels[] | undefined;
    private _mounts?;
    get mounts(): ContainerMounts[] | cdktf.IResolvable;
    set mounts(value: ContainerMounts[] | cdktf.IResolvable);
    resetMounts(): void;
    get mountsInput(): cdktf.IResolvable | ContainerMounts[] | undefined;
    private _networksAdvanced?;
    get networksAdvanced(): ContainerNetworksAdvanced[] | cdktf.IResolvable;
    set networksAdvanced(value: ContainerNetworksAdvanced[] | cdktf.IResolvable);
    resetNetworksAdvanced(): void;
    get networksAdvancedInput(): cdktf.IResolvable | ContainerNetworksAdvanced[] | undefined;
    private _ports?;
    get ports(): ContainerPorts[] | cdktf.IResolvable;
    set ports(value: ContainerPorts[] | cdktf.IResolvable);
    resetPorts(): void;
    get portsInput(): cdktf.IResolvable | ContainerPorts[] | undefined;
    private _ulimit?;
    get ulimit(): ContainerUlimit[] | cdktf.IResolvable;
    set ulimit(value: ContainerUlimit[] | cdktf.IResolvable);
    resetUlimit(): void;
    get ulimitInput(): cdktf.IResolvable | ContainerUlimit[] | undefined;
    private _upload?;
    get upload(): ContainerUpload[] | cdktf.IResolvable;
    set upload(value: ContainerUpload[] | cdktf.IResolvable);
    resetUpload(): void;
    get uploadInput(): cdktf.IResolvable | ContainerUpload[] | undefined;
    private _volumes?;
    get volumes(): ContainerVolumes[] | cdktf.IResolvable;
    set volumes(value: ContainerVolumes[] | cdktf.IResolvable);
    resetVolumes(): void;
    get volumesInput(): cdktf.IResolvable | ContainerVolumes[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
