import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDockerImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Docker image, including any tags or SHA256 repo digests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/d/image#name DataDockerImage#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker/d/image docker_image}
*/
export declare class DataDockerImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker/d/image docker_image} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDockerImageConfig
    */
    constructor(scope: Construct, id: string, config: DataDockerImageConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get repoDigest(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
