import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDockerNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Docker network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/d/network#name DataDockerNetwork#name}
    */
    readonly name: string;
}
export declare class DataDockerNetworkIpamConfig extends cdktf.ComplexComputedList {
    get auxAddress(): {
        [key: string]: string;
    };
    get gateway(): string;
    get ipRange(): string;
    get subnet(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker/d/network docker_network}
*/
export declare class DataDockerNetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker/d/network docker_network} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDockerNetworkConfig
    */
    constructor(scope: Construct, id: string, config: DataDockerNetworkConfig);
    get driver(): string;
    get id(): string;
    get internal(): cdktf.IResolvable;
    ipamConfig(index: string): DataDockerNetworkIpamConfig;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    options(key: string): string | cdktf.IResolvable;
    get scope(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
