import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDockerPluginConfig extends cdktf.TerraformMetaArguments {
    /**
    * The alias of the Docker plugin. If the tag is omitted, `:latest` is complemented to the attribute value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/d/plugin#alias DataDockerPlugin#alias}
    */
    readonly alias?: string;
    /**
    * The ID of the plugin, which has precedence over the `alias` of both are given
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/d/plugin#id DataDockerPlugin#id}
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker/d/plugin docker_plugin}
*/
export declare class DataDockerPlugin extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker/d/plugin docker_plugin} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDockerPluginConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDockerPluginConfig);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    get enabled(): cdktf.IResolvable;
    get env(): string[];
    get grantAllPermissions(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get pluginReference(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
