import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DockerProviderConfig {
    /**
    * PEM-encoded content of Docker host CA certificate
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#ca_material DockerProvider#ca_material}
    */
    readonly caMaterial?: string;
    /**
    * PEM-encoded content of Docker client certificate
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#cert_material DockerProvider#cert_material}
    */
    readonly certMaterial?: string;
    /**
    * Path to directory with Docker TLS config
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#cert_path DockerProvider#cert_path}
    */
    readonly certPath?: string;
    /**
    * The Docker daemon address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#host DockerProvider#host}
    */
    readonly host?: string;
    /**
    * PEM-encoded content of Docker client private key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#key_material DockerProvider#key_material}
    */
    readonly keyMaterial?: string;
    /**
    * Additional SSH option flags to be appended when using `ssh://` protocol
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#ssh_opts DockerProvider#ssh_opts}
    */
    readonly sshOpts?: string[];
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#alias DockerProvider#alias}
    */
    readonly alias?: string;
    /**
    * registry_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#registry_auth DockerProvider#registry_auth}
    */
    readonly registryAuth?: DockerProviderRegistryAuth;
}
export interface DockerProviderRegistryAuth {
    /**
    * Address of the registry
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#address DockerProvider#address}
    */
    readonly address: string;
    /**
    * Path to docker json file for registry auth
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#config_file DockerProvider#config_file}
    */
    readonly configFile?: string;
    /**
    * Plain content of the docker json file for registry auth
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#config_file_content DockerProvider#config_file_content}
    */
    readonly configFileContent?: string;
    /**
    * Password for the registry
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#password DockerProvider#password}
    */
    readonly password?: string;
    /**
    * Username for the registry
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker#username DockerProvider#username}
    */
    readonly username?: string;
}
export declare function dockerProviderRegistryAuthToTerraform(struct?: DockerProviderRegistryAuth): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker docker}
*/
export declare class DockerProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker docker} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DockerProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DockerProviderConfig);
    private _caMaterial?;
    get caMaterial(): string | undefined;
    set caMaterial(value: string | undefined);
    resetCaMaterial(): void;
    get caMaterialInput(): string | undefined;
    private _certMaterial?;
    get certMaterial(): string | undefined;
    set certMaterial(value: string | undefined);
    resetCertMaterial(): void;
    get certMaterialInput(): string | undefined;
    private _certPath?;
    get certPath(): string | undefined;
    set certPath(value: string | undefined);
    resetCertPath(): void;
    get certPathInput(): string | undefined;
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _keyMaterial?;
    get keyMaterial(): string | undefined;
    set keyMaterial(value: string | undefined);
    resetKeyMaterial(): void;
    get keyMaterialInput(): string | undefined;
    private _sshOpts?;
    get sshOpts(): string[] | undefined;
    set sshOpts(value: string[] | undefined);
    resetSshOpts(): void;
    get sshOptsInput(): string[] | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _registryAuth?;
    get registryAuth(): DockerProviderRegistryAuth | undefined;
    set registryAuth(value: DockerProviderRegistryAuth | undefined);
    resetRegistryAuth(): void;
    get registryAuthInput(): DockerProviderRegistryAuth | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
