"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerProvider = exports.dockerProviderRegistryAuthToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function dockerProviderRegistryAuthToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        address: cdktf.stringToTerraform(struct.address),
        config_file: cdktf.stringToTerraform(struct.configFile),
        config_file_content: cdktf.stringToTerraform(struct.configFileContent),
        password: cdktf.stringToTerraform(struct.password),
        username: cdktf.stringToTerraform(struct.username),
    };
}
exports.dockerProviderRegistryAuthToTerraform = dockerProviderRegistryAuthToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker docker}
*/
class DockerProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker docker} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DockerProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'docker',
            terraformGeneratorMetadata: {
                providerName: 'docker',
                providerVersionConstraint: '~> 2.12'
            },
            terraformProviderSource: 'kreuzwerker/docker'
        });
        this._caMaterial = config.caMaterial;
        this._certMaterial = config.certMaterial;
        this._certPath = config.certPath;
        this._host = config.host;
        this._keyMaterial = config.keyMaterial;
        this._sshOpts = config.sshOpts;
        this._alias = config.alias;
        this._registryAuth = config.registryAuth;
    }
    get caMaterial() {
        return this._caMaterial;
    }
    set caMaterial(value) {
        this._caMaterial = value;
    }
    resetCaMaterial() {
        this._caMaterial = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get caMaterialInput() {
        return this._caMaterial;
    }
    get certMaterial() {
        return this._certMaterial;
    }
    set certMaterial(value) {
        this._certMaterial = value;
    }
    resetCertMaterial() {
        this._certMaterial = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certMaterialInput() {
        return this._certMaterial;
    }
    get certPath() {
        return this._certPath;
    }
    set certPath(value) {
        this._certPath = value;
    }
    resetCertPath() {
        this._certPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certPathInput() {
        return this._certPath;
    }
    get host() {
        return this._host;
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get keyMaterial() {
        return this._keyMaterial;
    }
    set keyMaterial(value) {
        this._keyMaterial = value;
    }
    resetKeyMaterial() {
        this._keyMaterial = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyMaterialInput() {
        return this._keyMaterial;
    }
    get sshOpts() {
        return this._sshOpts;
    }
    set sshOpts(value) {
        this._sshOpts = value;
    }
    resetSshOpts() {
        this._sshOpts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sshOptsInput() {
        return this._sshOpts;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get registryAuth() {
        return this._registryAuth;
    }
    set registryAuth(value) {
        this._registryAuth = value;
    }
    resetRegistryAuth() {
        this._registryAuth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get registryAuthInput() {
        return this._registryAuth;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            ca_material: cdktf.stringToTerraform(this._caMaterial),
            cert_material: cdktf.stringToTerraform(this._certMaterial),
            cert_path: cdktf.stringToTerraform(this._certPath),
            host: cdktf.stringToTerraform(this._host),
            key_material: cdktf.stringToTerraform(this._keyMaterial),
            ssh_opts: cdktf.listMapper(cdktf.stringToTerraform)(this._sshOpts),
            alias: cdktf.stringToTerraform(this._alias),
            registry_auth: dockerProviderRegistryAuthToTerraform(this._registryAuth),
        };
    }
}
exports.DockerProvider = DockerProvider;
_a = JSII_RTTI_SYMBOL_1;
DockerProvider[_a] = { fqn: "@cdktf/provider-docker.DockerProvider", version: "0.6.57" };
// =================
// STATIC PROPERTIES
// =================
DockerProvider.tfResourceType = "docker";
//# sourceMappingURL=data:application/json;base64,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