import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * If true, then the image is removed forcibly when the resource is destroyed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#force_remove Image#force_remove}
    */
    readonly forceRemove?: boolean | cdktf.IResolvable;
    /**
    * If true, then the Docker image won't be deleted on destroy operation. If this is false, it will delete the image from the docker local storage on destroy operation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#keep_locally Image#keep_locally}
    */
    readonly keepLocally?: boolean | cdktf.IResolvable;
    /**
    * The name of the Docker image, including any tags or SHA256 repo digests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#name Image#name}
    */
    readonly name: string;
    /**
    * A value which cause an image pull when changed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#pull_trigger Image#pull_trigger}
    */
    readonly pullTrigger?: string;
    /**
    * List of values which cause an image pull when changed. This is used to store the image digest from the registry when using the [docker_registry_image](../data-sources/registry_image.md).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#pull_triggers Image#pull_triggers}
    */
    readonly pullTriggers?: string[];
    /**
    * build block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#build Image#build}
    */
    readonly buildAttribute?: ImageBuild;
}
export interface ImageBuild {
    /**
    * Set build-time variables
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#build_arg Image#build_arg}
    */
    readonly buildArg?: {
        [key: string]: string;
    };
    /**
    * Name of the Dockerfile. Defaults to `Dockerfile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#dockerfile Image#dockerfile}
    */
    readonly dockerfile?: string;
    /**
    * Always remove intermediate containers
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#force_remove Image#force_remove}
    */
    readonly forceRemove?: boolean | cdktf.IResolvable;
    /**
    * Set metadata for an image
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#label Image#label}
    */
    readonly label?: {
        [key: string]: string;
    };
    /**
    * Do not use cache when building the image
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#no_cache Image#no_cache}
    */
    readonly noCache?: boolean | cdktf.IResolvable;
    /**
    * Context path
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#path Image#path}
    */
    readonly path: string;
    /**
    * Remove intermediate containers after a successful build. Defaults to  `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#remove Image#remove}
    */
    readonly remove?: boolean | cdktf.IResolvable;
    /**
    * Name and optionally a tag in the 'name:tag' format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#tag Image#tag}
    */
    readonly tag?: string[];
    /**
    * Set the target build stage to build
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/image#target Image#target}
    */
    readonly target?: string;
}
export declare function imageBuildToTerraform(struct?: ImageBuildOutputReference | ImageBuild | cdktf.IResolvable): any;
export declare class ImageBuildOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ImageBuild | undefined;
    set internalValue(value: ImageBuild | undefined);
    private _buildArg?;
    get buildArg(): {
        [key: string]: string;
    };
    set buildArg(value: {
        [key: string]: string;
    });
    resetBuildArg(): void;
    get buildArgInput(): {
        [key: string]: string;
    } | undefined;
    private _dockerfile?;
    get dockerfile(): string;
    set dockerfile(value: string);
    resetDockerfile(): void;
    get dockerfileInput(): string | undefined;
    private _forceRemove?;
    get forceRemove(): boolean | cdktf.IResolvable;
    set forceRemove(value: boolean | cdktf.IResolvable);
    resetForceRemove(): void;
    get forceRemoveInput(): boolean | cdktf.IResolvable | undefined;
    private _label?;
    get label(): {
        [key: string]: string;
    };
    set label(value: {
        [key: string]: string;
    });
    resetLabel(): void;
    get labelInput(): {
        [key: string]: string;
    } | undefined;
    private _noCache?;
    get noCache(): boolean | cdktf.IResolvable;
    set noCache(value: boolean | cdktf.IResolvable);
    resetNoCache(): void;
    get noCacheInput(): boolean | cdktf.IResolvable | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _remove?;
    get remove(): boolean | cdktf.IResolvable;
    set remove(value: boolean | cdktf.IResolvable);
    resetRemove(): void;
    get removeInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string[];
    set tag(value: string[]);
    resetTag(): void;
    get tagInput(): string[] | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker/r/image docker_image}
*/
export declare class Image extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker/r/image docker_image} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ImageConfig
    */
    constructor(scope: Construct, id: string, config: ImageConfig);
    private _forceRemove?;
    get forceRemove(): boolean | cdktf.IResolvable;
    set forceRemove(value: boolean | cdktf.IResolvable);
    resetForceRemove(): void;
    get forceRemoveInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _keepLocally?;
    get keepLocally(): boolean | cdktf.IResolvable;
    set keepLocally(value: boolean | cdktf.IResolvable);
    resetKeepLocally(): void;
    get keepLocallyInput(): boolean | cdktf.IResolvable | undefined;
    get latest(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get output(): string;
    private _pullTrigger?;
    get pullTrigger(): string;
    set pullTrigger(value: string);
    resetPullTrigger(): void;
    get pullTriggerInput(): string | undefined;
    private _pullTriggers?;
    get pullTriggers(): string[];
    set pullTriggers(value: string[]);
    resetPullTriggers(): void;
    get pullTriggersInput(): string[] | undefined;
    get repoDigest(): string;
    private _build;
    get buildAttribute(): ImageBuildOutputReference;
    putBuildAttribute(value: ImageBuild): void;
    resetBuildAttribute(): void;
    get buildAttributeInput(): ImageBuild | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
