import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enable manual container attachment to the network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#attachable Network#attachable}
    */
    readonly attachable?: boolean | cdktf.IResolvable;
    /**
    * Requests daemon to check for networks with same name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#check_duplicate Network#check_duplicate}
    */
    readonly checkDuplicate?: boolean | cdktf.IResolvable;
    /**
    * The driver of the Docker network. Possible values are `bridge`, `host`, `overlay`, `macvlan`. See [network docs](https://docs.docker.com/network/#network-drivers) for more details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#driver Network#driver}
    */
    readonly driver?: string;
    /**
    * Create swarm routing-mesh network. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#ingress Network#ingress}
    */
    readonly ingress?: boolean | cdktf.IResolvable;
    /**
    * Whether the network is internal.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#internal Network#internal}
    */
    readonly internal?: boolean | cdktf.IResolvable;
    /**
    * Driver used by the custom IP scheme of the network. Defaults to `default`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#ipam_driver Network#ipam_driver}
    */
    readonly ipamDriver?: string;
    /**
    * Enable IPv6 networking. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#ipv6 Network#ipv6}
    */
    readonly ipv6?: boolean | cdktf.IResolvable;
    /**
    * The name of the Docker network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#name Network#name}
    */
    readonly name: string;
    /**
    * Only available with bridge networks. See [bridge options docs](https://docs.docker.com/engine/reference/commandline/network_create/#bridge-driver-options) for more details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#options Network#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * ipam_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#ipam_config Network#ipam_config}
    */
    readonly ipamConfig?: NetworkIpamConfig[] | cdktf.IResolvable;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#labels Network#labels}
    */
    readonly labels?: NetworkLabels[] | cdktf.IResolvable;
}
export interface NetworkIpamConfig {
    /**
    * Auxiliary IPv4 or IPv6 addresses used by Network driver
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#aux_address Network#aux_address}
    */
    readonly auxAddress?: {
        [key: string]: string;
    };
    /**
    * The IP address of the gateway
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#gateway Network#gateway}
    */
    readonly gateway?: string;
    /**
    * The ip range in CIDR form
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#ip_range Network#ip_range}
    */
    readonly ipRange?: string;
    /**
    * The subnet in CIDR form
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#subnet Network#subnet}
    */
    readonly subnet?: string;
}
export declare function networkIpamConfigToTerraform(struct?: NetworkIpamConfig | cdktf.IResolvable): any;
export interface NetworkLabels {
    /**
    * Name of the label
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#label Network#label}
    */
    readonly label: string;
    /**
    * Value of the label
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/network#value Network#value}
    */
    readonly value: string;
}
export declare function networkLabelsToTerraform(struct?: NetworkLabels | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker/r/network docker_network}
*/
export declare class Network extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker/r/network docker_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkConfig
    */
    constructor(scope: Construct, id: string, config: NetworkConfig);
    private _attachable?;
    get attachable(): boolean | cdktf.IResolvable;
    set attachable(value: boolean | cdktf.IResolvable);
    resetAttachable(): void;
    get attachableInput(): boolean | cdktf.IResolvable | undefined;
    private _checkDuplicate?;
    get checkDuplicate(): boolean | cdktf.IResolvable;
    set checkDuplicate(value: boolean | cdktf.IResolvable);
    resetCheckDuplicate(): void;
    get checkDuplicateInput(): boolean | cdktf.IResolvable | undefined;
    private _driver?;
    get driver(): string;
    set driver(value: string);
    resetDriver(): void;
    get driverInput(): string | undefined;
    get id(): string;
    private _ingress?;
    get ingress(): boolean | cdktf.IResolvable;
    set ingress(value: boolean | cdktf.IResolvable);
    resetIngress(): void;
    get ingressInput(): boolean | cdktf.IResolvable | undefined;
    private _internal?;
    get internal(): boolean | cdktf.IResolvable;
    set internal(value: boolean | cdktf.IResolvable);
    resetInternal(): void;
    get internalInput(): boolean | cdktf.IResolvable | undefined;
    private _ipamDriver?;
    get ipamDriver(): string;
    set ipamDriver(value: string);
    resetIpamDriver(): void;
    get ipamDriverInput(): string | undefined;
    private _ipv6?;
    get ipv6(): boolean | cdktf.IResolvable;
    set ipv6(value: boolean | cdktf.IResolvable);
    resetIpv6(): void;
    get ipv6Input(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    get scope(): string;
    private _ipamConfig?;
    get ipamConfig(): NetworkIpamConfig[] | cdktf.IResolvable;
    set ipamConfig(value: NetworkIpamConfig[] | cdktf.IResolvable);
    resetIpamConfig(): void;
    get ipamConfigInput(): cdktf.IResolvable | NetworkIpamConfig[] | undefined;
    private _labels?;
    get labels(): NetworkLabels[] | cdktf.IResolvable;
    set labels(value: NetworkLabels[] | cdktf.IResolvable);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | NetworkLabels[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
