import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PluginConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docker Plugin alias
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/plugin#alias Plugin#alias}
    */
    readonly alias?: string;
    /**
    * HTTP client timeout to enable the plugin
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/plugin#enable_timeout Plugin#enable_timeout}
    */
    readonly enableTimeout?: number;
    /**
    * If `true` the plugin is enabled. Defaults to `true`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/plugin#enabled Plugin#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The environment variables in the form of `KEY=VALUE`, e.g. `DEBUG=0`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/plugin#env Plugin#env}
    */
    readonly env?: string[];
    /**
    * If true, then the plugin is destroyed forcibly
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/plugin#force_destroy Plugin#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * If true, then the plugin is disabled forcibly
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/plugin#force_disable Plugin#force_disable}
    */
    readonly forceDisable?: boolean | cdktf.IResolvable;
    /**
    * If true, grant all permissions necessary to run the plugin
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/plugin#grant_all_permissions Plugin#grant_all_permissions}
    */
    readonly grantAllPermissions?: boolean | cdktf.IResolvable;
    /**
    * Docker Plugin name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/plugin#name Plugin#name}
    */
    readonly name: string;
    /**
    * grant_permissions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/plugin#grant_permissions Plugin#grant_permissions}
    */
    readonly grantPermissions?: PluginGrantPermissions[] | cdktf.IResolvable;
}
export interface PluginGrantPermissions {
    /**
    * The name of the permission
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/plugin#name Plugin#name}
    */
    readonly name: string;
    /**
    * The value of the permission
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/plugin#value Plugin#value}
    */
    readonly value: string[];
}
export declare function pluginGrantPermissionsToTerraform(struct?: PluginGrantPermissions | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker/r/plugin docker_plugin}
*/
export declare class Plugin extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker/r/plugin docker_plugin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PluginConfig
    */
    constructor(scope: Construct, id: string, config: PluginConfig);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _enableTimeout?;
    get enableTimeout(): number;
    set enableTimeout(value: number);
    resetEnableTimeout(): void;
    get enableTimeoutInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _env?;
    get env(): string[];
    set env(value: string[]);
    resetEnv(): void;
    get envInput(): string[] | undefined;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _forceDisable?;
    get forceDisable(): boolean | cdktf.IResolvable;
    set forceDisable(value: boolean | cdktf.IResolvable);
    resetForceDisable(): void;
    get forceDisableInput(): boolean | cdktf.IResolvable | undefined;
    private _grantAllPermissions?;
    get grantAllPermissions(): boolean | cdktf.IResolvable;
    set grantAllPermissions(value: boolean | cdktf.IResolvable);
    resetGrantAllPermissions(): void;
    get grantAllPermissionsInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get pluginReference(): string;
    private _grantPermissions?;
    get grantPermissions(): PluginGrantPermissions[] | cdktf.IResolvable;
    set grantPermissions(value: PluginGrantPermissions[] | cdktf.IResolvable);
    resetGrantPermissions(): void;
    get grantPermissionsInput(): cdktf.IResolvable | PluginGrantPermissions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
