import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RegistryImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#insecure_skip_verify RegistryImage#insecure_skip_verify}
    */
    readonly insecureSkipVerify?: boolean | cdktf.IResolvable;
    /**
    * If true, then the Docker image won't be deleted on destroy operation. If this is false, it will delete the image from the docker registry on destroy operation. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#keep_remotely RegistryImage#keep_remotely}
    */
    readonly keepRemotely?: boolean | cdktf.IResolvable;
    /**
    * The name of the Docker image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#name RegistryImage#name}
    */
    readonly name: string;
    /**
    * build block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#build RegistryImage#build}
    */
    readonly buildAttribute?: RegistryImageBuild;
}
export interface RegistryImageBuildAuthConfig {
    /**
    * the auth token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#auth RegistryImage#auth}
    */
    readonly auth?: string;
    /**
    * the user emal
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#email RegistryImage#email}
    */
    readonly email?: string;
    /**
    * hostname of the registry
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#host_name RegistryImage#host_name}
    */
    readonly hostName: string;
    /**
    * the identity token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#identity_token RegistryImage#identity_token}
    */
    readonly identityToken?: string;
    /**
    * the registry password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#password RegistryImage#password}
    */
    readonly password?: string;
    /**
    * the registry token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#registry_token RegistryImage#registry_token}
    */
    readonly registryToken?: string;
    /**
    * the server address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#server_address RegistryImage#server_address}
    */
    readonly serverAddress?: string;
    /**
    * the registry user name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#user_name RegistryImage#user_name}
    */
    readonly userName?: string;
}
export declare function registryImageBuildAuthConfigToTerraform(struct?: RegistryImageBuildAuthConfig | cdktf.IResolvable): any;
export interface RegistryImageBuildUlimit {
    /**
    * soft limit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#hard RegistryImage#hard}
    */
    readonly hard: number;
    /**
    * type of ulimit, e.g. `nofile`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#name RegistryImage#name}
    */
    readonly name: string;
    /**
    * hard limit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#soft RegistryImage#soft}
    */
    readonly soft: number;
}
export declare function registryImageBuildUlimitToTerraform(struct?: RegistryImageBuildUlimit | cdktf.IResolvable): any;
export interface RegistryImageBuild {
    /**
    * Pairs for build-time variables in the form TODO
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#build_args RegistryImage#build_args}
    */
    readonly buildArgs?: {
        [key: string]: string;
    };
    /**
    * BuildID is an optional identifier that can be passed together with the build request. The same identifier can be used to gracefully cancel the build with the cancel request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#build_id RegistryImage#build_id}
    */
    readonly buildId?: string;
    /**
    * Images to consider as cache sources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#cache_from RegistryImage#cache_from}
    */
    readonly cacheFrom?: string[];
    /**
    * Optional parent cgroup for the container
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#cgroup_parent RegistryImage#cgroup_parent}
    */
    readonly cgroupParent?: string;
    /**
    * The absolute path to the context folder. You can use the helper function '${path.cwd}/context-dir'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#context RegistryImage#context}
    */
    readonly context: string;
    /**
    * The length of a CPU period in microseconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#cpu_period RegistryImage#cpu_period}
    */
    readonly cpuPeriod?: number;
    /**
    * Microseconds of CPU time that the container can get in a CPU period
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#cpu_quota RegistryImage#cpu_quota}
    */
    readonly cpuQuota?: number;
    /**
    * CPUs in which to allow execution (e.g., `0-3`, `0`, `1`)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#cpu_set_cpus RegistryImage#cpu_set_cpus}
    */
    readonly cpuSetCpus?: string;
    /**
    * MEMs in which to allow execution (`0-3`, `0`, `1`)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#cpu_set_mems RegistryImage#cpu_set_mems}
    */
    readonly cpuSetMems?: string;
    /**
    * CPU shares (relative weight)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#cpu_shares RegistryImage#cpu_shares}
    */
    readonly cpuShares?: number;
    /**
    * Dockerfile file. Defaults to `Dockerfile`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#dockerfile RegistryImage#dockerfile}
    */
    readonly dockerfile?: string;
    /**
    * A list of hostnames/IP mappings to add to the container’s /etc/hosts file. Specified in the form ["hostname:IP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#extra_hosts RegistryImage#extra_hosts}
    */
    readonly extraHosts?: string[];
    /**
    * Always remove intermediate containers
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#force_remove RegistryImage#force_remove}
    */
    readonly forceRemove?: boolean | cdktf.IResolvable;
    /**
    * Isolation represents the isolation technology of a container. The supported values are
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#isolation RegistryImage#isolation}
    */
    readonly isolation?: string;
    /**
    * User-defined key/value metadata
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#labels RegistryImage#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Set memory limit for build
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#memory RegistryImage#memory}
    */
    readonly memory?: number;
    /**
    * Total memory (memory + swap), -1 to enable unlimited swap
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#memory_swap RegistryImage#memory_swap}
    */
    readonly memorySwap?: number;
    /**
    * Set the networking mode for the RUN instructions during build
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#network_mode RegistryImage#network_mode}
    */
    readonly networkMode?: string;
    /**
    * Do not use the cache when building the image
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#no_cache RegistryImage#no_cache}
    */
    readonly noCache?: boolean | cdktf.IResolvable;
    /**
    * Set platform if server is multi-platform capable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#platform RegistryImage#platform}
    */
    readonly platform?: string;
    /**
    * Attempt to pull the image even if an older image exists locally
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#pull_parent RegistryImage#pull_parent}
    */
    readonly pullParent?: boolean | cdktf.IResolvable;
    /**
    * A Git repository URI or HTTP/HTTPS context URI
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#remote_context RegistryImage#remote_context}
    */
    readonly remoteContext?: string;
    /**
    * Remove intermediate containers after a successful build (default behavior)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#remove RegistryImage#remove}
    */
    readonly remove?: boolean | cdktf.IResolvable;
    /**
    * The security options
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#security_opt RegistryImage#security_opt}
    */
    readonly securityOpt?: string[];
    /**
    * Set an ID for the build session
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#session_id RegistryImage#session_id}
    */
    readonly sessionId?: string;
    /**
    * Size of /dev/shm in bytes. The size must be greater than 0
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#shm_size RegistryImage#shm_size}
    */
    readonly shmSize?: number;
    /**
    * If true the new layers are squashed into a new image with a single new layer
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#squash RegistryImage#squash}
    */
    readonly squash?: boolean | cdktf.IResolvable;
    /**
    * Suppress the build output and print image ID on success
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#suppress_output RegistryImage#suppress_output}
    */
    readonly suppressOutput?: boolean | cdktf.IResolvable;
    /**
    * Set the target build stage to build
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#target RegistryImage#target}
    */
    readonly target?: string;
    /**
    * Version of the underlying builder to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#version RegistryImage#version}
    */
    readonly version?: string;
    /**
    * auth_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#auth_config RegistryImage#auth_config}
    */
    readonly authConfig?: RegistryImageBuildAuthConfig[] | cdktf.IResolvable;
    /**
    * ulimit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/registry_image#ulimit RegistryImage#ulimit}
    */
    readonly ulimit?: RegistryImageBuildUlimit[] | cdktf.IResolvable;
}
export declare function registryImageBuildToTerraform(struct?: RegistryImageBuildOutputReference | RegistryImageBuild): any;
export declare class RegistryImageBuildOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RegistryImageBuild | undefined;
    set internalValue(value: RegistryImageBuild | undefined);
    private _buildArgs?;
    get buildArgs(): {
        [key: string]: string;
    };
    set buildArgs(value: {
        [key: string]: string;
    });
    resetBuildArgs(): void;
    get buildArgsInput(): {
        [key: string]: string;
    } | undefined;
    private _buildId?;
    get buildId(): string;
    set buildId(value: string);
    resetBuildId(): void;
    get buildIdInput(): string | undefined;
    private _cacheFrom?;
    get cacheFrom(): string[];
    set cacheFrom(value: string[]);
    resetCacheFrom(): void;
    get cacheFromInput(): string[] | undefined;
    private _cgroupParent?;
    get cgroupParent(): string;
    set cgroupParent(value: string);
    resetCgroupParent(): void;
    get cgroupParentInput(): string | undefined;
    private _context?;
    get context(): string;
    set context(value: string);
    get contextInput(): string | undefined;
    private _cpuPeriod?;
    get cpuPeriod(): number;
    set cpuPeriod(value: number);
    resetCpuPeriod(): void;
    get cpuPeriodInput(): number | undefined;
    private _cpuQuota?;
    get cpuQuota(): number;
    set cpuQuota(value: number);
    resetCpuQuota(): void;
    get cpuQuotaInput(): number | undefined;
    private _cpuSetCpus?;
    get cpuSetCpus(): string;
    set cpuSetCpus(value: string);
    resetCpuSetCpus(): void;
    get cpuSetCpusInput(): string | undefined;
    private _cpuSetMems?;
    get cpuSetMems(): string;
    set cpuSetMems(value: string);
    resetCpuSetMems(): void;
    get cpuSetMemsInput(): string | undefined;
    private _cpuShares?;
    get cpuShares(): number;
    set cpuShares(value: number);
    resetCpuShares(): void;
    get cpuSharesInput(): number | undefined;
    private _dockerfile?;
    get dockerfile(): string;
    set dockerfile(value: string);
    resetDockerfile(): void;
    get dockerfileInput(): string | undefined;
    private _extraHosts?;
    get extraHosts(): string[];
    set extraHosts(value: string[]);
    resetExtraHosts(): void;
    get extraHostsInput(): string[] | undefined;
    private _forceRemove?;
    get forceRemove(): boolean | cdktf.IResolvable;
    set forceRemove(value: boolean | cdktf.IResolvable);
    resetForceRemove(): void;
    get forceRemoveInput(): boolean | cdktf.IResolvable | undefined;
    private _isolation?;
    get isolation(): string;
    set isolation(value: string);
    resetIsolation(): void;
    get isolationInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _memory?;
    get memory(): number;
    set memory(value: number);
    resetMemory(): void;
    get memoryInput(): number | undefined;
    private _memorySwap?;
    get memorySwap(): number;
    set memorySwap(value: number);
    resetMemorySwap(): void;
    get memorySwapInput(): number | undefined;
    private _networkMode?;
    get networkMode(): string;
    set networkMode(value: string);
    resetNetworkMode(): void;
    get networkModeInput(): string | undefined;
    private _noCache?;
    get noCache(): boolean | cdktf.IResolvable;
    set noCache(value: boolean | cdktf.IResolvable);
    resetNoCache(): void;
    get noCacheInput(): boolean | cdktf.IResolvable | undefined;
    private _platform?;
    get platform(): string;
    set platform(value: string);
    resetPlatform(): void;
    get platformInput(): string | undefined;
    private _pullParent?;
    get pullParent(): boolean | cdktf.IResolvable;
    set pullParent(value: boolean | cdktf.IResolvable);
    resetPullParent(): void;
    get pullParentInput(): boolean | cdktf.IResolvable | undefined;
    private _remoteContext?;
    get remoteContext(): string;
    set remoteContext(value: string);
    resetRemoteContext(): void;
    get remoteContextInput(): string | undefined;
    private _remove?;
    get remove(): boolean | cdktf.IResolvable;
    set remove(value: boolean | cdktf.IResolvable);
    resetRemove(): void;
    get removeInput(): boolean | cdktf.IResolvable | undefined;
    private _securityOpt?;
    get securityOpt(): string[];
    set securityOpt(value: string[]);
    resetSecurityOpt(): void;
    get securityOptInput(): string[] | undefined;
    private _sessionId?;
    get sessionId(): string;
    set sessionId(value: string);
    resetSessionId(): void;
    get sessionIdInput(): string | undefined;
    private _shmSize?;
    get shmSize(): number;
    set shmSize(value: number);
    resetShmSize(): void;
    get shmSizeInput(): number | undefined;
    private _squash?;
    get squash(): boolean | cdktf.IResolvable;
    set squash(value: boolean | cdktf.IResolvable);
    resetSquash(): void;
    get squashInput(): boolean | cdktf.IResolvable | undefined;
    private _suppressOutput?;
    get suppressOutput(): boolean | cdktf.IResolvable;
    set suppressOutput(value: boolean | cdktf.IResolvable);
    resetSuppressOutput(): void;
    get suppressOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _authConfig?;
    get authConfig(): RegistryImageBuildAuthConfig[] | cdktf.IResolvable;
    set authConfig(value: RegistryImageBuildAuthConfig[] | cdktf.IResolvable);
    resetAuthConfig(): void;
    get authConfigInput(): cdktf.IResolvable | RegistryImageBuildAuthConfig[] | undefined;
    private _ulimit?;
    get ulimit(): RegistryImageBuildUlimit[] | cdktf.IResolvable;
    set ulimit(value: RegistryImageBuildUlimit[] | cdktf.IResolvable);
    resetUlimit(): void;
    get ulimitInput(): cdktf.IResolvable | RegistryImageBuildUlimit[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker/r/registry_image docker_registry_image}
*/
export declare class RegistryImage extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker/r/registry_image docker_registry_image} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RegistryImageConfig
    */
    constructor(scope: Construct, id: string, config: RegistryImageConfig);
    get id(): string;
    private _insecureSkipVerify?;
    get insecureSkipVerify(): boolean | cdktf.IResolvable;
    set insecureSkipVerify(value: boolean | cdktf.IResolvable);
    resetInsecureSkipVerify(): void;
    get insecureSkipVerifyInput(): boolean | cdktf.IResolvable | undefined;
    private _keepRemotely?;
    get keepRemotely(): boolean | cdktf.IResolvable;
    set keepRemotely(value: boolean | cdktf.IResolvable);
    resetKeepRemotely(): void;
    get keepRemotelyInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get sha256Digest(): string;
    private _build;
    get buildAttribute(): RegistryImageBuildOutputReference;
    putBuildAttribute(value: RegistryImageBuild): void;
    resetBuildAttribute(): void;
    get buildAttributeInput(): RegistryImageBuild | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
