import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Base64-url-safe-encoded secret data
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/secret#data Secret#data}
    */
    readonly data: string;
    /**
    * User-defined name of the secret
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/secret#name Secret#name}
    */
    readonly name: string;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/secret#labels Secret#labels}
    */
    readonly labels?: SecretLabels[] | cdktf.IResolvable;
}
export interface SecretLabels {
    /**
    * Name of the label
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/secret#label Secret#label}
    */
    readonly label: string;
    /**
    * Value of the label
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/secret#value Secret#value}
    */
    readonly value: string;
}
export declare function secretLabelsToTerraform(struct?: SecretLabels | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker/r/secret docker_secret}
*/
export declare class Secret extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker/r/secret docker_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecretConfig
    */
    constructor(scope: Construct, id: string, config: SecretConfig);
    private _data?;
    get data(): string;
    set data(value: string);
    get dataInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _labels?;
    get labels(): SecretLabels[] | cdktf.IResolvable;
    set labels(value: SecretLabels[] | cdktf.IResolvable);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | SecretLabels[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
