import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Driver type for the volume. Defaults to `local`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/volume#driver Volume#driver}
    */
    readonly driver?: string;
    /**
    * Options specific to the driver.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/volume#driver_opts Volume#driver_opts}
    */
    readonly driverOpts?: {
        [key: string]: string;
    };
    /**
    * The name of the Docker volume (will be generated if not provided).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/volume#name Volume#name}
    */
    readonly name?: string;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/volume#labels Volume#labels}
    */
    readonly labels?: VolumeLabels[] | cdktf.IResolvable;
}
export interface VolumeLabels {
    /**
    * Name of the label
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/volume#label Volume#label}
    */
    readonly label: string;
    /**
    * Value of the label
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/docker/r/volume#value Volume#value}
    */
    readonly value: string;
}
export declare function volumeLabelsToTerraform(struct?: VolumeLabels | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/docker/r/volume docker_volume}
*/
export declare class Volume extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/docker/r/volume docker_volume} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VolumeConfig = {}
    */
    constructor(scope: Construct, id: string, config?: VolumeConfig);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    resetDriver(): void;
    get driverInput(): string | undefined;
    private _driverOpts?;
    get driverOpts(): {
        [key: string]: string;
    };
    set driverOpts(value: {
        [key: string]: string;
    });
    resetDriverOpts(): void;
    get driverOptsInput(): {
        [key: string]: string;
    } | undefined;
    get id(): string;
    get mountpoint(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _labels?;
    get labels(): VolumeLabels[] | cdktf.IResolvable;
    set labels(value: VolumeLabels[] | cdktf.IResolvable);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | VolumeLabels[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
