from .evm_net import (
  EvmNetData,
  EvmNetConstants,
  EVM_NET_DATA,
  EVM_NET_CONSTANTS,
  EVM_ABI_DATA,
)

EE_ID = 'EE_ID'
SB_ID = 'SB_ID'  # change to SB_ID = EE_ID post mod from sb to ee

class ETHVarTypes:
  ETH_ADDR = 'address'
  ETH_INT = 'uint256'
  ETH_STR = 'string'
  ETH_ARRAY_INT = 'uint256[]'
  ETH_ARRAY_STR = 'string[]'

class BCctbase: 
  SIGN      = 'EE_SIGN'
  SENDER    = 'EE_SENDER'
  HASH      = 'EE_HASH'
  
  ETH_SIGN  = 'EE_ETH_SIGN'
  ETH_SENDER= 'EE_ETH_SENDER'


EE_VPN_IMPL_ENV_KEY = 'EE_VPN_IMPL'

DAUTH_SUBKEY = 'auth'
DAUTH_ENV_KEY = 'EE_DAUTH_URL'
DAUTH_NONCE = 'nonce'
DAUTH_VARS = [DAUTH_NONCE, BCctbase.SIGN, BCctbase.SENDER, BCctbase.HASH]


EE_SDK_ALIAS_ENV_KEY = "EE_SDK_ALIAS"
EE_SDK_ALIAS_DEFAULT = "R1SDK"



class dAuth:
  EVM_ABI_DATA = EVM_ABI_DATA
  EvmNetData = EvmNetData
  EVM_NET_DATA = EVM_NET_DATA
    
  DAUTH_NET_ENV_KEY = 'EE_EVM_NET'
  DAUTH_SDK_NET_DEFAULT = 'mainnet'
    
  DAUTH_SENDER_ALIAS = 'sender_alias'
  DAUTH_SENDER_ALIAS_DEFAULT = 'direct-call'
  DAUTH_SENDER_CORE_VER = 'sender_core_ver'
  DAUTH_SENDER_SDK_VER = 'sender_sdk_ver'
  DAUTH_SENDER_APP_VER = 'sender_app_ver'
  DAUTH_REQUEST = 'request'
  
  DAUTH_ENV_KEYS_PREFIX = 'EE_'
  
  DAUTH_ALIAS_UNK = 'unknown-alias'
  DAUTH_ADDR_UNK =  'unknown-address'
  
  DAUTH_SERVER_ALIAS = 'server_alias'
  
  DAUTH_WHITELIST = 'whitelist'
  
  DAUTH_SUBKEY = DAUTH_SUBKEY
  DAUTH_NONCE = DAUTH_NONCE
  DAUTH_VARS = DAUTH_VARS
  
  DAUTH_SERVER_INFO = 'server_info'
  DAUTH_SERVER_IS_SEED = "is_seed_server"
  DAUTH_SENDER_TYPE = 'sender_type'
  DAUTH_SENDER_TYPE_CORE = 'core'
  DAUTH_SENDER_TYPE_SDK = 'sdk'
  DAUTH_SENDER_TYPE_NODE = 'node'
  DAUTH_SENDER_ETH = 'sender_eth_addr'
  
# end class dAuth

ETH_ENABLED_ENV_KEY = 'EE_ETH_ENABLED'

EE_EPOCH_INTERVALS_KEY = 'EE_EPOCH_INTERVALS'
EE_EPOCH_INTERVAL_SECONDS_KEY = 'EE_EPOCH_INTERVAL_SECONDS'


class LocalInfo:
  LOCAL_INFO_FILE = 'local_info.json'
  K_ADDRESS = 'address'
  K_ALIAS = 'alias'
  K_ETH_ADDRESS = 'eth_address'
  K_VER_LONG = 'version_long'
  K_VER_SHORT = 'version_short'
  K_INFO = 'info'
    

class BCct:
  SIGN        = BCctbase.SIGN
  SENDER      = BCctbase.SENDER
  HASH        = BCctbase.HASH
  ETH_SIGN    = BCctbase.ETH_SIGN
  ETH_SENDER  = BCctbase.ETH_SENDER
  
  ADDR_PREFIX_OLD = "aixp_"
  ADDR_PREFIX   = "0xai_"
  
  K_USER_CONFIG_PEM_FILE = 'NAEURAL_PEM_FILE'
  K_PEM_FILE = 'PEM_FILE'
  K_PASSWORD = 'PASSWORD'
  K_PEM_LOCATION = 'PEM_LOCATION'
  
  ERR_UNAVL_MSG = "Missing signature/sender data"
  ERR_UNAVL = 1

  ERR_SIGN_MSG = "Bad hash"
  ERR_UNAVL = 1000

  ERR_SIGN_MSG = "Bad signature"
  ERR_UNAVL = 1001
  
  AUTHORISED_ADDRS = 'authorized_addrs'
  
  DEFAULT_INFO = '0xai handshake data'
  
  USER_PEM_FILE = '_naeural.pem'
  DEFAULT_PEM_FILE = '_pk.pem'
  DEFAULT_PEM_LOCATION = 'data'
  
BLOCKCHAIN_CONFIG = {
    "PEM_FILE": BCct.DEFAULT_PEM_FILE,
    "PASSWORD": None,
    "PEM_LOCATION": BCct.DEFAULT_PEM_LOCATION
}
  

class DCT_TYPES:
  VOID_PIPELINE = 'Void'
  NETWORK_LISTENER = 'NetworkListener'
  METASTREAM_PIPELINE = 'MetaStream'
  
  
class DCT_OPTIONS:
  NETWORK_LISTENER_PATH_FILTER = "PATH_FILTER"
  NETWORK_LISTENER_MESSAGE_FILTER = "MESSAGE_FILTER"
  ADMIN_PIPELINE_VER = 'ADMIN_PIPELINE_VER'

class CONFIG_STREAM:
  K_URL = 'URL'
  K_TYPE = 'TYPE'
  K_RECONNECTABLE = 'RECONNECTABLE'
  K_NAME = 'NAME'
  K_LIVE_FEED = 'LIVE_FEED'
  K_PLUGINS = 'PLUGINS'
  K_INSTANCES = 'INSTANCES'

  K_MODIFIED_BY_ADDR = 'MODIFIED_BY_ADDR'
  K_MODIFIED_BY_ID = 'MODIFIED_BY_ID'

  K_INITIATOR_ID = 'INITIATOR_ID'
  K_INITIATOR_ADDR = 'INITIATOR_ADDR'
  K_OWNER = 'OWNER'
  K_SESSION_ID = 'SESSION_ID'
  K_ALLOWED_PLUGINS = 'ALLOWED_PLUGINS'

  K_PIPELINE_COMMAND = 'PIPELINE_COMMAND'
  K_USE_LOCAL_COMMS_ONLY = 'USE_LOCAL_COMMS_ONLY'

  METASTREAM = DCT_TYPES.METASTREAM_PIPELINE

  INITIATOR_ID = K_INITIATOR_ID
  SESSION_ID = K_SESSION_ID
  COLLECTED_STREAMS = 'COLLECTED_STREAMS'
  STREAM_CONFIG_METADATA = 'STREAM_CONFIG_METADATA'
  CAP_RESOLUTION = 'CAP_RESOLUTION'

  LAST_UPDATE_TIME = 'LAST_UPDATE_TIME'

  IS_DEEPLOYED = 'IS_DEEPLOYED'
  DEEPLOY_SPECS = 'DEEPLOY_SPECS'

  URL = K_URL
  TYPE = K_TYPE
  RECONNECTABLE = K_RECONNECTABLE
  NAME = K_NAME
  LIVE_FEED = K_LIVE_FEED
  PLUGINS = K_PLUGINS
  INSTANCES = K_INSTANCES
  PIPELINE_COMMAND = K_PIPELINE_COMMAND
  LAST_PIPELINE_COMMAND = 'LAST_' + PIPELINE_COMMAND

  DEFAULT_PLUGINS = 'DEFAULT_PLUGINS'
  OVERWRITE_DEFAULT_PLUGIN_CONFIG = 'OVERWRITE_DEFAULT_PLUGIN_CONFIG'

  DEFAULT_PLUGIN = 'DEFAULT_PLUGIN'
  DEFAULT_PLUGIN_SIGNATURE = 'REST_CUSTOM_EXEC_01'
  DEFAULT_PLUGIN_CONFIG = 'DEFAULT_PLUGIN_CONFIG'

  ALLOWED_PLUGINS = K_ALLOWED_PLUGINS

  MANDATORY = [K_NAME, K_TYPE]

  VOID_STREAM = DCT_TYPES.VOID_PIPELINE
  
  DEFAULT_ADMIN_PIPELINE_TYPE = DCT_TYPES.NETWORK_LISTENER

  NO_DATA_STREAMS = [VOID_STREAM]
  
  PIPELINE_OPTIONS = DCT_OPTIONS
  PIPELINE_TYPES = DCT_TYPES

class BIZ_PLUGIN_DATA:
  INSTANCE_ID = 'INSTANCE_ID'
  MAX_INPUTS_QUEUE_SIZE = 'MAX_INPUTS_QUEUE_SIZE'
  COORDS = 'COORDS'
  POINTS = 'POINTS'
  INSTANCES = 'INSTANCES'
  SIGNATURE = 'SIGNATURE'
  PROCESS_DELAY = 'PROCESS_DELAY'
  ALLOW_EMPTY_INPUTS = 'ALLOW_EMPTY_INPUTS'
  RUN_WITHOUT_IMAGE = 'RUN_WITHOUT_IMAGE'
  CHAINSTORE_PEERS = 'CHAINSTORE_PEERS'
  CHAINSTORE_RESPONSE_KEY = 'CHAINSTORE_RESPONSE_KEY'


class PLUGIN_INFO:
  STREAM_ID = 'STREAM_ID'
  INSTANCE_ID = BIZ_PLUGIN_DATA.INSTANCE_ID
  SIGNATURE = BIZ_PLUGIN_DATA.SIGNATURE
  FREQUENCY = 'FREQUENCY'
  EXEC_TIMESTAMP = 'EXEC_TIMESTAMP'
  INIT_TIMESTAMP = 'INIT_TIMESTAMP'
  LAST_CONFIG_TIMESTAMP = 'LAST_CONFIG_TIMESTAMP'
  FIRST_ERROR_TIME = 'FIRST_ERROR_TIME'
  LAST_ERROR_TIME = 'LAST_ERROR_TIME'
  PROC_ITER = 'PROC_ITER'
  EXEC_ITER = 'EXEC_ITER'
  OUTSIDE_WORKING_HOURS = 'OUTSIDE_WORKING_HOURS'
  ACTIVE_PLUGINS_FIELDS = [
      STREAM_ID,
      SIGNATURE,
      INSTANCE_ID,

      FREQUENCY,
      INIT_TIMESTAMP,
      EXEC_TIMESTAMP,
      LAST_CONFIG_TIMESTAMP,
      FIRST_ERROR_TIME,
      LAST_ERROR_TIME,
      OUTSIDE_WORKING_HOURS,
  ]


EE_DATE_TIME_FORMAT = "%Y.%m.%d_%H:%M:%S"
