"""Add is_default to taxonomy fields

Revision ID: f131a1263a10
Revises: f53e04e5b7f5
Create Date: 2022-08-10 16:25:13.754740

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "f131a1263a10"
down_revision = "f53e04e5b7f5"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "data_categories", sa.Column("is_default", sa.BOOLEAN(), nullable=True)
    )
    op.drop_index("ix_data_categories_id", table_name="data_categories")
    op.create_index(
        op.f("ix_data_categories_id"), "data_categories", ["id"], unique=False
    )
    op.add_column(
        "data_qualifiers", sa.Column("is_default", sa.BOOLEAN(), nullable=True)
    )
    op.drop_index("ix_data_qualifiers_id", table_name="data_qualifiers")
    op.create_index(
        op.f("ix_data_qualifiers_id"), "data_qualifiers", ["id"], unique=False
    )
    op.add_column("data_subjects", sa.Column("is_default", sa.BOOLEAN(), nullable=True))
    op.drop_index("ix_data_subjects_id", table_name="data_subjects")
    op.create_index(op.f("ix_data_subjects_id"), "data_subjects", ["id"], unique=False)
    op.add_column("data_uses", sa.Column("is_default", sa.BOOLEAN(), nullable=True))
    op.drop_index("ix_data_uses_id", table_name="data_uses")
    op.create_index(op.f("ix_data_uses_id"), "data_uses", ["id"], unique=False)
    op.drop_index("ix_datasets_id", table_name="datasets")
    op.create_index(op.f("ix_datasets_id"), "datasets", ["id"], unique=False)
    op.drop_index("ix_evaluations_id", table_name="evaluations")
    op.create_index(op.f("ix_evaluations_id"), "evaluations", ["id"], unique=False)
    op.drop_index("ix_organizations_id", table_name="organizations")
    op.create_index(op.f("ix_organizations_id"), "organizations", ["id"], unique=False)
    op.drop_index("ix_policies_id", table_name="policies")
    op.create_index(op.f("ix_policies_id"), "policies", ["id"], unique=False)
    op.drop_index("ix_registries_id", table_name="registries")
    op.create_index(op.f("ix_registries_id"), "registries", ["id"], unique=False)
    op.drop_index("ix_systems_id", table_name="systems")
    op.create_index(op.f("ix_systems_id"), "systems", ["id"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_systems_id"), table_name="systems")
    op.create_index("ix_systems_id", "systems", ["id"], unique=False)
    op.drop_index(op.f("ix_registries_id"), table_name="registries")
    op.create_index("ix_registries_id", "registries", ["id"], unique=False)
    op.drop_index(op.f("ix_policies_id"), table_name="policies")
    op.create_index("ix_policies_id", "policies", ["id"], unique=False)
    op.drop_index(op.f("ix_organizations_id"), table_name="organizations")
    op.create_index("ix_organizations_id", "organizations", ["id"], unique=False)
    op.drop_index(op.f("ix_evaluations_id"), table_name="evaluations")
    op.create_index("ix_evaluations_id", "evaluations", ["id"], unique=False)
    op.drop_index(op.f("ix_datasets_id"), table_name="datasets")
    op.create_index("ix_datasets_id", "datasets", ["id"], unique=False)
    op.drop_index(op.f("ix_data_uses_id"), table_name="data_uses")
    op.create_index("ix_data_uses_id", "data_uses", ["id"], unique=False)
    op.drop_column("data_uses", "is_default")
    op.drop_index(op.f("ix_data_subjects_id"), table_name="data_subjects")
    op.create_index("ix_data_subjects_id", "data_subjects", ["id"], unique=False)
    op.drop_column("data_subjects", "is_default")
    op.drop_index(op.f("ix_data_qualifiers_id"), table_name="data_qualifiers")
    op.create_index("ix_data_qualifiers_id", "data_qualifiers", ["id"], unique=False)
    op.drop_column("data_qualifiers", "is_default")
    op.drop_index(op.f("ix_data_categories_id"), table_name="data_categories")
    op.create_index("ix_data_categories_id", "data_categories", ["id"], unique=False)
    op.drop_column("data_categories", "is_default")
    # ### end Alembic commands ###
