# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.ab_test_selection_a_inner import AbTestSelectionAInner
from rapidata.api_client.models.and_user_filter_model_filters_inner import AndUserFilterModelFiltersInner
from rapidata.api_client.models.feature_flag import FeatureFlag
from typing import Optional, Set
from typing_extensions import Self

class AddCampaignModel(BaseModel):
    """
    The model for adding a campaign to an existing pipeline.
    """ # noqa: E501
    t: StrictStr = Field(description="Discriminator value for AddCampaignModel", alias="_t")
    artifact_id: Optional[StrictStr] = Field(default=None, description="The id of the campaign artifact. If not provided a random value will be used.", alias="artifactId")
    campaign_name: StrictStr = Field(description="The name of the campaign.", alias="campaignName")
    user_filters: Optional[List[AndUserFilterModelFiltersInner]] = Field(default=None, description="The user filters to apply to the campaign.", alias="userFilters")
    validation_set_id: Optional[StrictStr] = Field(default=None, description="A validation set that should be used.", alias="validationSetId")
    selections: Optional[List[AbTestSelectionAInner]] = Field(default=None, description="The selections that the campaign should have.")
    retrieval_mode: Optional[StrictStr] = Field(default=None, description="The retrieval mode defines how rapids are retrieved from the active labeling pool.", alias="retrievalMode")
    max_iterations: Optional[StrictInt] = Field(default=None, description="The maximum number of times a user is allowed to see the same rapid.", alias="maxIterations")
    feature_flags: List[FeatureFlag] = Field(description="The feature flags that should be applied to the campaign.", alias="featureFlags")
    priority: StrictInt = Field(description="The priority of the campaign.")
    is_sticky: Optional[StrictBool] = Field(default=None, description="Indicates if the campaign is sticky.", alias="isSticky")
    is_preview_enabled: Optional[StrictBool] = Field(default=None, description="A flag to indicate whether the campaign should be put into preview mode after creation. This way the campaign will not start automatically and the user will have to manually start it.", alias="isPreviewEnabled")
    __properties: ClassVar[List[str]] = ["_t", "artifactId", "campaignName", "userFilters", "validationSetId", "selections", "retrievalMode", "maxIterations", "featureFlags", "priority", "isSticky", "isPreviewEnabled"]

    @field_validator('t')
    def t_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['AddCampaignModel']):
            raise ValueError("must be one of enum values ('AddCampaignModel')")
        return value

    @field_validator('retrieval_mode')
    def retrieval_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Random', 'Shuffled', 'Sequential']):
            raise ValueError("must be one of enum values ('Random', 'Shuffled', 'Sequential')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddCampaignModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in user_filters (list)
        _items = []
        if self.user_filters:
            for _item_user_filters in self.user_filters:
                if _item_user_filters:
                    _items.append(_item_user_filters.to_dict())
            _dict['userFilters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in selections (list)
        _items = []
        if self.selections:
            for _item_selections in self.selections:
                if _item_selections:
                    _items.append(_item_selections.to_dict())
            _dict['selections'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in feature_flags (list)
        _items = []
        if self.feature_flags:
            for _item_feature_flags in self.feature_flags:
                if _item_feature_flags:
                    _items.append(_item_feature_flags.to_dict())
            _dict['featureFlags'] = _items
        # set to None if artifact_id (nullable) is None
        # and model_fields_set contains the field
        if self.artifact_id is None and "artifact_id" in self.model_fields_set:
            _dict['artifactId'] = None

        # set to None if user_filters (nullable) is None
        # and model_fields_set contains the field
        if self.user_filters is None and "user_filters" in self.model_fields_set:
            _dict['userFilters'] = None

        # set to None if validation_set_id (nullable) is None
        # and model_fields_set contains the field
        if self.validation_set_id is None and "validation_set_id" in self.model_fields_set:
            _dict['validationSetId'] = None

        # set to None if selections (nullable) is None
        # and model_fields_set contains the field
        if self.selections is None and "selections" in self.model_fields_set:
            _dict['selections'] = None

        # set to None if retrieval_mode (nullable) is None
        # and model_fields_set contains the field
        if self.retrieval_mode is None and "retrieval_mode" in self.model_fields_set:
            _dict['retrievalMode'] = None

        # set to None if max_iterations (nullable) is None
        # and model_fields_set contains the field
        if self.max_iterations is None and "max_iterations" in self.model_fields_set:
            _dict['maxIterations'] = None

        # set to None if is_sticky (nullable) is None
        # and model_fields_set contains the field
        if self.is_sticky is None and "is_sticky" in self.model_fields_set:
            _dict['isSticky'] = None

        # set to None if is_preview_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.is_preview_enabled is None and "is_preview_enabled" in self.model_fields_set:
            _dict['isPreviewEnabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddCampaignModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_t": obj.get("_t") if obj.get("_t") is not None else 'AddCampaignModel',
            "artifactId": obj.get("artifactId"),
            "campaignName": obj.get("campaignName"),
            "userFilters": [AndUserFilterModelFiltersInner.from_dict(_item) for _item in obj["userFilters"]] if obj.get("userFilters") is not None else None,
            "validationSetId": obj.get("validationSetId"),
            "selections": [AbTestSelectionAInner.from_dict(_item) for _item in obj["selections"]] if obj.get("selections") is not None else None,
            "retrievalMode": obj.get("retrievalMode"),
            "maxIterations": obj.get("maxIterations"),
            "featureFlags": [FeatureFlag.from_dict(_item) for _item in obj["featureFlags"]] if obj.get("featureFlags") is not None else None,
            "priority": obj.get("priority"),
            "isSticky": obj.get("isSticky"),
            "isPreviewEnabled": obj.get("isPreviewEnabled")
        })
        return _obj


