# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.create_default_order_model_workflow_config import CreateDefaultOrderModelWorkflowConfig
from typing import Optional, Set
from typing_extensions import Self

class CreateDefaultOrderModel(BaseModel):
    """
    The model for creating a new order with a default pipeline.
    """ # noqa: E501
    order_name: StrictStr = Field(description="The name of the order", alias="orderName")
    dataset_name: StrictStr = Field(description="The name of the dataset", alias="datasetName")
    is_public: StrictBool = Field(description="Whether the order is public", alias="isPublic")
    workflow_config: CreateDefaultOrderModelWorkflowConfig = Field(alias="workflowConfig")
    aggregator_type: Optional[StrictStr] = Field(default='NonCommittal', alias="aggregatorType")
    __properties: ClassVar[List[str]] = ["orderName", "datasetName", "isPublic", "workflowConfig", "aggregatorType"]

    @field_validator('aggregator_type')
    def aggregator_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NonCommittal', 'MajorityVote', 'SimpleMatchup', 'LocateCluster', 'Classification', 'Locate', 'BoundingBox', 'Line', 'Transcription', 'SinglePointLocate', 'FreeText']):
            raise ValueError("must be one of enum values ('NonCommittal', 'MajorityVote', 'SimpleMatchup', 'LocateCluster', 'Classification', 'Locate', 'BoundingBox', 'Line', 'Transcription', 'SinglePointLocate', 'FreeText')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateDefaultOrderModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of workflow_config
        if self.workflow_config:
            _dict['workflowConfig'] = self.workflow_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateDefaultOrderModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderName": obj.get("orderName"),
            "datasetName": obj.get("datasetName"),
            "isPublic": obj.get("isPublic"),
            "workflowConfig": CreateDefaultOrderModelWorkflowConfig.from_dict(obj["workflowConfig"]) if obj.get("workflowConfig") is not None else None,
            "aggregatorType": obj.get("aggregatorType") if obj.get("aggregatorType") is not None else 'NonCommittal'
        })
        return _obj


