# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.page_info import PageInfo
from rapidata.api_client.models.root_filter import RootFilter
from rapidata.api_client.models.sort_criterion import SortCriterion
from typing import Optional, Set
from typing_extensions import Self

class QueryValidationSetModel(BaseModel):
    """
    The model for querying validation sets.
    """ # noqa: E501
    page_info: Optional[PageInfo] = Field(default=None, alias="pageInfo")
    filter: Optional[RootFilter] = None
    sort_criteria: Optional[List[SortCriterion]] = Field(default=None, description="The sorting criteria to apply.", alias="sortCriteria")
    __properties: ClassVar[List[str]] = ["pageInfo", "filter", "sortCriteria"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QueryValidationSetModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of page_info
        if self.page_info:
            _dict['pageInfo'] = self.page_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of filter
        if self.filter:
            _dict['filter'] = self.filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sort_criteria (list)
        _items = []
        if self.sort_criteria:
            for _item_sort_criteria in self.sort_criteria:
                if _item_sort_criteria:
                    _items.append(_item_sort_criteria.to_dict())
            _dict['sortCriteria'] = _items
        # set to None if sort_criteria (nullable) is None
        # and model_fields_set contains the field
        if self.sort_criteria is None and "sort_criteria" in self.model_fields_set:
            _dict['sortCriteria'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QueryValidationSetModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pageInfo": PageInfo.from_dict(obj["pageInfo"]) if obj.get("pageInfo") is not None else None,
            "filter": RootFilter.from_dict(obj["filter"]) if obj.get("filter") is not None else None,
            "sortCriteria": [SortCriterion.from_dict(_item) for _item in obj["sortCriteria"]] if obj.get("sortCriteria") is not None else None
        })
        return _obj


