# Generated by Django 4.2.16 on 2024-12-05 13:18

import django.contrib.postgres.fields
import django.contrib.postgres.search
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    replaces = [
        ("ansible", "0001_initial"),
        ("ansible", "0002_advanced_collections"),
        ("ansible", "0003_add_tags_and_collectionversion_fields"),
        ("ansible", "0004_add_fulltext_search_indexes"),
        ("ansible", "0005_collectionversion_is_highest"),
        ("ansible", "0006_remove_whitelist_and_alter_collection_version_name"),
        ("ansible", "0007_collectionversion_is_certified"),
        ("ansible", "0008_collectionremote_requirements_file"),
        ("ansible", "0009_collectionimport"),
        ("ansible", "0010_ansible_related_names"),
        ("ansible", "0011_collectionimport"),
        ("ansible", "0012_auto_20190906_2253"),
        ("ansible", "0013_pulp_fields"),
        ("ansible", "0014_certification_enum"),
        ("ansible", "0015_ansiblerepository"),
        ("ansible", "0016_add_extension"),
        ("ansible", "0017_increase_length_collectionversion_fields"),
        ("ansible", "0018_fix_collection_relative_path"),
        ("ansible", "0019_collection_token"),
        ("ansible", "0020_auto_20200810_1926"),
        ("ansible", "0021_rename_role_remote"),
        ("ansible", "0022_URLField_to_CharField"),
        ("ansible", "0023_alter_requirements_file_field"),
        ("ansible", "0024_remove_collectionversion_certification"),
        ("ansible", "0025_increase_collection_version_version_size"),
        ("ansible", "0026_deprecation_per_repository"),
        ("ansible", "0027_tag_length"),
        ("ansible", "0028_collectionversion_namespace_length"),
        ("ansible", "0029_manifest_and_files_json_fields"),
        ("ansible", "0030_collectionversion_requires_ansible"),
        ("ansible", "0031_ansiblerepository_last_synced_metadata_time"),
        ("ansible", "0032_collectionremote_sync_dependencies"),
        ("ansible", "0033_swap_distribution_model"),
        ("ansible", "0034_handle_jsonfield_warnings"),
        ("ansible", "0035_deprecation_content"),
        ("ansible", "0036_update_repository_content"),
        ("ansible", "0037_gitremote"),
        ("ansible", "0038_collectionversionsignature"),
        ("ansible", "0039_collectionremote_signed_only"),
        ("ansible", "0040_ansiblerepository_keyring"),
    ]

    dependencies = [
        ("core", "0091_systemid"),
    ]

    operations = [
        migrations.CreateModel(
            name="Collection",
            fields=[
                (
                    "pulp_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("pulp_created", models.DateTimeField(auto_now_add=True)),
                ("pulp_last_updated", models.DateTimeField(auto_now=True, null=True)),
                ("namespace", models.CharField(editable=False, max_length=64)),
                ("name", models.CharField(editable=False, max_length=64)),
            ],
            options={
                "unique_together": {("namespace", "name")},
            },
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                (
                    "pulp_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("pulp_created", models.DateTimeField(auto_now_add=True)),
                ("pulp_last_updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.CharField(editable=False, max_length=64, unique=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Role",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="ansible_role",
                        serialize=False,
                        to="core.content",
                    ),
                ),
                ("namespace", models.CharField(max_length=64)),
                ("name", models.CharField(max_length=64)),
                ("version", models.CharField(max_length=128)),
            ],
            options={
                "unique_together": {("version", "name", "namespace")},
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.content",),
        ),
        migrations.CreateModel(
            name="CollectionImport",
            fields=[
                ("messages", models.JSONField(default=list, editable=False)),
                (
                    "task",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="+",
                        serialize=False,
                        to="core.task",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "ordering": ["task__pulp_created"],
            },
        ),
        migrations.CreateModel(
            name="RoleRemote",
            fields=[
                (
                    "remote_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="ansible_roleremote",
                        serialize=False,
                        to="core.remote",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.remote",),
        ),
        migrations.CreateModel(
            name="AnsibleRepository",
            fields=[
                (
                    "repository_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="ansible_ansiblerepository",
                        serialize=False,
                        to="core.repository",
                    ),
                ),
                ("last_synced_metadata_time", models.DateTimeField(null=True)),
                (
                    "keyring",
                    models.FilePathField(blank=True, path="/etc/pulp/certs/", recursive=True),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "permissions": (
                    ("modify_ansible_repo_content", "Can modify ansible repository content"),
                ),
            },
            bases=("core.repository",),
        ),
        migrations.CreateModel(
            name="collectionversion",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="ansible_collectionversion",
                        serialize=False,
                        to="core.content",
                    ),
                ),
                ("version", models.CharField(editable=False, max_length=128)),
                ("contents", models.JSONField(default=list, editable=False)),
                (
                    "collection",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="versions",
                        to="ansible.collection",
                        to_field="pulp_id",
                    ),
                ),
                (
                    "authors",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=64),
                        default=list,
                        editable=False,
                        size=None,
                    ),
                ),
                ("dependencies", models.JSONField(default=dict, editable=False)),
                ("description", models.TextField(blank=True, default="", editable=False)),
                ("docs_blob", models.JSONField(default=dict, editable=False)),
                (
                    "documentation",
                    models.CharField(blank=True, default="", editable=False, max_length=2000),
                ),
                (
                    "homepage",
                    models.CharField(blank=True, default="", editable=False, max_length=2000),
                ),
                (
                    "issues",
                    models.CharField(blank=True, default="", editable=False, max_length=2000),
                ),
                (
                    "license",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=32),
                        default=list,
                        editable=False,
                        size=None,
                    ),
                ),
                ("name", models.CharField(editable=False, max_length=64)),
                ("namespace", models.CharField(editable=False, max_length=64)),
                (
                    "repository",
                    models.CharField(blank=True, default="", editable=False, max_length=2000),
                ),
                (
                    "tags",
                    models.ManyToManyField(
                        editable=False, related_name="ansible_collectionversion", to="ansible.tag"
                    ),
                ),
                ("search_vector", django.contrib.postgres.search.SearchVectorField(default="")),
                ("is_highest", models.BooleanField(default=False, editable=False)),
                ("files", models.JSONField(default=dict, editable=False)),
                ("manifest", models.JSONField(default=dict, editable=False)),
                ("requires_ansible", models.CharField(max_length=255, null=True)),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "unique_together": {("namespace", "name", "version")},
            },
            bases=("core.content",),
        ),
        migrations.CreateModel(
            name="AnsibleDistribution",
            fields=[
                (
                    "distribution_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="ansible_ansibledistribution",
                        serialize=False,
                        to="core.distribution",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.distribution",),
        ),
        migrations.CreateModel(
            name="AnsibleCollectionDeprecated",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="ansible_ansiblecollectiondeprecated",
                        serialize=False,
                        to="core.content",
                    ),
                ),
                ("namespace", models.CharField(editable=False, max_length=64)),
                ("name", models.CharField(editable=False, max_length=64)),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "unique_together": {("namespace", "name")},
            },
            bases=("core.content",),
        ),
        migrations.CreateModel(
            name="GitRemote",
            fields=[
                (
                    "remote_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="ansible_gitremote",
                        serialize=False,
                        to="core.remote",
                    ),
                ),
                ("metadata_only", models.BooleanField(default=False)),
                ("git_ref", models.TextField()),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.remote",),
        ),
        migrations.CreateModel(
            name="CollectionRemote",
            fields=[
                (
                    "remote_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="ansible_collectionremote",
                        serialize=False,
                        to="core.remote",
                    ),
                ),
                ("requirements_file", models.TextField(null=True)),
                ("auth_url", models.CharField(max_length=255, null=True)),
                ("token", models.TextField(max_length=2000, null=True)),
                ("sync_dependencies", models.BooleanField(default=True)),
                ("signed_only", models.BooleanField(default=False)),
            ],
            options={
                "abstract": False,
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.remote",),
        ),
        migrations.CreateModel(
            name="CollectionVersionSignature",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="ansible_collectionversionsignature",
                        serialize=False,
                        to="core.content",
                    ),
                ),
                ("data", models.BinaryField()),
                ("digest", models.CharField(max_length=64)),
                ("pubkey_fingerprint", models.CharField(max_length=64)),
                (
                    "signed_collection",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="signatures",
                        to="ansible.collectionversion",
                    ),
                ),
                (
                    "signing_service",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="signatures",
                        to="core.signingservice",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "unique_together": {("pubkey_fingerprint", "signed_collection")},
            },
            bases=("core.content",),
        ),
        migrations.AddConstraint(
            model_name="collectionversion",
            constraint=models.UniqueConstraint(
                condition=models.Q(("is_highest", True)),
                fields=("collection", "is_highest"),
                name="unique_is_highest",
            ),
        ),
        migrations.RunSQL(
            sql="\nUPDATE ansible_collectionversion AS c\nSET search_vector = (\n    SELECT \n    setweight(to_tsvector(coalesce(namespace,'')), 'A')\n    || setweight(to_tsvector(coalesce(name, '')), 'A')\n    || (\n      SELECT\n        setweight(to_tsvector(\n          coalesce(string_agg(\"ansible_tag\".\"name\", ' '), '')\n        ), 'B')\n      FROM\n        \"ansible_tag\" INNER JOIN \"ansible_collectionversion_tags\" ON (\"ansible_tag\".\"pulp_id\" = \"ansible_collectionversion_tags\".\"tag_id\")\n    )\n    || (\n      SELECT\n        setweight(to_tsvector(\n          coalesce(string_agg(cvc ->> 'name', ' '), '')\n        ), 'C')\n      FROM jsonb_array_elements(cv.contents) AS cvc\n    )\n    || setweight(to_tsvector(coalesce(description, '')), 'D')\n\n    FROM ansible_collectionversion cv\n    WHERE c.content_ptr_id = cv.content_ptr_id\n)\n",
            reverse_sql="",
        ),
        migrations.RunSQL(
            sql="\nCREATE OR REPLACE FUNCTION update_collection_ts_vector()\n    RETURNS TRIGGER AS\n$$\nBEGIN\n    NEW.search_vector := (\n        SELECT \n    setweight(to_tsvector(coalesce(namespace,'')), 'A')\n    || setweight(to_tsvector(coalesce(name, '')), 'A')\n    || (\n      SELECT\n        setweight(to_tsvector(\n          coalesce(string_agg(\"ansible_tag\".\"name\", ' '), '')\n        ), 'B')\n      FROM\n        \"ansible_tag\" INNER JOIN \"ansible_collectionversion_tags\" ON (\"ansible_tag\".\"pulp_id\" = \"ansible_collectionversion_tags\".\"tag_id\")\n    )\n    || (\n      SELECT\n        setweight(to_tsvector(\n          coalesce(string_agg(cvc ->> 'name', ' '), '')\n        ), 'C')\n      FROM jsonb_array_elements(cv.contents) AS cvc\n    )\n    || setweight(to_tsvector(coalesce(description, '')), 'D')\n\n        FROM ansible_collectionversion cv\n        WHERE cv.content_ptr_id = NEW.content_ptr_id\n    );\n    RETURN NEW;\nEND;\n$$ LANGUAGE plpgsql;\nCREATE TRIGGER update_ts_vector\n    BEFORE UPDATE\n    ON ansible_collectionversion\n    FOR EACH ROW\nEXECUTE PROCEDURE update_collection_ts_vector();\n",
            reverse_sql="\nDROP TRIGGER IF EXISTS update_ts_vector ON ansible_collectionversion;\nDROP FUNCTION IF EXISTS update_collection_ts_vector();\n",
        ),
    ]
