# Generated by Django 2.2.19 on 2021-03-19 17:42

from django.db import migrations, models, transaction
import django.db.models.deletion


def migrate_data_from_old_model_to_new_model_up(apps, schema_editor):
    """Move objects from AnsibleDistribution to NewAnsibleDistribution."""
    AnsibleDistribution = apps.get_model("ansible", "AnsibleDistribution")
    NewAnsibleDistribution = apps.get_model("ansible", "NewAnsibleDistribution")
    for ansible_distribution in AnsibleDistribution.objects.all():
        with transaction.atomic():
            NewAnsibleDistribution(
                pulp_id=ansible_distribution.pulp_id,
                pulp_created=ansible_distribution.pulp_created,
                pulp_last_updated=ansible_distribution.pulp_last_updated,
                pulp_type=ansible_distribution.pulp_type,
                name=ansible_distribution.name,
                base_path=ansible_distribution.base_path,
                content_guard=ansible_distribution.content_guard,
                remote=ansible_distribution.remote,
                repository_version=ansible_distribution.repository_version,
                repository=ansible_distribution.repository,
            ).save()
            ansible_distribution.delete()


def migrate_data_from_old_model_to_new_model_down(apps, schema_editor):
    """Move objects from NewAnsibleDistribution to AnsibleDistribution."""
    AnsibleDistribution = apps.get_model("ansible", "AnsibleDistribution")
    NewAnsibleDistribution = apps.get_model("ansible", "NewAnsibleDistribution")
    for ansible_distribution in NewAnsibleDistribution.objects.all():
        with transaction.atomic():
            AnsibleDistribution(
                pulp_id=ansible_distribution.pulp_id,
                pulp_created=ansible_distribution.pulp_created,
                pulp_last_updated=ansible_distribution.pulp_last_updated,
                pulp_type=ansible_distribution.pulp_type,
                name=ansible_distribution.name,
                base_path=ansible_distribution.base_path,
                content_guard=ansible_distribution.content_guard,
                remote=ansible_distribution.remote,
                repository_version=ansible_distribution.repository_version,
                repository=ansible_distribution.repository,
            ).save()
            ansible_distribution.delete()


class Migration(migrations.Migration):
    atomic = False

    dependencies = [
        ("ansible", "0032_collectionremote_sync_dependencies"),
    ]

    operations = [
        migrations.CreateModel(
            name="NewAnsibleDistribution",
            fields=[
                (
                    "distribution_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="ansible_ansibledistribution",
                        serialize=False,
                        to="core.Distribution",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.distribution",),
        ),
        migrations.RunPython(
            code=migrate_data_from_old_model_to_new_model_up,
            reverse_code=migrate_data_from_old_model_to_new_model_down,
            elidable=True,
        ),
        migrations.DeleteModel(
            name="AnsibleDistribution",
        ),
        migrations.RenameModel(
            old_name="NewAnsibleDistribution",
            new_name="AnsibleDistribution",
        ),
    ]
