# -*- coding: utf-8 -*-
"""
hpack/hpack
~~~~~~~~~~~

Implements the HPACK header compression algorithm as detailed by the IETF.
"""

from .huffman import HuffmanEncoder
from .table import HeaderTable

# Precompute 2^i for 1-8 for use in prefix calcs.
# Zero index is not used but there to save a subtraction
# as prefix numbers are not zero indexed.
_PREFIX_BIT_MAX_NUMBERS = [(2**i) - 1 for i in range(9)]
_HUFFMAN_TABLE = [
    # Node 0 (Root Node, never emits symbols.)
    (4, 0, 0),
    (5, 0, 0),
    (7, 0, 0),
    (8, 0, 0),
    (11, 0, 0),
    (12, 0, 0),
    (16, 0, 0),
    (19, 0, 0),
    (25, 0, 0),
    (28, 0, 0),
    (32, 0, 0),
    (35, 0, 0),
    (42, 0, 0),
    (49, 0, 0),
    (57, 0, 0),
    (64, 1, 0),
    # Node 1
    (0, 1 | (1 << 1), 48),
    (0, 1 | (1 << 1), 49),
    (0, 1 | (1 << 1), 50),
    (0, 1 | (1 << 1), 97),
    (0, 1 | (1 << 1), 99),
    (0, 1 | (1 << 1), 101),
    (0, 1 | (1 << 1), 105),
    (0, 1 | (1 << 1), 111),
    (0, 1 | (1 << 1), 115),
    (0, 1 | (1 << 1), 116),
    (13, 0, 0),
    (14, 0, 0),
    (17, 0, 0),
    (18, 0, 0),
    (20, 0, 0),
    (21, 0, 0),
    # Node 2
    (1, (1 << 1), 48),
    (22, 1 | (1 << 1), 48),
    (1, (1 << 1), 49),
    (22, 1 | (1 << 1), 49),
    (1, (1 << 1), 50),
    (22, 1 | (1 << 1), 50),
    (1, (1 << 1), 97),
    (22, 1 | (1 << 1), 97),
    (1, (1 << 1), 99),
    (22, 1 | (1 << 1), 99),
    (1, (1 << 1), 101),
    (22, 1 | (1 << 1), 101),
    (1, (1 << 1), 105),
    (22, 1 | (1 << 1), 105),
    (1, (1 << 1), 111),
    (22, 1 | (1 << 1), 111),
    # Node 3
    (2, (1 << 1), 48),
    (9, (1 << 1), 48),
    (23, (1 << 1), 48),
    (40, 1 | (1 << 1), 48),
    (2, (1 << 1), 49),
    (9, (1 << 1), 49),
    (23, (1 << 1), 49),
    (40, 1 | (1 << 1), 49),
    (2, (1 << 1), 50),
    (9, (1 << 1), 50),
    (23, (1 << 1), 50),
    (40, 1 | (1 << 1), 50),
    (2, (1 << 1), 97),
    (9, (1 << 1), 97),
    (23, (1 << 1), 97),
    (40, 1 | (1 << 1), 97),
    # Node 4
    (3, (1 << 1), 48),
    (6, (1 << 1), 48),
    (10, (1 << 1), 48),
    (15, (1 << 1), 48),
    (24, (1 << 1), 48),
    (31, (1 << 1), 48),
    (41, (1 << 1), 48),
    (56, 1 | (1 << 1), 48),
    (3, (1 << 1), 49),
    (6, (1 << 1), 49),
    (10, (1 << 1), 49),
    (15, (1 << 1), 49),
    (24, (1 << 1), 49),
    (31, (1 << 1), 49),
    (41, (1 << 1), 49),
    (56, 1 | (1 << 1), 49),
    # Node 5
    (3, (1 << 1), 50),
    (6, (1 << 1), 50),
    (10, (1 << 1), 50),
    (15, (1 << 1), 50),
    (24, (1 << 1), 50),
    (31, (1 << 1), 50),
    (41, (1 << 1), 50),
    (56, 1 | (1 << 1), 50),
    (3, (1 << 1), 97),
    (6, (1 << 1), 97),
    (10, (1 << 1), 97),
    (15, (1 << 1), 97),
    (24, (1 << 1), 97),
    (31, (1 << 1), 97),
    (41, (1 << 1), 97),
    (56, 1 | (1 << 1), 97),
    # Node 6
    (2, (1 << 1), 99),
    (9, (1 << 1), 99),
    (23, (1 << 1), 99),
    (40, 1 | (1 << 1), 99),
    (2, (1 << 1), 101),
    (9, (1 << 1), 101),
    (23, (1 << 1), 101),
    (40, 1 | (1 << 1), 101),
    (2, (1 << 1), 105),
    (9, (1 << 1), 105),
    (23, (1 << 1), 105),
    (40, 1 | (1 << 1), 105),
    (2, (1 << 1), 111),
    (9, (1 << 1), 111),
    (23, (1 << 1), 111),
    (40, 1 | (1 << 1), 111),
    # Node 7
    (3, (1 << 1), 99),
    (6, (1 << 1), 99),
    (10, (1 << 1), 99),
    (15, (1 << 1), 99),
    (24, (1 << 1), 99),
    (31, (1 << 1), 99),
    (41, (1 << 1), 99),
    (56, 1 | (1 << 1), 99),
    (3, (1 << 1), 101),
    (6, (1 << 1), 101),
    (10, (1 << 1), 101),
    (15, (1 << 1), 101),
    (24, (1 << 1), 101),
    (31, (1 << 1), 101),
    (41, (1 << 1), 101),
    (56, 1 | (1 << 1), 101),
    # Node 8
    (3, (1 << 1), 105),
    (6, (1 << 1), 105),
    (10, (1 << 1), 105),
    (15, (1 << 1), 105),
    (24, (1 << 1), 105),
    (31, (1 << 1), 105),
    (41, (1 << 1), 105),
    (56, 1 | (1 << 1), 105),
    (3, (1 << 1), 111),
    (6, (1 << 1), 111),
    (10, (1 << 1), 111),
    (15, (1 << 1), 111),
    (24, (1 << 1), 111),
    (31, (1 << 1), 111),
    (41, (1 << 1), 111),
    (56, 1 | (1 << 1), 111),
    # Node 9
    (1, (1 << 1), 115),
    (22, 1 | (1 << 1), 115),
    (1, (1 << 1), 116),
    (22, 1 | (1 << 1), 116),
    (0, 1 | (1 << 1), 32),
    (0, 1 | (1 << 1), 37),
    (0, 1 | (1 << 1), 45),
    (0, 1 | (1 << 1), 46),
    (0, 1 | (1 << 1), 47),
    (0, 1 | (1 << 1), 51),
    (0, 1 | (1 << 1), 52),
    (0, 1 | (1 << 1), 53),
    (0, 1 | (1 << 1), 54),
    (0, 1 | (1 << 1), 55),
    (0, 1 | (1 << 1), 56),
    (0, 1 | (1 << 1), 57),
    # Node 10
    (2, (1 << 1), 115),
    (9, (1 << 1), 115),
    (23, (1 << 1), 115),
    (40, 1 | (1 << 1), 115),
    (2, (1 << 1), 116),
    (9, (1 << 1), 116),
    (23, (1 << 1), 116),
    (40, 1 | (1 << 1), 116),
    (1, (1 << 1), 32),
    (22, 1 | (1 << 1), 32),
    (1, (1 << 1), 37),
    (22, 1 | (1 << 1), 37),
    (1, (1 << 1), 45),
    (22, 1 | (1 << 1), 45),
    (1, (1 << 1), 46),
    (22, 1 | (1 << 1), 46),
    # Node 11
    (3, (1 << 1), 115),
    (6, (1 << 1), 115),
    (10, (1 << 1), 115),
    (15, (1 << 1), 115),
    (24, (1 << 1), 115),
    (31, (1 << 1), 115),
    (41, (1 << 1), 115),
    (56, 1 | (1 << 1), 115),
    (3, (1 << 1), 116),
    (6, (1 << 1), 116),
    (10, (1 << 1), 116),
    (15, (1 << 1), 116),
    (24, (1 << 1), 116),
    (31, (1 << 1), 116),
    (41, (1 << 1), 116),
    (56, 1 | (1 << 1), 116),
    # Node 12
    (2, (1 << 1), 32),
    (9, (1 << 1), 32),
    (23, (1 << 1), 32),
    (40, 1 | (1 << 1), 32),
    (2, (1 << 1), 37),
    (9, (1 << 1), 37),
    (23, (1 << 1), 37),
    (40, 1 | (1 << 1), 37),
    (2, (1 << 1), 45),
    (9, (1 << 1), 45),
    (23, (1 << 1), 45),
    (40, 1 | (1 << 1), 45),
    (2, (1 << 1), 46),
    (9, (1 << 1), 46),
    (23, (1 << 1), 46),
    (40, 1 | (1 << 1), 46),
    # Node 13
    (3, (1 << 1), 32),
    (6, (1 << 1), 32),
    (10, (1 << 1), 32),
    (15, (1 << 1), 32),
    (24, (1 << 1), 32),
    (31, (1 << 1), 32),
    (41, (1 << 1), 32),
    (56, 1 | (1 << 1), 32),
    (3, (1 << 1), 37),
    (6, (1 << 1), 37),
    (10, (1 << 1), 37),
    (15, (1 << 1), 37),
    (24, (1 << 1), 37),
    (31, (1 << 1), 37),
    (41, (1 << 1), 37),
    (56, 1 | (1 << 1), 37),
    # Node 14
    (3, (1 << 1), 45),
    (6, (1 << 1), 45),
    (10, (1 << 1), 45),
    (15, (1 << 1), 45),
    (24, (1 << 1), 45),
    (31, (1 << 1), 45),
    (41, (1 << 1), 45),
    (56, 1 | (1 << 1), 45),
    (3, (1 << 1), 46),
    (6, (1 << 1), 46),
    (10, (1 << 1), 46),
    (15, (1 << 1), 46),
    (24, (1 << 1), 46),
    (31, (1 << 1), 46),
    (41, (1 << 1), 46),
    (56, 1 | (1 << 1), 46),
    # Node 15
    (1, (1 << 1), 47),
    (22, 1 | (1 << 1), 47),
    (1, (1 << 1), 51),
    (22, 1 | (1 << 1), 51),
    (1, (1 << 1), 52),
    (22, 1 | (1 << 1), 52),
    (1, (1 << 1), 53),
    (22, 1 | (1 << 1), 53),
    (1, (1 << 1), 54),
    (22, 1 | (1 << 1), 54),
    (1, (1 << 1), 55),
    (22, 1 | (1 << 1), 55),
    (1, (1 << 1), 56),
    (22, 1 | (1 << 1), 56),
    (1, (1 << 1), 57),
    (22, 1 | (1 << 1), 57),
    # Node 16
    (2, (1 << 1), 47),
    (9, (1 << 1), 47),
    (23, (1 << 1), 47),
    (40, 1 | (1 << 1), 47),
    (2, (1 << 1), 51),
    (9, (1 << 1), 51),
    (23, (1 << 1), 51),
    (40, 1 | (1 << 1), 51),
    (2, (1 << 1), 52),
    (9, (1 << 1), 52),
    (23, (1 << 1), 52),
    (40, 1 | (1 << 1), 52),
    (2, (1 << 1), 53),
    (9, (1 << 1), 53),
    (23, (1 << 1), 53),
    (40, 1 | (1 << 1), 53),
    # Node 17
    (3, (1 << 1), 47),
    (6, (1 << 1), 47),
    (10, (1 << 1), 47),
    (15, (1 << 1), 47),
    (24, (1 << 1), 47),
    (31, (1 << 1), 47),
    (41, (1 << 1), 47),
    (56, 1 | (1 << 1), 47),
    (3, (1 << 1), 51),
    (6, (1 << 1), 51),
    (10, (1 << 1), 51),
    (15, (1 << 1), 51),
    (24, (1 << 1), 51),
    (31, (1 << 1), 51),
    (41, (1 << 1), 51),
    (56, 1 | (1 << 1), 51),
    # Node 18
    (3, (1 << 1), 52),
    (6, (1 << 1), 52),
    (10, (1 << 1), 52),
    (15, (1 << 1), 52),
    (24, (1 << 1), 52),
    (31, (1 << 1), 52),
    (41, (1 << 1), 52),
    (56, 1 | (1 << 1), 52),
    (3, (1 << 1), 53),
    (6, (1 << 1), 53),
    (10, (1 << 1), 53),
    (15, (1 << 1), 53),
    (24, (1 << 1), 53),
    (31, (1 << 1), 53),
    (41, (1 << 1), 53),
    (56, 1 | (1 << 1), 53),
    # Node 19
    (2, (1 << 1), 54),
    (9, (1 << 1), 54),
    (23, (1 << 1), 54),
    (40, 1 | (1 << 1), 54),
    (2, (1 << 1), 55),
    (9, (1 << 1), 55),
    (23, (1 << 1), 55),
    (40, 1 | (1 << 1), 55),
    (2, (1 << 1), 56),
    (9, (1 << 1), 56),
    (23, (1 << 1), 56),
    (40, 1 | (1 << 1), 56),
    (2, (1 << 1), 57),
    (9, (1 << 1), 57),
    (23, (1 << 1), 57),
    (40, 1 | (1 << 1), 57),
    # Node 20
    (3, (1 << 1), 54),
    (6, (1 << 1), 54),
    (10, (1 << 1), 54),
    (15, (1 << 1), 54),
    (24, (1 << 1), 54),
    (31, (1 << 1), 54),
    (41, (1 << 1), 54),
    (56, 1 | (1 << 1), 54),
    (3, (1 << 1), 55),
    (6, (1 << 1), 55),
    (10, (1 << 1), 55),
    (15, (1 << 1), 55),
    (24, (1 << 1), 55),
    (31, (1 << 1), 55),
    (41, (1 << 1), 55),
    (56, 1 | (1 << 1), 55),
    # Node 21
    (3, (1 << 1), 56),
    (6, (1 << 1), 56),
    (10, (1 << 1), 56),
    (15, (1 << 1), 56),
    (24, (1 << 1), 56),
    (31, (1 << 1), 56),
    (41, (1 << 1), 56),
    (56, 1 | (1 << 1), 56),
    (3, (1 << 1), 57),
    (6, (1 << 1), 57),
    (10, (1 << 1), 57),
    (15, (1 << 1), 57),
    (24, (1 << 1), 57),
    (31, (1 << 1), 57),
    (41, (1 << 1), 57),
    (56, 1 | (1 << 1), 57),
    # Node 22
    (26, 0, 0),
    (27, 0, 0),
    (29, 0, 0),
    (30, 0, 0),
    (33, 0, 0),
    (34, 0, 0),
    (36, 0, 0),
    (37, 0, 0),
    (43, 0, 0),
    (46, 0, 0),
    (50, 0, 0),
    (53, 0, 0),
    (58, 0, 0),
    (61, 0, 0),
    (65, 0, 0),
    (68, 1, 0),
    # Node 23
    (0, 1 | (1 << 1), 61),
    (0, 1 | (1 << 1), 65),
    (0, 1 | (1 << 1), 95),
    (0, 1 | (1 << 1), 98),
    (0, 1 | (1 << 1), 100),
    (0, 1 | (1 << 1), 102),
    (0, 1 | (1 << 1), 103),
    (0, 1 | (1 << 1), 104),
    (0, 1 | (1 << 1), 108),
    (0, 1 | (1 << 1), 109),
    (0, 1 | (1 << 1), 110),
    (0, 1 | (1 << 1), 112),
    (0, 1 | (1 << 1), 114),
    (0, 1 | (1 << 1), 117),
    (38, 0, 0),
    (39, 0, 0),
    # Node 24
    (1, (1 << 1), 61),
    (22, 1 | (1 << 1), 61),
    (1, (1 << 1), 65),
    (22, 1 | (1 << 1), 65),
    (1, (1 << 1), 95),
    (22, 1 | (1 << 1), 95),
    (1, (1 << 1), 98),
    (22, 1 | (1 << 1), 98),
    (1, (1 << 1), 100),
    (22, 1 | (1 << 1), 100),
    (1, (1 << 1), 102),
    (22, 1 | (1 << 1), 102),
    (1, (1 << 1), 103),
    (22, 1 | (1 << 1), 103),
    (1, (1 << 1), 104),
    (22, 1 | (1 << 1), 104),
    # Node 25
    (2, (1 << 1), 61),
    (9, (1 << 1), 61),
    (23, (1 << 1), 61),
    (40, 1 | (1 << 1), 61),
    (2, (1 << 1), 65),
    (9, (1 << 1), 65),
    (23, (1 << 1), 65),
    (40, 1 | (1 << 1), 65),
    (2, (1 << 1), 95),
    (9, (1 << 1), 95),
    (23, (1 << 1), 95),
    (40, 1 | (1 << 1), 95),
    (2, (1 << 1), 98),
    (9, (1 << 1), 98),
    (23, (1 << 1), 98),
    (40, 1 | (1 << 1), 98),
    # Node 26
    (3, (1 << 1), 61),
    (6, (1 << 1), 61),
    (10, (1 << 1), 61),
    (15, (1 << 1), 61),
    (24, (1 << 1), 61),
    (31, (1 << 1), 61),
    (41, (1 << 1), 61),
    (56, 1 | (1 << 1), 61),
    (3, (1 << 1), 65),
    (6, (1 << 1), 65),
    (10, (1 << 1), 65),
    (15, (1 << 1), 65),
    (24, (1 << 1), 65),
    (31, (1 << 1), 65),
    (41, (1 << 1), 65),
    (56, 1 | (1 << 1), 65),
    # Node 27
    (3, (1 << 1), 95),
    (6, (1 << 1), 95),
    (10, (1 << 1), 95),
    (15, (1 << 1), 95),
    (24, (1 << 1), 95),
    (31, (1 << 1), 95),
    (41, (1 << 1), 95),
    (56, 1 | (1 << 1), 95),
    (3, (1 << 1), 98),
    (6, (1 << 1), 98),
    (10, (1 << 1), 98),
    (15, (1 << 1), 98),
    (24, (1 << 1), 98),
    (31, (1 << 1), 98),
    (41, (1 << 1), 98),
    (56, 1 | (1 << 1), 98),
    # Node 28
    (2, (1 << 1), 100),
    (9, (1 << 1), 100),
    (23, (1 << 1), 100),
    (40, 1 | (1 << 1), 100),
    (2, (1 << 1), 102),
    (9, (1 << 1), 102),
    (23, (1 << 1), 102),
    (40, 1 | (1 << 1), 102),
    (2, (1 << 1), 103),
    (9, (1 << 1), 103),
    (23, (1 << 1), 103),
    (40, 1 | (1 << 1), 103),
    (2, (1 << 1), 104),
    (9, (1 << 1), 104),
    (23, (1 << 1), 104),
    (40, 1 | (1 << 1), 104),
    # Node 29
    (3, (1 << 1), 100),
    (6, (1 << 1), 100),
    (10, (1 << 1), 100),
    (15, (1 << 1), 100),
    (24, (1 << 1), 100),
    (31, (1 << 1), 100),
    (41, (1 << 1), 100),
    (56, 1 | (1 << 1), 100),
    (3, (1 << 1), 102),
    (6, (1 << 1), 102),
    (10, (1 << 1), 102),
    (15, (1 << 1), 102),
    (24, (1 << 1), 102),
    (31, (1 << 1), 102),
    (41, (1 << 1), 102),
    (56, 1 | (1 << 1), 102),
    # Node 30
    (3, (1 << 1), 103),
    (6, (1 << 1), 103),
    (10, (1 << 1), 103),
    (15, (1 << 1), 103),
    (24, (1 << 1), 103),
    (31, (1 << 1), 103),
    (41, (1 << 1), 103),
    (56, 1 | (1 << 1), 103),
    (3, (1 << 1), 104),
    (6, (1 << 1), 104),
    (10, (1 << 1), 104),
    (15, (1 << 1), 104),
    (24, (1 << 1), 104),
    (31, (1 << 1), 104),
    (41, (1 << 1), 104),
    (56, 1 | (1 << 1), 104),
    # Node 31
    (1, (1 << 1), 108),
    (22, 1 | (1 << 1), 108),
    (1, (1 << 1), 109),
    (22, 1 | (1 << 1), 109),
    (1, (1 << 1), 110),
    (22, 1 | (1 << 1), 110),
    (1, (1 << 1), 112),
    (22, 1 | (1 << 1), 112),
    (1, (1 << 1), 114),
    (22, 1 | (1 << 1), 114),
    (1, (1 << 1), 117),
    (22, 1 | (1 << 1), 117),
    (0, 1 | (1 << 1), 58),
    (0, 1 | (1 << 1), 66),
    (0, 1 | (1 << 1), 67),
    (0, 1 | (1 << 1), 68),
    # Node 32
    (2, (1 << 1), 108),
    (9, (1 << 1), 108),
    (23, (1 << 1), 108),
    (40, 1 | (1 << 1), 108),
    (2, (1 << 1), 109),
    (9, (1 << 1), 109),
    (23, (1 << 1), 109),
    (40, 1 | (1 << 1), 109),
    (2, (1 << 1), 110),
    (9, (1 << 1), 110),
    (23, (1 << 1), 110),
    (40, 1 | (1 << 1), 110),
    (2, (1 << 1), 112),
    (9, (1 << 1), 112),
    (23, (1 << 1), 112),
    (40, 1 | (1 << 1), 112),
    # Node 33
    (3, (1 << 1), 108),
    (6, (1 << 1), 108),
    (10, (1 << 1), 108),
    (15, (1 << 1), 108),
    (24, (1 << 1), 108),
    (31, (1 << 1), 108),
    (41, (1 << 1), 108),
    (56, 1 | (1 << 1), 108),
    (3, (1 << 1), 109),
    (6, (1 << 1), 109),
    (10, (1 << 1), 109),
    (15, (1 << 1), 109),
    (24, (1 << 1), 109),
    (31, (1 << 1), 109),
    (41, (1 << 1), 109),
    (56, 1 | (1 << 1), 109),
    # Node 34
    (3, (1 << 1), 110),
    (6, (1 << 1), 110),
    (10, (1 << 1), 110),
    (15, (1 << 1), 110),
    (24, (1 << 1), 110),
    (31, (1 << 1), 110),
    (41, (1 << 1), 110),
    (56, 1 | (1 << 1), 110),
    (3, (1 << 1), 112),
    (6, (1 << 1), 112),
    (10, (1 << 1), 112),
    (15, (1 << 1), 112),
    (24, (1 << 1), 112),
    (31, (1 << 1), 112),
    (41, (1 << 1), 112),
    (56, 1 | (1 << 1), 112),
    # Node 35
    (2, (1 << 1), 114),
    (9, (1 << 1), 114),
    (23, (1 << 1), 114),
    (40, 1 | (1 << 1), 114),
    (2, (1 << 1), 117),
    (9, (1 << 1), 117),
    (23, (1 << 1), 117),
    (40, 1 | (1 << 1), 117),
    (1, (1 << 1), 58),
    (22, 1 | (1 << 1), 58),
    (1, (1 << 1), 66),
    (22, 1 | (1 << 1), 66),
    (1, (1 << 1), 67),
    (22, 1 | (1 << 1), 67),
    (1, (1 << 1), 68),
    (22, 1 | (1 << 1), 68),
    # Node 36
    (3, (1 << 1), 114),
    (6, (1 << 1), 114),
    (10, (1 << 1), 114),
    (15, (1 << 1), 114),
    (24, (1 << 1), 114),
    (31, (1 << 1), 114),
    (41, (1 << 1), 114),
    (56, 1 | (1 << 1), 114),
    (3, (1 << 1), 117),
    (6, (1 << 1), 117),
    (10, (1 << 1), 117),
    (15, (1 << 1), 117),
    (24, (1 << 1), 117),
    (31, (1 << 1), 117),
    (41, (1 << 1), 117),
    (56, 1 | (1 << 1), 117),
    # Node 37
    (2, (1 << 1), 58),
    (9, (1 << 1), 58),
    (23, (1 << 1), 58),
    (40, 1 | (1 << 1), 58),
    (2, (1 << 1), 66),
    (9, (1 << 1), 66),
    (23, (1 << 1), 66),
    (40, 1 | (1 << 1), 66),
    (2, (1 << 1), 67),
    (9, (1 << 1), 67),
    (23, (1 << 1), 67),
    (40, 1 | (1 << 1), 67),
    (2, (1 << 1), 68),
    (9, (1 << 1), 68),
    (23, (1 << 1), 68),
    (40, 1 | (1 << 1), 68),
    # Node 38
    (3, (1 << 1), 58),
    (6, (1 << 1), 58),
    (10, (1 << 1), 58),
    (15, (1 << 1), 58),
    (24, (1 << 1), 58),
    (31, (1 << 1), 58),
    (41, (1 << 1), 58),
    (56, 1 | (1 << 1), 58),
    (3, (1 << 1), 66),
    (6, (1 << 1), 66),
    (10, (1 << 1), 66),
    (15, (1 << 1), 66),
    (24, (1 << 1), 66),
    (31, (1 << 1), 66),
    (41, (1 << 1), 66),
    (56, 1 | (1 << 1), 66),
    # Node 39
    (3, (1 << 1), 67),
    (6, (1 << 1), 67),
    (10, (1 << 1), 67),
    (15, (1 << 1), 67),
    (24, (1 << 1), 67),
    (31, (1 << 1), 67),
    (41, (1 << 1), 67),
    (56, 1 | (1 << 1), 67),
    (3, (1 << 1), 68),
    (6, (1 << 1), 68),
    (10, (1 << 1), 68),
    (15, (1 << 1), 68),
    (24, (1 << 1), 68),
    (31, (1 << 1), 68),
    (41, (1 << 1), 68),
    (56, 1 | (1 << 1), 68),
    # Node 40
    (44, 0, 0),
    (45, 0, 0),
    (47, 0, 0),
    (48, 0, 0),
    (51, 0, 0),
    (52, 0, 0),
    (54, 0, 0),
    (55, 0, 0),
    (59, 0, 0),
    (60, 0, 0),
    (62, 0, 0),
    (63, 0, 0),
    (66, 0, 0),
    (67, 0, 0),
    (69, 0, 0),
    (72, 1, 0),
    # Node 41
    (0, 1 | (1 << 1), 69),
    (0, 1 | (1 << 1), 70),
    (0, 1 | (1 << 1), 71),
    (0, 1 | (1 << 1), 72),
    (0, 1 | (1 << 1), 73),
    (0, 1 | (1 << 1), 74),
    (0, 1 | (1 << 1), 75),
    (0, 1 | (1 << 1), 76),
    (0, 1 | (1 << 1), 77),
    (0, 1 | (1 << 1), 78),
    (0, 1 | (1 << 1), 79),
    (0, 1 | (1 << 1), 80),
    (0, 1 | (1 << 1), 81),
    (0, 1 | (1 << 1), 82),
    (0, 1 | (1 << 1), 83),
    (0, 1 | (1 << 1), 84),
    # Node 42
    (1, (1 << 1), 69),
    (22, 1 | (1 << 1), 69),
    (1, (1 << 1), 70),
    (22, 1 | (1 << 1), 70),
    (1, (1 << 1), 71),
    (22, 1 | (1 << 1), 71),
    (1, (1 << 1), 72),
    (22, 1 | (1 << 1), 72),
    (1, (1 << 1), 73),
    (22, 1 | (1 << 1), 73),
    (1, (1 << 1), 74),
    (22, 1 | (1 << 1), 74),
    (1, (1 << 1), 75),
    (22, 1 | (1 << 1), 75),
    (1, (1 << 1), 76),
    (22, 1 | (1 << 1), 76),
    # Node 43
    (2, (1 << 1), 69),
    (9, (1 << 1), 69),
    (23, (1 << 1), 69),
    (40, 1 | (1 << 1), 69),
    (2, (1 << 1), 70),
    (9, (1 << 1), 70),
    (23, (1 << 1), 70),
    (40, 1 | (1 << 1), 70),
    (2, (1 << 1), 71),
    (9, (1 << 1), 71),
    (23, (1 << 1), 71),
    (40, 1 | (1 << 1), 71),
    (2, (1 << 1), 72),
    (9, (1 << 1), 72),
    (23, (1 << 1), 72),
    (40, 1 | (1 << 1), 72),
    # Node 44
    (3, (1 << 1), 69),
    (6, (1 << 1), 69),
    (10, (1 << 1), 69),
    (15, (1 << 1), 69),
    (24, (1 << 1), 69),
    (31, (1 << 1), 69),
    (41, (1 << 1), 69),
    (56, 1 | (1 << 1), 69),
    (3, (1 << 1), 70),
    (6, (1 << 1), 70),
    (10, (1 << 1), 70),
    (15, (1 << 1), 70),
    (24, (1 << 1), 70),
    (31, (1 << 1), 70),
    (41, (1 << 1), 70),
    (56, 1 | (1 << 1), 70),
    # Node 45
    (3, (1 << 1), 71),
    (6, (1 << 1), 71),
    (10, (1 << 1), 71),
    (15, (1 << 1), 71),
    (24, (1 << 1), 71),
    (31, (1 << 1), 71),
    (41, (1 << 1), 71),
    (56, 1 | (1 << 1), 71),
    (3, (1 << 1), 72),
    (6, (1 << 1), 72),
    (10, (1 << 1), 72),
    (15, (1 << 1), 72),
    (24, (1 << 1), 72),
    (31, (1 << 1), 72),
    (41, (1 << 1), 72),
    (56, 1 | (1 << 1), 72),
    # Node 46
    (2, (1 << 1), 73),
    (9, (1 << 1), 73),
    (23, (1 << 1), 73),
    (40, 1 | (1 << 1), 73),
    (2, (1 << 1), 74),
    (9, (1 << 1), 74),
    (23, (1 << 1), 74),
    (40, 1 | (1 << 1), 74),
    (2, (1 << 1), 75),
    (9, (1 << 1), 75),
    (23, (1 << 1), 75),
    (40, 1 | (1 << 1), 75),
    (2, (1 << 1), 76),
    (9, (1 << 1), 76),
    (23, (1 << 1), 76),
    (40, 1 | (1 << 1), 76),
    # Node 47
    (3, (1 << 1), 73),
    (6, (1 << 1), 73),
    (10, (1 << 1), 73),
    (15, (1 << 1), 73),
    (24, (1 << 1), 73),
    (31, (1 << 1), 73),
    (41, (1 << 1), 73),
    (56, 1 | (1 << 1), 73),
    (3, (1 << 1), 74),
    (6, (1 << 1), 74),
    (10, (1 << 1), 74),
    (15, (1 << 1), 74),
    (24, (1 << 1), 74),
    (31, (1 << 1), 74),
    (41, (1 << 1), 74),
    (56, 1 | (1 << 1), 74),
    # Node 48
    (3, (1 << 1), 75),
    (6, (1 << 1), 75),
    (10, (1 << 1), 75),
    (15, (1 << 1), 75),
    (24, (1 << 1), 75),
    (31, (1 << 1), 75),
    (41, (1 << 1), 75),
    (56, 1 | (1 << 1), 75),
    (3, (1 << 1), 76),
    (6, (1 << 1), 76),
    (10, (1 << 1), 76),
    (15, (1 << 1), 76),
    (24, (1 << 1), 76),
    (31, (1 << 1), 76),
    (41, (1 << 1), 76),
    (56, 1 | (1 << 1), 76),
    # Node 49
    (1, (1 << 1), 77),
    (22, 1 | (1 << 1), 77),
    (1, (1 << 1), 78),
    (22, 1 | (1 << 1), 78),
    (1, (1 << 1), 79),
    (22, 1 | (1 << 1), 79),
    (1, (1 << 1), 80),
    (22, 1 | (1 << 1), 80),
    (1, (1 << 1), 81),
    (22, 1 | (1 << 1), 81),
    (1, (1 << 1), 82),
    (22, 1 | (1 << 1), 82),
    (1, (1 << 1), 83),
    (22, 1 | (1 << 1), 83),
    (1, (1 << 1), 84),
    (22, 1 | (1 << 1), 84),
    # Node 50
    (2, (1 << 1), 77),
    (9, (1 << 1), 77),
    (23, (1 << 1), 77),
    (40, 1 | (1 << 1), 77),
    (2, (1 << 1), 78),
    (9, (1 << 1), 78),
    (23, (1 << 1), 78),
    (40, 1 | (1 << 1), 78),
    (2, (1 << 1), 79),
    (9, (1 << 1), 79),
    (23, (1 << 1), 79),
    (40, 1 | (1 << 1), 79),
    (2, (1 << 1), 80),
    (9, (1 << 1), 80),
    (23, (1 << 1), 80),
    (40, 1 | (1 << 1), 80),
    # Node 51
    (3, (1 << 1), 77),
    (6, (1 << 1), 77),
    (10, (1 << 1), 77),
    (15, (1 << 1), 77),
    (24, (1 << 1), 77),
    (31, (1 << 1), 77),
    (41, (1 << 1), 77),
    (56, 1 | (1 << 1), 77),
    (3, (1 << 1), 78),
    (6, (1 << 1), 78),
    (10, (1 << 1), 78),
    (15, (1 << 1), 78),
    (24, (1 << 1), 78),
    (31, (1 << 1), 78),
    (41, (1 << 1), 78),
    (56, 1 | (1 << 1), 78),
    # Node 52
    (3, (1 << 1), 79),
    (6, (1 << 1), 79),
    (10, (1 << 1), 79),
    (15, (1 << 1), 79),
    (24, (1 << 1), 79),
    (31, (1 << 1), 79),
    (41, (1 << 1), 79),
    (56, 1 | (1 << 1), 79),
    (3, (1 << 1), 80),
    (6, (1 << 1), 80),
    (10, (1 << 1), 80),
    (15, (1 << 1), 80),
    (24, (1 << 1), 80),
    (31, (1 << 1), 80),
    (41, (1 << 1), 80),
    (56, 1 | (1 << 1), 80),
    # Node 53
    (2, (1 << 1), 81),
    (9, (1 << 1), 81),
    (23, (1 << 1), 81),
    (40, 1 | (1 << 1), 81),
    (2, (1 << 1), 82),
    (9, (1 << 1), 82),
    (23, (1 << 1), 82),
    (40, 1 | (1 << 1), 82),
    (2, (1 << 1), 83),
    (9, (1 << 1), 83),
    (23, (1 << 1), 83),
    (40, 1 | (1 << 1), 83),
    (2, (1 << 1), 84),
    (9, (1 << 1), 84),
    (23, (1 << 1), 84),
    (40, 1 | (1 << 1), 84),
    # Node 54
    (3, (1 << 1), 81),
    (6, (1 << 1), 81),
    (10, (1 << 1), 81),
    (15, (1 << 1), 81),
    (24, (1 << 1), 81),
    (31, (1 << 1), 81),
    (41, (1 << 1), 81),
    (56, 1 | (1 << 1), 81),
    (3, (1 << 1), 82),
    (6, (1 << 1), 82),
    (10, (1 << 1), 82),
    (15, (1 << 1), 82),
    (24, (1 << 1), 82),
    (31, (1 << 1), 82),
    (41, (1 << 1), 82),
    (56, 1 | (1 << 1), 82),
    # Node 55
    (3, (1 << 1), 83),
    (6, (1 << 1), 83),
    (10, (1 << 1), 83),
    (15, (1 << 1), 83),
    (24, (1 << 1), 83),
    (31, (1 << 1), 83),
    (41, (1 << 1), 83),
    (56, 1 | (1 << 1), 83),
    (3, (1 << 1), 84),
    (6, (1 << 1), 84),
    (10, (1 << 1), 84),
    (15, (1 << 1), 84),
    (24, (1 << 1), 84),
    (31, (1 << 1), 84),
    (41, (1 << 1), 84),
    (56, 1 | (1 << 1), 84),
    # Node 56
    (0, 1 | (1 << 1), 85),
    (0, 1 | (1 << 1), 86),
    (0, 1 | (1 << 1), 87),
    (0, 1 | (1 << 1), 89),
    (0, 1 | (1 << 1), 106),
    (0, 1 | (1 << 1), 107),
    (0, 1 | (1 << 1), 113),
    (0, 1 | (1 << 1), 118),
    (0, 1 | (1 << 1), 119),
    (0, 1 | (1 << 1), 120),
    (0, 1 | (1 << 1), 121),
    (0, 1 | (1 << 1), 122),
    (70, 0, 0),
    (71, 0, 0),
    (73, 0, 0),
    (74, 1, 0),
    # Node 57
    (1, (1 << 1), 85),
    (22, 1 | (1 << 1), 85),
    (1, (1 << 1), 86),
    (22, 1 | (1 << 1), 86),
    (1, (1 << 1), 87),
    (22, 1 | (1 << 1), 87),
    (1, (1 << 1), 89),
    (22, 1 | (1 << 1), 89),
    (1, (1 << 1), 106),
    (22, 1 | (1 << 1), 106),
    (1, (1 << 1), 107),
    (22, 1 | (1 << 1), 107),
    (1, (1 << 1), 113),
    (22, 1 | (1 << 1), 113),
    (1, (1 << 1), 118),
    (22, 1 | (1 << 1), 118),
    # Node 58
    (2, (1 << 1), 85),
    (9, (1 << 1), 85),
    (23, (1 << 1), 85),
    (40, 1 | (1 << 1), 85),
    (2, (1 << 1), 86),
    (9, (1 << 1), 86),
    (23, (1 << 1), 86),
    (40, 1 | (1 << 1), 86),
    (2, (1 << 1), 87),
    (9, (1 << 1), 87),
    (23, (1 << 1), 87),
    (40, 1 | (1 << 1), 87),
    (2, (1 << 1), 89),
    (9, (1 << 1), 89),
    (23, (1 << 1), 89),
    (40, 1 | (1 << 1), 89),
    # Node 59
    (3, (1 << 1), 85),
    (6, (1 << 1), 85),
    (10, (1 << 1), 85),
    (15, (1 << 1), 85),
    (24, (1 << 1), 85),
    (31, (1 << 1), 85),
    (41, (1 << 1), 85),
    (56, 1 | (1 << 1), 85),
    (3, (1 << 1), 86),
    (6, (1 << 1), 86),
    (10, (1 << 1), 86),
    (15, (1 << 1), 86),
    (24, (1 << 1), 86),
    (31, (1 << 1), 86),
    (41, (1 << 1), 86),
    (56, 1 | (1 << 1), 86),
    # Node 60
    (3, (1 << 1), 87),
    (6, (1 << 1), 87),
    (10, (1 << 1), 87),
    (15, (1 << 1), 87),
    (24, (1 << 1), 87),
    (31, (1 << 1), 87),
    (41, (1 << 1), 87),
    (56, 1 | (1 << 1), 87),
    (3, (1 << 1), 89),
    (6, (1 << 1), 89),
    (10, (1 << 1), 89),
    (15, (1 << 1), 89),
    (24, (1 << 1), 89),
    (31, (1 << 1), 89),
    (41, (1 << 1), 89),
    (56, 1 | (1 << 1), 89),
    # Node 61
    (2, (1 << 1), 106),
    (9, (1 << 1), 106),
    (23, (1 << 1), 106),
    (40, 1 | (1 << 1), 106),
    (2, (1 << 1), 107),
    (9, (1 << 1), 107),
    (23, (1 << 1), 107),
    (40, 1 | (1 << 1), 107),
    (2, (1 << 1), 113),
    (9, (1 << 1), 113),
    (23, (1 << 1), 113),
    (40, 1 | (1 << 1), 113),
    (2, (1 << 1), 118),
    (9, (1 << 1), 118),
    (23, (1 << 1), 118),
    (40, 1 | (1 << 1), 118),
    # Node 62
    (3, (1 << 1), 106),
    (6, (1 << 1), 106),
    (10, (1 << 1), 106),
    (15, (1 << 1), 106),
    (24, (1 << 1), 106),
    (31, (1 << 1), 106),
    (41, (1 << 1), 106),
    (56, 1 | (1 << 1), 106),
    (3, (1 << 1), 107),
    (6, (1 << 1), 107),
    (10, (1 << 1), 107),
    (15, (1 << 1), 107),
    (24, (1 << 1), 107),
    (31, (1 << 1), 107),
    (41, (1 << 1), 107),
    (56, 1 | (1 << 1), 107),
    # Node 63
    (3, (1 << 1), 113),
    (6, (1 << 1), 113),
    (10, (1 << 1), 113),
    (15, (1 << 1), 113),
    (24, (1 << 1), 113),
    (31, (1 << 1), 113),
    (41, (1 << 1), 113),
    (56, 1 | (1 << 1), 113),
    (3, (1 << 1), 118),
    (6, (1 << 1), 118),
    (10, (1 << 1), 118),
    (15, (1 << 1), 118),
    (24, (1 << 1), 118),
    (31, (1 << 1), 118),
    (41, (1 << 1), 118),
    (56, 1 | (1 << 1), 118),
    # Node 64
    (1, (1 << 1), 119),
    (22, 1 | (1 << 1), 119),
    (1, (1 << 1), 120),
    (22, 1 | (1 << 1), 120),
    (1, (1 << 1), 121),
    (22, 1 | (1 << 1), 121),
    (1, (1 << 1), 122),
    (22, 1 | (1 << 1), 122),
    (0, 1 | (1 << 1), 38),
    (0, 1 | (1 << 1), 42),
    (0, 1 | (1 << 1), 44),
    (0, 1 | (1 << 1), 59),
    (0, 1 | (1 << 1), 88),
    (0, 1 | (1 << 1), 90),
    (75, 0, 0),
    (78, 0, 0),
    # Node 65
    (2, (1 << 1), 119),
    (9, (1 << 1), 119),
    (23, (1 << 1), 119),
    (40, 1 | (1 << 1), 119),
    (2, (1 << 1), 120),
    (9, (1 << 1), 120),
    (23, (1 << 1), 120),
    (40, 1 | (1 << 1), 120),
    (2, (1 << 1), 121),
    (9, (1 << 1), 121),
    (23, (1 << 1), 121),
    (40, 1 | (1 << 1), 121),
    (2, (1 << 1), 122),
    (9, (1 << 1), 122),
    (23, (1 << 1), 122),
    (40, 1 | (1 << 1), 122),
    # Node 66
    (3, (1 << 1), 119),
    (6, (1 << 1), 119),
    (10, (1 << 1), 119),
    (15, (1 << 1), 119),
    (24, (1 << 1), 119),
    (31, (1 << 1), 119),
    (41, (1 << 1), 119),
    (56, 1 | (1 << 1), 119),
    (3, (1 << 1), 120),
    (6, (1 << 1), 120),
    (10, (1 << 1), 120),
    (15, (1 << 1), 120),
    (24, (1 << 1), 120),
    (31, (1 << 1), 120),
    (41, (1 << 1), 120),
    (56, 1 | (1 << 1), 120),
    # Node 67
    (3, (1 << 1), 121),
    (6, (1 << 1), 121),
    (10, (1 << 1), 121),
    (15, (1 << 1), 121),
    (24, (1 << 1), 121),
    (31, (1 << 1), 121),
    (41, (1 << 1), 121),
    (56, 1 | (1 << 1), 121),
    (3, (1 << 1), 122),
    (6, (1 << 1), 122),
    (10, (1 << 1), 122),
    (15, (1 << 1), 122),
    (24, (1 << 1), 122),
    (31, (1 << 1), 122),
    (41, (1 << 1), 122),
    (56, 1 | (1 << 1), 122),
    # Node 68
    (1, (1 << 1), 38),
    (22, 1 | (1 << 1), 38),
    (1, (1 << 1), 42),
    (22, 1 | (1 << 1), 42),
    (1, (1 << 1), 44),
    (22, 1 | (1 << 1), 44),
    (1, (1 << 1), 59),
    (22, 1 | (1 << 1), 59),
    (1, (1 << 1), 88),
    (22, 1 | (1 << 1), 88),
    (1, (1 << 1), 90),
    (22, 1 | (1 << 1), 90),
    (76, 0, 0),
    (77, 0, 0),
    (79, 0, 0),
    (81, 0, 0),
    # Node 69
    (2, (1 << 1), 38),
    (9, (1 << 1), 38),
    (23, (1 << 1), 38),
    (40, 1 | (1 << 1), 38),
    (2, (1 << 1), 42),
    (9, (1 << 1), 42),
    (23, (1 << 1), 42),
    (40, 1 | (1 << 1), 42),
    (2, (1 << 1), 44),
    (9, (1 << 1), 44),
    (23, (1 << 1), 44),
    (40, 1 | (1 << 1), 44),
    (2, (1 << 1), 59),
    (9, (1 << 1), 59),
    (23, (1 << 1), 59),
    (40, 1 | (1 << 1), 59),
    # Node 70
    (3, (1 << 1), 38),
    (6, (1 << 1), 38),
    (10, (1 << 1), 38),
    (15, (1 << 1), 38),
    (24, (1 << 1), 38),
    (31, (1 << 1), 38),
    (41, (1 << 1), 38),
    (56, 1 | (1 << 1), 38),
    (3, (1 << 1), 42),
    (6, (1 << 1), 42),
    (10, (1 << 1), 42),
    (15, (1 << 1), 42),
    (24, (1 << 1), 42),
    (31, (1 << 1), 42),
    (41, (1 << 1), 42),
    (56, 1 | (1 << 1), 42),
    # Node 71
    (3, (1 << 1), 44),
    (6, (1 << 1), 44),
    (10, (1 << 1), 44),
    (15, (1 << 1), 44),
    (24, (1 << 1), 44),
    (31, (1 << 1), 44),
    (41, (1 << 1), 44),
    (56, 1 | (1 << 1), 44),
    (3, (1 << 1), 59),
    (6, (1 << 1), 59),
    (10, (1 << 1), 59),
    (15, (1 << 1), 59),
    (24, (1 << 1), 59),
    (31, (1 << 1), 59),
    (41, (1 << 1), 59),
    (56, 1 | (1 << 1), 59),
    # Node 72
    (2, (1 << 1), 88),
    (9, (1 << 1), 88),
    (23, (1 << 1), 88),
    (40, 1 | (1 << 1), 88),
    (2, (1 << 1), 90),
    (9, (1 << 1), 90),
    (23, (1 << 1), 90),
    (40, 1 | (1 << 1), 90),
    (0, 1 | (1 << 1), 33),
    (0, 1 | (1 << 1), 34),
    (0, 1 | (1 << 1), 40),
    (0, 1 | (1 << 1), 41),
    (0, 1 | (1 << 1), 63),
    (80, 0, 0),
    (82, 0, 0),
    (84, 0, 0),
    # Node 73
    (3, (1 << 1), 88),
    (6, (1 << 1), 88),
    (10, (1 << 1), 88),
    (15, (1 << 1), 88),
    (24, (1 << 1), 88),
    (31, (1 << 1), 88),
    (41, (1 << 1), 88),
    (56, 1 | (1 << 1), 88),
    (3, (1 << 1), 90),
    (6, (1 << 1), 90),
    (10, (1 << 1), 90),
    (15, (1 << 1), 90),
    (24, (1 << 1), 90),
    (31, (1 << 1), 90),
    (41, (1 << 1), 90),
    (56, 1 | (1 << 1), 90),
    # Node 74
    (1, (1 << 1), 33),
    (22, 1 | (1 << 1), 33),
    (1, (1 << 1), 34),
    (22, 1 | (1 << 1), 34),
    (1, (1 << 1), 40),
    (22, 1 | (1 << 1), 40),
    (1, (1 << 1), 41),
    (22, 1 | (1 << 1), 41),
    (1, (1 << 1), 63),
    (22, 1 | (1 << 1), 63),
    (0, 1 | (1 << 1), 39),
    (0, 1 | (1 << 1), 43),
    (0, 1 | (1 << 1), 124),
    (83, 0, 0),
    (85, 0, 0),
    (88, 0, 0),
    # Node 75
    (2, (1 << 1), 33),
    (9, (1 << 1), 33),
    (23, (1 << 1), 33),
    (40, 1 | (1 << 1), 33),
    (2, (1 << 1), 34),
    (9, (1 << 1), 34),
    (23, (1 << 1), 34),
    (40, 1 | (1 << 1), 34),
    (2, (1 << 1), 40),
    (9, (1 << 1), 40),
    (23, (1 << 1), 40),
    (40, 1 | (1 << 1), 40),
    (2, (1 << 1), 41),
    (9, (1 << 1), 41),
    (23, (1 << 1), 41),
    (40, 1 | (1 << 1), 41),
    # Node 76
    (3, (1 << 1), 33),
    (6, (1 << 1), 33),
    (10, (1 << 1), 33),
    (15, (1 << 1), 33),
    (24, (1 << 1), 33),
    (31, (1 << 1), 33),
    (41, (1 << 1), 33),
    (56, 1 | (1 << 1), 33),
    (3, (1 << 1), 34),
    (6, (1 << 1), 34),
    (10, (1 << 1), 34),
    (15, (1 << 1), 34),
    (24, (1 << 1), 34),
    (31, (1 << 1), 34),
    (41, (1 << 1), 34),
    (56, 1 | (1 << 1), 34),
    # Node 77
    (3, (1 << 1), 40),
    (6, (1 << 1), 40),
    (10, (1 << 1), 40),
    (15, (1 << 1), 40),
    (24, (1 << 1), 40),
    (31, (1 << 1), 40),
    (41, (1 << 1), 40),
    (56, 1 | (1 << 1), 40),
    (3, (1 << 1), 41),
    (6, (1 << 1), 41),
    (10, (1 << 1), 41),
    (15, (1 << 1), 41),
    (24, (1 << 1), 41),
    (31, (1 << 1), 41),
    (41, (1 << 1), 41),
    (56, 1 | (1 << 1), 41),
    # Node 78
    (2, (1 << 1), 63),
    (9, (1 << 1), 63),
    (23, (1 << 1), 63),
    (40, 1 | (1 << 1), 63),
    (1, (1 << 1), 39),
    (22, 1 | (1 << 1), 39),
    (1, (1 << 1), 43),
    (22, 1 | (1 << 1), 43),
    (1, (1 << 1), 124),
    (22, 1 | (1 << 1), 124),
    (0, 1 | (1 << 1), 35),
    (0, 1 | (1 << 1), 62),
    (86, 0, 0),
    (87, 0, 0),
    (89, 0, 0),
    (90, 0, 0),
    # Node 79
    (3, (1 << 1), 63),
    (6, (1 << 1), 63),
    (10, (1 << 1), 63),
    (15, (1 << 1), 63),
    (24, (1 << 1), 63),
    (31, (1 << 1), 63),
    (41, (1 << 1), 63),
    (56, 1 | (1 << 1), 63),
    (2, (1 << 1), 39),
    (9, (1 << 1), 39),
    (23, (1 << 1), 39),
    (40, 1 | (1 << 1), 39),
    (2, (1 << 1), 43),
    (9, (1 << 1), 43),
    (23, (1 << 1), 43),
    (40, 1 | (1 << 1), 43),
    # Node 80
    (3, (1 << 1), 39),
    (6, (1 << 1), 39),
    (10, (1 << 1), 39),
    (15, (1 << 1), 39),
    (24, (1 << 1), 39),
    (31, (1 << 1), 39),
    (41, (1 << 1), 39),
    (56, 1 | (1 << 1), 39),
    (3, (1 << 1), 43),
    (6, (1 << 1), 43),
    (10, (1 << 1), 43),
    (15, (1 << 1), 43),
    (24, (1 << 1), 43),
    (31, (1 << 1), 43),
    (41, (1 << 1), 43),
    (56, 1 | (1 << 1), 43),
    # Node 81
    (2, (1 << 1), 124),
    (9, (1 << 1), 124),
    (23, (1 << 1), 124),
    (40, 1 | (1 << 1), 124),
    (1, (1 << 1), 35),
    (22, 1 | (1 << 1), 35),
    (1, (1 << 1), 62),
    (22, 1 | (1 << 1), 62),
    (0, 1 | (1 << 1), 0),
    (0, 1 | (1 << 1), 36),
    (0, 1 | (1 << 1), 64),
    (0, 1 | (1 << 1), 91),
    (0, 1 | (1 << 1), 93),
    (0, 1 | (1 << 1), 126),
    (91, 0, 0),
    (92, 0, 0),
    # Node 82
    (3, (1 << 1), 124),
    (6, (1 << 1), 124),
    (10, (1 << 1), 124),
    (15, (1 << 1), 124),
    (24, (1 << 1), 124),
    (31, (1 << 1), 124),
    (41, (1 << 1), 124),
    (56, 1 | (1 << 1), 124),
    (2, (1 << 1), 35),
    (9, (1 << 1), 35),
    (23, (1 << 1), 35),
    (40, 1 | (1 << 1), 35),
    (2, (1 << 1), 62),
    (9, (1 << 1), 62),
    (23, (1 << 1), 62),
    (40, 1 | (1 << 1), 62),
    # Node 83
    (3, (1 << 1), 35),
    (6, (1 << 1), 35),
    (10, (1 << 1), 35),
    (15, (1 << 1), 35),
    (24, (1 << 1), 35),
    (31, (1 << 1), 35),
    (41, (1 << 1), 35),
    (56, 1 | (1 << 1), 35),
    (3, (1 << 1), 62),
    (6, (1 << 1), 62),
    (10, (1 << 1), 62),
    (15, (1 << 1), 62),
    (24, (1 << 1), 62),
    (31, (1 << 1), 62),
    (41, (1 << 1), 62),
    (56, 1 | (1 << 1), 62),
    # Node 84
    (1, (1 << 1), 0),
    (22, 1 | (1 << 1), 0),
    (1, (1 << 1), 36),
    (22, 1 | (1 << 1), 36),
    (1, (1 << 1), 64),
    (22, 1 | (1 << 1), 64),
    (1, (1 << 1), 91),
    (22, 1 | (1 << 1), 91),
    (1, (1 << 1), 93),
    (22, 1 | (1 << 1), 93),
    (1, (1 << 1), 126),
    (22, 1 | (1 << 1), 126),
    (0, 1 | (1 << 1), 94),
    (0, 1 | (1 << 1), 125),
    (93, 0, 0),
    (94, 0, 0),
    # Node 85
    (2, (1 << 1), 0),
    (9, (1 << 1), 0),
    (23, (1 << 1), 0),
    (40, 1 | (1 << 1), 0),
    (2, (1 << 1), 36),
    (9, (1 << 1), 36),
    (23, (1 << 1), 36),
    (40, 1 | (1 << 1), 36),
    (2, (1 << 1), 64),
    (9, (1 << 1), 64),
    (23, (1 << 1), 64),
    (40, 1 | (1 << 1), 64),
    (2, (1 << 1), 91),
    (9, (1 << 1), 91),
    (23, (1 << 1), 91),
    (40, 1 | (1 << 1), 91),
    # Node 86
    (3, (1 << 1), 0),
    (6, (1 << 1), 0),
    (10, (1 << 1), 0),
    (15, (1 << 1), 0),
    (24, (1 << 1), 0),
    (31, (1 << 1), 0),
    (41, (1 << 1), 0),
    (56, 1 | (1 << 1), 0),
    (3, (1 << 1), 36),
    (6, (1 << 1), 36),
    (10, (1 << 1), 36),
    (15, (1 << 1), 36),
    (24, (1 << 1), 36),
    (31, (1 << 1), 36),
    (41, (1 << 1), 36),
    (56, 1 | (1 << 1), 36),
    # Node 87
    (3, (1 << 1), 64),
    (6, (1 << 1), 64),
    (10, (1 << 1), 64),
    (15, (1 << 1), 64),
    (24, (1 << 1), 64),
    (31, (1 << 1), 64),
    (41, (1 << 1), 64),
    (56, 1 | (1 << 1), 64),
    (3, (1 << 1), 91),
    (6, (1 << 1), 91),
    (10, (1 << 1), 91),
    (15, (1 << 1), 91),
    (24, (1 << 1), 91),
    (31, (1 << 1), 91),
    (41, (1 << 1), 91),
    (56, 1 | (1 << 1), 91),
    # Node 88
    (2, (1 << 1), 93),
    (9, (1 << 1), 93),
    (23, (1 << 1), 93),
    (40, 1 | (1 << 1), 93),
    (2, (1 << 1), 126),
    (9, (1 << 1), 126),
    (23, (1 << 1), 126),
    (40, 1 | (1 << 1), 126),
    (1, (1 << 1), 94),
    (22, 1 | (1 << 1), 94),
    (1, (1 << 1), 125),
    (22, 1 | (1 << 1), 125),
    (0, 1 | (1 << 1), 60),
    (0, 1 | (1 << 1), 96),
    (0, 1 | (1 << 1), 123),
    (95, 0, 0),
    # Node 89
    (3, (1 << 1), 93),
    (6, (1 << 1), 93),
    (10, (1 << 1), 93),
    (15, (1 << 1), 93),
    (24, (1 << 1), 93),
    (31, (1 << 1), 93),
    (41, (1 << 1), 93),
    (56, 1 | (1 << 1), 93),
    (3, (1 << 1), 126),
    (6, (1 << 1), 126),
    (10, (1 << 1), 126),
    (15, (1 << 1), 126),
    (24, (1 << 1), 126),
    (31, (1 << 1), 126),
    (41, (1 << 1), 126),
    (56, 1 | (1 << 1), 126),
    # Node 90
    (2, (1 << 1), 94),
    (9, (1 << 1), 94),
    (23, (1 << 1), 94),
    (40, 1 | (1 << 1), 94),
    (2, (1 << 1), 125),
    (9, (1 << 1), 125),
    (23, (1 << 1), 125),
    (40, 1 | (1 << 1), 125),
    (1, (1 << 1), 60),
    (22, 1 | (1 << 1), 60),
    (1, (1 << 1), 96),
    (22, 1 | (1 << 1), 96),
    (1, (1 << 1), 123),
    (22, 1 | (1 << 1), 123),
    (96, 0, 0),
    (110, 0, 0),
    # Node 91
    (3, (1 << 1), 94),
    (6, (1 << 1), 94),
    (10, (1 << 1), 94),
    (15, (1 << 1), 94),
    (24, (1 << 1), 94),
    (31, (1 << 1), 94),
    (41, (1 << 1), 94),
    (56, 1 | (1 << 1), 94),
    (3, (1 << 1), 125),
    (6, (1 << 1), 125),
    (10, (1 << 1), 125),
    (15, (1 << 1), 125),
    (24, (1 << 1), 125),
    (31, (1 << 1), 125),
    (41, (1 << 1), 125),
    (56, 1 | (1 << 1), 125),
    # Node 92
    (2, (1 << 1), 60),
    (9, (1 << 1), 60),
    (23, (1 << 1), 60),
    (40, 1 | (1 << 1), 60),
    (2, (1 << 1), 96),
    (9, (1 << 1), 96),
    (23, (1 << 1), 96),
    (40, 1 | (1 << 1), 96),
    (2, (1 << 1), 123),
    (9, (1 << 1), 123),
    (23, (1 << 1), 123),
    (40, 1 | (1 << 1), 123),
    (97, 0, 0),
    (101, 0, 0),
    (111, 0, 0),
    (133, 0, 0),
    # Node 93
    (3, (1 << 1), 60),
    (6, (1 << 1), 60),
    (10, (1 << 1), 60),
    (15, (1 << 1), 60),
    (24, (1 << 1), 60),
    (31, (1 << 1), 60),
    (41, (1 << 1), 60),
    (56, 1 | (1 << 1), 60),
    (3, (1 << 1), 96),
    (6, (1 << 1), 96),
    (10, (1 << 1), 96),
    (15, (1 << 1), 96),
    (24, (1 << 1), 96),
    (31, (1 << 1), 96),
    (41, (1 << 1), 96),
    (56, 1 | (1 << 1), 96),
    # Node 94
    (3, (1 << 1), 123),
    (6, (1 << 1), 123),
    (10, (1 << 1), 123),
    (15, (1 << 1), 123),
    (24, (1 << 1), 123),
    (31, (1 << 1), 123),
    (41, (1 << 1), 123),
    (56, 1 | (1 << 1), 123),
    (98, 0, 0),
    (99, 0, 0),
    (102, 0, 0),
    (105, 0, 0),
    (112, 0, 0),
    (119, 0, 0),
    (134, 0, 0),
    (153, 0, 0),
    # Node 95
    (0, 1 | (1 << 1), 92),
    (0, 1 | (1 << 1), 195),
    (0, 1 | (1 << 1), 208),
    (100, 0, 0),
    (103, 0, 0),
    (104, 0, 0),
    (106, 0, 0),
    (107, 0, 0),
    (113, 0, 0),
    (116, 0, 0),
    (120, 0, 0),
    (126, 0, 0),
    (135, 0, 0),
    (142, 0, 0),
    (154, 0, 0),
    (169, 0, 0),
    # Node 96
    (1, (1 << 1), 92),
    (22, 1 | (1 << 1), 92),
    (1, (1 << 1), 195),
    (22, 1 | (1 << 1), 195),
    (1, (1 << 1), 208),
    (22, 1 | (1 << 1), 208),
    (0, 1 | (1 << 1), 128),
    (0, 1 | (1 << 1), 130),
    (0, 1 | (1 << 1), 131),
    (0, 1 | (1 << 1), 162),
    (0, 1 | (1 << 1), 184),
    (0, 1 | (1 << 1), 194),
    (0, 1 | (1 << 1), 224),
    (0, 1 | (1 << 1), 226),
    (108, 0, 0),
    (109, 0, 0),
    # Node 97
    (2, (1 << 1), 92),
    (9, (1 << 1), 92),
    (23, (1 << 1), 92),
    (40, 1 | (1 << 1), 92),
    (2, (1 << 1), 195),
    (9, (1 << 1), 195),
    (23, (1 << 1), 195),
    (40, 1 | (1 << 1), 195),
    (2, (1 << 1), 208),
    (9, (1 << 1), 208),
    (23, (1 << 1), 208),
    (40, 1 | (1 << 1), 208),
    (1, (1 << 1), 128),
    (22, 1 | (1 << 1), 128),
    (1, (1 << 1), 130),
    (22, 1 | (1 << 1), 130),
    # Node 98
    (3, (1 << 1), 92),
    (6, (1 << 1), 92),
    (10, (1 << 1), 92),
    (15, (1 << 1), 92),
    (24, (1 << 1), 92),
    (31, (1 << 1), 92),
    (41, (1 << 1), 92),
    (56, 1 | (1 << 1), 92),
    (3, (1 << 1), 195),
    (6, (1 << 1), 195),
    (10, (1 << 1), 195),
    (15, (1 << 1), 195),
    (24, (1 << 1), 195),
    (31, (1 << 1), 195),
    (41, (1 << 1), 195),
    (56, 1 | (1 << 1), 195),
    # Node 99
    (3, (1 << 1), 208),
    (6, (1 << 1), 208),
    (10, (1 << 1), 208),
    (15, (1 << 1), 208),
    (24, (1 << 1), 208),
    (31, (1 << 1), 208),
    (41, (1 << 1), 208),
    (56, 1 | (1 << 1), 208),
    (2, (1 << 1), 128),
    (9, (1 << 1), 128),
    (23, (1 << 1), 128),
    (40, 1 | (1 << 1), 128),
    (2, (1 << 1), 130),
    (9, (1 << 1), 130),
    (23, (1 << 1), 130),
    (40, 1 | (1 << 1), 130),
    # Node 100
    (3, (1 << 1), 128),
    (6, (1 << 1), 128),
    (10, (1 << 1), 128),
    (15, (1 << 1), 128),
    (24, (1 << 1), 128),
    (31, (1 << 1), 128),
    (41, (1 << 1), 128),
    (56, 1 | (1 << 1), 128),
    (3, (1 << 1), 130),
    (6, (1 << 1), 130),
    (10, (1 << 1), 130),
    (15, (1 << 1), 130),
    (24, (1 << 1), 130),
    (31, (1 << 1), 130),
    (41, (1 << 1), 130),
    (56, 1 | (1 << 1), 130),
    # Node 101
    (1, (1 << 1), 131),
    (22, 1 | (1 << 1), 131),
    (1, (1 << 1), 162),
    (22, 1 | (1 << 1), 162),
    (1, (1 << 1), 184),
    (22, 1 | (1 << 1), 184),
    (1, (1 << 1), 194),
    (22, 1 | (1 << 1), 194),
    (1, (1 << 1), 224),
    (22, 1 | (1 << 1), 224),
    (1, (1 << 1), 226),
    (22, 1 | (1 << 1), 226),
    (0, 1 | (1 << 1), 153),
    (0, 1 | (1 << 1), 161),
    (0, 1 | (1 << 1), 167),
    (0, 1 | (1 << 1), 172),
    # Node 102
    (2, (1 << 1), 131),
    (9, (1 << 1), 131),
    (23, (1 << 1), 131),
    (40, 1 | (1 << 1), 131),
    (2, (1 << 1), 162),
    (9, (1 << 1), 162),
    (23, (1 << 1), 162),
    (40, 1 | (1 << 1), 162),
    (2, (1 << 1), 184),
    (9, (1 << 1), 184),
    (23, (1 << 1), 184),
    (40, 1 | (1 << 1), 184),
    (2, (1 << 1), 194),
    (9, (1 << 1), 194),
    (23, (1 << 1), 194),
    (40, 1 | (1 << 1), 194),
    # Node 103
    (3, (1 << 1), 131),
    (6, (1 << 1), 131),
    (10, (1 << 1), 131),
    (15, (1 << 1), 131),
    (24, (1 << 1), 131),
    (31, (1 << 1), 131),
    (41, (1 << 1), 131),
    (56, 1 | (1 << 1), 131),
    (3, (1 << 1), 162),
    (6, (1 << 1), 162),
    (10, (1 << 1), 162),
    (15, (1 << 1), 162),
    (24, (1 << 1), 162),
    (31, (1 << 1), 162),
    (41, (1 << 1), 162),
    (56, 1 | (1 << 1), 162),
    # Node 104
    (3, (1 << 1), 184),
    (6, (1 << 1), 184),
    (10, (1 << 1), 184),
    (15, (1 << 1), 184),
    (24, (1 << 1), 184),
    (31, (1 << 1), 184),
    (41, (1 << 1), 184),
    (56, 1 | (1 << 1), 184),
    (3, (1 << 1), 194),
    (6, (1 << 1), 194),
    (10, (1 << 1), 194),
    (15, (1 << 1), 194),
    (24, (1 << 1), 194),
    (31, (1 << 1), 194),
    (41, (1 << 1), 194),
    (56, 1 | (1 << 1), 194),
    # Node 105
    (2, (1 << 1), 224),
    (9, (1 << 1), 224),
    (23, (1 << 1), 224),
    (40, 1 | (1 << 1), 224),
    (2, (1 << 1), 226),
    (9, (1 << 1), 226),
    (23, (1 << 1), 226),
    (40, 1 | (1 << 1), 226),
    (1, (1 << 1), 153),
    (22, 1 | (1 << 1), 153),
    (1, (1 << 1), 161),
    (22, 1 | (1 << 1), 161),
    (1, (1 << 1), 167),
    (22, 1 | (1 << 1), 167),
    (1, (1 << 1), 172),
    (22, 1 | (1 << 1), 172),
    # Node 106
    (3, (1 << 1), 224),
    (6, (1 << 1), 224),
    (10, (1 << 1), 224),
    (15, (1 << 1), 224),
    (24, (1 << 1), 224),
    (31, (1 << 1), 224),
    (41, (1 << 1), 224),
    (56, 1 | (1 << 1), 224),
    (3, (1 << 1), 226),
    (6, (1 << 1), 226),
    (10, (1 << 1), 226),
    (15, (1 << 1), 226),
    (24, (1 << 1), 226),
    (31, (1 << 1), 226),
    (41, (1 << 1), 226),
    (56, 1 | (1 << 1), 226),
    # Node 107
    (2, (1 << 1), 153),
    (9, (1 << 1), 153),
    (23, (1 << 1), 153),
    (40, 1 | (1 << 1), 153),
    (2, (1 << 1), 161),
    (9, (1 << 1), 161),
    (23, (1 << 1), 161),
    (40, 1 | (1 << 1), 161),
    (2, (1 << 1), 167),
    (9, (1 << 1), 167),
    (23, (1 << 1), 167),
    (40, 1 | (1 << 1), 167),
    (2, (1 << 1), 172),
    (9, (1 << 1), 172),
    (23, (1 << 1), 172),
    (40, 1 | (1 << 1), 172),
    # Node 108
    (3, (1 << 1), 153),
    (6, (1 << 1), 153),
    (10, (1 << 1), 153),
    (15, (1 << 1), 153),
    (24, (1 << 1), 153),
    (31, (1 << 1), 153),
    (41, (1 << 1), 153),
    (56, 1 | (1 << 1), 153),
    (3, (1 << 1), 161),
    (6, (1 << 1), 161),
    (10, (1 << 1), 161),
    (15, (1 << 1), 161),
    (24, (1 << 1), 161),
    (31, (1 << 1), 161),
    (41, (1 << 1), 161),
    (56, 1 | (1 << 1), 161),
    # Node 109
    (3, (1 << 1), 167),
    (6, (1 << 1), 167),
    (10, (1 << 1), 167),
    (15, (1 << 1), 167),
    (24, (1 << 1), 167),
    (31, (1 << 1), 167),
    (41, (1 << 1), 167),
    (56, 1 | (1 << 1), 167),
    (3, (1 << 1), 172),
    (6, (1 << 1), 172),
    (10, (1 << 1), 172),
    (15, (1 << 1), 172),
    (24, (1 << 1), 172),
    (31, (1 << 1), 172),
    (41, (1 << 1), 172),
    (56, 1 | (1 << 1), 172),
    # Node 110
    (114, 0, 0),
    (115, 0, 0),
    (117, 0, 0),
    (118, 0, 0),
    (121, 0, 0),
    (123, 0, 0),
    (127, 0, 0),
    (130, 0, 0),
    (136, 0, 0),
    (139, 0, 0),
    (143, 0, 0),
    (146, 0, 0),
    (155, 0, 0),
    (162, 0, 0),
    (170, 0, 0),
    (180, 0, 0),
    # Node 111
    (0, 1 | (1 << 1), 176),
    (0, 1 | (1 << 1), 177),
    (0, 1 | (1 << 1), 179),
    (0, 1 | (1 << 1), 209),
    (0, 1 | (1 << 1), 216),
    (0, 1 | (1 << 1), 217),
    (0, 1 | (1 << 1), 227),
    (0, 1 | (1 << 1), 229),
    (0, 1 | (1 << 1), 230),
    (122, 0, 0),
    (124, 0, 0),
    (125, 0, 0),
    (128, 0, 0),
    (129, 0, 0),
    (131, 0, 0),
    (132, 0, 0),
    # Node 112
    (1, (1 << 1), 176),
    (22, 1 | (1 << 1), 176),
    (1, (1 << 1), 177),
    (22, 1 | (1 << 1), 177),
    (1, (1 << 1), 179),
    (22, 1 | (1 << 1), 179),
    (1, (1 << 1), 209),
    (22, 1 | (1 << 1), 209),
    (1, (1 << 1), 216),
    (22, 1 | (1 << 1), 216),
    (1, (1 << 1), 217),
    (22, 1 | (1 << 1), 217),
    (1, (1 << 1), 227),
    (22, 1 | (1 << 1), 227),
    (1, (1 << 1), 229),
    (22, 1 | (1 << 1), 229),
    # Node 113
    (2, (1 << 1), 176),
    (9, (1 << 1), 176),
    (23, (1 << 1), 176),
    (40, 1 | (1 << 1), 176),
    (2, (1 << 1), 177),
    (9, (1 << 1), 177),
    (23, (1 << 1), 177),
    (40, 1 | (1 << 1), 177),
    (2, (1 << 1), 179),
    (9, (1 << 1), 179),
    (23, (1 << 1), 179),
    (40, 1 | (1 << 1), 179),
    (2, (1 << 1), 209),
    (9, (1 << 1), 209),
    (23, (1 << 1), 209),
    (40, 1 | (1 << 1), 209),
    # Node 114
    (3, (1 << 1), 176),
    (6, (1 << 1), 176),
    (10, (1 << 1), 176),
    (15, (1 << 1), 176),
    (24, (1 << 1), 176),
    (31, (1 << 1), 176),
    (41, (1 << 1), 176),
    (56, 1 | (1 << 1), 176),
    (3, (1 << 1), 177),
    (6, (1 << 1), 177),
    (10, (1 << 1), 177),
    (15, (1 << 1), 177),
    (24, (1 << 1), 177),
    (31, (1 << 1), 177),
    (41, (1 << 1), 177),
    (56, 1 | (1 << 1), 177),
    # Node 115
    (3, (1 << 1), 179),
    (6, (1 << 1), 179),
    (10, (1 << 1), 179),
    (15, (1 << 1), 179),
    (24, (1 << 1), 179),
    (31, (1 << 1), 179),
    (41, (1 << 1), 179),
    (56, 1 | (1 << 1), 179),
    (3, (1 << 1), 209),
    (6, (1 << 1), 209),
    (10, (1 << 1), 209),
    (15, (1 << 1), 209),
    (24, (1 << 1), 209),
    (31, (1 << 1), 209),
    (41, (1 << 1), 209),
    (56, 1 | (1 << 1), 209),
    # Node 116
    (2, (1 << 1), 216),
    (9, (1 << 1), 216),
    (23, (1 << 1), 216),
    (40, 1 | (1 << 1), 216),
    (2, (1 << 1), 217),
    (9, (1 << 1), 217),
    (23, (1 << 1), 217),
    (40, 1 | (1 << 1), 217),
    (2, (1 << 1), 227),
    (9, (1 << 1), 227),
    (23, (1 << 1), 227),
    (40, 1 | (1 << 1), 227),
    (2, (1 << 1), 229),
    (9, (1 << 1), 229),
    (23, (1 << 1), 229),
    (40, 1 | (1 << 1), 229),
    # Node 117
    (3, (1 << 1), 216),
    (6, (1 << 1), 216),
    (10, (1 << 1), 216),
    (15, (1 << 1), 216),
    (24, (1 << 1), 216),
    (31, (1 << 1), 216),
    (41, (1 << 1), 216),
    (56, 1 | (1 << 1), 216),
    (3, (1 << 1), 217),
    (6, (1 << 1), 217),
    (10, (1 << 1), 217),
    (15, (1 << 1), 217),
    (24, (1 << 1), 217),
    (31, (1 << 1), 217),
    (41, (1 << 1), 217),
    (56, 1 | (1 << 1), 217),
    # Node 118
    (3, (1 << 1), 227),
    (6, (1 << 1), 227),
    (10, (1 << 1), 227),
    (15, (1 << 1), 227),
    (24, (1 << 1), 227),
    (31, (1 << 1), 227),
    (41, (1 << 1), 227),
    (56, 1 | (1 << 1), 227),
    (3, (1 << 1), 229),
    (6, (1 << 1), 229),
    (10, (1 << 1), 229),
    (15, (1 << 1), 229),
    (24, (1 << 1), 229),
    (31, (1 << 1), 229),
    (41, (1 << 1), 229),
    (56, 1 | (1 << 1), 229),
    # Node 119
    (1, (1 << 1), 230),
    (22, 1 | (1 << 1), 230),
    (0, 1 | (1 << 1), 129),
    (0, 1 | (1 << 1), 132),
    (0, 1 | (1 << 1), 133),
    (0, 1 | (1 << 1), 134),
    (0, 1 | (1 << 1), 136),
    (0, 1 | (1 << 1), 146),
    (0, 1 | (1 << 1), 154),
    (0, 1 | (1 << 1), 156),
    (0, 1 | (1 << 1), 160),
    (0, 1 | (1 << 1), 163),
    (0, 1 | (1 << 1), 164),
    (0, 1 | (1 << 1), 169),
    (0, 1 | (1 << 1), 170),
    (0, 1 | (1 << 1), 173),
    # Node 120
    (2, (1 << 1), 230),
    (9, (1 << 1), 230),
    (23, (1 << 1), 230),
    (40, 1 | (1 << 1), 230),
    (1, (1 << 1), 129),
    (22, 1 | (1 << 1), 129),
    (1, (1 << 1), 132),
    (22, 1 | (1 << 1), 132),
    (1, (1 << 1), 133),
    (22, 1 | (1 << 1), 133),
    (1, (1 << 1), 134),
    (22, 1 | (1 << 1), 134),
    (1, (1 << 1), 136),
    (22, 1 | (1 << 1), 136),
    (1, (1 << 1), 146),
    (22, 1 | (1 << 1), 146),
    # Node 121
    (3, (1 << 1), 230),
    (6, (1 << 1), 230),
    (10, (1 << 1), 230),
    (15, (1 << 1), 230),
    (24, (1 << 1), 230),
    (31, (1 << 1), 230),
    (41, (1 << 1), 230),
    (56, 1 | (1 << 1), 230),
    (2, (1 << 1), 129),
    (9, (1 << 1), 129),
    (23, (1 << 1), 129),
    (40, 1 | (1 << 1), 129),
    (2, (1 << 1), 132),
    (9, (1 << 1), 132),
    (23, (1 << 1), 132),
    (40, 1 | (1 << 1), 132),
    # Node 122
    (3, (1 << 1), 129),
    (6, (1 << 1), 129),
    (10, (1 << 1), 129),
    (15, (1 << 1), 129),
    (24, (1 << 1), 129),
    (31, (1 << 1), 129),
    (41, (1 << 1), 129),
    (56, 1 | (1 << 1), 129),
    (3, (1 << 1), 132),
    (6, (1 << 1), 132),
    (10, (1 << 1), 132),
    (15, (1 << 1), 132),
    (24, (1 << 1), 132),
    (31, (1 << 1), 132),
    (41, (1 << 1), 132),
    (56, 1 | (1 << 1), 132),
    # Node 123
    (2, (1 << 1), 133),
    (9, (1 << 1), 133),
    (23, (1 << 1), 133),
    (40, 1 | (1 << 1), 133),
    (2, (1 << 1), 134),
    (9, (1 << 1), 134),
    (23, (1 << 1), 134),
    (40, 1 | (1 << 1), 134),
    (2, (1 << 1), 136),
    (9, (1 << 1), 136),
    (23, (1 << 1), 136),
    (40, 1 | (1 << 1), 136),
    (2, (1 << 1), 146),
    (9, (1 << 1), 146),
    (23, (1 << 1), 146),
    (40, 1 | (1 << 1), 146),
    # Node 124
    (3, (1 << 1), 133),
    (6, (1 << 1), 133),
    (10, (1 << 1), 133),
    (15, (1 << 1), 133),
    (24, (1 << 1), 133),
    (31, (1 << 1), 133),
    (41, (1 << 1), 133),
    (56, 1 | (1 << 1), 133),
    (3, (1 << 1), 134),
    (6, (1 << 1), 134),
    (10, (1 << 1), 134),
    (15, (1 << 1), 134),
    (24, (1 << 1), 134),
    (31, (1 << 1), 134),
    (41, (1 << 1), 134),
    (56, 1 | (1 << 1), 134),
    # Node 125
    (3, (1 << 1), 136),
    (6, (1 << 1), 136),
    (10, (1 << 1), 136),
    (15, (1 << 1), 136),
    (24, (1 << 1), 136),
    (31, (1 << 1), 136),
    (41, (1 << 1), 136),
    (56, 1 | (1 << 1), 136),
    (3, (1 << 1), 146),
    (6, (1 << 1), 146),
    (10, (1 << 1), 146),
    (15, (1 << 1), 146),
    (24, (1 << 1), 146),
    (31, (1 << 1), 146),
    (41, (1 << 1), 146),
    (56, 1 | (1 << 1), 146),
    # Node 126
    (1, (1 << 1), 154),
    (22, 1 | (1 << 1), 154),
    (1, (1 << 1), 156),
    (22, 1 | (1 << 1), 156),
    (1, (1 << 1), 160),
    (22, 1 | (1 << 1), 160),
    (1, (1 << 1), 163),
    (22, 1 | (1 << 1), 163),
    (1, (1 << 1), 164),
    (22, 1 | (1 << 1), 164),
    (1, (1 << 1), 169),
    (22, 1 | (1 << 1), 169),
    (1, (1 << 1), 170),
    (22, 1 | (1 << 1), 170),
    (1, (1 << 1), 173),
    (22, 1 | (1 << 1), 173),
    # Node 127
    (2, (1 << 1), 154),
    (9, (1 << 1), 154),
    (23, (1 << 1), 154),
    (40, 1 | (1 << 1), 154),
    (2, (1 << 1), 156),
    (9, (1 << 1), 156),
    (23, (1 << 1), 156),
    (40, 1 | (1 << 1), 156),
    (2, (1 << 1), 160),
    (9, (1 << 1), 160),
    (23, (1 << 1), 160),
    (40, 1 | (1 << 1), 160),
    (2, (1 << 1), 163),
    (9, (1 << 1), 163),
    (23, (1 << 1), 163),
    (40, 1 | (1 << 1), 163),
    # Node 128
    (3, (1 << 1), 154),
    (6, (1 << 1), 154),
    (10, (1 << 1), 154),
    (15, (1 << 1), 154),
    (24, (1 << 1), 154),
    (31, (1 << 1), 154),
    (41, (1 << 1), 154),
    (56, 1 | (1 << 1), 154),
    (3, (1 << 1), 156),
    (6, (1 << 1), 156),
    (10, (1 << 1), 156),
    (15, (1 << 1), 156),
    (24, (1 << 1), 156),
    (31, (1 << 1), 156),
    (41, (1 << 1), 156),
    (56, 1 | (1 << 1), 156),
    # Node 129
    (3, (1 << 1), 160),
    (6, (1 << 1), 160),
    (10, (1 << 1), 160),
    (15, (1 << 1), 160),
    (24, (1 << 1), 160),
    (31, (1 << 1), 160),
    (41, (1 << 1), 160),
    (56, 1 | (1 << 1), 160),
    (3, (1 << 1), 163),
    (6, (1 << 1), 163),
    (10, (1 << 1), 163),
    (15, (1 << 1), 163),
    (24, (1 << 1), 163),
    (31, (1 << 1), 163),
    (41, (1 << 1), 163),
    (56, 1 | (1 << 1), 163),
    # Node 130
    (2, (1 << 1), 164),
    (9, (1 << 1), 164),
    (23, (1 << 1), 164),
    (40, 1 | (1 << 1), 164),
    (2, (1 << 1), 169),
    (9, (1 << 1), 169),
    (23, (1 << 1), 169),
    (40, 1 | (1 << 1), 169),
    (2, (1 << 1), 170),
    (9, (1 << 1), 170),
    (23, (1 << 1), 170),
    (40, 1 | (1 << 1), 170),
    (2, (1 << 1), 173),
    (9, (1 << 1), 173),
    (23, (1 << 1), 173),
    (40, 1 | (1 << 1), 173),
    # Node 131
    (3, (1 << 1), 164),
    (6, (1 << 1), 164),
    (10, (1 << 1), 164),
    (15, (1 << 1), 164),
    (24, (1 << 1), 164),
    (31, (1 << 1), 164),
    (41, (1 << 1), 164),
    (56, 1 | (1 << 1), 164),
    (3, (1 << 1), 169),
    (6, (1 << 1), 169),
    (10, (1 << 1), 169),
    (15, (1 << 1), 169),
    (24, (1 << 1), 169),
    (31, (1 << 1), 169),
    (41, (1 << 1), 169),
    (56, 1 | (1 << 1), 169),
    # Node 132
    (3, (1 << 1), 170),
    (6, (1 << 1), 170),
    (10, (1 << 1), 170),
    (15, (1 << 1), 170),
    (24, (1 << 1), 170),
    (31, (1 << 1), 170),
    (41, (1 << 1), 170),
    (56, 1 | (1 << 1), 170),
    (3, (1 << 1), 173),
    (6, (1 << 1), 173),
    (10, (1 << 1), 173),
    (15, (1 << 1), 173),
    (24, (1 << 1), 173),
    (31, (1 << 1), 173),
    (41, (1 << 1), 173),
    (56, 1 | (1 << 1), 173),
    # Node 133
    (137, 0, 0),
    (138, 0, 0),
    (140, 0, 0),
    (141, 0, 0),
    (144, 0, 0),
    (145, 0, 0),
    (147, 0, 0),
    (150, 0, 0),
    (156, 0, 0),
    (159, 0, 0),
    (163, 0, 0),
    (166, 0, 0),
    (171, 0, 0),
    (174, 0, 0),
    (181, 0, 0),
    (190, 0, 0),
    # Node 134
    (0, 1 | (1 << 1), 178),
    (0, 1 | (1 << 1), 181),
    (0, 1 | (1 << 1), 185),
    (0, 1 | (1 << 1), 186),
    (0, 1 | (1 << 1), 187),
    (0, 1 | (1 << 1), 189),
    (0, 1 | (1 << 1), 190),
    (0, 1 | (1 << 1), 196),
    (0, 1 | (1 << 1), 198),
    (0, 1 | (1 << 1), 228),
    (0, 1 | (1 << 1), 232),
    (0, 1 | (1 << 1), 233),
    (148, 0, 0),
    (149, 0, 0),
    (151, 0, 0),
    (152, 0, 0),
    # Node 135
    (1, (1 << 1), 178),
    (22, 1 | (1 << 1), 178),
    (1, (1 << 1), 181),
    (22, 1 | (1 << 1), 181),
    (1, (1 << 1), 185),
    (22, 1 | (1 << 1), 185),
    (1, (1 << 1), 186),
    (22, 1 | (1 << 1), 186),
    (1, (1 << 1), 187),
    (22, 1 | (1 << 1), 187),
    (1, (1 << 1), 189),
    (22, 1 | (1 << 1), 189),
    (1, (1 << 1), 190),
    (22, 1 | (1 << 1), 190),
    (1, (1 << 1), 196),
    (22, 1 | (1 << 1), 196),
    # Node 136
    (2, (1 << 1), 178),
    (9, (1 << 1), 178),
    (23, (1 << 1), 178),
    (40, 1 | (1 << 1), 178),
    (2, (1 << 1), 181),
    (9, (1 << 1), 181),
    (23, (1 << 1), 181),
    (40, 1 | (1 << 1), 181),
    (2, (1 << 1), 185),
    (9, (1 << 1), 185),
    (23, (1 << 1), 185),
    (40, 1 | (1 << 1), 185),
    (2, (1 << 1), 186),
    (9, (1 << 1), 186),
    (23, (1 << 1), 186),
    (40, 1 | (1 << 1), 186),
    # Node 137
    (3, (1 << 1), 178),
    (6, (1 << 1), 178),
    (10, (1 << 1), 178),
    (15, (1 << 1), 178),
    (24, (1 << 1), 178),
    (31, (1 << 1), 178),
    (41, (1 << 1), 178),
    (56, 1 | (1 << 1), 178),
    (3, (1 << 1), 181),
    (6, (1 << 1), 181),
    (10, (1 << 1), 181),
    (15, (1 << 1), 181),
    (24, (1 << 1), 181),
    (31, (1 << 1), 181),
    (41, (1 << 1), 181),
    (56, 1 | (1 << 1), 181),
    # Node 138
    (3, (1 << 1), 185),
    (6, (1 << 1), 185),
    (10, (1 << 1), 185),
    (15, (1 << 1), 185),
    (24, (1 << 1), 185),
    (31, (1 << 1), 185),
    (41, (1 << 1), 185),
    (56, 1 | (1 << 1), 185),
    (3, (1 << 1), 186),
    (6, (1 << 1), 186),
    (10, (1 << 1), 186),
    (15, (1 << 1), 186),
    (24, (1 << 1), 186),
    (31, (1 << 1), 186),
    (41, (1 << 1), 186),
    (56, 1 | (1 << 1), 186),
    # Node 139
    (2, (1 << 1), 187),
    (9, (1 << 1), 187),
    (23, (1 << 1), 187),
    (40, 1 | (1 << 1), 187),
    (2, (1 << 1), 189),
    (9, (1 << 1), 189),
    (23, (1 << 1), 189),
    (40, 1 | (1 << 1), 189),
    (2, (1 << 1), 190),
    (9, (1 << 1), 190),
    (23, (1 << 1), 190),
    (40, 1 | (1 << 1), 190),
    (2, (1 << 1), 196),
    (9, (1 << 1), 196),
    (23, (1 << 1), 196),
    (40, 1 | (1 << 1), 196),
    # Node 140
    (3, (1 << 1), 187),
    (6, (1 << 1), 187),
    (10, (1 << 1), 187),
    (15, (1 << 1), 187),
    (24, (1 << 1), 187),
    (31, (1 << 1), 187),
    (41, (1 << 1), 187),
    (56, 1 | (1 << 1), 187),
    (3, (1 << 1), 189),
    (6, (1 << 1), 189),
    (10, (1 << 1), 189),
    (15, (1 << 1), 189),
    (24, (1 << 1), 189),
    (31, (1 << 1), 189),
    (41, (1 << 1), 189),
    (56, 1 | (1 << 1), 189),
    # Node 141
    (3, (1 << 1), 190),
    (6, (1 << 1), 190),
    (10, (1 << 1), 190),
    (15, (1 << 1), 190),
    (24, (1 << 1), 190),
    (31, (1 << 1), 190),
    (41, (1 << 1), 190),
    (56, 1 | (1 << 1), 190),
    (3, (1 << 1), 196),
    (6, (1 << 1), 196),
    (10, (1 << 1), 196),
    (15, (1 << 1), 196),
    (24, (1 << 1), 196),
    (31, (1 << 1), 196),
    (41, (1 << 1), 196),
    (56, 1 | (1 << 1), 196),
    # Node 142
    (1, (1 << 1), 198),
    (22, 1 | (1 << 1), 198),
    (1, (1 << 1), 228),
    (22, 1 | (1 << 1), 228),
    (1, (1 << 1), 232),
    (22, 1 | (1 << 1), 232),
    (1, (1 << 1), 233),
    (22, 1 | (1 << 1), 233),
    (0, 1 | (1 << 1), 1),
    (0, 1 | (1 << 1), 135),
    (0, 1 | (1 << 1), 137),
    (0, 1 | (1 << 1), 138),
    (0, 1 | (1 << 1), 139),
    (0, 1 | (1 << 1), 140),
    (0, 1 | (1 << 1), 141),
    (0, 1 | (1 << 1), 143),
    # Node 143
    (2, (1 << 1), 198),
    (9, (1 << 1), 198),
    (23, (1 << 1), 198),
    (40, 1 | (1 << 1), 198),
    (2, (1 << 1), 228),
    (9, (1 << 1), 228),
    (23, (1 << 1), 228),
    (40, 1 | (1 << 1), 228),
    (2, (1 << 1), 232),
    (9, (1 << 1), 232),
    (23, (1 << 1), 232),
    (40, 1 | (1 << 1), 232),
    (2, (1 << 1), 233),
    (9, (1 << 1), 233),
    (23, (1 << 1), 233),
    (40, 1 | (1 << 1), 233),
    # Node 144
    (3, (1 << 1), 198),
    (6, (1 << 1), 198),
    (10, (1 << 1), 198),
    (15, (1 << 1), 198),
    (24, (1 << 1), 198),
    (31, (1 << 1), 198),
    (41, (1 << 1), 198),
    (56, 1 | (1 << 1), 198),
    (3, (1 << 1), 228),
    (6, (1 << 1), 228),
    (10, (1 << 1), 228),
    (15, (1 << 1), 228),
    (24, (1 << 1), 228),
    (31, (1 << 1), 228),
    (41, (1 << 1), 228),
    (56, 1 | (1 << 1), 228),
    # Node 145
    (3, (1 << 1), 232),
    (6, (1 << 1), 232),
    (10, (1 << 1), 232),
    (15, (1 << 1), 232),
    (24, (1 << 1), 232),
    (31, (1 << 1), 232),
    (41, (1 << 1), 232),
    (56, 1 | (1 << 1), 232),
    (3, (1 << 1), 233),
    (6, (1 << 1), 233),
    (10, (1 << 1), 233),
    (15, (1 << 1), 233),
    (24, (1 << 1), 233),
    (31, (1 << 1), 233),
    (41, (1 << 1), 233),
    (56, 1 | (1 << 1), 233),
    # Node 146
    (1, (1 << 1), 1),
    (22, 1 | (1 << 1), 1),
    (1, (1 << 1), 135),
    (22, 1 | (1 << 1), 135),
    (1, (1 << 1), 137),
    (22, 1 | (1 << 1), 137),
    (1, (1 << 1), 138),
    (22, 1 | (1 << 1), 138),
    (1, (1 << 1), 139),
    (22, 1 | (1 << 1), 139),
    (1, (1 << 1), 140),
    (22, 1 | (1 << 1), 140),
    (1, (1 << 1), 141),
    (22, 1 | (1 << 1), 141),
    (1, (1 << 1), 143),
    (22, 1 | (1 << 1), 143),
    # Node 147
    (2, (1 << 1), 1),
    (9, (1 << 1), 1),
    (23, (1 << 1), 1),
    (40, 1 | (1 << 1), 1),
    (2, (1 << 1), 135),
    (9, (1 << 1), 135),
    (23, (1 << 1), 135),
    (40, 1 | (1 << 1), 135),
    (2, (1 << 1), 137),
    (9, (1 << 1), 137),
    (23, (1 << 1), 137),
    (40, 1 | (1 << 1), 137),
    (2, (1 << 1), 138),
    (9, (1 << 1), 138),
    (23, (1 << 1), 138),
    (40, 1 | (1 << 1), 138),
    # Node 148
    (3, (1 << 1), 1),
    (6, (1 << 1), 1),
    (10, (1 << 1), 1),
    (15, (1 << 1), 1),
    (24, (1 << 1), 1),
    (31, (1 << 1), 1),
    (41, (1 << 1), 1),
    (56, 1 | (1 << 1), 1),
    (3, (1 << 1), 135),
    (6, (1 << 1), 135),
    (10, (1 << 1), 135),
    (15, (1 << 1), 135),
    (24, (1 << 1), 135),
    (31, (1 << 1), 135),
    (41, (1 << 1), 135),
    (56, 1 | (1 << 1), 135),
    # Node 149
    (3, (1 << 1), 137),
    (6, (1 << 1), 137),
    (10, (1 << 1), 137),
    (15, (1 << 1), 137),
    (24, (1 << 1), 137),
    (31, (1 << 1), 137),
    (41, (1 << 1), 137),
    (56, 1 | (1 << 1), 137),
    (3, (1 << 1), 138),
    (6, (1 << 1), 138),
    (10, (1 << 1), 138),
    (15, (1 << 1), 138),
    (24, (1 << 1), 138),
    (31, (1 << 1), 138),
    (41, (1 << 1), 138),
    (56, 1 | (1 << 1), 138),
    # Node 150
    (2, (1 << 1), 139),
    (9, (1 << 1), 139),
    (23, (1 << 1), 139),
    (40, 1 | (1 << 1), 139),
    (2, (1 << 1), 140),
    (9, (1 << 1), 140),
    (23, (1 << 1), 140),
    (40, 1 | (1 << 1), 140),
    (2, (1 << 1), 141),
    (9, (1 << 1), 141),
    (23, (1 << 1), 141),
    (40, 1 | (1 << 1), 141),
    (2, (1 << 1), 143),
    (9, (1 << 1), 143),
    (23, (1 << 1), 143),
    (40, 1 | (1 << 1), 143),
    # Node 151
    (3, (1 << 1), 139),
    (6, (1 << 1), 139),
    (10, (1 << 1), 139),
    (15, (1 << 1), 139),
    (24, (1 << 1), 139),
    (31, (1 << 1), 139),
    (41, (1 << 1), 139),
    (56, 1 | (1 << 1), 139),
    (3, (1 << 1), 140),
    (6, (1 << 1), 140),
    (10, (1 << 1), 140),
    (15, (1 << 1), 140),
    (24, (1 << 1), 140),
    (31, (1 << 1), 140),
    (41, (1 << 1), 140),
    (56, 1 | (1 << 1), 140),
    # Node 152
    (3, (1 << 1), 141),
    (6, (1 << 1), 141),
    (10, (1 << 1), 141),
    (15, (1 << 1), 141),
    (24, (1 << 1), 141),
    (31, (1 << 1), 141),
    (41, (1 << 1), 141),
    (56, 1 | (1 << 1), 141),
    (3, (1 << 1), 143),
    (6, (1 << 1), 143),
    (10, (1 << 1), 143),
    (15, (1 << 1), 143),
    (24, (1 << 1), 143),
    (31, (1 << 1), 143),
    (41, (1 << 1), 143),
    (56, 1 | (1 << 1), 143),
    # Node 153
    (157, 0, 0),
    (158, 0, 0),
    (160, 0, 0),
    (161, 0, 0),
    (164, 0, 0),
    (165, 0, 0),
    (167, 0, 0),
    (168, 0, 0),
    (172, 0, 0),
    (173, 0, 0),
    (175, 0, 0),
    (177, 0, 0),
    (182, 0, 0),
    (185, 0, 0),
    (191, 0, 0),
    (207, 0, 0),
    # Node 154
    (0, 1 | (1 << 1), 147),
    (0, 1 | (1 << 1), 149),
    (0, 1 | (1 << 1), 150),
    (0, 1 | (1 << 1), 151),
    (0, 1 | (1 << 1), 152),
    (0, 1 | (1 << 1), 155),
    (0, 1 | (1 << 1), 157),
    (0, 1 | (1 << 1), 158),
    (0, 1 | (1 << 1), 165),
    (0, 1 | (1 << 1), 166),
    (0, 1 | (1 << 1), 168),
    (0, 1 | (1 << 1), 174),
    (0, 1 | (1 << 1), 175),
    (0, 1 | (1 << 1), 180),
    (0, 1 | (1 << 1), 182),
    (0, 1 | (1 << 1), 183),
    # Node 155
    (1, (1 << 1), 147),
    (22, 1 | (1 << 1), 147),
    (1, (1 << 1), 149),
    (22, 1 | (1 << 1), 149),
    (1, (1 << 1), 150),
    (22, 1 | (1 << 1), 150),
    (1, (1 << 1), 151),
    (22, 1 | (1 << 1), 151),
    (1, (1 << 1), 152),
    (22, 1 | (1 << 1), 152),
    (1, (1 << 1), 155),
    (22, 1 | (1 << 1), 155),
    (1, (1 << 1), 157),
    (22, 1 | (1 << 1), 157),
    (1, (1 << 1), 158),
    (22, 1 | (1 << 1), 158),
    # Node 156
    (2, (1 << 1), 147),
    (9, (1 << 1), 147),
    (23, (1 << 1), 147),
    (40, 1 | (1 << 1), 147),
    (2, (1 << 1), 149),
    (9, (1 << 1), 149),
    (23, (1 << 1), 149),
    (40, 1 | (1 << 1), 149),
    (2, (1 << 1), 150),
    (9, (1 << 1), 150),
    (23, (1 << 1), 150),
    (40, 1 | (1 << 1), 150),
    (2, (1 << 1), 151),
    (9, (1 << 1), 151),
    (23, (1 << 1), 151),
    (40, 1 | (1 << 1), 151),
    # Node 157
    (3, (1 << 1), 147),
    (6, (1 << 1), 147),
    (10, (1 << 1), 147),
    (15, (1 << 1), 147),
    (24, (1 << 1), 147),
    (31, (1 << 1), 147),
    (41, (1 << 1), 147),
    (56, 1 | (1 << 1), 147),
    (3, (1 << 1), 149),
    (6, (1 << 1), 149),
    (10, (1 << 1), 149),
    (15, (1 << 1), 149),
    (24, (1 << 1), 149),
    (31, (1 << 1), 149),
    (41, (1 << 1), 149),
    (56, 1 | (1 << 1), 149),
    # Node 158
    (3, (1 << 1), 150),
    (6, (1 << 1), 150),
    (10, (1 << 1), 150),
    (15, (1 << 1), 150),
    (24, (1 << 1), 150),
    (31, (1 << 1), 150),
    (41, (1 << 1), 150),
    (56, 1 | (1 << 1), 150),
    (3, (1 << 1), 151),
    (6, (1 << 1), 151),
    (10, (1 << 1), 151),
    (15, (1 << 1), 151),
    (24, (1 << 1), 151),
    (31, (1 << 1), 151),
    (41, (1 << 1), 151),
    (56, 1 | (1 << 1), 151),
    # Node 159
    (2, (1 << 1), 152),
    (9, (1 << 1), 152),
    (23, (1 << 1), 152),
    (40, 1 | (1 << 1), 152),
    (2, (1 << 1), 155),
    (9, (1 << 1), 155),
    (23, (1 << 1), 155),
    (40, 1 | (1 << 1), 155),
    (2, (1 << 1), 157),
    (9, (1 << 1), 157),
    (23, (1 << 1), 157),
    (40, 1 | (1 << 1), 157),
    (2, (1 << 1), 158),
    (9, (1 << 1), 158),
    (23, (1 << 1), 158),
    (40, 1 | (1 << 1), 158),
    # Node 160
    (3, (1 << 1), 152),
    (6, (1 << 1), 152),
    (10, (1 << 1), 152),
    (15, (1 << 1), 152),
    (24, (1 << 1), 152),
    (31, (1 << 1), 152),
    (41, (1 << 1), 152),
    (56, 1 | (1 << 1), 152),
    (3, (1 << 1), 155),
    (6, (1 << 1), 155),
    (10, (1 << 1), 155),
    (15, (1 << 1), 155),
    (24, (1 << 1), 155),
    (31, (1 << 1), 155),
    (41, (1 << 1), 155),
    (56, 1 | (1 << 1), 155),
    # Node 161
    (3, (1 << 1), 157),
    (6, (1 << 1), 157),
    (10, (1 << 1), 157),
    (15, (1 << 1), 157),
    (24, (1 << 1), 157),
    (31, (1 << 1), 157),
    (41, (1 << 1), 157),
    (56, 1 | (1 << 1), 157),
    (3, (1 << 1), 158),
    (6, (1 << 1), 158),
    (10, (1 << 1), 158),
    (15, (1 << 1), 158),
    (24, (1 << 1), 158),
    (31, (1 << 1), 158),
    (41, (1 << 1), 158),
    (56, 1 | (1 << 1), 158),
    # Node 162
    (1, (1 << 1), 165),
    (22, 1 | (1 << 1), 165),
    (1, (1 << 1), 166),
    (22, 1 | (1 << 1), 166),
    (1, (1 << 1), 168),
    (22, 1 | (1 << 1), 168),
    (1, (1 << 1), 174),
    (22, 1 | (1 << 1), 174),
    (1, (1 << 1), 175),
    (22, 1 | (1 << 1), 175),
    (1, (1 << 1), 180),
    (22, 1 | (1 << 1), 180),
    (1, (1 << 1), 182),
    (22, 1 | (1 << 1), 182),
    (1, (1 << 1), 183),
    (22, 1 | (1 << 1), 183),
    # Node 163
    (2, (1 << 1), 165),
    (9, (1 << 1), 165),
    (23, (1 << 1), 165),
    (40, 1 | (1 << 1), 165),
    (2, (1 << 1), 166),
    (9, (1 << 1), 166),
    (23, (1 << 1), 166),
    (40, 1 | (1 << 1), 166),
    (2, (1 << 1), 168),
    (9, (1 << 1), 168),
    (23, (1 << 1), 168),
    (40, 1 | (1 << 1), 168),
    (2, (1 << 1), 174),
    (9, (1 << 1), 174),
    (23, (1 << 1), 174),
    (40, 1 | (1 << 1), 174),
    # Node 164
    (3, (1 << 1), 165),
    (6, (1 << 1), 165),
    (10, (1 << 1), 165),
    (15, (1 << 1), 165),
    (24, (1 << 1), 165),
    (31, (1 << 1), 165),
    (41, (1 << 1), 165),
    (56, 1 | (1 << 1), 165),
    (3, (1 << 1), 166),
    (6, (1 << 1), 166),
    (10, (1 << 1), 166),
    (15, (1 << 1), 166),
    (24, (1 << 1), 166),
    (31, (1 << 1), 166),
    (41, (1 << 1), 166),
    (56, 1 | (1 << 1), 166),
    # Node 165
    (3, (1 << 1), 168),
    (6, (1 << 1), 168),
    (10, (1 << 1), 168),
    (15, (1 << 1), 168),
    (24, (1 << 1), 168),
    (31, (1 << 1), 168),
    (41, (1 << 1), 168),
    (56, 1 | (1 << 1), 168),
    (3, (1 << 1), 174),
    (6, (1 << 1), 174),
    (10, (1 << 1), 174),
    (15, (1 << 1), 174),
    (24, (1 << 1), 174),
    (31, (1 << 1), 174),
    (41, (1 << 1), 174),
    (56, 1 | (1 << 1), 174),
    # Node 166
    (2, (1 << 1), 175),
    (9, (1 << 1), 175),
    (23, (1 << 1), 175),
    (40, 1 | (1 << 1), 175),
    (2, (1 << 1), 180),
    (9, (1 << 1), 180),
    (23, (1 << 1), 180),
    (40, 1 | (1 << 1), 180),
    (2, (1 << 1), 182),
    (9, (1 << 1), 182),
    (23, (1 << 1), 182),
    (40, 1 | (1 << 1), 182),
    (2, (1 << 1), 183),
    (9, (1 << 1), 183),
    (23, (1 << 1), 183),
    (40, 1 | (1 << 1), 183),
    # Node 167
    (3, (1 << 1), 175),
    (6, (1 << 1), 175),
    (10, (1 << 1), 175),
    (15, (1 << 1), 175),
    (24, (1 << 1), 175),
    (31, (1 << 1), 175),
    (41, (1 << 1), 175),
    (56, 1 | (1 << 1), 175),
    (3, (1 << 1), 180),
    (6, (1 << 1), 180),
    (10, (1 << 1), 180),
    (15, (1 << 1), 180),
    (24, (1 << 1), 180),
    (31, (1 << 1), 180),
    (41, (1 << 1), 180),
    (56, 1 | (1 << 1), 180),
    # Node 168
    (3, (1 << 1), 182),
    (6, (1 << 1), 182),
    (10, (1 << 1), 182),
    (15, (1 << 1), 182),
    (24, (1 << 1), 182),
    (31, (1 << 1), 182),
    (41, (1 << 1), 182),
    (56, 1 | (1 << 1), 182),
    (3, (1 << 1), 183),
    (6, (1 << 1), 183),
    (10, (1 << 1), 183),
    (15, (1 << 1), 183),
    (24, (1 << 1), 183),
    (31, (1 << 1), 183),
    (41, (1 << 1), 183),
    (56, 1 | (1 << 1), 183),
    # Node 169
    (0, 1 | (1 << 1), 188),
    (0, 1 | (1 << 1), 191),
    (0, 1 | (1 << 1), 197),
    (0, 1 | (1 << 1), 231),
    (0, 1 | (1 << 1), 239),
    (176, 0, 0),
    (178, 0, 0),
    (179, 0, 0),
    (183, 0, 0),
    (184, 0, 0),
    (186, 0, 0),
    (187, 0, 0),
    (192, 0, 0),
    (199, 0, 0),
    (208, 0, 0),
    (223, 0, 0),
    # Node 170
    (1, (1 << 1), 188),
    (22, 1 | (1 << 1), 188),
    (1, (1 << 1), 191),
    (22, 1 | (1 << 1), 191),
    (1, (1 << 1), 197),
    (22, 1 | (1 << 1), 197),
    (1, (1 << 1), 231),
    (22, 1 | (1 << 1), 231),
    (1, (1 << 1), 239),
    (22, 1 | (1 << 1), 239),
    (0, 1 | (1 << 1), 9),
    (0, 1 | (1 << 1), 142),
    (0, 1 | (1 << 1), 144),
    (0, 1 | (1 << 1), 145),
    (0, 1 | (1 << 1), 148),
    (0, 1 | (1 << 1), 159),
    # Node 171
    (2, (1 << 1), 188),
    (9, (1 << 1), 188),
    (23, (1 << 1), 188),
    (40, 1 | (1 << 1), 188),
    (2, (1 << 1), 191),
    (9, (1 << 1), 191),
    (23, (1 << 1), 191),
    (40, 1 | (1 << 1), 191),
    (2, (1 << 1), 197),
    (9, (1 << 1), 197),
    (23, (1 << 1), 197),
    (40, 1 | (1 << 1), 197),
    (2, (1 << 1), 231),
    (9, (1 << 1), 231),
    (23, (1 << 1), 231),
    (40, 1 | (1 << 1), 231),
    # Node 172
    (3, (1 << 1), 188),
    (6, (1 << 1), 188),
    (10, (1 << 1), 188),
    (15, (1 << 1), 188),
    (24, (1 << 1), 188),
    (31, (1 << 1), 188),
    (41, (1 << 1), 188),
    (56, 1 | (1 << 1), 188),
    (3, (1 << 1), 191),
    (6, (1 << 1), 191),
    (10, (1 << 1), 191),
    (15, (1 << 1), 191),
    (24, (1 << 1), 191),
    (31, (1 << 1), 191),
    (41, (1 << 1), 191),
    (56, 1 | (1 << 1), 191),
    # Node 173
    (3, (1 << 1), 197),
    (6, (1 << 1), 197),
    (10, (1 << 1), 197),
    (15, (1 << 1), 197),
    (24, (1 << 1), 197),
    (31, (1 << 1), 197),
    (41, (1 << 1), 197),
    (56, 1 | (1 << 1), 197),
    (3, (1 << 1), 231),
    (6, (1 << 1), 231),
    (10, (1 << 1), 231),
    (15, (1 << 1), 231),
    (24, (1 << 1), 231),
    (31, (1 << 1), 231),
    (41, (1 << 1), 231),
    (56, 1 | (1 << 1), 231),
    # Node 174
    (2, (1 << 1), 239),
    (9, (1 << 1), 239),
    (23, (1 << 1), 239),
    (40, 1 | (1 << 1), 239),
    (1, (1 << 1), 9),
    (22, 1 | (1 << 1), 9),
    (1, (1 << 1), 142),
    (22, 1 | (1 << 1), 142),
    (1, (1 << 1), 144),
    (22, 1 | (1 << 1), 144),
    (1, (1 << 1), 145),
    (22, 1 | (1 << 1), 145),
    (1, (1 << 1), 148),
    (22, 1 | (1 << 1), 148),
    (1, (1 << 1), 159),
    (22, 1 | (1 << 1), 159),
    # Node 175
    (3, (1 << 1), 239),
    (6, (1 << 1), 239),
    (10, (1 << 1), 239),
    (15, (1 << 1), 239),
    (24, (1 << 1), 239),
    (31, (1 << 1), 239),
    (41, (1 << 1), 239),
    (56, 1 | (1 << 1), 239),
    (2, (1 << 1), 9),
    (9, (1 << 1), 9),
    (23, (1 << 1), 9),
    (40, 1 | (1 << 1), 9),
    (2, (1 << 1), 142),
    (9, (1 << 1), 142),
    (23, (1 << 1), 142),
    (40, 1 | (1 << 1), 142),
    # Node 176
    (3, (1 << 1), 9),
    (6, (1 << 1), 9),
    (10, (1 << 1), 9),
    (15, (1 << 1), 9),
    (24, (1 << 1), 9),
    (31, (1 << 1), 9),
    (41, (1 << 1), 9),
    (56, 1 | (1 << 1), 9),
    (3, (1 << 1), 142),
    (6, (1 << 1), 142),
    (10, (1 << 1), 142),
    (15, (1 << 1), 142),
    (24, (1 << 1), 142),
    (31, (1 << 1), 142),
    (41, (1 << 1), 142),
    (56, 1 | (1 << 1), 142),
    # Node 177
    (2, (1 << 1), 144),
    (9, (1 << 1), 144),
    (23, (1 << 1), 144),
    (40, 1 | (1 << 1), 144),
    (2, (1 << 1), 145),
    (9, (1 << 1), 145),
    (23, (1 << 1), 145),
    (40, 1 | (1 << 1), 145),
    (2, (1 << 1), 148),
    (9, (1 << 1), 148),
    (23, (1 << 1), 148),
    (40, 1 | (1 << 1), 148),
    (2, (1 << 1), 159),
    (9, (1 << 1), 159),
    (23, (1 << 1), 159),
    (40, 1 | (1 << 1), 159),
    # Node 178
    (3, (1 << 1), 144),
    (6, (1 << 1), 144),
    (10, (1 << 1), 144),
    (15, (1 << 1), 144),
    (24, (1 << 1), 144),
    (31, (1 << 1), 144),
    (41, (1 << 1), 144),
    (56, 1 | (1 << 1), 144),
    (3, (1 << 1), 145),
    (6, (1 << 1), 145),
    (10, (1 << 1), 145),
    (15, (1 << 1), 145),
    (24, (1 << 1), 145),
    (31, (1 << 1), 145),
    (41, (1 << 1), 145),
    (56, 1 | (1 << 1), 145),
    # Node 179
    (3, (1 << 1), 148),
    (6, (1 << 1), 148),
    (10, (1 << 1), 148),
    (15, (1 << 1), 148),
    (24, (1 << 1), 148),
    (31, (1 << 1), 148),
    (41, (1 << 1), 148),
    (56, 1 | (1 << 1), 148),
    (3, (1 << 1), 159),
    (6, (1 << 1), 159),
    (10, (1 << 1), 159),
    (15, (1 << 1), 159),
    (24, (1 << 1), 159),
    (31, (1 << 1), 159),
    (41, (1 << 1), 159),
    (56, 1 | (1 << 1), 159),
    # Node 180
    (0, 1 | (1 << 1), 171),
    (0, 1 | (1 << 1), 206),
    (0, 1 | (1 << 1), 215),
    (0, 1 | (1 << 1), 225),
    (0, 1 | (1 << 1), 236),
    (0, 1 | (1 << 1), 237),
    (188, 0, 0),
    (189, 0, 0),
    (193, 0, 0),
    (196, 0, 0),
    (200, 0, 0),
    (203, 0, 0),
    (209, 0, 0),
    (216, 0, 0),
    (224, 0, 0),
    (238, 0, 0),
    # Node 181
    (1, (1 << 1), 171),
    (22, 1 | (1 << 1), 171),
    (1, (1 << 1), 206),
    (22, 1 | (1 << 1), 206),
    (1, (1 << 1), 215),
    (22, 1 | (1 << 1), 215),
    (1, (1 << 1), 225),
    (22, 1 | (1 << 1), 225),
    (1, (1 << 1), 236),
    (22, 1 | (1 << 1), 236),
    (1, (1 << 1), 237),
    (22, 1 | (1 << 1), 237),
    (0, 1 | (1 << 1), 199),
    (0, 1 | (1 << 1), 207),
    (0, 1 | (1 << 1), 234),
    (0, 1 | (1 << 1), 235),
    # Node 182
    (2, (1 << 1), 171),
    (9, (1 << 1), 171),
    (23, (1 << 1), 171),
    (40, 1 | (1 << 1), 171),
    (2, (1 << 1), 206),
    (9, (1 << 1), 206),
    (23, (1 << 1), 206),
    (40, 1 | (1 << 1), 206),
    (2, (1 << 1), 215),
    (9, (1 << 1), 215),
    (23, (1 << 1), 215),
    (40, 1 | (1 << 1), 215),
    (2, (1 << 1), 225),
    (9, (1 << 1), 225),
    (23, (1 << 1), 225),
    (40, 1 | (1 << 1), 225),
    # Node 183
    (3, (1 << 1), 171),
    (6, (1 << 1), 171),
    (10, (1 << 1), 171),
    (15, (1 << 1), 171),
    (24, (1 << 1), 171),
    (31, (1 << 1), 171),
    (41, (1 << 1), 171),
    (56, 1 | (1 << 1), 171),
    (3, (1 << 1), 206),
    (6, (1 << 1), 206),
    (10, (1 << 1), 206),
    (15, (1 << 1), 206),
    (24, (1 << 1), 206),
    (31, (1 << 1), 206),
    (41, (1 << 1), 206),
    (56, 1 | (1 << 1), 206),
    # Node 184
    (3, (1 << 1), 215),
    (6, (1 << 1), 215),
    (10, (1 << 1), 215),
    (15, (1 << 1), 215),
    (24, (1 << 1), 215),
    (31, (1 << 1), 215),
    (41, (1 << 1), 215),
    (56, 1 | (1 << 1), 215),
    (3, (1 << 1), 225),
    (6, (1 << 1), 225),
    (10, (1 << 1), 225),
    (15, (1 << 1), 225),
    (24, (1 << 1), 225),
    (31, (1 << 1), 225),
    (41, (1 << 1), 225),
    (56, 1 | (1 << 1), 225),
    # Node 185
    (2, (1 << 1), 236),
    (9, (1 << 1), 236),
    (23, (1 << 1), 236),
    (40, 1 | (1 << 1), 236),
    (2, (1 << 1), 237),
    (9, (1 << 1), 237),
    (23, (1 << 1), 237),
    (40, 1 | (1 << 1), 237),
    (1, (1 << 1), 199),
    (22, 1 | (1 << 1), 199),
    (1, (1 << 1), 207),
    (22, 1 | (1 << 1), 207),
    (1, (1 << 1), 234),
    (22, 1 | (1 << 1), 234),
    (1, (1 << 1), 235),
    (22, 1 | (1 << 1), 235),
    # Node 186
    (3, (1 << 1), 236),
    (6, (1 << 1), 236),
    (10, (1 << 1), 236),
    (15, (1 << 1), 236),
    (24, (1 << 1), 236),
    (31, (1 << 1), 236),
    (41, (1 << 1), 236),
    (56, 1 | (1 << 1), 236),
    (3, (1 << 1), 237),
    (6, (1 << 1), 237),
    (10, (1 << 1), 237),
    (15, (1 << 1), 237),
    (24, (1 << 1), 237),
    (31, (1 << 1), 237),
    (41, (1 << 1), 237),
    (56, 1 | (1 << 1), 237),
    # Node 187
    (2, (1 << 1), 199),
    (9, (1 << 1), 199),
    (23, (1 << 1), 199),
    (40, 1 | (1 << 1), 199),
    (2, (1 << 1), 207),
    (9, (1 << 1), 207),
    (23, (1 << 1), 207),
    (40, 1 | (1 << 1), 207),
    (2, (1 << 1), 234),
    (9, (1 << 1), 234),
    (23, (1 << 1), 234),
    (40, 1 | (1 << 1), 234),
    (2, (1 << 1), 235),
    (9, (1 << 1), 235),
    (23, (1 << 1), 235),
    (40, 1 | (1 << 1), 235),
    # Node 188
    (3, (1 << 1), 199),
    (6, (1 << 1), 199),
    (10, (1 << 1), 199),
    (15, (1 << 1), 199),
    (24, (1 << 1), 199),
    (31, (1 << 1), 199),
    (41, (1 << 1), 199),
    (56, 1 | (1 << 1), 199),
    (3, (1 << 1), 207),
    (6, (1 << 1), 207),
    (10, (1 << 1), 207),
    (15, (1 << 1), 207),
    (24, (1 << 1), 207),
    (31, (1 << 1), 207),
    (41, (1 << 1), 207),
    (56, 1 | (1 << 1), 207),
    # Node 189
    (3, (1 << 1), 234),
    (6, (1 << 1), 234),
    (10, (1 << 1), 234),
    (15, (1 << 1), 234),
    (24, (1 << 1), 234),
    (31, (1 << 1), 234),
    (41, (1 << 1), 234),
    (56, 1 | (1 << 1), 234),
    (3, (1 << 1), 235),
    (6, (1 << 1), 235),
    (10, (1 << 1), 235),
    (15, (1 << 1), 235),
    (24, (1 << 1), 235),
    (31, (1 << 1), 235),
    (41, (1 << 1), 235),
    (56, 1 | (1 << 1), 235),
    # Node 190
    (194, 0, 0),
    (195, 0, 0),
    (197, 0, 0),
    (198, 0, 0),
    (201, 0, 0),
    (202, 0, 0),
    (204, 0, 0),
    (205, 0, 0),
    (210, 0, 0),
    (213, 0, 0),
    (217, 0, 0),
    (220, 0, 0),
    (225, 0, 0),
    (231, 0, 0),
    (239, 0, 0),
    (246, 0, 0),
    # Node 191
    (0, 1 | (1 << 1), 192),
    (0, 1 | (1 << 1), 193),
    (0, 1 | (1 << 1), 200),
    (0, 1 | (1 << 1), 201),
    (0, 1 | (1 << 1), 202),
    (0, 1 | (1 << 1), 205),
    (0, 1 | (1 << 1), 210),
    (0, 1 | (1 << 1), 213),
    (0, 1 | (1 << 1), 218),
    (0, 1 | (1 << 1), 219),
    (0, 1 | (1 << 1), 238),
    (0, 1 | (1 << 1), 240),
    (0, 1 | (1 << 1), 242),
    (0, 1 | (1 << 1), 243),
    (0, 1 | (1 << 1), 255),
    (206, 0, 0),
    # Node 192
    (1, (1 << 1), 192),
    (22, 1 | (1 << 1), 192),
    (1, (1 << 1), 193),
    (22, 1 | (1 << 1), 193),
    (1, (1 << 1), 200),
    (22, 1 | (1 << 1), 200),
    (1, (1 << 1), 201),
    (22, 1 | (1 << 1), 201),
    (1, (1 << 1), 202),
    (22, 1 | (1 << 1), 202),
    (1, (1 << 1), 205),
    (22, 1 | (1 << 1), 205),
    (1, (1 << 1), 210),
    (22, 1 | (1 << 1), 210),
    (1, (1 << 1), 213),
    (22, 1 | (1 << 1), 213),
    # Node 193
    (2, (1 << 1), 192),
    (9, (1 << 1), 192),
    (23, (1 << 1), 192),
    (40, 1 | (1 << 1), 192),
    (2, (1 << 1), 193),
    (9, (1 << 1), 193),
    (23, (1 << 1), 193),
    (40, 1 | (1 << 1), 193),
    (2, (1 << 1), 200),
    (9, (1 << 1), 200),
    (23, (1 << 1), 200),
    (40, 1 | (1 << 1), 200),
    (2, (1 << 1), 201),
    (9, (1 << 1), 201),
    (23, (1 << 1), 201),
    (40, 1 | (1 << 1), 201),
    # Node 194
    (3, (1 << 1), 192),
    (6, (1 << 1), 192),
    (10, (1 << 1), 192),
    (15, (1 << 1), 192),
    (24, (1 << 1), 192),
    (31, (1 << 1), 192),
    (41, (1 << 1), 192),
    (56, 1 | (1 << 1), 192),
    (3, (1 << 1), 193),
    (6, (1 << 1), 193),
    (10, (1 << 1), 193),
    (15, (1 << 1), 193),
    (24, (1 << 1), 193),
    (31, (1 << 1), 193),
    (41, (1 << 1), 193),
    (56, 1 | (1 << 1), 193),
    # Node 195
    (3, (1 << 1), 200),
    (6, (1 << 1), 200),
    (10, (1 << 1), 200),
    (15, (1 << 1), 200),
    (24, (1 << 1), 200),
    (31, (1 << 1), 200),
    (41, (1 << 1), 200),
    (56, 1 | (1 << 1), 200),
    (3, (1 << 1), 201),
    (6, (1 << 1), 201),
    (10, (1 << 1), 201),
    (15, (1 << 1), 201),
    (24, (1 << 1), 201),
    (31, (1 << 1), 201),
    (41, (1 << 1), 201),
    (56, 1 | (1 << 1), 201),
    # Node 196
    (2, (1 << 1), 202),
    (9, (1 << 1), 202),
    (23, (1 << 1), 202),
    (40, 1 | (1 << 1), 202),
    (2, (1 << 1), 205),
    (9, (1 << 1), 205),
    (23, (1 << 1), 205),
    (40, 1 | (1 << 1), 205),
    (2, (1 << 1), 210),
    (9, (1 << 1), 210),
    (23, (1 << 1), 210),
    (40, 1 | (1 << 1), 210),
    (2, (1 << 1), 213),
    (9, (1 << 1), 213),
    (23, (1 << 1), 213),
    (40, 1 | (1 << 1), 213),
    # Node 197
    (3, (1 << 1), 202),
    (6, (1 << 1), 202),
    (10, (1 << 1), 202),
    (15, (1 << 1), 202),
    (24, (1 << 1), 202),
    (31, (1 << 1), 202),
    (41, (1 << 1), 202),
    (56, 1 | (1 << 1), 202),
    (3, (1 << 1), 205),
    (6, (1 << 1), 205),
    (10, (1 << 1), 205),
    (15, (1 << 1), 205),
    (24, (1 << 1), 205),
    (31, (1 << 1), 205),
    (41, (1 << 1), 205),
    (56, 1 | (1 << 1), 205),
    # Node 198
    (3, (1 << 1), 210),
    (6, (1 << 1), 210),
    (10, (1 << 1), 210),
    (15, (1 << 1), 210),
    (24, (1 << 1), 210),
    (31, (1 << 1), 210),
    (41, (1 << 1), 210),
    (56, 1 | (1 << 1), 210),
    (3, (1 << 1), 213),
    (6, (1 << 1), 213),
    (10, (1 << 1), 213),
    (15, (1 << 1), 213),
    (24, (1 << 1), 213),
    (31, (1 << 1), 213),
    (41, (1 << 1), 213),
    (56, 1 | (1 << 1), 213),
    # Node 199
    (1, (1 << 1), 218),
    (22, 1 | (1 << 1), 218),
    (1, (1 << 1), 219),
    (22, 1 | (1 << 1), 219),
    (1, (1 << 1), 238),
    (22, 1 | (1 << 1), 238),
    (1, (1 << 1), 240),
    (22, 1 | (1 << 1), 240),
    (1, (1 << 1), 242),
    (22, 1 | (1 << 1), 242),
    (1, (1 << 1), 243),
    (22, 1 | (1 << 1), 243),
    (1, (1 << 1), 255),
    (22, 1 | (1 << 1), 255),
    (0, 1 | (1 << 1), 203),
    (0, 1 | (1 << 1), 204),
    # Node 200
    (2, (1 << 1), 218),
    (9, (1 << 1), 218),
    (23, (1 << 1), 218),
    (40, 1 | (1 << 1), 218),
    (2, (1 << 1), 219),
    (9, (1 << 1), 219),
    (23, (1 << 1), 219),
    (40, 1 | (1 << 1), 219),
    (2, (1 << 1), 238),
    (9, (1 << 1), 238),
    (23, (1 << 1), 238),
    (40, 1 | (1 << 1), 238),
    (2, (1 << 1), 240),
    (9, (1 << 1), 240),
    (23, (1 << 1), 240),
    (40, 1 | (1 << 1), 240),
    # Node 201
    (3, (1 << 1), 218),
    (6, (1 << 1), 218),
    (10, (1 << 1), 218),
    (15, (1 << 1), 218),
    (24, (1 << 1), 218),
    (31, (1 << 1), 218),
    (41, (1 << 1), 218),
    (56, 1 | (1 << 1), 218),
    (3, (1 << 1), 219),
    (6, (1 << 1), 219),
    (10, (1 << 1), 219),
    (15, (1 << 1), 219),
    (24, (1 << 1), 219),
    (31, (1 << 1), 219),
    (41, (1 << 1), 219),
    (56, 1 | (1 << 1), 219),
    # Node 202
    (3, (1 << 1), 238),
    (6, (1 << 1), 238),
    (10, (1 << 1), 238),
    (15, (1 << 1), 238),
    (24, (1 << 1), 238),
    (31, (1 << 1), 238),
    (41, (1 << 1), 238),
    (56, 1 | (1 << 1), 238),
    (3, (1 << 1), 240),
    (6, (1 << 1), 240),
    (10, (1 << 1), 240),
    (15, (1 << 1), 240),
    (24, (1 << 1), 240),
    (31, (1 << 1), 240),
    (41, (1 << 1), 240),
    (56, 1 | (1 << 1), 240),
    # Node 203
    (2, (1 << 1), 242),
    (9, (1 << 1), 242),
    (23, (1 << 1), 242),
    (40, 1 | (1 << 1), 242),
    (2, (1 << 1), 243),
    (9, (1 << 1), 243),
    (23, (1 << 1), 243),
    (40, 1 | (1 << 1), 243),
    (2, (1 << 1), 255),
    (9, (1 << 1), 255),
    (23, (1 << 1), 255),
    (40, 1 | (1 << 1), 255),
    (1, (1 << 1), 203),
    (22, 1 | (1 << 1), 203),
    (1, (1 << 1), 204),
    (22, 1 | (1 << 1), 204),
    # Node 204
    (3, (1 << 1), 242),
    (6, (1 << 1), 242),
    (10, (1 << 1), 242),
    (15, (1 << 1), 242),
    (24, (1 << 1), 242),
    (31, (1 << 1), 242),
    (41, (1 << 1), 242),
    (56, 1 | (1 << 1), 242),
    (3, (1 << 1), 243),
    (6, (1 << 1), 243),
    (10, (1 << 1), 243),
    (15, (1 << 1), 243),
    (24, (1 << 1), 243),
    (31, (1 << 1), 243),
    (41, (1 << 1), 243),
    (56, 1 | (1 << 1), 243),
    # Node 205
    (3, (1 << 1), 255),
    (6, (1 << 1), 255),
    (10, (1 << 1), 255),
    (15, (1 << 1), 255),
    (24, (1 << 1), 255),
    (31, (1 << 1), 255),
    (41, (1 << 1), 255),
    (56, 1 | (1 << 1), 255),
    (2, (1 << 1), 203),
    (9, (1 << 1), 203),
    (23, (1 << 1), 203),
    (40, 1 | (1 << 1), 203),
    (2, (1 << 1), 204),
    (9, (1 << 1), 204),
    (23, (1 << 1), 204),
    (40, 1 | (1 << 1), 204),
    # Node 206
    (3, (1 << 1), 203),
    (6, (1 << 1), 203),
    (10, (1 << 1), 203),
    (15, (1 << 1), 203),
    (24, (1 << 1), 203),
    (31, (1 << 1), 203),
    (41, (1 << 1), 203),
    (56, 1 | (1 << 1), 203),
    (3, (1 << 1), 204),
    (6, (1 << 1), 204),
    (10, (1 << 1), 204),
    (15, (1 << 1), 204),
    (24, (1 << 1), 204),
    (31, (1 << 1), 204),
    (41, (1 << 1), 204),
    (56, 1 | (1 << 1), 204),
    # Node 207
    (211, 0, 0),
    (212, 0, 0),
    (214, 0, 0),
    (215, 0, 0),
    (218, 0, 0),
    (219, 0, 0),
    (221, 0, 0),
    (222, 0, 0),
    (226, 0, 0),
    (228, 0, 0),
    (232, 0, 0),
    (235, 0, 0),
    (240, 0, 0),
    (243, 0, 0),
    (247, 0, 0),
    (250, 0, 0),
    # Node 208
    (0, 1 | (1 << 1), 211),
    (0, 1 | (1 << 1), 212),
    (0, 1 | (1 << 1), 214),
    (0, 1 | (1 << 1), 221),
    (0, 1 | (1 << 1), 222),
    (0, 1 | (1 << 1), 223),
    (0, 1 | (1 << 1), 241),
    (0, 1 | (1 << 1), 244),
    (0, 1 | (1 << 1), 245),
    (0, 1 | (1 << 1), 246),
    (0, 1 | (1 << 1), 247),
    (0, 1 | (1 << 1), 248),
    (0, 1 | (1 << 1), 250),
    (0, 1 | (1 << 1), 251),
    (0, 1 | (1 << 1), 252),
    (0, 1 | (1 << 1), 253),
    # Node 209
    (1, (1 << 1), 211),
    (22, 1 | (1 << 1), 211),
    (1, (1 << 1), 212),
    (22, 1 | (1 << 1), 212),
    (1, (1 << 1), 214),
    (22, 1 | (1 << 1), 214),
    (1, (1 << 1), 221),
    (22, 1 | (1 << 1), 221),
    (1, (1 << 1), 222),
    (22, 1 | (1 << 1), 222),
    (1, (1 << 1), 223),
    (22, 1 | (1 << 1), 223),
    (1, (1 << 1), 241),
    (22, 1 | (1 << 1), 241),
    (1, (1 << 1), 244),
    (22, 1 | (1 << 1), 244),
    # Node 210
    (2, (1 << 1), 211),
    (9, (1 << 1), 211),
    (23, (1 << 1), 211),
    (40, 1 | (1 << 1), 211),
    (2, (1 << 1), 212),
    (9, (1 << 1), 212),
    (23, (1 << 1), 212),
    (40, 1 | (1 << 1), 212),
    (2, (1 << 1), 214),
    (9, (1 << 1), 214),
    (23, (1 << 1), 214),
    (40, 1 | (1 << 1), 214),
    (2, (1 << 1), 221),
    (9, (1 << 1), 221),
    (23, (1 << 1), 221),
    (40, 1 | (1 << 1), 221),
    # Node 211
    (3, (1 << 1), 211),
    (6, (1 << 1), 211),
    (10, (1 << 1), 211),
    (15, (1 << 1), 211),
    (24, (1 << 1), 211),
    (31, (1 << 1), 211),
    (41, (1 << 1), 211),
    (56, 1 | (1 << 1), 211),
    (3, (1 << 1), 212),
    (6, (1 << 1), 212),
    (10, (1 << 1), 212),
    (15, (1 << 1), 212),
    (24, (1 << 1), 212),
    (31, (1 << 1), 212),
    (41, (1 << 1), 212),
    (56, 1 | (1 << 1), 212),
    # Node 212
    (3, (1 << 1), 214),
    (6, (1 << 1), 214),
    (10, (1 << 1), 214),
    (15, (1 << 1), 214),
    (24, (1 << 1), 214),
    (31, (1 << 1), 214),
    (41, (1 << 1), 214),
    (56, 1 | (1 << 1), 214),
    (3, (1 << 1), 221),
    (6, (1 << 1), 221),
    (10, (1 << 1), 221),
    (15, (1 << 1), 221),
    (24, (1 << 1), 221),
    (31, (1 << 1), 221),
    (41, (1 << 1), 221),
    (56, 1 | (1 << 1), 221),
    # Node 213
    (2, (1 << 1), 222),
    (9, (1 << 1), 222),
    (23, (1 << 1), 222),
    (40, 1 | (1 << 1), 222),
    (2, (1 << 1), 223),
    (9, (1 << 1), 223),
    (23, (1 << 1), 223),
    (40, 1 | (1 << 1), 223),
    (2, (1 << 1), 241),
    (9, (1 << 1), 241),
    (23, (1 << 1), 241),
    (40, 1 | (1 << 1), 241),
    (2, (1 << 1), 244),
    (9, (1 << 1), 244),
    (23, (1 << 1), 244),
    (40, 1 | (1 << 1), 244),
    # Node 214
    (3, (1 << 1), 222),
    (6, (1 << 1), 222),
    (10, (1 << 1), 222),
    (15, (1 << 1), 222),
    (24, (1 << 1), 222),
    (31, (1 << 1), 222),
    (41, (1 << 1), 222),
    (56, 1 | (1 << 1), 222),
    (3, (1 << 1), 223),
    (6, (1 << 1), 223),
    (10, (1 << 1), 223),
    (15, (1 << 1), 223),
    (24, (1 << 1), 223),
    (31, (1 << 1), 223),
    (41, (1 << 1), 223),
    (56, 1 | (1 << 1), 223),
    # Node 215
    (3, (1 << 1), 241),
    (6, (1 << 1), 241),
    (10, (1 << 1), 241),
    (15, (1 << 1), 241),
    (24, (1 << 1), 241),
    (31, (1 << 1), 241),
    (41, (1 << 1), 241),
    (56, 1 | (1 << 1), 241),
    (3, (1 << 1), 244),
    (6, (1 << 1), 244),
    (10, (1 << 1), 244),
    (15, (1 << 1), 244),
    (24, (1 << 1), 244),
    (31, (1 << 1), 244),
    (41, (1 << 1), 244),
    (56, 1 | (1 << 1), 244),
    # Node 216
    (1, (1 << 1), 245),
    (22, 1 | (1 << 1), 245),
    (1, (1 << 1), 246),
    (22, 1 | (1 << 1), 246),
    (1, (1 << 1), 247),
    (22, 1 | (1 << 1), 247),
    (1, (1 << 1), 248),
    (22, 1 | (1 << 1), 248),
    (1, (1 << 1), 250),
    (22, 1 | (1 << 1), 250),
    (1, (1 << 1), 251),
    (22, 1 | (1 << 1), 251),
    (1, (1 << 1), 252),
    (22, 1 | (1 << 1), 252),
    (1, (1 << 1), 253),
    (22, 1 | (1 << 1), 253),
    # Node 217
    (2, (1 << 1), 245),
    (9, (1 << 1), 245),
    (23, (1 << 1), 245),
    (40, 1 | (1 << 1), 245),
    (2, (1 << 1), 246),
    (9, (1 << 1), 246),
    (23, (1 << 1), 246),
    (40, 1 | (1 << 1), 246),
    (2, (1 << 1), 247),
    (9, (1 << 1), 247),
    (23, (1 << 1), 247),
    (40, 1 | (1 << 1), 247),
    (2, (1 << 1), 248),
    (9, (1 << 1), 248),
    (23, (1 << 1), 248),
    (40, 1 | (1 << 1), 248),
    # Node 218
    (3, (1 << 1), 245),
    (6, (1 << 1), 245),
    (10, (1 << 1), 245),
    (15, (1 << 1), 245),
    (24, (1 << 1), 245),
    (31, (1 << 1), 245),
    (41, (1 << 1), 245),
    (56, 1 | (1 << 1), 245),
    (3, (1 << 1), 246),
    (6, (1 << 1), 246),
    (10, (1 << 1), 246),
    (15, (1 << 1), 246),
    (24, (1 << 1), 246),
    (31, (1 << 1), 246),
    (41, (1 << 1), 246),
    (56, 1 | (1 << 1), 246),
    # Node 219
    (3, (1 << 1), 247),
    (6, (1 << 1), 247),
    (10, (1 << 1), 247),
    (15, (1 << 1), 247),
    (24, (1 << 1), 247),
    (31, (1 << 1), 247),
    (41, (1 << 1), 247),
    (56, 1 | (1 << 1), 247),
    (3, (1 << 1), 248),
    (6, (1 << 1), 248),
    (10, (1 << 1), 248),
    (15, (1 << 1), 248),
    (24, (1 << 1), 248),
    (31, (1 << 1), 248),
    (41, (1 << 1), 248),
    (56, 1 | (1 << 1), 248),
    # Node 220
    (2, (1 << 1), 250),
    (9, (1 << 1), 250),
    (23, (1 << 1), 250),
    (40, 1 | (1 << 1), 250),
    (2, (1 << 1), 251),
    (9, (1 << 1), 251),
    (23, (1 << 1), 251),
    (40, 1 | (1 << 1), 251),
    (2, (1 << 1), 252),
    (9, (1 << 1), 252),
    (23, (1 << 1), 252),
    (40, 1 | (1 << 1), 252),
    (2, (1 << 1), 253),
    (9, (1 << 1), 253),
    (23, (1 << 1), 253),
    (40, 1 | (1 << 1), 253),
    # Node 221
    (3, (1 << 1), 250),
    (6, (1 << 1), 250),
    (10, (1 << 1), 250),
    (15, (1 << 1), 250),
    (24, (1 << 1), 250),
    (31, (1 << 1), 250),
    (41, (1 << 1), 250),
    (56, 1 | (1 << 1), 250),
    (3, (1 << 1), 251),
    (6, (1 << 1), 251),
    (10, (1 << 1), 251),
    (15, (1 << 1), 251),
    (24, (1 << 1), 251),
    (31, (1 << 1), 251),
    (41, (1 << 1), 251),
    (56, 1 | (1 << 1), 251),
    # Node 222
    (3, (1 << 1), 252),
    (6, (1 << 1), 252),
    (10, (1 << 1), 252),
    (15, (1 << 1), 252),
    (24, (1 << 1), 252),
    (31, (1 << 1), 252),
    (41, (1 << 1), 252),
    (56, 1 | (1 << 1), 252),
    (3, (1 << 1), 253),
    (6, (1 << 1), 253),
    (10, (1 << 1), 253),
    (15, (1 << 1), 253),
    (24, (1 << 1), 253),
    (31, (1 << 1), 253),
    (41, (1 << 1), 253),
    (56, 1 | (1 << 1), 253),
    # Node 223
    (0, 1 | (1 << 1), 254),
    (227, 0, 0),
    (229, 0, 0),
    (230, 0, 0),
    (233, 0, 0),
    (234, 0, 0),
    (236, 0, 0),
    (237, 0, 0),
    (241, 0, 0),
    (242, 0, 0),
    (244, 0, 0),
    (245, 0, 0),
    (248, 0, 0),
    (249, 0, 0),
    (251, 0, 0),
    (252, 0, 0),
    # Node 224
    (1, (1 << 1), 254),
    (22, 1 | (1 << 1), 254),
    (0, 1 | (1 << 1), 2),
    (0, 1 | (1 << 1), 3),
    (0, 1 | (1 << 1), 4),
    (0, 1 | (1 << 1), 5),
    (0, 1 | (1 << 1), 6),
    (0, 1 | (1 << 1), 7),
    (0, 1 | (1 << 1), 8),
    (0, 1 | (1 << 1), 11),
    (0, 1 | (1 << 1), 12),
    (0, 1 | (1 << 1), 14),
    (0, 1 | (1 << 1), 15),
    (0, 1 | (1 << 1), 16),
    (0, 1 | (1 << 1), 17),
    (0, 1 | (1 << 1), 18),
    # Node 225
    (2, (1 << 1), 254),
    (9, (1 << 1), 254),
    (23, (1 << 1), 254),
    (40, 1 | (1 << 1), 254),
    (1, (1 << 1), 2),
    (22, 1 | (1 << 1), 2),
    (1, (1 << 1), 3),
    (22, 1 | (1 << 1), 3),
    (1, (1 << 1), 4),
    (22, 1 | (1 << 1), 4),
    (1, (1 << 1), 5),
    (22, 1 | (1 << 1), 5),
    (1, (1 << 1), 6),
    (22, 1 | (1 << 1), 6),
    (1, (1 << 1), 7),
    (22, 1 | (1 << 1), 7),
    # Node 226
    (3, (1 << 1), 254),
    (6, (1 << 1), 254),
    (10, (1 << 1), 254),
    (15, (1 << 1), 254),
    (24, (1 << 1), 254),
    (31, (1 << 1), 254),
    (41, (1 << 1), 254),
    (56, 1 | (1 << 1), 254),
    (2, (1 << 1), 2),
    (9, (1 << 1), 2),
    (23, (1 << 1), 2),
    (40, 1 | (1 << 1), 2),
    (2, (1 << 1), 3),
    (9, (1 << 1), 3),
    (23, (1 << 1), 3),
    (40, 1 | (1 << 1), 3),
    # Node 227
    (3, (1 << 1), 2),
    (6, (1 << 1), 2),
    (10, (1 << 1), 2),
    (15, (1 << 1), 2),
    (24, (1 << 1), 2),
    (31, (1 << 1), 2),
    (41, (1 << 1), 2),
    (56, 1 | (1 << 1), 2),
    (3, (1 << 1), 3),
    (6, (1 << 1), 3),
    (10, (1 << 1), 3),
    (15, (1 << 1), 3),
    (24, (1 << 1), 3),
    (31, (1 << 1), 3),
    (41, (1 << 1), 3),
    (56, 1 | (1 << 1), 3),
    # Node 228
    (2, (1 << 1), 4),
    (9, (1 << 1), 4),
    (23, (1 << 1), 4),
    (40, 1 | (1 << 1), 4),
    (2, (1 << 1), 5),
    (9, (1 << 1), 5),
    (23, (1 << 1), 5),
    (40, 1 | (1 << 1), 5),
    (2, (1 << 1), 6),
    (9, (1 << 1), 6),
    (23, (1 << 1), 6),
    (40, 1 | (1 << 1), 6),
    (2, (1 << 1), 7),
    (9, (1 << 1), 7),
    (23, (1 << 1), 7),
    (40, 1 | (1 << 1), 7),
    # Node 229
    (3, (1 << 1), 4),
    (6, (1 << 1), 4),
    (10, (1 << 1), 4),
    (15, (1 << 1), 4),
    (24, (1 << 1), 4),
    (31, (1 << 1), 4),
    (41, (1 << 1), 4),
    (56, 1 | (1 << 1), 4),
    (3, (1 << 1), 5),
    (6, (1 << 1), 5),
    (10, (1 << 1), 5),
    (15, (1 << 1), 5),
    (24, (1 << 1), 5),
    (31, (1 << 1), 5),
    (41, (1 << 1), 5),
    (56, 1 | (1 << 1), 5),
    # Node 230
    (3, (1 << 1), 6),
    (6, (1 << 1), 6),
    (10, (1 << 1), 6),
    (15, (1 << 1), 6),
    (24, (1 << 1), 6),
    (31, (1 << 1), 6),
    (41, (1 << 1), 6),
    (56, 1 | (1 << 1), 6),
    (3, (1 << 1), 7),
    (6, (1 << 1), 7),
    (10, (1 << 1), 7),
    (15, (1 << 1), 7),
    (24, (1 << 1), 7),
    (31, (1 << 1), 7),
    (41, (1 << 1), 7),
    (56, 1 | (1 << 1), 7),
    # Node 231
    (1, (1 << 1), 8),
    (22, 1 | (1 << 1), 8),
    (1, (1 << 1), 11),
    (22, 1 | (1 << 1), 11),
    (1, (1 << 1), 12),
    (22, 1 | (1 << 1), 12),
    (1, (1 << 1), 14),
    (22, 1 | (1 << 1), 14),
    (1, (1 << 1), 15),
    (22, 1 | (1 << 1), 15),
    (1, (1 << 1), 16),
    (22, 1 | (1 << 1), 16),
    (1, (1 << 1), 17),
    (22, 1 | (1 << 1), 17),
    (1, (1 << 1), 18),
    (22, 1 | (1 << 1), 18),
    # Node 232
    (2, (1 << 1), 8),
    (9, (1 << 1), 8),
    (23, (1 << 1), 8),
    (40, 1 | (1 << 1), 8),
    (2, (1 << 1), 11),
    (9, (1 << 1), 11),
    (23, (1 << 1), 11),
    (40, 1 | (1 << 1), 11),
    (2, (1 << 1), 12),
    (9, (1 << 1), 12),
    (23, (1 << 1), 12),
    (40, 1 | (1 << 1), 12),
    (2, (1 << 1), 14),
    (9, (1 << 1), 14),
    (23, (1 << 1), 14),
    (40, 1 | (1 << 1), 14),
    # Node 233
    (3, (1 << 1), 8),
    (6, (1 << 1), 8),
    (10, (1 << 1), 8),
    (15, (1 << 1), 8),
    (24, (1 << 1), 8),
    (31, (1 << 1), 8),
    (41, (1 << 1), 8),
    (56, 1 | (1 << 1), 8),
    (3, (1 << 1), 11),
    (6, (1 << 1), 11),
    (10, (1 << 1), 11),
    (15, (1 << 1), 11),
    (24, (1 << 1), 11),
    (31, (1 << 1), 11),
    (41, (1 << 1), 11),
    (56, 1 | (1 << 1), 11),
    # Node 234
    (3, (1 << 1), 12),
    (6, (1 << 1), 12),
    (10, (1 << 1), 12),
    (15, (1 << 1), 12),
    (24, (1 << 1), 12),
    (31, (1 << 1), 12),
    (41, (1 << 1), 12),
    (56, 1 | (1 << 1), 12),
    (3, (1 << 1), 14),
    (6, (1 << 1), 14),
    (10, (1 << 1), 14),
    (15, (1 << 1), 14),
    (24, (1 << 1), 14),
    (31, (1 << 1), 14),
    (41, (1 << 1), 14),
    (56, 1 | (1 << 1), 14),
    # Node 235
    (2, (1 << 1), 15),
    (9, (1 << 1), 15),
    (23, (1 << 1), 15),
    (40, 1 | (1 << 1), 15),
    (2, (1 << 1), 16),
    (9, (1 << 1), 16),
    (23, (1 << 1), 16),
    (40, 1 | (1 << 1), 16),
    (2, (1 << 1), 17),
    (9, (1 << 1), 17),
    (23, (1 << 1), 17),
    (40, 1 | (1 << 1), 17),
    (2, (1 << 1), 18),
    (9, (1 << 1), 18),
    (23, (1 << 1), 18),
    (40, 1 | (1 << 1), 18),
    # Node 236
    (3, (1 << 1), 15),
    (6, (1 << 1), 15),
    (10, (1 << 1), 15),
    (15, (1 << 1), 15),
    (24, (1 << 1), 15),
    (31, (1 << 1), 15),
    (41, (1 << 1), 15),
    (56, 1 | (1 << 1), 15),
    (3, (1 << 1), 16),
    (6, (1 << 1), 16),
    (10, (1 << 1), 16),
    (15, (1 << 1), 16),
    (24, (1 << 1), 16),
    (31, (1 << 1), 16),
    (41, (1 << 1), 16),
    (56, 1 | (1 << 1), 16),
    # Node 237
    (3, (1 << 1), 17),
    (6, (1 << 1), 17),
    (10, (1 << 1), 17),
    (15, (1 << 1), 17),
    (24, (1 << 1), 17),
    (31, (1 << 1), 17),
    (41, (1 << 1), 17),
    (56, 1 | (1 << 1), 17),
    (3, (1 << 1), 18),
    (6, (1 << 1), 18),
    (10, (1 << 1), 18),
    (15, (1 << 1), 18),
    (24, (1 << 1), 18),
    (31, (1 << 1), 18),
    (41, (1 << 1), 18),
    (56, 1 | (1 << 1), 18),
    # Node 238
    (0, 1 | (1 << 1), 19),
    (0, 1 | (1 << 1), 20),
    (0, 1 | (1 << 1), 21),
    (0, 1 | (1 << 1), 23),
    (0, 1 | (1 << 1), 24),
    (0, 1 | (1 << 1), 25),
    (0, 1 | (1 << 1), 26),
    (0, 1 | (1 << 1), 27),
    (0, 1 | (1 << 1), 28),
    (0, 1 | (1 << 1), 29),
    (0, 1 | (1 << 1), 30),
    (0, 1 | (1 << 1), 31),
    (0, 1 | (1 << 1), 127),
    (0, 1 | (1 << 1), 220),
    (0, 1 | (1 << 1), 249),
    (253, 0, 0),
    # Node 239
    (1, (1 << 1), 19),
    (22, 1 | (1 << 1), 19),
    (1, (1 << 1), 20),
    (22, 1 | (1 << 1), 20),
    (1, (1 << 1), 21),
    (22, 1 | (1 << 1), 21),
    (1, (1 << 1), 23),
    (22, 1 | (1 << 1), 23),
    (1, (1 << 1), 24),
    (22, 1 | (1 << 1), 24),
    (1, (1 << 1), 25),
    (22, 1 | (1 << 1), 25),
    (1, (1 << 1), 26),
    (22, 1 | (1 << 1), 26),
    (1, (1 << 1), 27),
    (22, 1 | (1 << 1), 27),
    # Node 240
    (2, (1 << 1), 19),
    (9, (1 << 1), 19),
    (23, (1 << 1), 19),
    (40, 1 | (1 << 1), 19),
    (2, (1 << 1), 20),
    (9, (1 << 1), 20),
    (23, (1 << 1), 20),
    (40, 1 | (1 << 1), 20),
    (2, (1 << 1), 21),
    (9, (1 << 1), 21),
    (23, (1 << 1), 21),
    (40, 1 | (1 << 1), 21),
    (2, (1 << 1), 23),
    (9, (1 << 1), 23),
    (23, (1 << 1), 23),
    (40, 1 | (1 << 1), 23),
    # Node 241
    (3, (1 << 1), 19),
    (6, (1 << 1), 19),
    (10, (1 << 1), 19),
    (15, (1 << 1), 19),
    (24, (1 << 1), 19),
    (31, (1 << 1), 19),
    (41, (1 << 1), 19),
    (56, 1 | (1 << 1), 19),
    (3, (1 << 1), 20),
    (6, (1 << 1), 20),
    (10, (1 << 1), 20),
    (15, (1 << 1), 20),
    (24, (1 << 1), 20),
    (31, (1 << 1), 20),
    (41, (1 << 1), 20),
    (56, 1 | (1 << 1), 20),
    # Node 242
    (3, (1 << 1), 21),
    (6, (1 << 1), 21),
    (10, (1 << 1), 21),
    (15, (1 << 1), 21),
    (24, (1 << 1), 21),
    (31, (1 << 1), 21),
    (41, (1 << 1), 21),
    (56, 1 | (1 << 1), 21),
    (3, (1 << 1), 23),
    (6, (1 << 1), 23),
    (10, (1 << 1), 23),
    (15, (1 << 1), 23),
    (24, (1 << 1), 23),
    (31, (1 << 1), 23),
    (41, (1 << 1), 23),
    (56, 1 | (1 << 1), 23),
    # Node 243
    (2, (1 << 1), 24),
    (9, (1 << 1), 24),
    (23, (1 << 1), 24),
    (40, 1 | (1 << 1), 24),
    (2, (1 << 1), 25),
    (9, (1 << 1), 25),
    (23, (1 << 1), 25),
    (40, 1 | (1 << 1), 25),
    (2, (1 << 1), 26),
    (9, (1 << 1), 26),
    (23, (1 << 1), 26),
    (40, 1 | (1 << 1), 26),
    (2, (1 << 1), 27),
    (9, (1 << 1), 27),
    (23, (1 << 1), 27),
    (40, 1 | (1 << 1), 27),
    # Node 244
    (3, (1 << 1), 24),
    (6, (1 << 1), 24),
    (10, (1 << 1), 24),
    (15, (1 << 1), 24),
    (24, (1 << 1), 24),
    (31, (1 << 1), 24),
    (41, (1 << 1), 24),
    (56, 1 | (1 << 1), 24),
    (3, (1 << 1), 25),
    (6, (1 << 1), 25),
    (10, (1 << 1), 25),
    (15, (1 << 1), 25),
    (24, (1 << 1), 25),
    (31, (1 << 1), 25),
    (41, (1 << 1), 25),
    (56, 1 | (1 << 1), 25),
    # Node 245
    (3, (1 << 1), 26),
    (6, (1 << 1), 26),
    (10, (1 << 1), 26),
    (15, (1 << 1), 26),
    (24, (1 << 1), 26),
    (31, (1 << 1), 26),
    (41, (1 << 1), 26),
    (56, 1 | (1 << 1), 26),
    (3, (1 << 1), 27),
    (6, (1 << 1), 27),
    (10, (1 << 1), 27),
    (15, (1 << 1), 27),
    (24, (1 << 1), 27),
    (31, (1 << 1), 27),
    (41, (1 << 1), 27),
    (56, 1 | (1 << 1), 27),
    # Node 246
    (1, (1 << 1), 28),
    (22, 1 | (1 << 1), 28),
    (1, (1 << 1), 29),
    (22, 1 | (1 << 1), 29),
    (1, (1 << 1), 30),
    (22, 1 | (1 << 1), 30),
    (1, (1 << 1), 31),
    (22, 1 | (1 << 1), 31),
    (1, (1 << 1), 127),
    (22, 1 | (1 << 1), 127),
    (1, (1 << 1), 220),
    (22, 1 | (1 << 1), 220),
    (1, (1 << 1), 249),
    (22, 1 | (1 << 1), 249),
    (254, 0, 0),
    (255, 0, 0),
    # Node 247
    (2, (1 << 1), 28),
    (9, (1 << 1), 28),
    (23, (1 << 1), 28),
    (40, 1 | (1 << 1), 28),
    (2, (1 << 1), 29),
    (9, (1 << 1), 29),
    (23, (1 << 1), 29),
    (40, 1 | (1 << 1), 29),
    (2, (1 << 1), 30),
    (9, (1 << 1), 30),
    (23, (1 << 1), 30),
    (40, 1 | (1 << 1), 30),
    (2, (1 << 1), 31),
    (9, (1 << 1), 31),
    (23, (1 << 1), 31),
    (40, 1 | (1 << 1), 31),
    # Node 248
    (3, (1 << 1), 28),
    (6, (1 << 1), 28),
    (10, (1 << 1), 28),
    (15, (1 << 1), 28),
    (24, (1 << 1), 28),
    (31, (1 << 1), 28),
    (41, (1 << 1), 28),
    (56, 1 | (1 << 1), 28),
    (3, (1 << 1), 29),
    (6, (1 << 1), 29),
    (10, (1 << 1), 29),
    (15, (1 << 1), 29),
    (24, (1 << 1), 29),
    (31, (1 << 1), 29),
    (41, (1 << 1), 29),
    (56, 1 | (1 << 1), 29),
    # Node 249
    (3, (1 << 1), 30),
    (6, (1 << 1), 30),
    (10, (1 << 1), 30),
    (15, (1 << 1), 30),
    (24, (1 << 1), 30),
    (31, (1 << 1), 30),
    (41, (1 << 1), 30),
    (56, 1 | (1 << 1), 30),
    (3, (1 << 1), 31),
    (6, (1 << 1), 31),
    (10, (1 << 1), 31),
    (15, (1 << 1), 31),
    (24, (1 << 1), 31),
    (31, (1 << 1), 31),
    (41, (1 << 1), 31),
    (56, 1 | (1 << 1), 31),
    # Node 250
    (2, (1 << 1), 127),
    (9, (1 << 1), 127),
    (23, (1 << 1), 127),
    (40, 1 | (1 << 1), 127),
    (2, (1 << 1), 220),
    (9, (1 << 1), 220),
    (23, (1 << 1), 220),
    (40, 1 | (1 << 1), 220),
    (2, (1 << 1), 249),
    (9, (1 << 1), 249),
    (23, (1 << 1), 249),
    (40, 1 | (1 << 1), 249),
    (0, 1 | (1 << 1), 10),
    (0, 1 | (1 << 1), 13),
    (0, 1 | (1 << 1), 22),
    (0, (1 << 2), 0),
    # Node 251
    (3, (1 << 1), 127),
    (6, (1 << 1), 127),
    (10, (1 << 1), 127),
    (15, (1 << 1), 127),
    (24, (1 << 1), 127),
    (31, (1 << 1), 127),
    (41, (1 << 1), 127),
    (56, 1 | (1 << 1), 127),
    (3, (1 << 1), 220),
    (6, (1 << 1), 220),
    (10, (1 << 1), 220),
    (15, (1 << 1), 220),
    (24, (1 << 1), 220),
    (31, (1 << 1), 220),
    (41, (1 << 1), 220),
    (56, 1 | (1 << 1), 220),
    # Node 252
    (3, (1 << 1), 249),
    (6, (1 << 1), 249),
    (10, (1 << 1), 249),
    (15, (1 << 1), 249),
    (24, (1 << 1), 249),
    (31, (1 << 1), 249),
    (41, (1 << 1), 249),
    (56, 1 | (1 << 1), 249),
    (1, (1 << 1), 10),
    (22, 1 | (1 << 1), 10),
    (1, (1 << 1), 13),
    (22, 1 | (1 << 1), 13),
    (1, (1 << 1), 22),
    (22, 1 | (1 << 1), 22),
    (0, (1 << 2), 0),
    (0, (1 << 2), 0),
    # Node 253
    (2, (1 << 1), 10),
    (9, (1 << 1), 10),
    (23, (1 << 1), 10),
    (40, 1 | (1 << 1), 10),
    (2, (1 << 1), 13),
    (9, (1 << 1), 13),
    (23, (1 << 1), 13),
    (40, 1 | (1 << 1), 13),
    (2, (1 << 1), 22),
    (9, (1 << 1), 22),
    (23, (1 << 1), 22),
    (40, 1 | (1 << 1), 22),
    (0, (1 << 2), 0),
    (0, (1 << 2), 0),
    (0, (1 << 2), 0),
    (0, (1 << 2), 0),
    # Node 254
    (3, (1 << 1), 10),
    (6, (1 << 1), 10),
    (10, (1 << 1), 10),
    (15, (1 << 1), 10),
    (24, (1 << 1), 10),
    (31, (1 << 1), 10),
    (41, (1 << 1), 10),
    (56, 1 | (1 << 1), 10),
    (3, (1 << 1), 13),
    (6, (1 << 1), 13),
    (10, (1 << 1), 13),
    (15, (1 << 1), 13),
    (24, (1 << 1), 13),
    (31, (1 << 1), 13),
    (41, (1 << 1), 13),
    (56, 1 | (1 << 1), 13),
    # Node 255
    (3, (1 << 1), 22),
    (6, (1 << 1), 22),
    (10, (1 << 1), 22),
    (15, (1 << 1), 22),
    (24, (1 << 1), 22),
    (31, (1 << 1), 22),
    (41, (1 << 1), 22),
    (56, 1 | (1 << 1), 22),
    (0, (1 << 2), 0),
    (0, (1 << 2), 0),
    (0, (1 << 2), 0),
    (0, (1 << 2), 0),
    (0, (1 << 2), 0),
    (0, (1 << 2), 0),
    (0, (1 << 2), 0),
    (0, (1 << 2), 0),
]


class Encoder:
    """
    An HPACK encoder object. This object takes HTTP headers and emits encoded
    HTTP/2 header blocks.
    """

    __slots__ = ("header_table", "huffman_coder", "table_size_changes")

    def __init__(self):
        self.header_table = HeaderTable()
        self.huffman_coder = HuffmanEncoder()
        self.table_size_changes = []

    @property
    def header_table_size(self):
        """
        Controls the size of the HPACK header table.
        """
        return self.header_table.maxsize

    @header_table_size.setter
    def header_table_size(self, value):
        self.header_table.maxsize = value
        if self.header_table.resized:
            self.table_size_changes.append(value)

    def encode(self, headers, huffman=True):
        header_block = bytearray()

        # Signal table size changes if the header table has been resized
        if self.header_table.resized:
            block = bytearray()
            for size_bytes in self.table_size_changes:
                size_bytes = self._encode_integer(size_bytes, 5)
                size_bytes[0] |= 0x20
                block += size_bytes
            self.table_size_changes = []
            header_block.extend(block)
            self.header_table.resized = False

        for header in headers:
            if len(header) > 2:
                name, value, sensitive = header
            else:
                name, value = header
                sensitive = False

            indexbit = b"\x40" if not sensitive else b"\x10"
            match = self.header_table.search(name, value)

            if match is None:
                if huffman:
                    name = self.huffman_coder.encode(name)
                    value = self.huffman_coder.encode(value)

                name_len = self._encode_integer(len(name), 7)
                value_len = self._encode_integer(len(value), 7)

                if huffman:
                    name_len[0] |= 0x80
                    value_len[0] |= 0x80

                encoded = indexbit + bytes(name_len) + name + bytes(value_len) + value

                if not sensitive:
                    self.header_table.add(name, value)

            else:
                index, _, perfect = match

                if perfect:
                    field = self._encode_integer(index, 7)
                    field[0] |= 0x80
                    encoded = bytes(field)
                else:
                    prefix_bits = 4 if indexbit != b"\x40" else 6
                    prefix = self._encode_integer(index, prefix_bits)
                    prefix[0] |= ord(indexbit)

                    if huffman:
                        value = self.huffman_coder.encode(value)

                    value_len = self._encode_integer(len(value), 7)

                    if huffman:
                        value_len[0] |= 0x80

                    encoded = prefix + bytes(value_len) + value
                    if not sensitive:
                        self.header_table.add(name, value)

            header_block += encoded

        return bytes(header_block)

    def _encode_integer(self, integer, prefix_bits):
        """
        This encodes an integer according to the wacky integer encoding rules
        defined in the HPACK spec.
        """

        max_number = _PREFIX_BIT_MAX_NUMBERS[prefix_bits]

        if integer < max_number:
            return bytearray(
                [integer & 127]
            )  # Clear the highest bit for small integers

        elements = bytearray()
        integer -= max_number

        while integer >= 128:
            elements.append((integer & 127) + 128)
            integer >>= 7

        elements.append(integer)

        return elements

    def _encode_indexed(self, index):
        """
        Encodes a header using the indexed representation.
        """
        field = self._encode_integer(index, 7)
        field[0] |= 0x80  # we set the top bit
        return bytes(field)


class Decoder:
    __slots__ = ("header_table", "max_header_list_size", "max_allowed_table_size")
    """
    An HPACK decoder object.

    .. versionchanged:: 2.3.0
       Added ``max_header_list_size`` argument.

    :param max_header_list_size: The maximum decompressed size we will allow
        for any single header block. This is a protection against DoS attacks
        that attempt to force the application to expand a relatively small
        amount of data into a really large header list, allowing enormous
        amounts of memory to be allocated.

        If this amount of data is exceeded, a `OversizedHeaderListError
        <hpack.OversizedHeaderListError>` exception will be raised. At this
        point the connection should be shut down, as the HPACK state will no
        longer be usable.

        Defaults to 64kB.
    :type max_header_list_size: ``int``
    """

    def __init__(self, max_header_list_size=2**16):
        #: The maximum decompressed size we will allow for any single header
        #: block. This is a protection against DoS attacks that attempt to
        #: force the application to expand a relatively small amount of data
        #: into a really large header list, allowing enormous amounts of memory
        #: to be allocated.
        #:
        #: If this amount of data is exceeded, a `OversizedHeaderListError
        #: <hpack.OversizedHeaderListError>` exception will be raised. At this
        #: point the connection should be shut down, as the HPACK state will no
        #: longer be usable.
        #:
        #: Defaults to 64kB.
        #:
        #: .. versionadded:: 2.3.0
        self.header_table = HeaderTable()
        self.max_header_list_size = max_header_list_size

        #: Maximum allowed header table size.
        #:
        #: A HTTP/2 implementation should set this to the most recent value of
        #: SETTINGS_HEADER_TABLE_SIZE that it sent *and has received an ACK
        #: for*. Once this setting is set, the actual header table size will be
        #: checked at the end of each decoding run and whenever it is changed,
        #: to confirm that it fits in this size.
        self.max_allowed_table_size = self.header_table.maxsize

    @property
    def header_table_size(self):
        """
        Controls the size of the HPACK header table.
        """
        return self.header_table.maxsize

    @header_table_size.setter
    def header_table_size(self, value):
        self.header_table.maxsize = value

    def decode(self, data, raw=False):
        """
        Takes an HPACK-encoded header block and decodes it into a header set.

        :param data: A bytestring representing a complete HPACK-encoded header
                     block.
        :param raw: (optional) Whether to return the headers as tuples of raw
                    byte strings or to decode them as UTF-8 before returning
                    them. The default value is False, which returns tuples of
                    Unicode strings
        :returns: A list of two-tuples of ``(name, value)`` representing the
                  HPACK-encoded headers, in the order they were decoded.
        :raises HPACKDecodingError: If an error is encountered while decoding
                                    the header block.
        """

        data_mem = memoryview(data)
        headers = []
        data_len = len(data)
        inflated_size = 0
        current_index = 0

        while current_index < data_len:
            # Work out what kind of header we're decoding.
            # If the high bit is 1, it's an indexed field.
            current = data[current_index]
            indexed = True if current & 0x80 else False

            # Otherwise, if the second-highest bit is 1 it's a field that does
            # alter the header table.
            literal_index = True if current & 0x40 else False

            # Otherwise, if the third-highest bit is 1 it's an encoding context
            # update.
            encoding_update = True if current & 0x20 else False

            if indexed:
                index, consumed = self._decode_integer(data_mem[current_index:], 7)
                header = self.header_table.get_by_index(index)

            elif literal_index:
                # It's a literal header that does affect the header table.
                header, consumed = self._decode_literal(data_mem[current_index:], True)
            elif encoding_update:
                new_size, consumed = self._decode_integer(data_mem[current_index:], 5)
                if new_size > self.max_allowed_table_size:
                    raise Exception("Encoder exceeded max allowable table size")

                self.header_table_size = new_size
                header = None
            else:
                # It's a literal header that does not affect the header table.
                header, consumed = self._decode_literal(data_mem[current_index:], False)

            if header:
                headers.append(header)
                name, value = header
                inflated_size += 32 + len(name) + len(value)

            current_index += consumed

        return [
            (str(header[0], "utf-8"), str(header[1], "utf-8")) if raw else header
            for header in headers
        ]

    def _decode_integer(self, data, prefix_bits):
        """
        This decodes an integer according to the wacky integer encoding rules
        defined in the HPACK spec. Returns a tuple of the decoded integer and the
        number of bytes that were consumed from ``data`` in order to get that
        integer.
        """
        if prefix_bits < 1 or prefix_bits > 8:
            raise ValueError(
                "Prefix bits must be between 1 and 8, got %s" % prefix_bits
            )

        max_number = _PREFIX_BIT_MAX_NUMBERS[prefix_bits]
        index = 1
        shift = 0
        mask = 0xFF >> (8 - prefix_bits)

        number = data[0] & mask
        if number == max_number:
            while True:
                next_byte = data[index]
                index += 1

                if next_byte >= 128:
                    number += (next_byte - 128) << shift
                else:
                    number += next_byte << shift
                    break
                shift += 7

        return number, index

    def _decode_literal(self, data, should_index):
        """
        Decodes a header represented with a literal.
        """
        total_consumed = 0

        # When should_index is true, if the low six bits of the first byte are
        # nonzero, the header name is indexed.
        # When should_index is false, if the low four bits of the first byte
        # are nonzero the header name is indexed.
        if should_index:
            indexed_name = data[0] & 0x3F
            name_len = 6
            not_indexable = False
        else:
            high_byte = data[0]
            indexed_name = high_byte & 0x0F
            name_len = 4
            not_indexable = high_byte & 0x10

        if indexed_name:
            # Indexed header name.
            index, consumed = self._decode_integer(data, name_len)
            name = self.header_table.get_by_index(index)[0]

            total_consumed = consumed
            length = 0
        else:
            # Literal header name. The first byte was consumed, so we need to
            # move forward.
            data = data[1:]

            length, consumed = self._decode_integer(data, 7)
            name = data[consumed : consumed + length]

            if data[0] & 0x80:
                if not name:
                    name = b""

                state = 0
                flags = 0
                decoded_bytes = bytearray()
                # This loop is unrolled somewhat. Because we use a nibble, not a byte, we
                # need to handle each nibble twice. We unroll that: it makes the loop body
                # a bit longer, but that's ok.
                for input_byte in name:
                    index = (state * 16) + (input_byte >> 4)
                    state, flags, output_byte = _HUFFMAN_TABLE[index]

                    if flags & (1 << 1):
                        decoded_bytes.append(output_byte)

                    index = (state * 16) + (input_byte & 0x0F)
                    state, flags, output_byte = _HUFFMAN_TABLE[index]

                    if flags & (1 << 1):
                        decoded_bytes.append(output_byte)

                name = bytes(decoded_bytes)

            total_consumed = consumed + length + 1  # Since we moved forward 1.

        data = data[consumed + length :]

        # The header value is definitely length-based.
        length, consumed = self._decode_integer(data, 7)
        value = data[consumed : consumed + length]

        if data[0] & 0x80:
            if not value:
                value = b""

            state = 0
            flags = 0
            decoded_bytes = bytearray()

            # This loop is unrolled somewhat. Because we use a nibble, not a byte, we
            # need to handle each nibble twice. We unroll that: it makes the loop body
            # a bit longer, but that's ok.
            for input_byte in value:
                index = (state * 16) + (input_byte >> 4)
                state, flags, output_byte = _HUFFMAN_TABLE[index]

                if flags & (1 << 1):
                    decoded_bytes.append(output_byte)

                index = (state * 16) + (input_byte & 0x0F)
                state, flags, output_byte = _HUFFMAN_TABLE[index]

                if flags & (1 << 1):
                    decoded_bytes.append(output_byte)

            value = bytes(decoded_bytes)

        # Updated the total consumed length.
        total_consumed += length + consumed

        # If we have been told never to index the header field, encode that in
        # the tuple we use.
        if not_indexable:
            header = (name, value)
        else:
            header = (name, value)

        # If we've been asked to index this, add it to the header table.
        if should_index:
            self.header_table.add(name, value)

        return header, total_consumed
