/* This file is a c++ wrapper function for computing the transportation cost
 * between two vectors given a cost matrix.
 *
 * It was written by Antoine Rolet (2014) and mainly consists of a wrapper
 * of the code written by Nicolas Bonneel available on this page
 *          http://people.seas.harvard.edu/~nbonneel/FastTransport/
 *
 * It was then modified to make it more amenable to python inline calling
 *
 * Please give relevant credit to the original author (Nicolas Bonneel) if
 * you use this code for a publication.
 *
 */


#ifndef EMD_H
#define EMD_H

#include <iostream>
#include <vector>
#include "network_simplex_simple.h"

using namespace lemon;
typedef unsigned int node_id_type;


void EMD_wrap(int n1,int n2, double *X, double *Y,double *D, double *G, double *cost);

#endif
