export const tokens = {
  themes: {
    default: {
      theme: {
        colors: {
          'secondary-text': '#555F6B',
          'secondary-100': '#eff8ff',
          'secondary-200': '#eaf3fd',
          'secondary-300': '#e2ebf5',
          'secondary-400': '#c0c9d3',
          'secondary-500': '#a3abb4',
          'secondary-600': '#79818a',
          'secondary-700': '#656c75',
          'secondary-800': '#454d55',
          'secondary-900': '#242b32',
          'info-text': '#FFFFFF',
          'info-100': '#EBF2FC',
          'info-200': '#8CB5EA',
          'info-300': '#5894E1',
          'info-400': '#377FDB',
          'info-500': '#055FD2',
          'info-600': '#0556BF',
          'info-700': '#044395',
          'info-800': '#033474',
          'info-900': '#022858',
          'greyscale-100': '#FAFAFB',
          'greyscale-200': '#F3F4F4',
          'greyscale-300': '#E7E8EA',
          'greyscale-400': '#C2C6CA',
          'greyscale-500': '#9EA3AA',
          'greyscale-600': '#79818A',
          'greyscale-700': '#555F6B',
          'greyscale-800': '#303C4B',
          'greyscale-900': '#0C1A2B',
          'greyscale-000': '#FFFFFF',
          'primary-100': '#ffcad1',
          'primary-200': '#f19597',
          'primary-300': '#e86a6f',
          'primary-400': '#f2444b',
          'primary-500': '#f72c30',
          'primary-600': '#e81f2f',
          'primary-700': '#d60f29',
          'primary-800': '#c90022',
          'primary-900': '#bb0014',
          'success-100': '#EFFCD3',
          'success-200': '#DBFAA9',
          'success-300': '#BEF27C',
          'success-400': '#A0E659',
          'success-500': '#76D628',
          'success-600': '#5AB81D',
          'success-700': '#419A14',
          'success-800': '#2C7C0C',
          'success-900': '#1D6607',
          'warning-100': '#FFF8CD',
          'warning-200': '#FFEF9B',
          'warning-300': '#FFE469',
          'warning-400': '#FFDA43',
          'warning-500': '#FFC805',
          'warning-600': '#DBA603',
          'warning-700': '#B78702',
          'warning-800': '#936901',
          'warning-900': '#7A5400',
          'danger-100': '#F4B0B0',
          'danger-200': '#EE8A8A',
          'danger-300': '#E65454',
          'danger-400': '#E13333',
          'danger-500': '#DA0000',
          'danger-600': '#C60000',
          'danger-700': '#9B0000',
          'danger-800': '#780000',
          'danger-900': '#5C0000',
          'primary-text': '#FFFFFF',
          'success-text': '#FFFFFF',
          'warning-text': '#FFFFFF',
          'danger-text': '#FFFFFF',
          black: '#090909',
          'dark-grey': '#232323',
          charcoal: '#29303b',
          'slate-grey': '#686868',
          'battleship-grey': '#686f7a',
          'light-grey': '#d2d2d2',
          silver: '#d5dbe0',
          azure2: '#eceff1',
          smoke: '#fdfdfd',
          white: '#ffffff',
          denim: '#0067b7',
          firebrick6: '#f72c30',
          'purplish-grey': '#726c74',
          grey32: '#525151',
          grey59: '#969696',
          grey87: '#dfdfdf',
          indianred3: '#df484b',
          midnightblue: '#141b2c',
          mantis: '#76ce68',
          'mantis-darken': '#006908',
        },
        font: {
          sizes: {
            h1: '1.75rem',
            h2: '1.375rem',
            h3: '1.125rem',
            h4: '0.8125rem',
            h5: '0.625rem',
            h6: '0.5rem',
            l: '1rem',
            m: '0.8125rem',
            s: '0.6875rem',
          },
          weights: {
            thin: 200,
            light: 300,
            regular: 400,
            medium: 500,
            bold: 600,
            extrabold: 700,
            black: 800,
          },
          families: { base: 'Hind', accent: 'Montserrat' },
          letterSpacings: {
            h1: 'normal',
            h2: 'normal',
            h3: 'normal',
            h4: 'normal',
            h5: '1px',
            h6: 'normal',
            l: 'normal',
            m: 'normal',
            s: 'normal',
          },
        },
        spacings: { xl: '4rem', l: '3rem', b: '1.625rem', s: '1rem', t: '0.5rem', st: '0.25rem' },
        transitions: {
          'ease-in': 'cubic-bezier(0.32, 0, 0.67, 0)',
          'ease-out': 'cubic-bezier(0.33, 1, 0.68, 1)',
          'ease-in-out': 'cubic-bezier(0.65, 0, 0.35, 1)',
          duration: '250ms',
        },
        breakpoints: { xs: 0, sm: '576px', md: '768px', lg: '992px', xl: '1200px', xxl: '1400px' },
      },
      components: {
        tabs: { 'border-bottom-color': '#E7E8EA' },
        button: { 'font-family': 'Montserrat' },
        dashboardListAvatar: { saturation: 30, lightness: 55 },
      },
    },
    dark: {
      theme: {
        colors: {
          'greyscale-100': '#182536',
          'greyscale-200': '#303C4B',
          'greyscale-300': '#555F6B',
          'greyscale-400': '#79818A',
          'greyscale-500': '#9EA3AA',
          'greyscale-600': '#C2C6CA',
          'greyscale-700': '#E7E8EA',
          'greyscale-800': '#F3F4F4',
          'greyscale-900': '#FAFAFB',
          'greyscale-000': '#0C1A2B',
          'primary-100': '#3B4C62',
          'primary-200': '#4D6481',
          'primary-300': '#6381A6',
          'primary-400': '#7FA5D5',
          'primary-500': '#8CB5EA',
          'primary-600': '#A3C4EE',
          'primary-700': '#C3D8F4',
          'primary-800': '#DDE9F8',
          'primary-900': '#F4F8FD',
          'success-100': '#EEF8D7',
          'success-200': '#D9F1B2',
          'success-300': '#BDE985',
          'success-400': '#A0E25D',
          'success-500': '#76D628',
          'success-600': '#5BB520',
          'success-700': '#43941A',
          'success-800': '#307414',
          'success-900': '#225D10',
          'warning-100': '#F7F3D5',
          'warning-200': '#F0E5AA',
          'warning-300': '#E8D680',
          'warning-400': '#E3C95F',
          'warning-500': '#D9B32B',
          'warning-600': '#BD9721',
          'warning-700': '#9D7B1C',
          'warning-800': '#7E6016',
          'warning-900': '#684D12',
          'danger-100': '#F8D0D0',
          'danger-200': '#F09898',
          'danger-300': '#F09898',
          'danger-400': '#ED8585',
          'danger-500': '#E96666',
          'danger-600': '#DD6666',
          'danger-700': '#C36666',
          'danger-800': '#AE6666',
          'danger-900': '#9D6666',
        },
      },
    },
  },
};
