# Generated by Django 2.2.11 on 2020-03-13 14:14

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import cms.models.fields
import filer.fields.image


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("cms", "0022_auto_20180620_1551"),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Glimpse",
            fields=[
                (
                    "cmsplugin_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="glimpse_glimpse",
                        serialize=False,
                        to="cms.CMSPlugin",
                    ),
                ),
                ("title", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "variant",
                    models.CharField(
                        blank=True,
                        choices=[
                            (None, "Inherit"),
                            ("card_square", "Square card"),
                            ("row_half", "Half row"),
                            ("row_full", "Full row"),
                        ],
                        default=None,
                        help_text="Form factor variant",
                        max_length=50,
                        null=True,
                        verbose_name="Variant",
                    ),
                ),
                ("content", models.TextField(default="", verbose_name="Content")),
                (
                    "link_url",
                    models.URLField(
                        blank=True,
                        help_text="Make the glimpse as a link with an external URL.",
                        max_length=255,
                        null=True,
                        verbose_name="External URL",
                    ),
                ),
                (
                    "image",
                    filer.fields.image.FilerImageField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="image",
                        to=settings.FILER_IMAGE_MODEL,
                        verbose_name="image",
                    ),
                ),
                (
                    "link_page",
                    cms.models.fields.PageField(
                        blank=True,
                        help_text="Make the glimpse as a link with an internal (page) URL.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="cms.Page",
                        verbose_name="Internal URL",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("cms.cmsplugin",),
        ),
    ]
