from dataclasses import dataclass
from typing import Union


@dataclass
class EnvVar:
    name: str
    type = str
    default: Union[str, None] = None
    show_default: bool = True


ENV_VARS = {
    'RAY_ADDRESS': EnvVar('RAY_ADDRESS'),
    'RAY_DASHBOARD_ADDRESS': EnvVar('RAY_DASHBOARD_ADDRESS'),
    'RAY_SERVE_ADDRESS': EnvVar('RAY_SERVE_ADDRESS'),
    'SYNAPSE_PLUGIN_STORAGE': EnvVar('SYNAPSE_PLUGIN_STORAGE', default='', show_default=False),
    'SYNAPSE_DEBUG_PLUGIN_PATH': EnvVar('SYNAPSE_DEBUG_PLUGIN_PATH', default='', show_default=False),
    'SYNAPSE_DEBUG_MODULES': EnvVar('SYNAPSE_DEBUG_MODULES', default='', show_default=False),
    'SYNAPSE_PLUGIN_PUBLISH_HOST': EnvVar('SYNAPSE_PLUGIN_PUBLISH_HOST'),
    'SYNAPSE_PLUGIN_PUBLISH_USER_TOKEN': EnvVar('SYNAPSE_PLUGIN_PUBLISH_USER_TOKEN'),
    'SYNAPSE_PLUGIN_PUBLISH_TENANT': EnvVar('SYNAPSE_PLUGIN_PUBLISH_TENANT'),
    'SYNAPSE_PLUGIN_RUN_HOST': EnvVar('SYNAPSE_PLUGIN_RUN_HOST', default='SYNAPSE_PLUGIN_PUBLISH_HOST'),
    'SYNAPSE_PLUGIN_RUN_AGENT': EnvVar('SYNAPSE_PLUGIN_RUN_AGENT', default='', show_default=False),
    'SYNAPSE_PLUGIN_RUN_AGENT_TOKEN': EnvVar('SYNAPSE_PLUGIN_RUN_AGENT_TOKEN'),
    'SYNAPSE_PLUGIN_RUN_AGENT_HOST': EnvVar('SYNAPSE_PLUGIN_RUN_AGENT_HOST'),
    'SYNAPSE_PLUGIN_RUN_USER_TOKEN': EnvVar(
        'SYNAPSE_PLUGIN_RUN_USER_TOKEN', default='SYNAPSE_PLUGIN_PUBLISH_USER_TOKEN'
    ),
    'SYNAPSE_PLUGIN_RUN_TENANT': EnvVar('SYNAPSE_PLUGIN_RUN_TENANT', default='SYNAPSE_PLUGIN_PUBLISH_TENANT'),
}
