"use strict";
// @see https://circleci.com/docs/2.0/configuration-reference
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineParameterType = exports.JobWhen = exports.ResourceClass = exports.JobType = void 0;
/**
 * A job may have a type of approval indicating it must be manually approved before downstream jobs may proceed
 * @see https://circleci.com/docs/2.0/configuration-reference/#type
 */
var JobType;
(function (JobType) {
    JobType["APPROVAL"] = "approval";
})(JobType || (exports.JobType = JobType = {}));
/**
 * The resource_class feature allows configuring CPU and RAM resources for each job.
 * Different resource classes are available for different executors, as described in the tables below.
 * @see https://circleci.com/docs/2.0/configuration-reference/#resourceclass
 */
var ResourceClass;
(function (ResourceClass) {
    ResourceClass["SMALL"] = "small";
    ResourceClass["MEDIUM"] = "medium";
    ResourceClass["MEDIUM_PLUS"] = "medium+";
    ResourceClass["LARGE_X"] = "xlarge";
    ResourceClass["LARGE_2X"] = "2xlarge";
    ResourceClass["LARGE_2X_PLUS"] = "2xlarge+";
})(ResourceClass || (exports.ResourceClass = ResourceClass = {}));
/**
 * Specify when to enable or disable the step.
 * @see https://circleci.com/docs/2.0/configuration-reference/#steps
 */
var JobWhen;
(function (JobWhen) {
    JobWhen["ALWAYS"] = "always";
    JobWhen["ON_SUCCESS"] = "on_success";
    JobWhen["ON_FAIL"] = "on_fail";
})(JobWhen || (exports.JobWhen = JobWhen = {}));
/**
 * Pipeline parameter types
 * @see https://circleci.com/docs/2.0/reusing-config#parameter-syntax
 */
var PipelineParameterType;
(function (PipelineParameterType) {
    PipelineParameterType["STRING"] = "string";
    PipelineParameterType["BOOLEAN"] = "boolean";
    PipelineParameterType["INTEGER"] = "integer";
    PipelineParameterType["ENUM"] = "enum";
})(PipelineParameterType || (exports.PipelineParameterType = PipelineParameterType = {}));
//# sourceMappingURL=data:application/json;base64,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