import { IConstruct } from "constructs";
import { Component } from "../component";
import * as gh from "../github";
/**
 * The merge method used to add the PR to the merge queue
 *
 * Behavior can be further configured in repository settings.
 */
export declare enum MergeMethod {
    SQUASH = "squash",
    MERGE = "merge",
    REBASE = "rebase"
}
/**
 * Options for 'AutoQueue'
 */
export interface AutoQueueOptions {
    /**
     * Only pull requests authored by these Github usernames will have auto-queue enabled.
     * @default - pull requests from all users are eligible for auto-queuing
     */
    readonly allowedUsernames?: string[];
    /**
     * Only pull requests with one of this labels will have auto-queue enabled.
     * @default - all pull requests are eligible for auto-queueing
     */
    readonly labels?: string[];
    /**
     * Choose a method for authenticating with GitHub to enable auto-queue on pull requests.
     *
     * The workflow cannot use a default github token. Queuing a PR
     * with the default token will not trigger any merge queue workflows,
     * which results in the PR just not getting merged at all.
     *
     * @see https://projen.io/docs/integrations/github/
     * @default - uses credentials from the GitHub component
     */
    readonly projenCredentials?: gh.GithubCredentials;
    /**
     * The method used to add the PR to the merge queue
     * Any branch protection rules must allow this merge method.
     * @default MergeMethod.SQUASH
     */
    readonly mergeMethod?: MergeMethod;
    /**
     * Github Runner selection labels
     * @default ["ubuntu-latest"]
     */
    readonly runsOn?: string[];
}
/**
 * Automatically add pull requests to the merge queue
 * PRs will be merged once they pass required checks.
 */
export declare class AutoQueue extends Component {
    constructor(scope: IConstruct, options?: AutoQueueOptions);
}
