"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MergeQueue = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const auto_queue_1 = require("./auto-queue");
const component_1 = require("../component");
const gh = require("../github");
const github_1 = require("../github");
/**
 * Merge pull requests using a merge queue
 */
class MergeQueue extends component_1.Component {
    constructor(scope, options = {}) {
        super(scope);
        this.options = options;
        const workflowEngine = gh.GitHub.of(this.project);
        if (!workflowEngine) {
            throw new Error(`Cannot add ${new.target.name} to project without GitHub enabled. Please enable GitHub for this project.`);
        }
        const autoMerge = options.autoQueue ?? true;
        if (autoMerge) {
            new auto_queue_1.AutoQueue(this, options.autoQueueOptions);
        }
    }
    preSynthesize() {
        const targetBranches = this.options.targetBranches;
        const mergeGroup = targetBranches
            ? {
                branches: targetBranches,
            }
            : {};
        const workflowEngine = github_1.GitHub.of(this.project);
        workflowEngine?.tryFindWorkflow("build")?.on({
            mergeGroup,
        });
    }
}
exports.MergeQueue = MergeQueue;
_a = JSII_RTTI_SYMBOL_1;
MergeQueue[_a] = { fqn: "projen.github.MergeQueue", version: "0.91.13" };
//# sourceMappingURL=data:application/json;base64,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