"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mergify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const util_1 = require("../util");
const yaml_1 = require("../yaml");
class Mergify extends component_1.Component {
    constructor(github, options = {}) {
        super(github.project);
        this.rules = new Array();
        this.queues = new Array();
        for (const rule of options.rules ?? []) {
            this.addRule(rule);
        }
        for (const queue of options.queues ?? []) {
            this.addQueue(queue);
        }
    }
    createYamlFile() {
        if (this.yamlFile == null) {
            this.yamlFile = new yaml_1.YamlFile(this.project, ".mergify.yml", {
                obj: {
                    queue_rules: () => this.queues.map((q) => (0, util_1.snakeCaseKeys)(q, false)),
                    pull_request_rules: this.rules,
                },
                // Mergify needs to read the file from the repository in order to work.
                committed: true,
            });
        }
    }
    addRule(rule) {
        this.rules.push(rule);
        this.createYamlFile();
    }
    addQueue(queue) {
        this.queues.push(queue);
        this.createYamlFile();
    }
}
exports.Mergify = Mergify;
_a = JSII_RTTI_SYMBOL_1;
Mergify[_a] = { fqn: "projen.github.Mergify", version: "0.91.13" };
//# sourceMappingURL=data:application/json;base64,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