"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.secretToString = secretToString;
exports.context = context;
exports.isHiddenPath = isHiddenPath;
exports.ensureNotHiddenPath = ensureNotHiddenPath;
function secretToString(secretName) {
    return `\${{ secrets.${secretName} }}`;
}
function context(value) {
    return `\${{ ${value} }}`;
}
// Checks if part of the file path is hidden
function isHiddenPath(path) {
    return /(^|\/)\.[^\/\.]/g.test(path);
}
// Helper to assert a path is not hidden
function ensureNotHiddenPath(value, name) {
    if (isHiddenPath(value)) {
        throw Error(`${name} cannot be a hidden path, got: ${value}`);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9naXRodWIvcHJpdmF0ZS91dGlsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBRUM7QUFFRCwwQkFFQztBQUdELG9DQUVDO0FBR0Qsa0RBSUM7QUFsQkQsU0FBZ0IsY0FBYyxDQUFDLFVBQWtCO0lBQy9DLE9BQU8sZ0JBQWdCLFVBQVUsS0FBSyxDQUFDO0FBQ3pDLENBQUM7QUFFRCxTQUFnQixPQUFPLENBQUMsS0FBYTtJQUNuQyxPQUFPLFFBQVEsS0FBSyxLQUFLLENBQUM7QUFDNUIsQ0FBQztBQUVELDRDQUE0QztBQUM1QyxTQUFnQixZQUFZLENBQUMsSUFBWTtJQUN2QyxPQUFPLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUN2QyxDQUFDO0FBRUQsd0NBQXdDO0FBQ3hDLFNBQWdCLG1CQUFtQixDQUFDLEtBQWEsRUFBRSxJQUFZO0lBQzdELElBQUksWUFBWSxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7UUFDeEIsTUFBTSxLQUFLLENBQUMsR0FBRyxJQUFJLGtDQUFrQyxLQUFLLEVBQUUsQ0FBQyxDQUFDO0lBQ2hFLENBQUM7QUFDSCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGZ1bmN0aW9uIHNlY3JldFRvU3RyaW5nKHNlY3JldE5hbWU6IHN0cmluZyk6IHN0cmluZyB7XG4gIHJldHVybiBgXFwke3sgc2VjcmV0cy4ke3NlY3JldE5hbWV9IH19YDtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNvbnRleHQodmFsdWU6IHN0cmluZykge1xuICByZXR1cm4gYFxcJHt7ICR7dmFsdWV9IH19YDtcbn1cblxuLy8gQ2hlY2tzIGlmIHBhcnQgb2YgdGhlIGZpbGUgcGF0aCBpcyBoaWRkZW5cbmV4cG9ydCBmdW5jdGlvbiBpc0hpZGRlblBhdGgocGF0aDogc3RyaW5nKSB7XG4gIHJldHVybiAvKF58XFwvKVxcLlteXFwvXFwuXS9nLnRlc3QocGF0aCk7XG59XG5cbi8vIEhlbHBlciB0byBhc3NlcnQgYSBwYXRoIGlzIG5vdCBoaWRkZW5cbmV4cG9ydCBmdW5jdGlvbiBlbnN1cmVOb3RIaWRkZW5QYXRoKHZhbHVlOiBzdHJpbmcsIG5hbWU6IHN0cmluZykge1xuICBpZiAoaXNIaWRkZW5QYXRoKHZhbHVlKSkge1xuICAgIHRocm93IEVycm9yKGAke25hbWV9IGNhbm5vdCBiZSBhIGhpZGRlbiBwYXRoLCBnb3Q6ICR7dmFsdWV9YCk7XG4gIH1cbn1cbiJdfQ==