"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskWorkflowJob = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constants_1 = require("./constants");
const workflow_steps_1 = require("./workflow-steps");
const component_1 = require("../component");
const runner_options_1 = require("../runner-options");
const util_1 = require("./private/util");
/**
 * The primary or initial job of a TaskWorkflow.
 *
 * @implements {Job}
 */
class TaskWorkflowJob extends component_1.Component {
    /**
     * @param scope should be part of the project the Task belongs to.
     * @param task the main task that is run as part of this job.
     * @param options options to configure the TaskWorkflowJob.
     */
    constructor(scope, task, options) {
        super(scope, `${new.target.name}#${task.name}`);
        const preCheckoutSteps = options.preCheckoutSteps ?? [];
        const checkoutWith = {};
        if (options.downloadLfs) {
            checkoutWith.lfs = true;
        }
        // 'checkoutWith' can override 'lfs'
        Object.assign(checkoutWith, options.checkoutWith ?? {});
        const preBuildSteps = options.preBuildSteps ?? [];
        const postBuildSteps = options.postBuildSteps ?? [];
        const gitIdentity = options.gitIdentity ?? constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        if (options.artifactsDirectory) {
            (0, util_1.ensureNotHiddenPath)(options.artifactsDirectory, "artifactsDirectory");
            postBuildSteps.push(workflow_steps_1.WorkflowSteps.uploadArtifact({
                // Setting to always will ensure that this step will run even if
                // the previous ones have failed (e.g. coverage report, internal logs, etc)
                if: "always()",
                with: {
                    name: options.artifactsDirectory,
                    path: options.artifactsDirectory,
                },
            }));
        }
        const runsOnInputs = (0, runner_options_1.filteredRunsOnOptions)(options.runsOn, options.runsOnGroup);
        this.runsOn = runsOnInputs?.runsOn;
        this.runsOnGroup = runsOnInputs?.runsOnGroup;
        this.container = options.container;
        this.env = options.env;
        this.permissions = options.permissions;
        this.defaults = options?.jobDefaults;
        this.if = options.condition;
        this.outputs = options.outputs;
        this.steps = [
            ...preCheckoutSteps,
            // check out sources.
            workflow_steps_1.WorkflowSteps.checkout({ with: checkoutWith }),
            // sets git identity so we can push later
            workflow_steps_1.WorkflowSteps.setupGitIdentity({ gitIdentity }),
            ...preBuildSteps,
            // run the main build task
            {
                name: task.name,
                run: this.project.runTaskCommand(task),
            },
            ...postBuildSteps,
        ];
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        return {
            runsOn: this.runsOn,
            runsOnGroup: this.runsOnGroup,
            steps: this.steps,
            environment: this.environment,
            outputs: this.outputs,
            env: this.env,
            defaults: this.defaults,
            timeoutMinutes: this.timeoutMinutes,
            continueOnError: this.continueOnError,
            container: this.container,
            services: this.services,
            tools: this.tools,
            name: this.name,
            needs: this.needs,
            permissions: this.permissions,
            concurrency: this.concurrency,
            if: this.if,
            strategy: this.strategy,
        };
    }
}
exports.TaskWorkflowJob = TaskWorkflowJob;
_a = JSII_RTTI_SYMBOL_1;
TaskWorkflowJob[_a] = { fqn: "projen.github.TaskWorkflowJob", version: "0.91.13" };
//# sourceMappingURL=data:application/json;base64,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