"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskWorkflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const task_workflow_job_1 = require("./task-workflow-job");
const workflows_1 = require("./workflows");
const DEFAULT_JOB_ID = "build";
/**
 * A GitHub workflow for common build tasks within a project.
 */
class TaskWorkflow extends workflows_1.GithubWorkflow {
    constructor(github, options) {
        super(github, options.name);
        this.jobId = options.jobId ?? DEFAULT_JOB_ID;
        this.artifactsDirectory = options.artifactsDirectory;
        if (options.triggers) {
            if (options.triggers.issueComment) {
                // https://docs.github.com/en/actions/learn-github-actions/security-hardening-for-github-actions#potential-impact-of-a-compromised-runner
                throw new Error('Trigger "issueComment" should not be used due to a security concern');
            }
            this.on(options.triggers);
        }
        this.on({
            workflowDispatch: {}, // allow manual triggering
        });
        const job = new task_workflow_job_1.TaskWorkflowJob(this, options.task, {
            ...options,
            downloadLfs: options.downloadLfs ?? github.downloadLfs,
        });
        this.addJobs({ [this.jobId]: job });
    }
}
exports.TaskWorkflow = TaskWorkflow;
_a = JSII_RTTI_SYMBOL_1;
TaskWorkflow[_a] = { fqn: "projen.github.TaskWorkflow", version: "0.91.13" };
//# sourceMappingURL=data:application/json;base64,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