"use strict";
// @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppPermission = exports.JobPermission = void 0;
/**
 * Access level for workflow permission scopes.
 */
var JobPermission;
(function (JobPermission) {
    /** Read-only access */
    JobPermission["READ"] = "read";
    /** Read-write access */
    JobPermission["WRITE"] = "write";
    /** No access at all */
    JobPermission["NONE"] = "none";
})(JobPermission || (exports.JobPermission = JobPermission = {}));
/**
 * The permissions available for an access token for a GitHub App.
 */
var AppPermission;
(function (AppPermission) {
    /** Read-only acccess */
    AppPermission["READ"] = "read";
    /** Read-write access */
    AppPermission["WRITE"] = "write";
    /**
     * Read-write and admin access.
     *
     * Not all permissions support `admin`.
     */
    AppPermission["ADMIN"] = "admin";
})(AppPermission || (exports.AppPermission = AppPermission = {}));
//#endregion
//# sourceMappingURL=data:application/json;base64,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