"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MavenSample = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("../component");
const sample_file_1 = require("../sample-file");
/**
 * Java code sample.
 */
class MavenSample extends component_1.Component {
    constructor(project, options) {
        super(project);
        const pkg = options.package.split(".");
        new sample_file_1.SampleDir(project, (0, path_1.join)("src", "main", "java", ...pkg), {
            files: {
                "Main.java": [
                    ...(options.package ? [`package ${options.package};`] : []),
                    "",
                    "public class Main {",
                    "  public static void main(final String[] args) {",
                    '    System.out.println("Hello, world!");',
                    "  }",
                    "}",
                ].join("\n"),
            },
        });
    }
}
exports.MavenSample = MavenSample;
_a = JSII_RTTI_SYMBOL_1;
MavenSample[_a] = { fqn: "projen.java.MavenSample", version: "0.91.13" };
//# sourceMappingURL=data:application/json;base64,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