"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const eslint_1 = require("./eslint");
const render_options_1 = require("./render-options");
const common_1 = require("../common");
const projenrc_1 = require("../projenrc");
/**
 * A projenrc file written in JavaScript
 *
 * This component can be instantiated in any type of project
 * and has no expectations around the project's main language.
 */
class Projenrc extends projenrc_1.ProjenrcFile {
    constructor(project, options = {}) {
        super(project);
        this.filePath = options.filename ?? common_1.DEFAULT_PROJEN_RC_JS_FILENAME;
        // this is the task projen executes when running `projen`
        project.defaultTask?.exec(`node ${this.filePath}`);
        this.generateProjenrc();
    }
    preSynthesize() {
        super.preSynthesize();
        const eslint = eslint_1.Eslint.of(this.project);
        eslint?.addLintPattern(this.filePath);
        eslint?.addIgnorePattern(`!${this.filePath}`);
        eslint?.addOverride({
            files: [this.filePath],
            rules: {
                "@typescript-eslint/no-require-imports": "off",
                "import/no-extraneous-dependencies": "off",
            },
        });
    }
    generateProjenrc() {
        const rcfile = (0, path_1.resolve)(this.project.outdir, this.filePath);
        if ((0, fs_1.existsSync)(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split(".");
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join(".");
        const { renderedOptions, imports } = (0, render_options_1.renderJavaScriptOptions)({
            comments: bootstrap.comments,
            args: bootstrap.args,
            type: bootstrap.type,
        });
        imports.add(moduleName, importName);
        const lines = new Array();
        lines.push(...imports.asCjsRequire());
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push("project.synth();");
        (0, fs_1.mkdirSync)((0, path_1.dirname)(rcfile), { recursive: true });
        (0, fs_1.writeFileSync)(rcfile, lines.join("\n"));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.javascript.Projenrc", version: "0.91.13" };
//# sourceMappingURL=data:application/json;base64,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