"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Yarnrc = exports.YarnWorkerPoolMode = exports.YarnWinLinkType = exports.YarnCacheMigrationMode = exports.YarnProgressBarStyle = exports.YarnPnpMode = exports.YarnPnpFallbackMode = exports.YarnNpmPublishAccess = exports.YarnNodeLinker = exports.YarnNmMode = exports.YarnNmHoistingLimit = exports.YarnLogFilterLevel = exports.YarnDefaultSemverRangePrefix = exports.YarnChecksumBehavior = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const component_1 = require("../component");
const yaml_1 = require("../yaml");
/** https://yarnpkg.com/configuration/yarnrc#checksumBehavior */
var YarnChecksumBehavior;
(function (YarnChecksumBehavior) {
    YarnChecksumBehavior["THROW"] = "throw";
    YarnChecksumBehavior["UPDATE"] = "update";
    YarnChecksumBehavior["RESET"] = "reset";
    YarnChecksumBehavior["IGNORE"] = "ignore";
})(YarnChecksumBehavior || (exports.YarnChecksumBehavior = YarnChecksumBehavior = {}));
/** https://yarnpkg.com/configuration/yarnrc#defaultSemverRangePrefix */
var YarnDefaultSemverRangePrefix;
(function (YarnDefaultSemverRangePrefix) {
    YarnDefaultSemverRangePrefix["CARET"] = "^";
    YarnDefaultSemverRangePrefix["TILDE"] = "~";
    YarnDefaultSemverRangePrefix["EMPTY_STRING"] = "";
})(YarnDefaultSemverRangePrefix || (exports.YarnDefaultSemverRangePrefix = YarnDefaultSemverRangePrefix = {}));
/** https://v3.yarnpkg.com/configuration/yarnrc#logFilters.0.level */
var YarnLogFilterLevel;
(function (YarnLogFilterLevel) {
    YarnLogFilterLevel["INFO"] = "info";
    YarnLogFilterLevel["WARNING"] = "warning";
    YarnLogFilterLevel["ERROR"] = "error";
    YarnLogFilterLevel["DISCARD"] = "discard";
})(YarnLogFilterLevel || (exports.YarnLogFilterLevel = YarnLogFilterLevel = {}));
/** https://yarnpkg.com/configuration/yarnrc#nmHoistingLimits */
var YarnNmHoistingLimit;
(function (YarnNmHoistingLimit) {
    YarnNmHoistingLimit["DEPENDENCIES"] = "dependencies";
    YarnNmHoistingLimit["NONE"] = "none";
    YarnNmHoistingLimit["WORKSPACES"] = "workspaces";
})(YarnNmHoistingLimit || (exports.YarnNmHoistingLimit = YarnNmHoistingLimit = {}));
/** https://yarnpkg.com/configuration/yarnrc#nmMode */
var YarnNmMode;
(function (YarnNmMode) {
    YarnNmMode["CLASSIC"] = "classic";
    YarnNmMode["HARDLINKS_LOCAL"] = "hardlinks-local";
    YarnNmMode["HARDLINKS_GLOBAL"] = "hardlinks-global";
})(YarnNmMode || (exports.YarnNmMode = YarnNmMode = {}));
/** https://yarnpkg.com/configuration/yarnrc#nodeLinker */
var YarnNodeLinker;
(function (YarnNodeLinker) {
    YarnNodeLinker["PNP"] = "pnp";
    YarnNodeLinker["PNPM"] = "pnpm";
    YarnNodeLinker["NODE_MODULES"] = "node-modules";
})(YarnNodeLinker || (exports.YarnNodeLinker = YarnNodeLinker = {}));
/** https://yarnpkg.com/configuration/yarnrc#npmPublishAccess */
var YarnNpmPublishAccess;
(function (YarnNpmPublishAccess) {
    YarnNpmPublishAccess["PUBLIC"] = "public";
    YarnNpmPublishAccess["RESTRICTED"] = "restricted";
})(YarnNpmPublishAccess || (exports.YarnNpmPublishAccess = YarnNpmPublishAccess = {}));
/** https://yarnpkg.com/configuration/yarnrc#pnpFallbackMode */
var YarnPnpFallbackMode;
(function (YarnPnpFallbackMode) {
    YarnPnpFallbackMode["NONE"] = "none";
    YarnPnpFallbackMode["DEPENDENCIES_ONLY"] = "dependencies-only";
    YarnPnpFallbackMode["ALL"] = "all";
})(YarnPnpFallbackMode || (exports.YarnPnpFallbackMode = YarnPnpFallbackMode = {}));
/** https://yarnpkg.com/configuration/yarnrc#pnpMode */
var YarnPnpMode;
(function (YarnPnpMode) {
    YarnPnpMode["STRICT"] = "strict";
    YarnPnpMode["LOOSE"] = "loose";
})(YarnPnpMode || (exports.YarnPnpMode = YarnPnpMode = {}));
/** https://yarnpkg.com/configuration/yarnrc#progressBarStyle */
var YarnProgressBarStyle;
(function (YarnProgressBarStyle) {
    YarnProgressBarStyle["PATRICK"] = "patrick";
    YarnProgressBarStyle["SIMBA"] = "simba";
    YarnProgressBarStyle["JACK"] = "jack";
    YarnProgressBarStyle["HOGSFATHER"] = "hogsfather";
    YarnProgressBarStyle["DEFAULT"] = "default";
})(YarnProgressBarStyle || (exports.YarnProgressBarStyle = YarnProgressBarStyle = {}));
/** https://yarnpkg.com/configuration/yarnrc#cacheMigrationMode */
var YarnCacheMigrationMode;
(function (YarnCacheMigrationMode) {
    YarnCacheMigrationMode["REQUIRED_ONLY"] = "requied-only";
    YarnCacheMigrationMode["MATCH_SPEC"] = "match-spec";
    YarnCacheMigrationMode["ALWAYS"] = "always";
})(YarnCacheMigrationMode || (exports.YarnCacheMigrationMode = YarnCacheMigrationMode = {}));
/** https://yarnpkg.com/configuration/yarnrc#winLinkType */
var YarnWinLinkType;
(function (YarnWinLinkType) {
    YarnWinLinkType["JUNCTIONS"] = "junctions";
    YarnWinLinkType["SYMLINKS"] = "symlinks";
})(YarnWinLinkType || (exports.YarnWinLinkType = YarnWinLinkType = {}));
var YarnWorkerPoolMode;
(function (YarnWorkerPoolMode) {
    YarnWorkerPoolMode["ASYNC"] = "async";
    YarnWorkerPoolMode["WORKERS"] = "workers";
})(YarnWorkerPoolMode || (exports.YarnWorkerPoolMode = YarnWorkerPoolMode = {}));
class Yarnrc extends component_1.Component {
    constructor(project, version, options = {}) {
        super(project);
        this.validateOptionsForVersion(semver.major(version), options);
        this.updateGitAttributes();
        new yaml_1.YamlFile(project, ".yarnrc.yml", {
            obj: options,
        });
    }
    updateGitAttributes() {
        const { project } = this;
        project.gitattributes.addAttributes("/.yarn/**", "linguist-vendored");
        project.gitattributes.addAttributes("/.yarn/releases/*", "binary");
        project.gitattributes.addAttributes("/.yarn/plugins/**/*", "binary");
        project.gitattributes.addAttributes("/.pnp.*", "binary", "linguist-vendored");
    }
    validateOptionsForVersion(majorVersion, options) {
        const removedInV4 = [
            "ignoreCwd",
            "lockfileFilename",
            "pnpDataPath",
            "preferAggregateCacheInfo",
        ];
        const newInV4 = [
            "cacheMigrationMode",
            "httpsCaFilePath",
            "enableConstraintsCheck",
            "enableHardenedMode",
            "enableInlineHunks",
            "enableOfflineMode",
            "injectEnvironmentFiles",
            "winLinkType",
            "preferReuse",
            "taskPoolConcurrency",
            "workerPoolMode",
            "tsEnableAutoTypes",
        ];
        if (majorVersion >= 4) {
            const invalidOptions = Object.keys(options).filter((option) => removedInV4.includes(option));
            if (invalidOptions.length > 0) {
                throw new Error(`The following options are not available in Yarn >= 4: ${invalidOptions.join(", ")}`);
            }
        }
        else {
            const invalidOptions = Object.keys(options).filter((option) => newInV4.includes(option));
            if (invalidOptions.length > 0) {
                throw new Error(`The following options are only available in Yarn v4 and newer: ${invalidOptions.join(", ")}`);
            }
            if (options.checksumBehavior &&
                options.checksumBehavior === YarnChecksumBehavior.RESET) {
                throw new Error("The YarnChecksumBehavior.RESET is only available in Yarn v4 and newer.");
            }
        }
    }
}
exports.Yarnrc = Yarnrc;
_a = JSII_RTTI_SYMBOL_1;
Yarnrc[_a] = { fqn: "projen.javascript.Yarnrc", version: "0.91.13" };
//# sourceMappingURL=data:application/json;base64,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