"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ICON = void 0;
exports.debug = debug;
exports.verbose = verbose;
exports.info = info;
exports.error = error;
exports.warn = warn;
exports.empty = empty;
exports.disable = disable;
exports.isEnabled = isEnabled;
const chalk = require("chalk");
const common_1 = require("./common");
exports.ICON = "👾"; //'✨';
// disable logs if running inside a test
let enabled = common_1.IS_TEST_RUN ? false : true;
function log(isError, color, ...text) {
    // errors are always emitted, even if logs are disabled
    if (!enabled && !isError) {
        return;
    }
    console.error(`${exports.ICON} ${color(...text)}`);
}
function debug(...text) {
    if (process.env.DEBUG) {
        log(false, chalk.gray, ...text);
    }
}
function verbose(...text) {
    log(false, chalk.white, ...text);
}
function info(...text) {
    log(false, chalk.cyan, ...text);
}
function error(...text) {
    log(true, chalk.red, ...text);
}
function warn(...text) {
    log(false, chalk.yellow, ...text);
}
function empty(count = 1) {
    console.log("\n".repeat(count - 1));
}
function disable() {
    enabled = false;
}
function isEnabled() {
    return enabled;
}
//# sourceMappingURL=data:application/json;base64,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