"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequirementsFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const dependencies_1 = require("../dependencies");
const file_1 = require("../file");
const semver_1 = require("../util/semver");
/**
 * Specifies a list of packages to be installed using pip.
 *
 * @see https://pip.pypa.io/en/stable/reference/pip_install/#requirements-file-format
 */
class RequirementsFile extends file_1.FileBase {
    constructor(project, filePath, options) {
        super(project, filePath);
        this.packages = new Array();
        this.packageProvider = options.packageProvider;
    }
    /**
     * Adds the specified packages provided in semver format.
     *
     * Comment lines (start with `#`) are ignored.
     *
     * @param packages Package version in format `<module>@<semver>`
     */
    addPackages(...packages) {
        for (let pkg of packages) {
            if (pkg.startsWith("#")) {
                this.packages.push(pkg);
            }
            else {
                const { name, version } = dependencies_1.Dependencies.parseDependency(pkg);
                if (version) {
                    this.packages.push(`${name}${(0, semver_1.toPythonVersionRange)(version)}`);
                }
                else {
                    this.packages.push(name);
                }
            }
        }
    }
    formatDependency(dep) {
        if (dep.version) {
            return `${dep.name}${(0, semver_1.toPythonVersionRange)(dep.version)}`;
        }
        else {
            return dep.name;
        }
    }
    synthesizeContent(resolver) {
        const allPackages = [...this.packages];
        if (this.packageProvider) {
            allPackages.push(...this.packageProvider.packages.map((dep) => this.formatDependency(dep)));
        }
        return `${resolver
            .resolve([...(this.marker ? [`# ${this.marker}`] : []), ...allPackages])
            .join("\n")}\n`;
    }
}
exports.RequirementsFile = RequirementsFile;
_a = JSII_RTTI_SYMBOL_1;
RequirementsFile[_a] = { fqn: "projen.python.RequirementsFile", version: "0.91.13" };
//# sourceMappingURL=data:application/json;base64,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