"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("../file");
/**
 * Python packaging script where package metadata can be placed.
 */
class SetupPy extends file_1.FileBase {
    constructor(project, options) {
        super(project, "setup.py");
        this.setupConfig = {
            name: project.name,
            packages: options.packages,
            python_requires: ">=3.8",
            classifiers: [
                "Intended Audience :: Developers",
                "Programming Language :: Python :: 3 :: Only",
                "Programming Language :: Python :: 3.8",
                "Programming Language :: Python :: 3.9",
                "Programming Language :: Python :: 3.10",
                "Programming Language :: Python :: 3.11",
                "Programming Language :: Python :: 3.12",
            ],
            ...(options ? this.renameFields(options) : []),
        };
    }
    synthesizeContent(resolver) {
        const lines = [
            ...(this.marker ? [`# ${this.marker}`] : []),
            "",
            "import json",
            "from setuptools import setup",
            "",
            "kwargs = json.loads(",
            '    """',
            JSON.stringify(this.setupConfig, null, 4),
            '"""',
            ")",
            "",
            "setup(**kwargs)",
        ];
        return `${resolver.resolve(lines).join("\n")}\n`;
    }
    // modify some key names since JSII interfaces require fields to be camelCase
    renameFields(options) {
        const obj = {};
        for (const [key, value] of Object.entries(options)) {
            switch (key) {
                case "authorName":
                    obj.author = value;
                    break;
                case "authorEmail":
                    obj.author_email = value;
                    break;
                case "homepage":
                    obj.url = value;
                    break;
                case "additionalOptions":
                    Object.assign(obj, this.renameFields(value));
                    break;
                default:
                    obj[key] = value;
            }
        }
        return obj;
    }
}
exports.SetupPy = SetupPy;
_a = JSII_RTTI_SYMBOL_1;
SetupPy[_a] = { fqn: "projen.python.SetupPy", version: "0.91.13" };
//# sourceMappingURL=data:application/json;base64,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