"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filteredRunsOnOptions = filteredRunsOnOptions;
exports.filteredWorkflowRunsOnOptions = filteredWorkflowRunsOnOptions;
function filteredRunsOnOptions(runsOn, runsOnGroup) {
    verifyJobConstraints(runsOn, runsOnGroup);
    return runsOnGroup
        ? { runsOnGroup: runsOnGroup }
        : runsOn
            ? { runsOn: runsOn }
            : { runsOn: ["ubuntu-latest"] };
}
function filteredWorkflowRunsOnOptions(workflowRunsOn, workflowRunsOnGroup) {
    verifyJobConstraints(workflowRunsOn, workflowRunsOnGroup);
    return workflowRunsOnGroup
        ? { workflowRunsOnGroup: workflowRunsOnGroup }
        : workflowRunsOn
            ? { workflowRunsOn: workflowRunsOn }
            : { workflowRunsOn: ["ubuntu-latest"] };
}
function verifyJobConstraints(runsOn, runsOnGroup) {
    if (runsOn && runsOnGroup) {
        throw new Error("Cannot specify both `workflowRunsOn` and `runsOn`");
    }
}
//# sourceMappingURL=data:application/json;base64,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