"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const render_options_1 = require("../javascript/render-options");
const projenrc_1 = require("../projenrc");
const DEFAULT_FILENAME = ".projenrc.ts";
/**
 * Sets up a typescript project to use TypeScript for projenrc.
 */
class Projenrc extends projenrc_1.ProjenrcFile {
    constructor(project, options = {}) {
        super(project);
        this._tsProject = project;
        this.filePath = options.filename ?? DEFAULT_FILENAME;
        this._projenCodeDir = options.projenCodeDir ?? "projenrc";
        this._swc = options.swc ?? false;
        this.addDefaultTask();
        this.generateProjenrc();
    }
    addDefaultTask() {
        const deps = ["ts-node"];
        if (this._swc) {
            deps.push("@swc/core");
        }
        // this is the task projen executes when running `projen` without a
        // specific task (if this task is not defined, projen falls back to
        // running "node .projenrc.js").
        this._tsProject.addDevDeps(...deps);
        const tsNode = this._swc ? "ts-node --swc" : "ts-node";
        // we use "tsconfig.dev.json" here to allow projen source files to reside
        // anywhere in the project tree.
        this._tsProject.defaultTask?.exec(`${tsNode} --project ${this._tsProject.tsconfigDev.fileName} ${this.filePath}`);
    }
    preSynthesize() {
        super.preSynthesize();
        this._tsProject.addPackageIgnore(`/${this.filePath}`);
        this._tsProject.addPackageIgnore(`/${this._projenCodeDir}`);
        this._tsProject.tsconfigDev.addInclude(this.filePath);
        this._tsProject.tsconfigDev.addInclude(`${this._projenCodeDir}/**/*.ts`);
        this._tsProject.eslint?.addLintPattern(this._projenCodeDir);
        this._tsProject.eslint?.addLintPattern(this.filePath);
        this._tsProject.eslint?.allowDevDeps(this.filePath);
        this._tsProject.eslint?.allowDevDeps(`${this._projenCodeDir}/**/*.ts`);
        this._tsProject.eslint?.addIgnorePattern(`!${this.filePath}`);
        this._tsProject.eslint?.addIgnorePattern(`!${this._projenCodeDir}/**/*.ts`);
        this._tsProject.eslint?.addOverride({
            files: [this.filePath],
            rules: {
                "@typescript-eslint/no-require-imports": "off",
                "import/no-extraneous-dependencies": "off",
            },
        });
        this._tsProject.jest?.discoverTestMatchPatternsForDirs([this._projenCodeDir], {
            fileExtensionPattern: this._tsProject.tsconfig?.compilerOptions?.allowJs
                ? undefined
                : "ts?(x)",
        });
    }
    generateProjenrc() {
        const rcfile = (0, path_1.resolve)(this.project.outdir, this.filePath);
        if ((0, fs_1.existsSync)(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split(".");
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join(".");
        const { renderedOptions, imports } = (0, render_options_1.renderJavaScriptOptions)({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        imports.add(moduleName, importName);
        const lines = new Array();
        lines.push(...imports.asEsmImports());
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push("project.synth();");
        (0, fs_1.mkdirSync)((0, path_1.dirname)(rcfile), { recursive: true });
        (0, fs_1.writeFileSync)(rcfile, lines.join("\n"));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.typescript.Projenrc", version: "0.91.13" };
//# sourceMappingURL=data:application/json;base64,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