"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypedocDocgen = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
  Adds a simple Typescript documentation generator
 */
class TypedocDocgen {
    constructor(project) {
        project.addDevDeps("typedoc");
        const docgen = project.addTask("docgen", {
            description: `Generate TypeScript API reference ${project.docsDirectory}`,
            exec: `typedoc ${project.srcdir} --disableSources --out ${project.docsDirectory}`,
        });
        // spawn after a successful compile
        project.postCompileTask.spawn(docgen);
    }
}
exports.TypedocDocgen = TypedocDocgen;
_a = JSII_RTTI_SYMBOL_1;
TypedocDocgen[_a] = { fqn: "projen.typescript.TypedocDocgen", version: "0.91.13" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXNjcmlwdC10eXBlZG9jLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3R5cGVzY3JpcHQvdHlwZXNjcmlwdC10eXBlZG9jLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBRUE7O0dBRUc7QUFDSCxNQUFhLGFBQWE7SUFDeEIsWUFBWSxPQUEwQjtRQUNwQyxPQUFPLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBRTlCLE1BQU0sTUFBTSxHQUFHLE9BQU8sQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFO1lBQ3ZDLFdBQVcsRUFBRSxxQ0FBcUMsT0FBTyxDQUFDLGFBQWEsRUFBRTtZQUN6RSxJQUFJLEVBQUUsV0FBVyxPQUFPLENBQUMsTUFBTSwyQkFBMkIsT0FBTyxDQUFDLGFBQWEsRUFBRTtTQUNsRixDQUFDLENBQUM7UUFFSCxtQ0FBbUM7UUFDbkMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDeEMsQ0FBQzs7QUFYSCxzQ0FZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFR5cGVTY3JpcHRQcm9qZWN0IH0gZnJvbSBcIi4uL3R5cGVzY3JpcHRcIjtcblxuLyoqXG4gIEFkZHMgYSBzaW1wbGUgVHlwZXNjcmlwdCBkb2N1bWVudGF0aW9uIGdlbmVyYXRvclxuICovXG5leHBvcnQgY2xhc3MgVHlwZWRvY0RvY2dlbiB7XG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IFR5cGVTY3JpcHRQcm9qZWN0KSB7XG4gICAgcHJvamVjdC5hZGREZXZEZXBzKFwidHlwZWRvY1wiKTtcblxuICAgIGNvbnN0IGRvY2dlbiA9IHByb2plY3QuYWRkVGFzayhcImRvY2dlblwiLCB7XG4gICAgICBkZXNjcmlwdGlvbjogYEdlbmVyYXRlIFR5cGVTY3JpcHQgQVBJIHJlZmVyZW5jZSAke3Byb2plY3QuZG9jc0RpcmVjdG9yeX1gLFxuICAgICAgZXhlYzogYHR5cGVkb2MgJHtwcm9qZWN0LnNyY2Rpcn0gLS1kaXNhYmxlU291cmNlcyAtLW91dCAke3Byb2plY3QuZG9jc0RpcmVjdG9yeX1gLFxuICAgIH0pO1xuXG4gICAgLy8gc3Bhd24gYWZ0ZXIgYSBzdWNjZXNzZnVsIGNvbXBpbGVcbiAgICBwcm9qZWN0LnBvc3RDb21waWxlVGFzay5zcGF3bihkb2NnZW4pO1xuICB9XG59XG4iXX0=