"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeScriptLibraryProject = exports.TypeScriptAppProject = exports.TypeScriptProject = exports.TsJestTsconfig = exports.TsJestDiagnostics = exports.TsJestBabelConfig = void 0;
exports.mergeTsconfigOptions = mergeTsconfigOptions;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const semver = require("semver");
const common_1 = require("../common");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const javascript_1 = require("../javascript");
const util_1 = require("../javascript/util");
const sample_file_1 = require("../sample-file");
const textfile_1 = require("../textfile");
const typescript_1 = require("../typescript");
const util_2 = require("../util");
/**
 * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/babelConfig/
 */
class TsJestBabelConfig {
    /**
     * Disables the use of Babel
     */
    static disabled() {
        return new TsJestBabelConfig(false);
    }
    /**
     * Enables Babel processing
     *
     * `ts-jest` will try to find an existing Babel configuration and pass it to the `babel-jest` processor.
     */
    static autoDetectConfig() {
        return new TsJestBabelConfig(true);
    }
    /**
     * Path to a babelrc file
     *
     * The path should be relative to the current working directory where you start Jest from. You can also use `<rootDir>` in the path.
     */
    static fromFile(filePath) {
        return new TsJestBabelConfig(filePath);
    }
    /**
     * Inline compiler options
     * @see https://babeljs.io/docs/options
     */
    static custom(config) {
        return new TsJestBabelConfig(config);
    }
    constructor(config) {
        this.config = config;
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        return this.config;
    }
}
exports.TsJestBabelConfig = TsJestBabelConfig;
_a = JSII_RTTI_SYMBOL_1;
TsJestBabelConfig[_a] = { fqn: "projen.typescript.TsJestBabelConfig", version: "0.91.13" };
/**
 * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/diagnostics/
 */
class TsJestDiagnostics {
    /**
     * Enable all diagnostics.
     */
    static all() {
        return new TsJestDiagnostics(true);
    }
    /**
     * Disable all diagnostics.
     */
    static none() {
        return new TsJestDiagnostics(false);
    }
    /**
     * Provide a custom diagnostics configuration.
     *
     * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/diagnostics/
     */
    static custom(config) {
        return new TsJestDiagnostics(config);
    }
    constructor(config) {
        this.config = config;
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        return this.config;
    }
}
exports.TsJestDiagnostics = TsJestDiagnostics;
_b = JSII_RTTI_SYMBOL_1;
TsJestDiagnostics[_b] = { fqn: "projen.typescript.TsJestDiagnostics", version: "0.91.13" };
/**
 * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/tsconfig/
 */
class TsJestTsconfig {
    /**
     * Uses `tsconfig.json` if found, or the built-in default TypeScript compiler options.
     */
    static auto() {
        return new TsJestTsconfig(true);
    }
    /**
     * Force` ts-jest` to use its built-in defaults even if there is a `tsconfig.json` in your project.
     */
    static builtInDefaults() {
        return new TsJestTsconfig(false);
    }
    /**
     * Path to a `tsconfig` file
     *
     * The path should be relative to the current working directory where you start Jest from. You can also use `<rootDir>` in the path to start from the project root dir.
     */
    static fromFile(filePath) {
        return new TsJestTsconfig(filePath);
    }
    /**
     * Inline compiler options
     *
     * @see TypescriptConfigOptions
     */
    static custom(config) {
        return new TsJestTsconfig(config);
    }
    constructor(config) {
        this.config = config;
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        return this.config;
    }
}
exports.TsJestTsconfig = TsJestTsconfig;
_c = JSII_RTTI_SYMBOL_1;
TsJestTsconfig[_c] = { fqn: "projen.typescript.TsJestTsconfig", version: "0.91.13" };
/**
 * TypeScript project
 * @pjid typescript
 */
class TypeScriptProject extends javascript_1.NodeProject {
    constructor(options) {
        super({
            ...options,
            // disable .projenrc.js if typescript is enabled
            projenrcJs: options.projenrcTs ? false : options.projenrcJs,
            jestOptions: {
                ...options.jestOptions,
                jestConfig: {
                    ...options.jestOptions?.jestConfig,
                    testMatch: options.jestOptions?.jestConfig?.testMatch ?? [],
                },
            },
        });
        this.srcdir = options.srcdir ?? "src";
        this.libdir = options.libdir ?? "lib";
        this.docgen = options.docgen;
        this.docsDirectory = options.docsDirectory ?? "docs/";
        const tsconfigFilename = options.tsconfig?.fileName;
        this.compileTask.exec(["tsc", "--build", tsconfigFilename].filter(Boolean).join(" "));
        this.watchTask = this.addTask("watch", {
            description: "Watch & compile in the background",
            exec: ["tsc", "--build", "-w", tsconfigFilename]
                .filter(Boolean)
                .join(" "),
        });
        this.testdir = options.testdir ?? "test";
        this.gitignore.include(`/${this.testdir}/`);
        this.npmignore?.exclude(`/${this.testdir}/`);
        // if the test directory is under `src/`, then we will run our tests against
        // the javascript files and not let jest compile it for us.
        const compiledTests = this.testdir.startsWith(this.srcdir + path.posix.sep);
        if (options.entrypointTypes || this.entrypoint !== "") {
            const entrypointPath = path.join(path.dirname(this.entrypoint), path.basename(this.entrypoint, ".js"));
            const normalizedPath = (0, util_2.normalizePersistedPath)(entrypointPath);
            const entrypointTypes = options.entrypointTypes ?? `${normalizedPath}.d.ts`;
            this.package.addField("types", entrypointTypes);
        }
        if (options.disableTsconfigDev && options.disableTsconfig) {
            throw new Error("Cannot specify both 'disableTsconfigDev' and 'disableTsconfig' fields.");
        }
        if (!options.disableTsconfig) {
            this.tsconfig = new javascript_1.TypescriptConfig(this, mergeTsconfigOptions({
                include: [`${this.srcdir}/**/*.ts`],
                // exclude: ['node_modules'], // TODO: shouldn't we exclude node_modules?
                compilerOptions: {
                    rootDir: this.srcdir,
                    outDir: this.libdir,
                    ...this.defaultTypeScriptCompilerOptions(),
                },
            }, options.tsconfig));
        }
        if (options.disableTsconfigDev) {
            this.tsconfigDev = this.tsconfig;
        }
        else {
            const tsconfigDevFile = options.tsconfigDevFile ?? "tsconfig.dev.json";
            this.tsconfigDev = new javascript_1.TypescriptConfig(this, mergeTsconfigOptions({
                fileName: tsconfigDevFile,
                include: [`${this.srcdir}/**/*.ts`, `${this.testdir}/**/*.ts`],
                exclude: ["node_modules"],
                compilerOptions: this.defaultTypeScriptCompilerOptions(),
            }, options.tsconfig, options.tsconfigDev));
        }
        this.gitignore.include(`/${this.srcdir}/`);
        this.npmignore?.exclude(`/${this.srcdir}/`);
        if (this.srcdir !== this.libdir) {
            // separated, can ignore the entire libdir
            this.gitignore.exclude(`/${this.libdir}`);
        }
        else {
            // collocated, can only ignore the compiled output
            this.gitignore.exclude(`/${this.libdir}/**/*.js`);
            this.gitignore.exclude(`/${this.libdir}/**/*.d.ts`);
            this.gitignore.exclude(`/${this.libdir}/**/*.d.ts.map`);
        }
        this.npmignore?.include(`/${this.libdir}/`);
        this.npmignore?.include(`/${this.libdir}/**/*.js`);
        this.npmignore?.include(`/${this.libdir}/**/*.d.ts`);
        this.gitignore.exclude("/dist/");
        this.npmignore?.exclude("dist"); // jsii-pacmak expects this to be "dist" and not "/dist". otherwise it will tamper with it
        this.npmignore?.exclude("/tsconfig.json");
        this.npmignore?.exclude("/.github/");
        this.npmignore?.exclude("/.vscode/");
        this.npmignore?.exclude("/.idea/");
        this.npmignore?.exclude("/.projenrc.js");
        this.npmignore?.exclude("tsconfig.tsbuildinfo");
        if (this.jest) {
            if (compiledTests) {
                this.addJestCompiled(this.jest);
            }
            else {
                this.addJestNoCompile(this.jest, options?.tsJestOptions);
            }
        }
        if (options.eslint ?? true) {
            this.eslint = new javascript_1.Eslint(this, {
                tsconfigPath: `./${this.tsconfigDev.fileName}`,
                dirs: [this.srcdir],
                devdirs: [this.testdir, "build-tools"],
                fileExtensions: [".ts", ".tsx"],
                lintProjenRc: false,
                ...options.eslintOptions,
            });
            this.tsconfigEslint = this.tsconfigDev;
        }
        // when this is a root project
        if (!this.parent) {
            if (options.projenrcTs) {
                new typescript_1.Projenrc(this, options.projenrcTsOptions);
            }
            else {
                // projenrc.js created in NodeProject needs to be added in tsconfigDev
                const projenrcJs = javascript_1.Projenrc.of(this);
                if (projenrcJs) {
                    this.tsconfigDev.addInclude(projenrcJs.filePath);
                }
            }
        }
        const tsDep = options.typescriptVersion
            ? `typescript@${options.typescriptVersion}`
            : "typescript";
        this.addDevDeps(tsDep);
        this.addNodeTypesVersion(options.typescriptVersion, options.minNodeVersion);
        // generate sample code in `src` and `lib` if these directories are empty or non-existent.
        if (options.sampleCode ?? true) {
            new SampleCode(this);
        }
        if (this.docgen) {
            new typescript_1.TypedocDocgen(this);
        }
    }
    /**
     * Projen default Typescript compiler options.
     */
    defaultTypeScriptCompilerOptions() {
        return {
            alwaysStrict: true,
            declaration: true,
            esModuleInterop: true,
            experimentalDecorators: true,
            inlineSourceMap: true,
            inlineSources: true,
            lib: ["es2019"],
            module: "CommonJS",
            noEmitOnError: false,
            noFallthroughCasesInSwitch: true,
            noImplicitAny: true,
            noImplicitReturns: true,
            noImplicitThis: true,
            noUnusedLocals: true,
            noUnusedParameters: true,
            resolveJsonModule: true,
            strict: true,
            strictNullChecks: true,
            strictPropertyInitialization: true,
            stripInternal: true,
            target: "ES2019",
        };
    }
    /**
     * Add `@types/node` to this project.
     *
     * If the user has already added this dependency, do nothing.
     * Otherwise use the major version of `minNodeVersion`.
     * If that's not available, match the version to the used typescript version.
     * And if that is also not available, we use latest and let the user manage the version.
     */
    addNodeTypesVersion(tsVersion, minNodeVersion) {
        const name = "@types/node";
        if (this.deps.tryGetDependency(name, dependencies_1.DependencyType.BUILD)) {
            return;
        }
        if (minNodeVersion) {
            const minNodeParsed = semver.minVersion(minNodeVersion);
            if (minNodeParsed) {
                return this.addDevDeps(`${name}@^${minNodeParsed.major}`);
            }
        }
        // coerce version, since the ts version likely something like ~5.3.0
        const tsParsed = semver.coerce(tsVersion);
        if (tsParsed) {
            return this.addDevDeps(`${name}@ts${tsParsed.major}.${tsParsed.minor}`);
        }
        this.addDevDeps(name);
    }
    /**
     * Tests are compiled to `lib/TESTDIR`, so we don't need jest to compile them
     * for us. just run them directly from javascript.
     */
    addJestCompiled(jest) {
        this.addDevDeps(`@types/jest${jest.jestVersion}`);
        const testout = path.posix.relative(this.srcdir, this.testdir);
        const libtest = path.posix.join(this.libdir, testout);
        const srctest = this.testdir;
        this.npmignore?.exclude(`/${libtest}/`);
        jest.discoverTestMatchPatternsForDirs([libtest], {
            fileExtensionPattern: this.tsconfig?.compilerOptions?.allowJs
                ? undefined
                : "js?(x)",
        });
        jest.addWatchIgnorePattern(`/${this.srcdir}/`);
        const resolveSnapshotPath = (test, ext) => {
            const fullpath = test.replace(libtest, srctest);
            return path.join(path.dirname(fullpath), "__snapshots__", path.basename(fullpath, ".js") + ".ts" + ext);
        };
        const resolveTestPath = (snap, ext) => {
            const filename = path.basename(snap, ".ts" + ext) + ".js";
            const dir = path.dirname(path.dirname(snap)).replace(srctest, libtest);
            return path.join(dir, filename);
        };
        const resolver = new textfile_1.TextFile(this, path.posix.join(common_1.PROJEN_DIR, "jest-snapshot-resolver.js"));
        if (!resolver.marker) {
            resolver.addLine(`// ${resolver.marker}`);
        }
        resolver.addLine('const path = require("path");');
        resolver.addLine(`const libtest = "${libtest}";`);
        resolver.addLine(`const srctest= "${srctest}";`);
        resolver.addLine("module.exports = {");
        resolver.addLine(`  resolveSnapshotPath: ${resolveSnapshotPath.toString()},`);
        resolver.addLine(`  resolveTestPath: ${resolveTestPath.toString()},`);
        resolver.addLine("  testPathForConsistencyCheck: path.join('some', '__tests__', 'example.test.js')");
        resolver.addLine("};");
        jest.addSnapshotResolver(`./${resolver.path}`);
    }
    addJestNoCompile(jest, tsJestOptions) {
        this.addDevDeps(`@types/jest${jest.jestVersion}`, `ts-jest${jest.jestVersion}`);
        jest.discoverTestMatchPatternsForDirs([this.srcdir, this.testdir], {
            fileExtensionPattern: this.tsconfig?.compilerOptions?.allowJs
                ? undefined
                : "ts?(x)",
        });
        // Test for the ts-jest version that was requested;
        //
        // - First, check the `jest` version that is requested via projen properties. This
        //   should be the same as the `ts-jest` version anyway.
        // - If none found, fall back to inspecting the actual `ts-jest` version
        //   that happens to be installed.
        let hasTsJest29;
        if (jest.jestVersion) {
            // We could maybe replace this will full "actual version" checking, but
            // the tests depend on this and the reading of 'package.json' is very
            // awkward to test.
            // Note that we use the requested version of `jest` as a proxy for the
            // version of `ts-jest`, which is what we're actually interested in.
            const major = semver.coerce(jest.jestVersion)?.major;
            hasTsJest29 = major ? major >= 29 : undefined;
        }
        if (hasTsJest29 === undefined) {
            hasTsJest29 = (0, util_1.hasDependencyVersion)(this, "ts-jest", ">= 29");
        }
        // add relevant deps (we treat "unknown" as having a modern ts-jest)
        if (hasTsJest29 !== false) {
            return this.addJestNoCompileModern(jest, tsJestOptions);
        }
        this.addJestNoCompileLegacy(jest, tsJestOptions);
    }
    addJestNoCompileModern(jest, tsJestOptions) {
        jest.config.transform = (0, util_2.deepMerge)([
            {
                [tsJestOptions?.transformPattern ??
                    TypeScriptProject.DEFAULT_TS_JEST_TRANFORM_PATTERN]: new javascript_1.Transform("ts-jest", {
                    tsconfig: TsJestTsconfig.fromFile(this.tsconfigDev.fileName),
                    ...(tsJestOptions?.transformOptions ?? {}),
                }),
            },
            jest.config.transform,
        ]);
    }
    addJestNoCompileLegacy(jest, tsJestOptions) {
        if (tsJestOptions) {
            this.logger.warn("You are using a legacy version (<29) of jest and ts-jest that does not support tsJestOptions, they will be ignored.");
        }
        if (!jest.config.preset) {
            jest.config.preset = "ts-jest";
        }
        jest.config.globals = (0, util_2.deepMerge)([
            {
                "ts-jest": {
                    tsconfig: this.tsconfigDev.fileName,
                },
            },
            jest.config.globals,
        ]);
    }
}
exports.TypeScriptProject = TypeScriptProject;
_d = JSII_RTTI_SYMBOL_1;
TypeScriptProject[_d] = { fqn: "projen.typescript.TypeScriptProject", version: "0.91.13" };
TypeScriptProject.DEFAULT_TS_JEST_TRANFORM_PATTERN = "^.+\\.[t]sx?$";
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        const srcCode = [
            "export class Hello {",
            "  public sayHello() {",
            "    return 'hello, world!';",
            "  }",
            "}",
        ].join("\n");
        const testCode = [
            "import { Hello } from '../src';",
            "",
            "test('hello', () => {",
            "  expect(new Hello().sayHello()).toBe('hello, world!');",
            "});",
        ].join("\n");
        new sample_file_1.SampleDir(project, project.srcdir, {
            files: {
                "index.ts": srcCode,
            },
        });
        if (project.jest) {
            new sample_file_1.SampleDir(project, project.testdir, {
                files: {
                    "hello.test.ts": testCode,
                },
            });
        }
    }
}
/**
 * TypeScript app.
 *
 * @pjid typescript-app
 */
class TypeScriptAppProject extends TypeScriptProject {
    constructor(options) {
        // Releasing and packaging are coupled. If one is disabled, disable the other by default.
        const shouldRelease = options.release ?? options.releaseWorkflow ?? false;
        super({
            release: shouldRelease,
            package: shouldRelease,
            allowLibraryDependencies: false,
            entrypoint: "", // "main" is not needed in typescript apps
            ...options,
        });
    }
}
exports.TypeScriptAppProject = TypeScriptAppProject;
_e = JSII_RTTI_SYMBOL_1;
TypeScriptAppProject[_e] = { fqn: "projen.typescript.TypeScriptAppProject", version: "0.91.13" };
/**
 * @deprecated use `TypeScriptProject`
 */
class TypeScriptLibraryProject extends TypeScriptProject {
}
exports.TypeScriptLibraryProject = TypeScriptLibraryProject;
_f = JSII_RTTI_SYMBOL_1;
TypeScriptLibraryProject[_f] = { fqn: "projen.typescript.TypeScriptLibraryProject", version: "0.91.13" };
/**
 * @internal
 */
function mergeTsconfigOptions(...options) {
    const definedOptions = options.filter(Boolean);
    return definedOptions.reduce((previous, current) => ({
        ...previous,
        ...current,
        include: [...(previous.include ?? []), ...(current.include ?? [])],
        exclude: [...(previous.exclude ?? []), ...(current.exclude ?? [])],
        compilerOptions: {
            ...previous.compilerOptions,
            ...current.compilerOptions,
        },
    }), { compilerOptions: {} });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXNjcmlwdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy90eXBlc2NyaXB0L3R5cGVzY3JpcHQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQWkxQkEsb0RBaUJDOztBQWwyQkQsNkJBQTZCO0FBQzdCLGlDQUFpQztBQUNqQyxzQ0FBdUM7QUFDdkMsNENBQXlDO0FBQ3pDLGtEQUFpRDtBQUNqRCw4Q0FXdUI7QUFDdkIsNkNBQTBEO0FBQzFELGdEQUEyQztBQUUzQywwQ0FBdUM7QUFDdkMsOENBSXVCO0FBQ3ZCLGtDQUE0RDtBQUU1RDs7R0FFRztBQUNILE1BQWEsaUJBQWlCO0lBQzVCOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFFBQVE7UUFDcEIsT0FBTyxJQUFJLGlCQUFpQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLGdCQUFnQjtRQUM1QixPQUFPLElBQUksaUJBQWlCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7O09BSUc7SUFDSSxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQWdCO1FBQ3JDLE9BQU8sSUFBSSxpQkFBaUIsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7OztPQUdHO0lBQ0ksTUFBTSxDQUFDLE1BQU0sQ0FBQyxNQUEyQjtRQUM5QyxPQUFPLElBQUksaUJBQWlCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVELFlBQ21CLE1BQThDO1FBQTlDLFdBQU0sR0FBTixNQUFNLENBQXdDO0lBQzlELENBQUM7SUFFSjs7O09BR0c7SUFDSSxNQUFNO1FBQ1gsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3JCLENBQUM7O0FBNUNILDhDQTZDQzs7O0FBRUQ7O0dBRUc7QUFDSCxNQUFhLGlCQUFpQjtJQUM1Qjs7T0FFRztJQUNJLE1BQU0sQ0FBQyxHQUFHO1FBQ2YsT0FBTyxJQUFJLGlCQUFpQixDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxJQUFJO1FBQ2hCLE9BQU8sSUFBSSxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyxNQUFNLENBQUMsTUFBMkI7UUFDOUMsT0FBTyxJQUFJLGlCQUFpQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRCxZQUFxQyxNQUFxQztRQUFyQyxXQUFNLEdBQU4sTUFBTSxDQUErQjtJQUFHLENBQUM7SUFFOUU7OztPQUdHO0lBQ0ksTUFBTTtRQUNYLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUNyQixDQUFDOztBQWhDSCw4Q0FpQ0M7OztBQUVEOztHQUVHO0FBQ0gsTUFBYSxjQUFjO0lBQ3pCOztPQUVHO0lBQ0ksTUFBTSxDQUFDLElBQUk7UUFDaEIsT0FBTyxJQUFJLGNBQWMsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsZUFBZTtRQUMzQixPQUFPLElBQUksY0FBYyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLFFBQVEsQ0FBQyxRQUFnQjtRQUNyQyxPQUFPLElBQUksY0FBYyxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLE1BQU0sQ0FBQyxNQUErQjtRQUNsRCxPQUFPLElBQUksY0FBYyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFRCxZQUNtQixNQUFrRDtRQUFsRCxXQUFNLEdBQU4sTUFBTSxDQUE0QztJQUNsRSxDQUFDO0lBRUo7OztPQUdHO0lBQ0ksTUFBTTtRQUNYLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUNyQixDQUFDOztBQTNDSCx3Q0E0Q0M7OztBQTBNRDs7O0dBR0c7QUFDSCxNQUFhLGlCQUFrQixTQUFRLHdCQUFXO0lBa0NoRCxZQUFZLE9BQWlDO1FBQzNDLEtBQUssQ0FBQztZQUNKLEdBQUcsT0FBTztZQUVWLGdEQUFnRDtZQUNoRCxVQUFVLEVBQUUsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsVUFBVTtZQUUzRCxXQUFXLEVBQUU7Z0JBQ1gsR0FBRyxPQUFPLENBQUMsV0FBVztnQkFDdEIsVUFBVSxFQUFFO29CQUNWLEdBQUcsT0FBTyxDQUFDLFdBQVcsRUFBRSxVQUFVO29CQUNsQyxTQUFTLEVBQUUsT0FBTyxDQUFDLFdBQVcsRUFBRSxVQUFVLEVBQUUsU0FBUyxJQUFJLEVBQUU7aUJBQzVEO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsTUFBTSxHQUFHLE9BQU8sQ0FBQyxNQUFNLElBQUksS0FBSyxDQUFDO1FBQ3RDLElBQUksQ0FBQyxNQUFNLEdBQUcsT0FBTyxDQUFDLE1BQU0sSUFBSSxLQUFLLENBQUM7UUFFdEMsSUFBSSxDQUFDLE1BQU0sR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDO1FBQzdCLElBQUksQ0FBQyxhQUFhLEdBQUcsT0FBTyxDQUFDLGFBQWEsSUFBSSxPQUFPLENBQUM7UUFFdEQsTUFBTSxnQkFBZ0IsR0FBRyxPQUFPLENBQUMsUUFBUSxFQUFFLFFBQVEsQ0FBQztRQUNwRCxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FDbkIsQ0FBQyxLQUFLLEVBQUUsU0FBUyxFQUFFLGdCQUFnQixDQUFDLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FDL0QsQ0FBQztRQUVGLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUU7WUFDckMsV0FBVyxFQUFFLG1DQUFtQztZQUNoRCxJQUFJLEVBQUUsQ0FBQyxLQUFLLEVBQUUsU0FBUyxFQUFFLElBQUksRUFBRSxnQkFBZ0IsQ0FBQztpQkFDN0MsTUFBTSxDQUFDLE9BQU8sQ0FBQztpQkFDZixJQUFJLENBQUMsR0FBRyxDQUFDO1NBQ2IsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUMsT0FBTyxJQUFJLE1BQU0sQ0FBQztRQUN6QyxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxJQUFJLElBQUksQ0FBQyxPQUFPLEdBQUcsQ0FBQyxDQUFDO1FBQzVDLElBQUksQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLElBQUksSUFBSSxDQUFDLE9BQU8sR0FBRyxDQUFDLENBQUM7UUFFN0MsNEVBQTRFO1FBQzVFLDJEQUEyRDtRQUMzRCxNQUFNLGFBQWEsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFFNUUsSUFBSSxPQUFPLENBQUMsZUFBZSxJQUFJLElBQUksQ0FBQyxVQUFVLEtBQUssRUFBRSxFQUFFLENBQUM7WUFDdEQsTUFBTSxjQUFjLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FDOUIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLEVBQzdCLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsQ0FDdEMsQ0FBQztZQUNGLE1BQU0sY0FBYyxHQUFHLElBQUEsNkJBQXNCLEVBQUMsY0FBYyxDQUFDLENBQUM7WUFDOUQsTUFBTSxlQUFlLEdBQ25CLE9BQU8sQ0FBQyxlQUFlLElBQUksR0FBRyxjQUFjLE9BQU8sQ0FBQztZQUN0RCxJQUFJLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxPQUFPLEVBQUUsZUFBZSxDQUFDLENBQUM7UUFDbEQsQ0FBQztRQUVELElBQUksT0FBTyxDQUFDLGtCQUFrQixJQUFJLE9BQU8sQ0FBQyxlQUFlLEVBQUUsQ0FBQztZQUMxRCxNQUFNLElBQUksS0FBSyxDQUNiLHdFQUF3RSxDQUN6RSxDQUFDO1FBQ0osQ0FBQztRQUVELElBQUksQ0FBQyxPQUFPLENBQUMsZUFBZSxFQUFFLENBQUM7WUFDN0IsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLDZCQUFnQixDQUNsQyxJQUFJLEVBQ0osb0JBQW9CLENBQ2xCO2dCQUNFLE9BQU8sRUFBRSxDQUFDLEdBQUcsSUFBSSxDQUFDLE1BQU0sVUFBVSxDQUFDO2dCQUNuQyx5RUFBeUU7Z0JBQ3pFLGVBQWUsRUFBRTtvQkFDZixPQUFPLEVBQUUsSUFBSSxDQUFDLE1BQU07b0JBQ3BCLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtvQkFDbkIsR0FBRyxJQUFJLENBQUMsZ0NBQWdDLEVBQUU7aUJBQzNDO2FBQ0YsRUFDRCxPQUFPLENBQUMsUUFBUSxDQUNqQixDQUNGLENBQUM7UUFDSixDQUFDO1FBRUQsSUFBSSxPQUFPLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztZQUMvQixJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxRQUFTLENBQUM7UUFDcEMsQ0FBQzthQUFNLENBQUM7WUFDTixNQUFNLGVBQWUsR0FBRyxPQUFPLENBQUMsZUFBZSxJQUFJLG1CQUFtQixDQUFDO1lBQ3ZFLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSw2QkFBZ0IsQ0FDckMsSUFBSSxFQUNKLG9CQUFvQixDQUNsQjtnQkFDRSxRQUFRLEVBQUUsZUFBZTtnQkFDekIsT0FBTyxFQUFFLENBQUMsR0FBRyxJQUFJLENBQUMsTUFBTSxVQUFVLEVBQUUsR0FBRyxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUM7Z0JBRTlELE9BQU8sRUFBRSxDQUFDLGNBQWMsQ0FBQztnQkFDekIsZUFBZSxFQUFFLElBQUksQ0FBQyxnQ0FBZ0MsRUFBRTthQUN6RCxFQUNELE9BQU8sQ0FBQyxRQUFRLEVBQ2hCLE9BQU8sQ0FBQyxXQUFXLENBQ3BCLENBQ0YsQ0FBQztRQUNKLENBQUM7UUFFRCxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxJQUFJLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDO1FBQzNDLElBQUksQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLElBQUksSUFBSSxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUM7UUFFNUMsSUFBSSxJQUFJLENBQUMsTUFBTSxLQUFLLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQztZQUNoQywwQ0FBMEM7WUFDMUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FBQztRQUM1QyxDQUFDO2FBQU0sQ0FBQztZQUNOLGtEQUFrRDtZQUNsRCxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxJQUFJLElBQUksQ0FBQyxNQUFNLFVBQVUsQ0FBQyxDQUFDO1lBQ2xELElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLElBQUksSUFBSSxDQUFDLE1BQU0sWUFBWSxDQUFDLENBQUM7WUFDcEQsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsSUFBSSxJQUFJLENBQUMsTUFBTSxnQkFBZ0IsQ0FBQyxDQUFDO1FBQzFELENBQUM7UUFFRCxJQUFJLENBQUMsU0FBUyxFQUFFLE9BQU8sQ0FBQyxJQUFJLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDO1FBRTVDLElBQUksQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLElBQUksSUFBSSxDQUFDLE1BQU0sVUFBVSxDQUFDLENBQUM7UUFDbkQsSUFBSSxDQUFDLFNBQVMsRUFBRSxPQUFPLENBQUMsSUFBSSxJQUFJLENBQUMsTUFBTSxZQUFZLENBQUMsQ0FBQztRQUVyRCxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUNqQyxJQUFJLENBQUMsU0FBUyxFQUFFLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLDBGQUEwRjtRQUUzSCxJQUFJLENBQUMsU0FBUyxFQUFFLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBQzFDLElBQUksQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ25DLElBQUksQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ3pDLElBQUksQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFFaEQsSUFBSSxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDZCxJQUFJLGFBQWEsRUFBRSxDQUFDO2dCQUNsQixJQUFJLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUNsQyxDQUFDO2lCQUFNLENBQUM7Z0JBQ04sSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsT0FBTyxFQUFFLGFBQWEsQ0FBQyxDQUFDO1lBQzNELENBQUM7UUFDSCxDQUFDO1FBRUQsSUFBSSxPQUFPLENBQUMsTUFBTSxJQUFJLElBQUksRUFBRSxDQUFDO1lBQzNCLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxtQkFBTSxDQUFDLElBQUksRUFBRTtnQkFDN0IsWUFBWSxFQUFFLEtBQUssSUFBSSxDQUFDLFdBQVcsQ0FBQyxRQUFRLEVBQUU7Z0JBQzlDLElBQUksRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUM7Z0JBQ25CLE9BQU8sRUFBRSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsYUFBYSxDQUFDO2dCQUN0QyxjQUFjLEVBQUUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDO2dCQUMvQixZQUFZLEVBQUUsS0FBSztnQkFDbkIsR0FBRyxPQUFPLENBQUMsYUFBYTthQUN6QixDQUFDLENBQUM7WUFFSCxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUM7UUFDekMsQ0FBQztRQUVELDhCQUE4QjtRQUM5QixJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO1lBQ2pCLElBQUksT0FBTyxDQUFDLFVBQVUsRUFBRSxDQUFDO2dCQUN2QixJQUFJLHFCQUFVLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1lBQ2xELENBQUM7aUJBQU0sQ0FBQztnQkFDTixzRUFBc0U7Z0JBQ3RFLE1BQU0sVUFBVSxHQUFHLHFCQUFtQixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFDaEQsSUFBSSxVQUFVLEVBQUUsQ0FBQztvQkFDZixJQUFJLENBQUMsV0FBVyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUM7Z0JBQ25ELENBQUM7WUFDSCxDQUFDO1FBQ0gsQ0FBQztRQUVELE1BQU0sS0FBSyxHQUFHLE9BQU8sQ0FBQyxpQkFBaUI7WUFDckMsQ0FBQyxDQUFDLGNBQWMsT0FBTyxDQUFDLGlCQUFpQixFQUFFO1lBQzNDLENBQUMsQ0FBQyxZQUFZLENBQUM7UUFDakIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUV2QixJQUFJLENBQUMsbUJBQW1CLENBQUMsT0FBTyxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUU1RSwwRkFBMEY7UUFDMUYsSUFBSSxPQUFPLENBQUMsVUFBVSxJQUFJLElBQUksRUFBRSxDQUFDO1lBQy9CLElBQUksVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3ZCLENBQUM7UUFFRCxJQUFJLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQztZQUNoQixJQUFJLDBCQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDMUIsQ0FBQztJQUNILENBQUM7SUFFRDs7T0FFRztJQUNPLGdDQUFnQztRQUN4QyxPQUFPO1lBQ0wsWUFBWSxFQUFFLElBQUk7WUFDbEIsV0FBVyxFQUFFLElBQUk7WUFDakIsZUFBZSxFQUFFLElBQUk7WUFDckIsc0JBQXNCLEVBQUUsSUFBSTtZQUM1QixlQUFlLEVBQUUsSUFBSTtZQUNyQixhQUFhLEVBQUUsSUFBSTtZQUNuQixHQUFHLEVBQUUsQ0FBQyxRQUFRLENBQUM7WUFDZixNQUFNLEVBQUUsVUFBVTtZQUNsQixhQUFhLEVBQUUsS0FBSztZQUNwQiwwQkFBMEIsRUFBRSxJQUFJO1lBQ2hDLGFBQWEsRUFBRSxJQUFJO1lBQ25CLGlCQUFpQixFQUFFLElBQUk7WUFDdkIsY0FBYyxFQUFFLElBQUk7WUFDcEIsY0FBYyxFQUFFLElBQUk7WUFDcEIsa0JBQWtCLEVBQUUsSUFBSTtZQUN4QixpQkFBaUIsRUFBRSxJQUFJO1lBQ3ZCLE1BQU0sRUFBRSxJQUFJO1lBQ1osZ0JBQWdCLEVBQUUsSUFBSTtZQUN0Qiw0QkFBNEIsRUFBRSxJQUFJO1lBQ2xDLGFBQWEsRUFBRSxJQUFJO1lBQ25CLE1BQU0sRUFBRSxRQUFRO1NBQ2pCLENBQUM7SUFDSixDQUFDO0lBRUQ7Ozs7Ozs7T0FPRztJQUNLLG1CQUFtQixDQUFDLFNBQWtCLEVBQUUsY0FBdUI7UUFDckUsTUFBTSxJQUFJLEdBQUcsYUFBYSxDQUFDO1FBRTNCLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEVBQUUsNkJBQWMsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDO1lBQzNELE9BQU87UUFDVCxDQUFDO1FBRUQsSUFBSSxjQUFjLEVBQUUsQ0FBQztZQUNuQixNQUFNLGFBQWEsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1lBQ3hELElBQUksYUFBYSxFQUFFLENBQUM7Z0JBQ2xCLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQyxHQUFHLElBQUksS0FBSyxhQUFhLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztZQUM1RCxDQUFDO1FBQ0gsQ0FBQztRQUVELG9FQUFvRTtRQUNwRSxNQUFNLFFBQVEsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQzFDLElBQUksUUFBUSxFQUFFLENBQUM7WUFDYixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxJQUFJLE1BQU0sUUFBUSxDQUFDLEtBQUssSUFBSSxRQUFRLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUMxRSxDQUFDO1FBRUQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN4QixDQUFDO0lBRUQ7OztPQUdHO0lBQ0ssZUFBZSxDQUFDLElBQVU7UUFDaEMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxjQUFjLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1FBRWxELE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQy9ELE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFDdEQsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztRQUU3QixJQUFJLENBQUMsU0FBUyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE9BQU8sR0FBRyxDQUFDLENBQUM7UUFDeEMsSUFBSSxDQUFDLGdDQUFnQyxDQUFDLENBQUMsT0FBTyxDQUFDLEVBQUU7WUFDL0Msb0JBQW9CLEVBQUUsSUFBSSxDQUFDLFFBQVEsRUFBRSxlQUFlLEVBQUUsT0FBTztnQkFDM0QsQ0FBQyxDQUFDLFNBQVM7Z0JBQ1gsQ0FBQyxDQUFDLFFBQVE7U0FDYixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMscUJBQXFCLENBQUMsSUFBSSxJQUFJLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQztRQUUvQyxNQUFNLG1CQUFtQixHQUFHLENBQUMsSUFBWSxFQUFFLEdBQVcsRUFBRSxFQUFFO1lBQ3hELE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1lBQ2hELE9BQU8sSUFBSSxDQUFDLElBQUksQ0FDZCxJQUFJLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxFQUN0QixlQUFlLEVBQ2YsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLEdBQUcsS0FBSyxHQUFHLEdBQUcsQ0FDN0MsQ0FBQztRQUNKLENBQUMsQ0FBQztRQUVGLE1BQU0sZUFBZSxHQUFHLENBQUMsSUFBWSxFQUFFLEdBQVcsRUFBRSxFQUFFO1lBQ3BELE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLEtBQUssR0FBRyxHQUFHLENBQUMsR0FBRyxLQUFLLENBQUM7WUFDMUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztZQUN2RSxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQ2xDLENBQUMsQ0FBQztRQUVGLE1BQU0sUUFBUSxHQUFHLElBQUksbUJBQVEsQ0FDM0IsSUFBSSxFQUNKLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLG1CQUFVLEVBQUUsMkJBQTJCLENBQUMsQ0FDekQsQ0FBQztRQUNGLElBQUksQ0FBQyxRQUFRLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDckIsUUFBUSxDQUFDLE9BQU8sQ0FBQyxNQUFNLFFBQVEsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDO1FBQzVDLENBQUM7UUFDRCxRQUFRLENBQUMsT0FBTyxDQUFDLCtCQUErQixDQUFDLENBQUM7UUFDbEQsUUFBUSxDQUFDLE9BQU8sQ0FBQyxvQkFBb0IsT0FBTyxJQUFJLENBQUMsQ0FBQztRQUNsRCxRQUFRLENBQUMsT0FBTyxDQUFDLG1CQUFtQixPQUFPLElBQUksQ0FBQyxDQUFDO1FBQ2pELFFBQVEsQ0FBQyxPQUFPLENBQUMsb0JBQW9CLENBQUMsQ0FBQztRQUN2QyxRQUFRLENBQUMsT0FBTyxDQUNkLDBCQUEwQixtQkFBbUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUM1RCxDQUFDO1FBQ0YsUUFBUSxDQUFDLE9BQU8sQ0FBQyxzQkFBc0IsZUFBZSxDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsQ0FBQztRQUN0RSxRQUFRLENBQUMsT0FBTyxDQUNkLGtGQUFrRixDQUNuRixDQUFDO1FBQ0YsUUFBUSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUV2QixJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxRQUFRLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBRU8sZ0JBQWdCLENBQ3RCLElBQVUsRUFDVixhQUF3QztRQUV4QyxJQUFJLENBQUMsVUFBVSxDQUNiLGNBQWMsSUFBSSxDQUFDLFdBQVcsRUFBRSxFQUNoQyxVQUFVLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FDN0IsQ0FBQztRQUVGLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQ2pFLG9CQUFvQixFQUFFLElBQUksQ0FBQyxRQUFRLEVBQUUsZUFBZSxFQUFFLE9BQU87Z0JBQzNELENBQUMsQ0FBQyxTQUFTO2dCQUNYLENBQUMsQ0FBQyxRQUFRO1NBQ2IsQ0FBQyxDQUFDO1FBRUgsbURBQW1EO1FBQ25ELEVBQUU7UUFDRixrRkFBa0Y7UUFDbEYsd0RBQXdEO1FBQ3hELHdFQUF3RTtRQUN4RSxrQ0FBa0M7UUFDbEMsSUFBSSxXQUFnQyxDQUFDO1FBQ3JDLElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO1lBQ3JCLHVFQUF1RTtZQUN2RSxxRUFBcUU7WUFDckUsbUJBQW1CO1lBQ25CLHNFQUFzRTtZQUN0RSxvRUFBb0U7WUFDcEUsTUFBTSxLQUFLLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLEVBQUUsS0FBSyxDQUFDO1lBQ3JELFdBQVcsR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssSUFBSSxFQUFFLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztRQUNoRCxDQUFDO1FBQ0QsSUFBSSxXQUFXLEtBQUssU0FBUyxFQUFFLENBQUM7WUFDOUIsV0FBVyxHQUFHLElBQUEsMkJBQW9CLEVBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRSxPQUFPLENBQUMsQ0FBQztRQUMvRCxDQUFDO1FBRUQsb0VBQW9FO1FBQ3BFLElBQUksV0FBVyxLQUFLLEtBQUssRUFBRSxDQUFDO1lBQzFCLE9BQU8sSUFBSSxDQUFDLHNCQUFzQixDQUFDLElBQUksRUFBRSxhQUFhLENBQUMsQ0FBQztRQUMxRCxDQUFDO1FBQ0QsSUFBSSxDQUFDLHNCQUFzQixDQUFDLElBQUksRUFBRSxhQUFhLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBRU8sc0JBQXNCLENBQzVCLElBQVUsRUFDVixhQUF3QztRQUV4QyxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsR0FBRyxJQUFBLGdCQUFTLEVBQUM7WUFDaEM7Z0JBQ0UsQ0FBQyxhQUFhLEVBQUUsZ0JBQWdCO29CQUNoQyxpQkFBaUIsQ0FBQyxnQ0FBZ0MsQ0FBQyxFQUFFLElBQUksc0JBQVMsQ0FDaEUsU0FBUyxFQUNUO29CQUNFLFFBQVEsRUFBRSxjQUFjLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsUUFBUSxDQUFDO29CQUM1RCxHQUFHLENBQUMsYUFBYSxFQUFFLGdCQUFnQixJQUFJLEVBQUUsQ0FBQztpQkFDM0MsQ0FDRjthQUNGO1lBQ0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTO1NBQ3RCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTyxzQkFBc0IsQ0FDNUIsSUFBVSxFQUNWLGFBQXdDO1FBRXhDLElBQUksYUFBYSxFQUFFLENBQUM7WUFDbEIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQ2QscUhBQXFILENBQ3RILENBQUM7UUFDSixDQUFDO1FBQ0QsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDeEIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEdBQUcsU0FBUyxDQUFDO1FBQ2pDLENBQUM7UUFDRCxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sR0FBRyxJQUFBLGdCQUFTLEVBQUM7WUFDOUI7Z0JBQ0UsU0FBUyxFQUFFO29CQUNULFFBQVEsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVE7aUJBQ3BDO2FBQ0Y7WUFDRCxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU87U0FDcEIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF4WkgsOENBeVpDOzs7QUF4WndCLGtEQUFnQyxHQUFHLGVBQWUsQ0FBQztBQTBaNUUsTUFBTSxVQUFXLFNBQVEscUJBQVM7SUFDaEMsWUFBWSxPQUEwQjtRQUNwQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDZixNQUFNLE9BQU8sR0FBRztZQUNkLHNCQUFzQjtZQUN0Qix1QkFBdUI7WUFDdkIsNkJBQTZCO1lBQzdCLEtBQUs7WUFDTCxHQUFHO1NBQ0osQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFYixNQUFNLFFBQVEsR0FBRztZQUNmLGlDQUFpQztZQUNqQyxFQUFFO1lBQ0YsdUJBQXVCO1lBQ3ZCLHlEQUF5RDtZQUN6RCxLQUFLO1NBQ04sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFYixJQUFJLHVCQUFTLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxNQUFNLEVBQUU7WUFDckMsS0FBSyxFQUFFO2dCQUNMLFVBQVUsRUFBRSxPQUFPO2FBQ3BCO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxPQUFPLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDakIsSUFBSSx1QkFBUyxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsT0FBTyxFQUFFO2dCQUN0QyxLQUFLLEVBQUU7b0JBQ0wsZUFBZSxFQUFFLFFBQVE7aUJBQzFCO2FBQ0YsQ0FBQyxDQUFDO1FBQ0wsQ0FBQztJQUNILENBQUM7Q0FDRjtBQUVEOzs7O0dBSUc7QUFDSCxNQUFhLG9CQUFxQixTQUFRLGlCQUFpQjtJQUN6RCxZQUFZLE9BQWlDO1FBQzNDLHlGQUF5RjtRQUN6RixNQUFNLGFBQWEsR0FBRyxPQUFPLENBQUMsT0FBTyxJQUFJLE9BQU8sQ0FBQyxlQUFlLElBQUksS0FBSyxDQUFDO1FBRTFFLEtBQUssQ0FBQztZQUNKLE9BQU8sRUFBRSxhQUFhO1lBQ3RCLE9BQU8sRUFBRSxhQUFhO1lBQ3RCLHdCQUF3QixFQUFFLEtBQUs7WUFDL0IsVUFBVSxFQUFFLEVBQUUsRUFBRSwwQ0FBMEM7WUFDMUQsR0FBRyxPQUFPO1NBQ1gsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFaSCxvREFhQzs7O0FBRUQ7O0dBRUc7QUFDSCxNQUFhLHdCQUF5QixTQUFRLGlCQUFpQjs7QUFBL0QsNERBQWtFOzs7QUFRbEU7O0dBRUc7QUFDSCxTQUFnQixvQkFBb0IsQ0FDbEMsR0FBRyxPQUFnRDtJQUVuRCxNQUFNLGNBQWMsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBOEIsQ0FBQztJQUM1RSxPQUFPLGNBQWMsQ0FBQyxNQUFNLENBQzFCLENBQUMsUUFBUSxFQUFFLE9BQU8sRUFBRSxFQUFFLENBQUMsQ0FBQztRQUN0QixHQUFHLFFBQVE7UUFDWCxHQUFHLE9BQU87UUFDVixPQUFPLEVBQUUsQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sSUFBSSxFQUFFLENBQUMsRUFBRSxHQUFHLENBQUMsT0FBTyxDQUFDLE9BQU8sSUFBSSxFQUFFLENBQUMsQ0FBQztRQUNsRSxPQUFPLEVBQUUsQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sSUFBSSxFQUFFLENBQUMsRUFBRSxHQUFHLENBQUMsT0FBTyxDQUFDLE9BQU8sSUFBSSxFQUFFLENBQUMsQ0FBQztRQUNsRSxlQUFlLEVBQUU7WUFDZixHQUFHLFFBQVEsQ0FBQyxlQUFlO1lBQzNCLEdBQUcsT0FBTyxDQUFDLGVBQWU7U0FDM0I7S0FDRixDQUFDLEVBQ0YsRUFBRSxlQUFlLEVBQUUsRUFBRSxFQUFFLENBQ3hCLENBQUM7QUFDSixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tIFwicGF0aFwiO1xuaW1wb3J0ICogYXMgc2VtdmVyIGZyb20gXCJzZW12ZXJcIjtcbmltcG9ydCB7IFBST0pFTl9ESVIgfSBmcm9tIFwiLi4vY29tbW9uXCI7XG5pbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tIFwiLi4vY29tcG9uZW50XCI7XG5pbXBvcnQgeyBEZXBlbmRlbmN5VHlwZSB9IGZyb20gXCIuLi9kZXBlbmRlbmNpZXNcIjtcbmltcG9ydCB7XG4gIEVzbGludCxcbiAgRXNsaW50T3B0aW9ucyxcbiAgSmVzdCxcbiAgTm9kZVByb2plY3QsXG4gIE5vZGVQcm9qZWN0T3B0aW9ucyxcbiAgUHJvamVucmMgYXMgTm9kZVByb2plY3RQcm9qZW5yYyxcbiAgVHJhbnNmb3JtLFxuICBUeXBlU2NyaXB0Q29tcGlsZXJPcHRpb25zLFxuICBUeXBlc2NyaXB0Q29uZmlnLFxuICBUeXBlc2NyaXB0Q29uZmlnT3B0aW9ucyxcbn0gZnJvbSBcIi4uL2phdmFzY3JpcHRcIjtcbmltcG9ydCB7IGhhc0RlcGVuZGVuY3lWZXJzaW9uIH0gZnJvbSBcIi4uL2phdmFzY3JpcHQvdXRpbFwiO1xuaW1wb3J0IHsgU2FtcGxlRGlyIH0gZnJvbSBcIi4uL3NhbXBsZS1maWxlXCI7XG5pbXBvcnQgeyBUYXNrIH0gZnJvbSBcIi4uL3Rhc2tcIjtcbmltcG9ydCB7IFRleHRGaWxlIH0gZnJvbSBcIi4uL3RleHRmaWxlXCI7XG5pbXBvcnQge1xuICBQcm9qZW5yYyBhcyBQcm9qZW5yY1RzLFxuICBQcm9qZW5yY09wdGlvbnMgYXMgUHJvamVucmNUc09wdGlvbnMsXG4gIFR5cGVkb2NEb2NnZW4sXG59IGZyb20gXCIuLi90eXBlc2NyaXB0XCI7XG5pbXBvcnQgeyBkZWVwTWVyZ2UsIG5vcm1hbGl6ZVBlcnNpc3RlZFBhdGggfSBmcm9tIFwiLi4vdXRpbFwiO1xuXG4vKipcbiAqIEBzZWUgaHR0cHM6Ly9rdWxzaGVraGFyLmdpdGh1Yi5pby90cy1qZXN0L2RvY3MvZ2V0dGluZy1zdGFydGVkL29wdGlvbnMvYmFiZWxDb25maWcvXG4gKi9cbmV4cG9ydCBjbGFzcyBUc0plc3RCYWJlbENvbmZpZyB7XG4gIC8qKlxuICAgKiBEaXNhYmxlcyB0aGUgdXNlIG9mIEJhYmVsXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGRpc2FibGVkKCkge1xuICAgIHJldHVybiBuZXcgVHNKZXN0QmFiZWxDb25maWcoZmFsc2UpO1xuICB9XG5cbiAgLyoqXG4gICAqIEVuYWJsZXMgQmFiZWwgcHJvY2Vzc2luZ1xuICAgKlxuICAgKiBgdHMtamVzdGAgd2lsbCB0cnkgdG8gZmluZCBhbiBleGlzdGluZyBCYWJlbCBjb25maWd1cmF0aW9uIGFuZCBwYXNzIGl0IHRvIHRoZSBgYmFiZWwtamVzdGAgcHJvY2Vzc29yLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBhdXRvRGV0ZWN0Q29uZmlnKCkge1xuICAgIHJldHVybiBuZXcgVHNKZXN0QmFiZWxDb25maWcodHJ1ZSk7XG4gIH1cblxuICAvKipcbiAgICogUGF0aCB0byBhIGJhYmVscmMgZmlsZVxuICAgKlxuICAgKiBUaGUgcGF0aCBzaG91bGQgYmUgcmVsYXRpdmUgdG8gdGhlIGN1cnJlbnQgd29ya2luZyBkaXJlY3Rvcnkgd2hlcmUgeW91IHN0YXJ0IEplc3QgZnJvbS4gWW91IGNhbiBhbHNvIHVzZSBgPHJvb3REaXI+YCBpbiB0aGUgcGF0aC5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUZpbGUoZmlsZVBhdGg6IHN0cmluZykge1xuICAgIHJldHVybiBuZXcgVHNKZXN0QmFiZWxDb25maWcoZmlsZVBhdGgpO1xuICB9XG5cbiAgLyoqXG4gICAqIElubGluZSBjb21waWxlciBvcHRpb25zXG4gICAqIEBzZWUgaHR0cHM6Ly9iYWJlbGpzLmlvL2RvY3Mvb3B0aW9uc1xuICAgKi9cbiAgcHVibGljIHN0YXRpYyBjdXN0b20oY29uZmlnOiBSZWNvcmQ8c3RyaW5nLCBhbnk+KSB7XG4gICAgcmV0dXJuIG5ldyBUc0plc3RCYWJlbENvbmZpZyhjb25maWcpO1xuICB9XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHJlYWRvbmx5IGNvbmZpZzogYm9vbGVhbiB8IHN0cmluZyB8IFJlY29yZDxzdHJpbmcsIGFueT5cbiAgKSB7fVxuXG4gIC8qKlxuICAgKiBAanNpaSBpZ25vcmVcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgdG9KU09OKCk6IGJvb2xlYW4gfCBzdHJpbmcgfCBSZWNvcmQ8c3RyaW5nLCBhbnk+IHtcbiAgICByZXR1cm4gdGhpcy5jb25maWc7XG4gIH1cbn1cblxuLyoqXG4gKiBAc2VlIGh0dHBzOi8va3Vsc2hla2hhci5naXRodWIuaW8vdHMtamVzdC9kb2NzL2dldHRpbmctc3RhcnRlZC9vcHRpb25zL2RpYWdub3N0aWNzL1xuICovXG5leHBvcnQgY2xhc3MgVHNKZXN0RGlhZ25vc3RpY3Mge1xuICAvKipcbiAgICogRW5hYmxlIGFsbCBkaWFnbm9zdGljcy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgYWxsKCkge1xuICAgIHJldHVybiBuZXcgVHNKZXN0RGlhZ25vc3RpY3ModHJ1ZSk7XG4gIH1cblxuICAvKipcbiAgICogRGlzYWJsZSBhbGwgZGlhZ25vc3RpY3MuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIG5vbmUoKSB7XG4gICAgcmV0dXJuIG5ldyBUc0plc3REaWFnbm9zdGljcyhmYWxzZSk7XG4gIH1cblxuICAvKipcbiAgICogUHJvdmlkZSBhIGN1c3RvbSBkaWFnbm9zdGljcyBjb25maWd1cmF0aW9uLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8va3Vsc2hla2hhci5naXRodWIuaW8vdHMtamVzdC9kb2NzL2dldHRpbmctc3RhcnRlZC9vcHRpb25zL2RpYWdub3N0aWNzL1xuICAgKi9cbiAgcHVibGljIHN0YXRpYyBjdXN0b20oY29uZmlnOiBSZWNvcmQ8c3RyaW5nLCBhbnk+KSB7XG4gICAgcmV0dXJuIG5ldyBUc0plc3REaWFnbm9zdGljcyhjb25maWcpO1xuICB9XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGNvbmZpZzogYm9vbGVhbiB8IFJlY29yZDxzdHJpbmcsIGFueT4pIHt9XG5cbiAgLyoqXG4gICAqIEBqc2lpIGlnbm9yZVxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyB0b0pTT04oKTogYm9vbGVhbiB8IFJlY29yZDxzdHJpbmcsIGFueT4ge1xuICAgIHJldHVybiB0aGlzLmNvbmZpZztcbiAgfVxufVxuXG4vKipcbiAqIEBzZWUgaHR0cHM6Ly9rdWxzaGVraGFyLmdpdGh1Yi5pby90cy1qZXN0L2RvY3MvZ2V0dGluZy1zdGFydGVkL29wdGlvbnMvdHNjb25maWcvXG4gKi9cbmV4cG9ydCBjbGFzcyBUc0plc3RUc2NvbmZpZyB7XG4gIC8qKlxuICAgKiBVc2VzIGB0c2NvbmZpZy5qc29uYCBpZiBmb3VuZCwgb3IgdGhlIGJ1aWx0LWluIGRlZmF1bHQgVHlwZVNjcmlwdCBjb21waWxlciBvcHRpb25zLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBhdXRvKCkge1xuICAgIHJldHVybiBuZXcgVHNKZXN0VHNjb25maWcodHJ1ZSk7XG4gIH1cblxuICAvKipcbiAgICogRm9yY2VgIHRzLWplc3RgIHRvIHVzZSBpdHMgYnVpbHQtaW4gZGVmYXVsdHMgZXZlbiBpZiB0aGVyZSBpcyBhIGB0c2NvbmZpZy5qc29uYCBpbiB5b3VyIHByb2plY3QuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGJ1aWx0SW5EZWZhdWx0cygpIHtcbiAgICByZXR1cm4gbmV3IFRzSmVzdFRzY29uZmlnKGZhbHNlKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBQYXRoIHRvIGEgYHRzY29uZmlnYCBmaWxlXG4gICAqXG4gICAqIFRoZSBwYXRoIHNob3VsZCBiZSByZWxhdGl2ZSB0byB0aGUgY3VycmVudCB3b3JraW5nIGRpcmVjdG9yeSB3aGVyZSB5b3Ugc3RhcnQgSmVzdCBmcm9tLiBZb3UgY2FuIGFsc28gdXNlIGA8cm9vdERpcj5gIGluIHRoZSBwYXRoIHRvIHN0YXJ0IGZyb20gdGhlIHByb2plY3Qgcm9vdCBkaXIuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21GaWxlKGZpbGVQYXRoOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gbmV3IFRzSmVzdFRzY29uZmlnKGZpbGVQYXRoKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBJbmxpbmUgY29tcGlsZXIgb3B0aW9uc1xuICAgKlxuICAgKiBAc2VlIFR5cGVzY3JpcHRDb25maWdPcHRpb25zXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGN1c3RvbShjb25maWc6IFR5cGVzY3JpcHRDb25maWdPcHRpb25zKSB7XG4gICAgcmV0dXJuIG5ldyBUc0plc3RUc2NvbmZpZyhjb25maWcpO1xuICB9XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHJlYWRvbmx5IGNvbmZpZzogYm9vbGVhbiB8IHN0cmluZyB8IFR5cGVzY3JpcHRDb25maWdPcHRpb25zXG4gICkge31cblxuICAvKipcbiAgICogQGpzaWkgaWdub3JlXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIHRvSlNPTigpOiBib29sZWFuIHwgc3RyaW5nIHwgVHlwZXNjcmlwdENvbmZpZ09wdGlvbnMge1xuICAgIHJldHVybiB0aGlzLmNvbmZpZztcbiAgfVxufVxuXG4vKipcbiAqIEBzZWUgaHR0cHM6Ly9rdWxzaGVraGFyLmdpdGh1Yi5pby90cy1qZXN0L2RvY3MvZ2V0dGluZy1zdGFydGVkL29wdGlvbnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBUc0plc3RUcmFuc2Zvcm1PcHRpb25zIHtcbiAgLyoqXG4gICAqIEN1c3RvbSBUeXBlU2NyaXB0IEFTVCB0cmFuc2Zvcm1lcnNcbiAgICpcbiAgICogQGRlZmF1bHQgYXV0b1xuICAgKi9cbiAgcmVhZG9ubHkgYXN0VHJhbnNmb3JtZXJzPzogUmVjb3JkPHN0cmluZywgYW55PjtcbiAgLyoqXG4gICAqIEJhYmVsKEplc3QpIHJlbGF0ZWQgY29uZmlndXJhdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgVHNKZXN0QmFiZWxDb25maWcuZGlzYWJsZWQoKVxuICAgKi9cbiAgcmVhZG9ubHkgYmFiZWxDb25maWc/OiBUc0plc3RCYWJlbENvbmZpZztcbiAgLyoqXG4gICAqIFR5cGVTY3JpcHQgbW9kdWxlIHRvIHVzZSBhcyBjb21waWxlci5cbiAgICpcbiAgICogQGRlZmF1bHQgXCJ0eXBlc2NyaXB0XCJcbiAgICovXG4gIHJlYWRvbmx5IGNvbXBpbGVyPzogc3RyaW5nO1xuICAvKipcbiAgICogRGlhZ25vc3RpY3MgcmVsYXRlZCBjb25maWd1cmF0aW9uLlxuICAgKlxuICAgKiBAZGVmYXVsdCBUc0plc3REaWFnbm9zdGljcy5hbGwoKVxuICAgKi9cbiAgcmVhZG9ubHkgZGlhZ25vc3RpY3M/OiBUc0plc3REaWFnbm9zdGljcztcbiAgLyoqXG4gICAqIFJ1biB0cy1qZXN0IHRlc3RzIHdpdGggdGhpcyBUU0NvbmZpZyBpc29sYXRlZE1vZHVsZXMgc2V0dGluZy5cbiAgICpcbiAgICogWW91J2xsIGxvc2UgdHlwZS1jaGVja2luZyBhYmlsaXR5IGFuZCBzb21lIGZlYXR1cmVzIHN1Y2ggYXMgY29uc3QgZW51bSwgYnV0IGluIHRoZSBjYXNlIHlvdSBwbGFuIG9uIHVzaW5nIEplc3Qgd2l0aCB0aGUgY2FjaGUgZGlzYWJsZWQgKGplc3QgLS1uby1jYWNoZSksIHlvdXIgdGVzdHMgd2lsbCB0aGVuIHJ1biBtdWNoIGZhc3Rlci5cbiAgICogQHNlZSBodHRwczovL2t1bHNoZWtoYXIuZ2l0aHViLmlvL3RzLWplc3QvZG9jcy9nZXR0aW5nLXN0YXJ0ZWQvb3B0aW9ucy9pc29sYXRlZE1vZHVsZXNcbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGlzb2xhdGVkTW9kdWxlcz86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBGaWxlcyB3aGljaCB3aWxsIGJlY29tZSBtb2R1bGVzIHJldHVybmluZyBzZWxmIGNvbnRlbnQuXG4gICAqXG4gICAqIEBkZWZhdWx0IGRpc2FibGVkXG4gICAqL1xuICByZWFkb25seSBzdHJpbmdpZnlDb250ZW50UGF0aFJlZ2V4Pzogc3RyaW5nO1xuICAvKipcbiAgICogVHlwZVNjcmlwdCBjb21waWxlciByZWxhdGVkIGNvbmZpZ3VyYXRpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gWW91ciBwcm9qZWN0J3MgYHRzY29uZmlnRGV2YCBmaWxlLlxuICAgKi9cbiAgcmVhZG9ubHkgdHNjb25maWc/OiBUc0plc3RUc2NvbmZpZztcbiAgLyoqXG4gICAqIEVuYWJsZSBFU00gc3VwcG9ydFxuICAgKlxuICAgKiBAZGVmYXVsdCBhdXRvXG4gICAqL1xuICByZWFkb25seSB1c2VFU00/OiBib29sZWFuO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFRzSmVzdE9wdGlvbnMge1xuICAvKipcbiAgICogV2hpY2ggZmlsZXMgc2hvdWxkIHRzLWplc3QgYWN0IHVwb24uXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9qZXN0anMuaW8vZG9jcy9jb25maWd1cmF0aW9uI3RyYW5zZm9ybS1vYmplY3RzdHJpbmctcGF0aHRvdHJhbnNmb3JtZXItLXBhdGh0b3RyYW5zZm9ybWVyLW9iamVjdFxuICAgKlxuICAgKiBAZGVmYXVsdCBcIl4uK1xcXFwuW3Rdc3g/JFwiXG4gICAqL1xuICByZWFkb25seSB0cmFuc2Zvcm1QYXR0ZXJuPzogc3RyaW5nO1xuICAvKipcbiAgICogT3ZlcnJpZGUgdGhlIGRlZmF1bHQgdHMtamVzdCB0cmFuc2Zvcm1lciBjb25maWd1cmF0aW9uLlxuICAgKi9cbiAgcmVhZG9ubHkgdHJhbnNmb3JtT3B0aW9ucz86IFRzSmVzdFRyYW5zZm9ybU9wdGlvbnM7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgVHlwZVNjcmlwdFByb2plY3RPcHRpb25zIGV4dGVuZHMgTm9kZVByb2plY3RPcHRpb25zIHtcbiAgLyoqXG4gICAqIFR5cGVzY3JpcHQgIGFydGlmYWN0cyBvdXRwdXQgZGlyZWN0b3J5XG4gICAqXG4gICAqIEBkZWZhdWx0IFwibGliXCJcbiAgICovXG4gIHJlYWRvbmx5IGxpYmRpcj86IHN0cmluZztcblxuICAvKipcbiAgICogVHlwZXNjcmlwdCBzb3VyY2VzIGRpcmVjdG9yeS5cbiAgICpcbiAgICogQGRlZmF1bHQgXCJzcmNcIlxuICAgKi9cbiAgcmVhZG9ubHkgc3JjZGlyPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBKZXN0IHRlc3RzIGRpcmVjdG9yeS4gVGVzdHMgZmlsZXMgc2hvdWxkIGJlIG5hbWVkIGB4eHgudGVzdC50c2AuXG4gICAqXG4gICAqIElmIHRoaXMgZGlyZWN0b3J5IGlzIHVuZGVyIGBzcmNkaXJgIChlLmcuIGBzcmMvdGVzdGAsIGBzcmMvX190ZXN0c19fYCksXG4gICAqIHRoZW4gdGVzdHMgYXJlIGdvaW5nIHRvIGJlIGNvbXBpbGVkIGludG8gYGxpYi9gIGFuZCBleGVjdXRlZCBhcyBqYXZhc2NyaXB0LlxuICAgKiBJZiB0aGUgdGVzdCBkaXJlY3RvcnkgaXMgb3V0c2lkZSBvZiBgc3JjYCwgdGhlbiB3ZSBjb25maWd1cmUgamVzdCB0b1xuICAgKiBjb21waWxlIHRoZSBjb2RlIGluLW1lbW9yeS5cbiAgICpcbiAgICogQGRlZmF1bHQgXCJ0ZXN0XCJcbiAgICovXG4gIHJlYWRvbmx5IHRlc3RkaXI/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFNldHVwIGVzbGludC5cbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgZXNsaW50PzogYm9vbGVhbjtcblxuICAvKipcbiAgICogRXNsaW50IG9wdGlvbnNcbiAgICogQGRlZmF1bHQgLSBvcGluaW9uYXRlZCBkZWZhdWx0IG9wdGlvbnNcbiAgICovXG4gIHJlYWRvbmx5IGVzbGludE9wdGlvbnM/OiBFc2xpbnRPcHRpb25zO1xuXG4gIC8qKlxuICAgKiBUeXBlU2NyaXB0IHZlcnNpb24gdG8gdXNlLlxuICAgKlxuICAgKiBOT1RFOiBUeXBlc2NyaXB0IGlzIG5vdCBzZW1hbnRpY2FsbHkgdmVyc2lvbmVkIGFuZCBzaG91bGQgcmVtYWluIG9uIHRoZVxuICAgKiBzYW1lIG1pbm9yLCBzbyB3ZSByZWNvbW1lbmQgdXNpbmcgYSBgfmAgZGVwZW5kZW5jeSAoZS5nLiBgfjEuMi4zYCkuXG4gICAqXG4gICAqIEBkZWZhdWx0IFwibGF0ZXN0XCJcbiAgICovXG4gIHJlYWRvbmx5IHR5cGVzY3JpcHRWZXJzaW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBEb2NnZW4gYnkgVHlwZWRvY1xuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgZG9jZ2VuPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogRG9jcyBkaXJlY3RvcnlcbiAgICpcbiAgICogQGRlZmF1bHQgXCJkb2NzXCJcbiAgICovXG4gIHJlYWRvbmx5IGRvY3NEaXJlY3Rvcnk/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEN1c3RvbSBUU0NvbmZpZ1xuICAgKiBAZGVmYXVsdCAtIGRlZmF1bHQgb3B0aW9uc1xuICAgKi9cbiAgcmVhZG9ubHkgdHNjb25maWc/OiBUeXBlc2NyaXB0Q29uZmlnT3B0aW9ucztcblxuICAvKipcbiAgICogQ3VzdG9tIHRzY29uZmlnIG9wdGlvbnMgZm9yIHRoZSBkZXZlbG9wbWVudCB0c2NvbmZpZy5qc29uIGZpbGUgKHVzZWQgZm9yIHRlc3RpbmcpLlxuICAgKiBAZGVmYXVsdCAtIHVzZSB0aGUgcHJvZHVjdGlvbiB0c2NvbmZpZyBvcHRpb25zXG4gICAqL1xuICByZWFkb25seSB0c2NvbmZpZ0Rldj86IFR5cGVzY3JpcHRDb25maWdPcHRpb25zO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgZGV2ZWxvcG1lbnQgdHNjb25maWcuanNvbiBmaWxlLlxuICAgKlxuICAgKiBAZGVmYXVsdCBcInRzY29uZmlnLmRldi5qc29uXCJcbiAgICovXG4gIHJlYWRvbmx5IHRzY29uZmlnRGV2RmlsZT86IHN0cmluZztcblxuICAvKipcbiAgICogRG8gbm90IGdlbmVyYXRlIGEgYHRzY29uZmlnLmpzb25gIGZpbGUgKHVzZWQgYnkganNpaSBwcm9qZWN0cyBzaW5jZVxuICAgKiB0c2NvbmZpZy5qc29uIGlzIGdlbmVyYXRlZCBieSB0aGUganNpaSBjb21waWxlcikuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBkaXNhYmxlVHNjb25maWc/OiBib29sZWFuO1xuICAvKipcbiAgICogRG8gbm90IGdlbmVyYXRlIGEgYHRzY29uZmlnLmRldi5qc29uYCBmaWxlLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgZGlzYWJsZVRzY29uZmlnRGV2PzogYm9vbGVhbjtcblxuICAvKipcbiAgICogR2VuZXJhdGUgb25lLXRpbWUgc2FtcGxlIGluIGBzcmMvYCBhbmQgYHRlc3QvYCBpZiB0aGVyZSBhcmUgbm8gZmlsZXMgdGhlcmUuXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IHNhbXBsZUNvZGU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgLmQudHMgZmlsZSB0aGF0IGluY2x1ZGVzIHRoZSB0eXBlIGRlY2xhcmF0aW9ucyBmb3IgdGhpcyBtb2R1bGUuXG4gICAqIEBkZWZhdWx0IC0gLmQudHMgZmlsZSBkZXJpdmVkIGZyb20gdGhlIHByb2plY3QncyBlbnRyeXBvaW50ICh1c3VhbGx5IGxpYi9pbmRleC5kLnRzKVxuICAgKi9cbiAgcmVhZG9ubHkgZW50cnlwb2ludFR5cGVzPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBVc2UgVHlwZVNjcmlwdCBmb3IgeW91ciBwcm9qZW5yYyBmaWxlIChgLnByb2plbnJjLnRzYCkuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqIEBwam5ldyB0cnVlXG4gICAqL1xuICByZWFkb25seSBwcm9qZW5yY1RzPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogT3B0aW9ucyBmb3IgLnByb2plbnJjLnRzXG4gICAqL1xuICByZWFkb25seSBwcm9qZW5yY1RzT3B0aW9ucz86IFByb2plbnJjVHNPcHRpb25zO1xuXG4gIC8qKlxuICAgKiBPcHRpb25zIGZvciB0cy1qZXN0XG4gICAqL1xuICByZWFkb25seSB0c0plc3RPcHRpb25zPzogVHNKZXN0T3B0aW9ucztcbn1cblxuLyoqXG4gKiBUeXBlU2NyaXB0IHByb2plY3RcbiAqIEBwamlkIHR5cGVzY3JpcHRcbiAqL1xuZXhwb3J0IGNsYXNzIFR5cGVTY3JpcHRQcm9qZWN0IGV4dGVuZHMgTm9kZVByb2plY3Qge1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERFRkFVTFRfVFNfSkVTVF9UUkFORk9STV9QQVRURVJOID0gXCJeLitcXFxcLlt0XXN4PyRcIjtcblxuICBwdWJsaWMgcmVhZG9ubHkgZG9jZ2VuPzogYm9vbGVhbjtcbiAgcHVibGljIHJlYWRvbmx5IGRvY3NEaXJlY3Rvcnk6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGVzbGludD86IEVzbGludDtcbiAgcHVibGljIHJlYWRvbmx5IHRzY29uZmlnRXNsaW50PzogVHlwZXNjcmlwdENvbmZpZztcbiAgcHVibGljIHJlYWRvbmx5IHRzY29uZmlnPzogVHlwZXNjcmlwdENvbmZpZztcblxuICAvKipcbiAgICogQSB0eXBlc2NyaXB0IGNvbmZpZ3VyYXRpb24gZmlsZSB3aGljaCBjb3ZlcnMgYWxsIGZpbGVzIChzb3VyY2VzLCB0ZXN0cywgcHJvamVuKS5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSB0c2NvbmZpZ0RldjogVHlwZXNjcmlwdENvbmZpZztcblxuICAvKipcbiAgICogVGhlIGRpcmVjdG9yeSBpbiB3aGljaCB0aGUgLnRzIHNvdXJjZXMgcmVzaWRlLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHNyY2Rpcjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgZGlyZWN0b3J5IGluIHdoaWNoIGNvbXBpbGVkIC5qcyBmaWxlcyByZXNpZGUuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgbGliZGlyOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBkaXJlY3RvcnkgaW4gd2hpY2ggdGVzdHMgcmVzaWRlLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHRlc3RkaXI6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIFwid2F0Y2hcIiB0YXNrLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHdhdGNoVGFzazogVGFzaztcblxuICBjb25zdHJ1Y3RvcihvcHRpb25zOiBUeXBlU2NyaXB0UHJvamVjdE9wdGlvbnMpIHtcbiAgICBzdXBlcih7XG4gICAgICAuLi5vcHRpb25zLFxuXG4gICAgICAvLyBkaXNhYmxlIC5wcm9qZW5yYy5qcyBpZiB0eXBlc2NyaXB0IGlzIGVuYWJsZWRcbiAgICAgIHByb2plbnJjSnM6IG9wdGlvbnMucHJvamVucmNUcyA/IGZhbHNlIDogb3B0aW9ucy5wcm9qZW5yY0pzLFxuXG4gICAgICBqZXN0T3B0aW9uczoge1xuICAgICAgICAuLi5vcHRpb25zLmplc3RPcHRpb25zLFxuICAgICAgICBqZXN0Q29uZmlnOiB7XG4gICAgICAgICAgLi4ub3B0aW9ucy5qZXN0T3B0aW9ucz8uamVzdENvbmZpZyxcbiAgICAgICAgICB0ZXN0TWF0Y2g6IG9wdGlvbnMuamVzdE9wdGlvbnM/Lmplc3RDb25maWc/LnRlc3RNYXRjaCA/PyBbXSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLnNyY2RpciA9IG9wdGlvbnMuc3JjZGlyID8/IFwic3JjXCI7XG4gICAgdGhpcy5saWJkaXIgPSBvcHRpb25zLmxpYmRpciA/PyBcImxpYlwiO1xuXG4gICAgdGhpcy5kb2NnZW4gPSBvcHRpb25zLmRvY2dlbjtcbiAgICB0aGlzLmRvY3NEaXJlY3RvcnkgPSBvcHRpb25zLmRvY3NEaXJlY3RvcnkgPz8gXCJkb2NzL1wiO1xuXG4gICAgY29uc3QgdHNjb25maWdGaWxlbmFtZSA9IG9wdGlvbnMudHNjb25maWc/LmZpbGVOYW1lO1xuICAgIHRoaXMuY29tcGlsZVRhc2suZXhlYyhcbiAgICAgIFtcInRzY1wiLCBcIi0tYnVpbGRcIiwgdHNjb25maWdGaWxlbmFtZV0uZmlsdGVyKEJvb2xlYW4pLmpvaW4oXCIgXCIpXG4gICAgKTtcblxuICAgIHRoaXMud2F0Y2hUYXNrID0gdGhpcy5hZGRUYXNrKFwid2F0Y2hcIiwge1xuICAgICAgZGVzY3JpcHRpb246IFwiV2F0Y2ggJiBjb21waWxlIGluIHRoZSBiYWNrZ3JvdW5kXCIsXG4gICAgICBleGVjOiBbXCJ0c2NcIiwgXCItLWJ1aWxkXCIsIFwiLXdcIiwgdHNjb25maWdGaWxlbmFtZV1cbiAgICAgICAgLmZpbHRlcihCb29sZWFuKVxuICAgICAgICAuam9pbihcIiBcIiksXG4gICAgfSk7XG5cbiAgICB0aGlzLnRlc3RkaXIgPSBvcHRpb25zLnRlc3RkaXIgPz8gXCJ0ZXN0XCI7XG4gICAgdGhpcy5naXRpZ25vcmUuaW5jbHVkZShgLyR7dGhpcy50ZXN0ZGlyfS9gKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZShgLyR7dGhpcy50ZXN0ZGlyfS9gKTtcblxuICAgIC8vIGlmIHRoZSB0ZXN0IGRpcmVjdG9yeSBpcyB1bmRlciBgc3JjL2AsIHRoZW4gd2Ugd2lsbCBydW4gb3VyIHRlc3RzIGFnYWluc3RcbiAgICAvLyB0aGUgamF2YXNjcmlwdCBmaWxlcyBhbmQgbm90IGxldCBqZXN0IGNvbXBpbGUgaXQgZm9yIHVzLlxuICAgIGNvbnN0IGNvbXBpbGVkVGVzdHMgPSB0aGlzLnRlc3RkaXIuc3RhcnRzV2l0aCh0aGlzLnNyY2RpciArIHBhdGgucG9zaXguc2VwKTtcblxuICAgIGlmIChvcHRpb25zLmVudHJ5cG9pbnRUeXBlcyB8fCB0aGlzLmVudHJ5cG9pbnQgIT09IFwiXCIpIHtcbiAgICAgIGNvbnN0IGVudHJ5cG9pbnRQYXRoID0gcGF0aC5qb2luKFxuICAgICAgICBwYXRoLmRpcm5hbWUodGhpcy5lbnRyeXBvaW50KSxcbiAgICAgICAgcGF0aC5iYXNlbmFtZSh0aGlzLmVudHJ5cG9pbnQsIFwiLmpzXCIpXG4gICAgICApO1xuICAgICAgY29uc3Qgbm9ybWFsaXplZFBhdGggPSBub3JtYWxpemVQZXJzaXN0ZWRQYXRoKGVudHJ5cG9pbnRQYXRoKTtcbiAgICAgIGNvbnN0IGVudHJ5cG9pbnRUeXBlcyA9XG4gICAgICAgIG9wdGlvbnMuZW50cnlwb2ludFR5cGVzID8/IGAke25vcm1hbGl6ZWRQYXRofS5kLnRzYDtcbiAgICAgIHRoaXMucGFja2FnZS5hZGRGaWVsZChcInR5cGVzXCIsIGVudHJ5cG9pbnRUeXBlcyk7XG4gICAgfVxuXG4gICAgaWYgKG9wdGlvbnMuZGlzYWJsZVRzY29uZmlnRGV2ICYmIG9wdGlvbnMuZGlzYWJsZVRzY29uZmlnKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgIFwiQ2Fubm90IHNwZWNpZnkgYm90aCAnZGlzYWJsZVRzY29uZmlnRGV2JyBhbmQgJ2Rpc2FibGVUc2NvbmZpZycgZmllbGRzLlwiXG4gICAgICApO1xuICAgIH1cblxuICAgIGlmICghb3B0aW9ucy5kaXNhYmxlVHNjb25maWcpIHtcbiAgICAgIHRoaXMudHNjb25maWcgPSBuZXcgVHlwZXNjcmlwdENvbmZpZyhcbiAgICAgICAgdGhpcyxcbiAgICAgICAgbWVyZ2VUc2NvbmZpZ09wdGlvbnMoXG4gICAgICAgICAge1xuICAgICAgICAgICAgaW5jbHVkZTogW2Ake3RoaXMuc3JjZGlyfS8qKi8qLnRzYF0sXG4gICAgICAgICAgICAvLyBleGNsdWRlOiBbJ25vZGVfbW9kdWxlcyddLCAvLyBUT0RPOiBzaG91bGRuJ3Qgd2UgZXhjbHVkZSBub2RlX21vZHVsZXM/XG4gICAgICAgICAgICBjb21waWxlck9wdGlvbnM6IHtcbiAgICAgICAgICAgICAgcm9vdERpcjogdGhpcy5zcmNkaXIsXG4gICAgICAgICAgICAgIG91dERpcjogdGhpcy5saWJkaXIsXG4gICAgICAgICAgICAgIC4uLnRoaXMuZGVmYXVsdFR5cGVTY3JpcHRDb21waWxlck9wdGlvbnMoKSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgICBvcHRpb25zLnRzY29uZmlnXG4gICAgICAgIClcbiAgICAgICk7XG4gICAgfVxuXG4gICAgaWYgKG9wdGlvbnMuZGlzYWJsZVRzY29uZmlnRGV2KSB7XG4gICAgICB0aGlzLnRzY29uZmlnRGV2ID0gdGhpcy50c2NvbmZpZyE7XG4gICAgfSBlbHNlIHtcbiAgICAgIGNvbnN0IHRzY29uZmlnRGV2RmlsZSA9IG9wdGlvbnMudHNjb25maWdEZXZGaWxlID8/IFwidHNjb25maWcuZGV2Lmpzb25cIjtcbiAgICAgIHRoaXMudHNjb25maWdEZXYgPSBuZXcgVHlwZXNjcmlwdENvbmZpZyhcbiAgICAgICAgdGhpcyxcbiAgICAgICAgbWVyZ2VUc2NvbmZpZ09wdGlvbnMoXG4gICAgICAgICAge1xuICAgICAgICAgICAgZmlsZU5hbWU6IHRzY29uZmlnRGV2RmlsZSxcbiAgICAgICAgICAgIGluY2x1ZGU6IFtgJHt0aGlzLnNyY2Rpcn0vKiovKi50c2AsIGAke3RoaXMudGVzdGRpcn0vKiovKi50c2BdLFxuXG4gICAgICAgICAgICBleGNsdWRlOiBbXCJub2RlX21vZHVsZXNcIl0sXG4gICAgICAgICAgICBjb21waWxlck9wdGlvbnM6IHRoaXMuZGVmYXVsdFR5cGVTY3JpcHRDb21waWxlck9wdGlvbnMoKSxcbiAgICAgICAgICB9LFxuICAgICAgICAgIG9wdGlvbnMudHNjb25maWcsXG4gICAgICAgICAgb3B0aW9ucy50c2NvbmZpZ0RldlxuICAgICAgICApXG4gICAgICApO1xuICAgIH1cblxuICAgIHRoaXMuZ2l0aWdub3JlLmluY2x1ZGUoYC8ke3RoaXMuc3JjZGlyfS9gKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZShgLyR7dGhpcy5zcmNkaXJ9L2ApO1xuXG4gICAgaWYgKHRoaXMuc3JjZGlyICE9PSB0aGlzLmxpYmRpcikge1xuICAgICAgLy8gc2VwYXJhdGVkLCBjYW4gaWdub3JlIHRoZSBlbnRpcmUgbGliZGlyXG4gICAgICB0aGlzLmdpdGlnbm9yZS5leGNsdWRlKGAvJHt0aGlzLmxpYmRpcn1gKTtcbiAgICB9IGVsc2Uge1xuICAgICAgLy8gY29sbG9jYXRlZCwgY2FuIG9ubHkgaWdub3JlIHRoZSBjb21waWxlZCBvdXRwdXRcbiAgICAgIHRoaXMuZ2l0aWdub3JlLmV4Y2x1ZGUoYC8ke3RoaXMubGliZGlyfS8qKi8qLmpzYCk7XG4gICAgICB0aGlzLmdpdGlnbm9yZS5leGNsdWRlKGAvJHt0aGlzLmxpYmRpcn0vKiovKi5kLnRzYCk7XG4gICAgICB0aGlzLmdpdGlnbm9yZS5leGNsdWRlKGAvJHt0aGlzLmxpYmRpcn0vKiovKi5kLnRzLm1hcGApO1xuICAgIH1cblxuICAgIHRoaXMubnBtaWdub3JlPy5pbmNsdWRlKGAvJHt0aGlzLmxpYmRpcn0vYCk7XG5cbiAgICB0aGlzLm5wbWlnbm9yZT8uaW5jbHVkZShgLyR7dGhpcy5saWJkaXJ9LyoqLyouanNgKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uaW5jbHVkZShgLyR7dGhpcy5saWJkaXJ9LyoqLyouZC50c2ApO1xuXG4gICAgdGhpcy5naXRpZ25vcmUuZXhjbHVkZShcIi9kaXN0L1wiKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZShcImRpc3RcIik7IC8vIGpzaWktcGFjbWFrIGV4cGVjdHMgdGhpcyB0byBiZSBcImRpc3RcIiBhbmQgbm90IFwiL2Rpc3RcIi4gb3RoZXJ3aXNlIGl0IHdpbGwgdGFtcGVyIHdpdGggaXRcblxuICAgIHRoaXMubnBtaWdub3JlPy5leGNsdWRlKFwiL3RzY29uZmlnLmpzb25cIik7XG4gICAgdGhpcy5ucG1pZ25vcmU/LmV4Y2x1ZGUoXCIvLmdpdGh1Yi9cIik7XG4gICAgdGhpcy5ucG1pZ25vcmU/LmV4Y2x1ZGUoXCIvLnZzY29kZS9cIik7XG4gICAgdGhpcy5ucG1pZ25vcmU/LmV4Y2x1ZGUoXCIvLmlkZWEvXCIpO1xuICAgIHRoaXMubnBtaWdub3JlPy5leGNsdWRlKFwiLy5wcm9qZW5yYy5qc1wiKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZShcInRzY29uZmlnLnRzYnVpbGRpbmZvXCIpO1xuXG4gICAgaWYgKHRoaXMuamVzdCkge1xuICAgICAgaWYgKGNvbXBpbGVkVGVzdHMpIHtcbiAgICAgICAgdGhpcy5hZGRKZXN0Q29tcGlsZWQodGhpcy5qZXN0KTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHRoaXMuYWRkSmVzdE5vQ29tcGlsZSh0aGlzLmplc3QsIG9wdGlvbnM/LnRzSmVzdE9wdGlvbnMpO1xuICAgICAgfVxuICAgIH1cblxuICAgIGlmIChvcHRpb25zLmVzbGludCA/PyB0cnVlKSB7XG4gICAgICB0aGlzLmVzbGludCA9IG5ldyBFc2xpbnQodGhpcywge1xuICAgICAgICB0c2NvbmZpZ1BhdGg6IGAuLyR7dGhpcy50c2NvbmZpZ0Rldi5maWxlTmFtZX1gLFxuICAgICAgICBkaXJzOiBbdGhpcy5zcmNkaXJdLFxuICAgICAgICBkZXZkaXJzOiBbdGhpcy50ZXN0ZGlyLCBcImJ1aWxkLXRvb2xzXCJdLFxuICAgICAgICBmaWxlRXh0ZW5zaW9uczogW1wiLnRzXCIsIFwiLnRzeFwiXSxcbiAgICAgICAgbGludFByb2plblJjOiBmYWxzZSxcbiAgICAgICAgLi4ub3B0aW9ucy5lc2xpbnRPcHRpb25zLFxuICAgICAgfSk7XG5cbiAgICAgIHRoaXMudHNjb25maWdFc2xpbnQgPSB0aGlzLnRzY29uZmlnRGV2O1xuICAgIH1cblxuICAgIC8vIHdoZW4gdGhpcyBpcyBhIHJvb3QgcHJvamVjdFxuICAgIGlmICghdGhpcy5wYXJlbnQpIHtcbiAgICAgIGlmIChvcHRpb25zLnByb2plbnJjVHMpIHtcbiAgICAgICAgbmV3IFByb2plbnJjVHModGhpcywgb3B0aW9ucy5wcm9qZW5yY1RzT3B0aW9ucyk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICAvLyBwcm9qZW5yYy5qcyBjcmVhdGVkIGluIE5vZGVQcm9qZWN0IG5lZWRzIHRvIGJlIGFkZGVkIGluIHRzY29uZmlnRGV2XG4gICAgICAgIGNvbnN0IHByb2plbnJjSnMgPSBOb2RlUHJvamVjdFByb2plbnJjLm9mKHRoaXMpO1xuICAgICAgICBpZiAocHJvamVucmNKcykge1xuICAgICAgICAgIHRoaXMudHNjb25maWdEZXYuYWRkSW5jbHVkZShwcm9qZW5yY0pzLmZpbGVQYXRoKTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cblxuICAgIGNvbnN0IHRzRGVwID0gb3B0aW9ucy50eXBlc2NyaXB0VmVyc2lvblxuICAgICAgPyBgdHlwZXNjcmlwdEAke29wdGlvbnMudHlwZXNjcmlwdFZlcnNpb259YFxuICAgICAgOiBcInR5cGVzY3JpcHRcIjtcbiAgICB0aGlzLmFkZERldkRlcHModHNEZXApO1xuXG4gICAgdGhpcy5hZGROb2RlVHlwZXNWZXJzaW9uKG9wdGlvbnMudHlwZXNjcmlwdFZlcnNpb24sIG9wdGlvbnMubWluTm9kZVZlcnNpb24pO1xuXG4gICAgLy8gZ2VuZXJhdGUgc2FtcGxlIGNvZGUgaW4gYHNyY2AgYW5kIGBsaWJgIGlmIHRoZXNlIGRpcmVjdG9yaWVzIGFyZSBlbXB0eSBvciBub24tZXhpc3RlbnQuXG4gICAgaWYgKG9wdGlvbnMuc2FtcGxlQ29kZSA/PyB0cnVlKSB7XG4gICAgICBuZXcgU2FtcGxlQ29kZSh0aGlzKTtcbiAgICB9XG5cbiAgICBpZiAodGhpcy5kb2NnZW4pIHtcbiAgICAgIG5ldyBUeXBlZG9jRG9jZ2VuKHRoaXMpO1xuICAgIH1cbiAgfVxuXG4gIC8qKlxuICAgKiBQcm9qZW4gZGVmYXVsdCBUeXBlc2NyaXB0IGNvbXBpbGVyIG9wdGlvbnMuXG4gICAqL1xuICBwcm90ZWN0ZWQgZGVmYXVsdFR5cGVTY3JpcHRDb21waWxlck9wdGlvbnMoKTogVHlwZVNjcmlwdENvbXBpbGVyT3B0aW9ucyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGFsd2F5c1N0cmljdDogdHJ1ZSxcbiAgICAgIGRlY2xhcmF0aW9uOiB0cnVlLFxuICAgICAgZXNNb2R1bGVJbnRlcm9wOiB0cnVlLFxuICAgICAgZXhwZXJpbWVudGFsRGVjb3JhdG9yczogdHJ1ZSxcbiAgICAgIGlubGluZVNvdXJjZU1hcDogdHJ1ZSxcbiAgICAgIGlubGluZVNvdXJjZXM6IHRydWUsXG4gICAgICBsaWI6IFtcImVzMjAxOVwiXSxcbiAgICAgIG1vZHVsZTogXCJDb21tb25KU1wiLFxuICAgICAgbm9FbWl0T25FcnJvcjogZmFsc2UsXG4gICAgICBub0ZhbGx0aHJvdWdoQ2FzZXNJblN3aXRjaDogdHJ1ZSxcbiAgICAgIG5vSW1wbGljaXRBbnk6IHRydWUsXG4gICAgICBub0ltcGxpY2l0UmV0dXJuczogdHJ1ZSxcbiAgICAgIG5vSW1wbGljaXRUaGlzOiB0cnVlLFxuICAgICAgbm9VbnVzZWRMb2NhbHM6IHRydWUsXG4gICAgICBub1VudXNlZFBhcmFtZXRlcnM6IHRydWUsXG4gICAgICByZXNvbHZlSnNvbk1vZHVsZTogdHJ1ZSxcbiAgICAgIHN0cmljdDogdHJ1ZSxcbiAgICAgIHN0cmljdE51bGxDaGVja3M6IHRydWUsXG4gICAgICBzdHJpY3RQcm9wZXJ0eUluaXRpYWxpemF0aW9uOiB0cnVlLFxuICAgICAgc3RyaXBJbnRlcm5hbDogdHJ1ZSxcbiAgICAgIHRhcmdldDogXCJFUzIwMTlcIixcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZCBgQHR5cGVzL25vZGVgIHRvIHRoaXMgcHJvamVjdC5cbiAgICpcbiAgICogSWYgdGhlIHVzZXIgaGFzIGFscmVhZHkgYWRkZWQgdGhpcyBkZXBlbmRlbmN5LCBkbyBub3RoaW5nLlxuICAgKiBPdGhlcndpc2UgdXNlIHRoZSBtYWpvciB2ZXJzaW9uIG9mIGBtaW5Ob2RlVmVyc2lvbmAuXG4gICAqIElmIHRoYXQncyBub3QgYXZhaWxhYmxlLCBtYXRjaCB0aGUgdmVyc2lvbiB0byB0aGUgdXNlZCB0eXBlc2NyaXB0IHZlcnNpb24uXG4gICAqIEFuZCBpZiB0aGF0IGlzIGFsc28gbm90IGF2YWlsYWJsZSwgd2UgdXNlIGxhdGVzdCBhbmQgbGV0IHRoZSB1c2VyIG1hbmFnZSB0aGUgdmVyc2lvbi5cbiAgICovXG4gIHByaXZhdGUgYWRkTm9kZVR5cGVzVmVyc2lvbih0c1ZlcnNpb24/OiBzdHJpbmcsIG1pbk5vZGVWZXJzaW9uPzogc3RyaW5nKSB7XG4gICAgY29uc3QgbmFtZSA9IFwiQHR5cGVzL25vZGVcIjtcblxuICAgIGlmICh0aGlzLmRlcHMudHJ5R2V0RGVwZW5kZW5jeShuYW1lLCBEZXBlbmRlbmN5VHlwZS5CVUlMRCkpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBpZiAobWluTm9kZVZlcnNpb24pIHtcbiAgICAgIGNvbnN0IG1pbk5vZGVQYXJzZWQgPSBzZW12ZXIubWluVmVyc2lvbihtaW5Ob2RlVmVyc2lvbik7XG4gICAgICBpZiAobWluTm9kZVBhcnNlZCkge1xuICAgICAgICByZXR1cm4gdGhpcy5hZGREZXZEZXBzKGAke25hbWV9QF4ke21pbk5vZGVQYXJzZWQubWFqb3J9YCk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgLy8gY29lcmNlIHZlcnNpb24sIHNpbmNlIHRoZSB0cyB2ZXJzaW9uIGxpa2VseSBzb21ldGhpbmcgbGlrZSB+NS4zLjBcbiAgICBjb25zdCB0c1BhcnNlZCA9IHNlbXZlci5jb2VyY2UodHNWZXJzaW9uKTtcbiAgICBpZiAodHNQYXJzZWQpIHtcbiAgICAgIHJldHVybiB0aGlzLmFkZERldkRlcHMoYCR7bmFtZX1AdHMke3RzUGFyc2VkLm1ham9yfS4ke3RzUGFyc2VkLm1pbm9yfWApO1xuICAgIH1cblxuICAgIHRoaXMuYWRkRGV2RGVwcyhuYW1lKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUZXN0cyBhcmUgY29tcGlsZWQgdG8gYGxpYi9URVNURElSYCwgc28gd2UgZG9uJ3QgbmVlZCBqZXN0IHRvIGNvbXBpbGUgdGhlbVxuICAgKiBmb3IgdXMuIGp1c3QgcnVuIHRoZW0gZGlyZWN0bHkgZnJvbSBqYXZhc2NyaXB0LlxuICAgKi9cbiAgcHJpdmF0ZSBhZGRKZXN0Q29tcGlsZWQoamVzdDogSmVzdCkge1xuICAgIHRoaXMuYWRkRGV2RGVwcyhgQHR5cGVzL2plc3Qke2plc3QuamVzdFZlcnNpb259YCk7XG5cbiAgICBjb25zdCB0ZXN0b3V0ID0gcGF0aC5wb3NpeC5yZWxhdGl2ZSh0aGlzLnNyY2RpciwgdGhpcy50ZXN0ZGlyKTtcbiAgICBjb25zdCBsaWJ0ZXN0ID0gcGF0aC5wb3NpeC5qb2luKHRoaXMubGliZGlyLCB0ZXN0b3V0KTtcbiAgICBjb25zdCBzcmN0ZXN0ID0gdGhpcy50ZXN0ZGlyO1xuXG4gICAgdGhpcy5ucG1pZ25vcmU/LmV4Y2x1ZGUoYC8ke2xpYnRlc3R9L2ApO1xuICAgIGplc3QuZGlzY292ZXJUZXN0TWF0Y2hQYXR0ZXJuc0ZvckRpcnMoW2xpYnRlc3RdLCB7XG4gICAgICBmaWxlRXh0ZW5zaW9uUGF0dGVybjogdGhpcy50c2NvbmZpZz8uY29tcGlsZXJPcHRpb25zPy5hbGxvd0pzXG4gICAgICAgID8gdW5kZWZpbmVkXG4gICAgICAgIDogXCJqcz8oeClcIixcbiAgICB9KTtcbiAgICBqZXN0LmFkZFdhdGNoSWdub3JlUGF0dGVybihgLyR7dGhpcy5zcmNkaXJ9L2ApO1xuXG4gICAgY29uc3QgcmVzb2x2ZVNuYXBzaG90UGF0aCA9ICh0ZXN0OiBzdHJpbmcsIGV4dDogc3RyaW5nKSA9PiB7XG4gICAgICBjb25zdCBmdWxscGF0aCA9IHRlc3QucmVwbGFjZShsaWJ0ZXN0LCBzcmN0ZXN0KTtcbiAgICAgIHJldHVybiBwYXRoLmpvaW4oXG4gICAgICAgIHBhdGguZGlybmFtZShmdWxscGF0aCksXG4gICAgICAgIFwiX19zbmFwc2hvdHNfX1wiLFxuICAgICAgICBwYXRoLmJhc2VuYW1lKGZ1bGxwYXRoLCBcIi5qc1wiKSArIFwiLnRzXCIgKyBleHRcbiAgICAgICk7XG4gICAgfTtcblxuICAgIGNvbnN0IHJlc29sdmVUZXN0UGF0aCA9IChzbmFwOiBzdHJpbmcsIGV4dDogc3RyaW5nKSA9PiB7XG4gICAgICBjb25zdCBmaWxlbmFtZSA9IHBhdGguYmFzZW5hbWUoc25hcCwgXCIudHNcIiArIGV4dCkgKyBcIi5qc1wiO1xuICAgICAgY29uc3QgZGlyID0gcGF0aC5kaXJuYW1lKHBhdGguZGlybmFtZShzbmFwKSkucmVwbGFjZShzcmN0ZXN0LCBsaWJ0ZXN0KTtcbiAgICAgIHJldHVybiBwYXRoLmpvaW4oZGlyLCBmaWxlbmFtZSk7XG4gICAgfTtcblxuICAgIGNvbnN0IHJlc29sdmVyID0gbmV3IFRleHRGaWxlKFxuICAgICAgdGhpcyxcbiAgICAgIHBhdGgucG9zaXguam9pbihQUk9KRU5fRElSLCBcImplc3Qtc25hcHNob3QtcmVzb2x2ZXIuanNcIilcbiAgICApO1xuICAgIGlmICghcmVzb2x2ZXIubWFya2VyKSB7XG4gICAgICByZXNvbHZlci5hZGRMaW5lKGAvLyAke3Jlc29sdmVyLm1hcmtlcn1gKTtcbiAgICB9XG4gICAgcmVzb2x2ZXIuYWRkTGluZSgnY29uc3QgcGF0aCA9IHJlcXVpcmUoXCJwYXRoXCIpOycpO1xuICAgIHJlc29sdmVyLmFkZExpbmUoYGNvbnN0IGxpYnRlc3QgPSBcIiR7bGlidGVzdH1cIjtgKTtcbiAgICByZXNvbHZlci5hZGRMaW5lKGBjb25zdCBzcmN0ZXN0PSBcIiR7c3JjdGVzdH1cIjtgKTtcbiAgICByZXNvbHZlci5hZGRMaW5lKFwibW9kdWxlLmV4cG9ydHMgPSB7XCIpO1xuICAgIHJlc29sdmVyLmFkZExpbmUoXG4gICAgICBgICByZXNvbHZlU25hcHNob3RQYXRoOiAke3Jlc29sdmVTbmFwc2hvdFBhdGgudG9TdHJpbmcoKX0sYFxuICAgICk7XG4gICAgcmVzb2x2ZXIuYWRkTGluZShgICByZXNvbHZlVGVzdFBhdGg6ICR7cmVzb2x2ZVRlc3RQYXRoLnRvU3RyaW5nKCl9LGApO1xuICAgIHJlc29sdmVyLmFkZExpbmUoXG4gICAgICBcIiAgdGVzdFBhdGhGb3JDb25zaXN0ZW5jeUNoZWNrOiBwYXRoLmpvaW4oJ3NvbWUnLCAnX190ZXN0c19fJywgJ2V4YW1wbGUudGVzdC5qcycpXCJcbiAgICApO1xuICAgIHJlc29sdmVyLmFkZExpbmUoXCJ9O1wiKTtcblxuICAgIGplc3QuYWRkU25hcHNob3RSZXNvbHZlcihgLi8ke3Jlc29sdmVyLnBhdGh9YCk7XG4gIH1cblxuICBwcml2YXRlIGFkZEplc3ROb0NvbXBpbGUoXG4gICAgamVzdDogSmVzdCxcbiAgICB0c0plc3RPcHRpb25zOiBUc0plc3RPcHRpb25zIHwgdW5kZWZpbmVkXG4gICkge1xuICAgIHRoaXMuYWRkRGV2RGVwcyhcbiAgICAgIGBAdHlwZXMvamVzdCR7amVzdC5qZXN0VmVyc2lvbn1gLFxuICAgICAgYHRzLWplc3Qke2plc3QuamVzdFZlcnNpb259YFxuICAgICk7XG5cbiAgICBqZXN0LmRpc2NvdmVyVGVzdE1hdGNoUGF0dGVybnNGb3JEaXJzKFt0aGlzLnNyY2RpciwgdGhpcy50ZXN0ZGlyXSwge1xuICAgICAgZmlsZUV4dGVuc2lvblBhdHRlcm46IHRoaXMudHNjb25maWc/LmNvbXBpbGVyT3B0aW9ucz8uYWxsb3dKc1xuICAgICAgICA/IHVuZGVmaW5lZFxuICAgICAgICA6IFwidHM/KHgpXCIsXG4gICAgfSk7XG5cbiAgICAvLyBUZXN0IGZvciB0aGUgdHMtamVzdCB2ZXJzaW9uIHRoYXQgd2FzIHJlcXVlc3RlZDtcbiAgICAvL1xuICAgIC8vIC0gRmlyc3QsIGNoZWNrIHRoZSBgamVzdGAgdmVyc2lvbiB0aGF0IGlzIHJlcXVlc3RlZCB2aWEgcHJvamVuIHByb3BlcnRpZXMuIFRoaXNcbiAgICAvLyAgIHNob3VsZCBiZSB0aGUgc2FtZSBhcyB0aGUgYHRzLWplc3RgIHZlcnNpb24gYW55d2F5LlxuICAgIC8vIC0gSWYgbm9uZSBmb3VuZCwgZmFsbCBiYWNrIHRvIGluc3BlY3RpbmcgdGhlIGFjdHVhbCBgdHMtamVzdGAgdmVyc2lvblxuICAgIC8vICAgdGhhdCBoYXBwZW5zIHRvIGJlIGluc3RhbGxlZC5cbiAgICBsZXQgaGFzVHNKZXN0Mjk6IGJvb2xlYW4gfCB1bmRlZmluZWQ7XG4gICAgaWYgKGplc3QuamVzdFZlcnNpb24pIHtcbiAgICAgIC8vIFdlIGNvdWxkIG1heWJlIHJlcGxhY2UgdGhpcyB3aWxsIGZ1bGwgXCJhY3R1YWwgdmVyc2lvblwiIGNoZWNraW5nLCBidXRcbiAgICAgIC8vIHRoZSB0ZXN0cyBkZXBlbmQgb24gdGhpcyBhbmQgdGhlIHJlYWRpbmcgb2YgJ3BhY2thZ2UuanNvbicgaXMgdmVyeVxuICAgICAgLy8gYXdrd2FyZCB0byB0ZXN0LlxuICAgICAgLy8gTm90ZSB0aGF0IHdlIHVzZSB0aGUgcmVxdWVzdGVkIHZlcnNpb24gb2YgYGplc3RgIGFzIGEgcHJveHkgZm9yIHRoZVxuICAgICAgLy8gdmVyc2lvbiBvZiBgdHMtamVzdGAsIHdoaWNoIGlzIHdoYXQgd2UncmUgYWN0dWFsbHkgaW50ZXJlc3RlZCBpbi5cbiAgICAgIGNvbnN0IG1ham9yID0gc2VtdmVyLmNvZXJjZShqZXN0Lmplc3RWZXJzaW9uKT8ubWFqb3I7XG4gICAgICBoYXNUc0plc3QyOSA9IG1ham9yID8gbWFqb3IgPj0gMjkgOiB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGlmIChoYXNUc0plc3QyOSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNUc0plc3QyOSA9IGhhc0RlcGVuZGVuY3lWZXJzaW9uKHRoaXMsIFwidHMtamVzdFwiLCBcIj49IDI5XCIpO1xuICAgIH1cblxuICAgIC8vIGFkZCByZWxldmFudCBkZXBzICh3ZSB0cmVhdCBcInVua25vd25cIiBhcyBoYXZpbmcgYSBtb2Rlcm4gdHMtamVzdClcbiAgICBpZiAoaGFzVHNKZXN0MjkgIT09IGZhbHNlKSB7XG4gICAgICByZXR1cm4gdGhpcy5hZGRKZXN0Tm9Db21waWxlTW9kZXJuKGplc3QsIHRzSmVzdE9wdGlvbnMpO1xuICAgIH1cbiAgICB0aGlzLmFkZEplc3ROb0NvbXBpbGVMZWdhY3koamVzdCwgdHNKZXN0T3B0aW9ucyk7XG4gIH1cblxuICBwcml2YXRlIGFkZEplc3ROb0NvbXBpbGVNb2Rlcm4oXG4gICAgamVzdDogSmVzdCxcbiAgICB0c0plc3RPcHRpb25zOiBUc0plc3RPcHRpb25zIHwgdW5kZWZpbmVkXG4gICkge1xuICAgIGplc3QuY29uZmlnLnRyYW5zZm9ybSA9IGRlZXBNZXJnZShbXG4gICAgICB7XG4gICAgICAgIFt0c0plc3RPcHRpb25zPy50cmFuc2Zvcm1QYXR0ZXJuID8/XG4gICAgICAgIFR5cGVTY3JpcHRQcm9qZWN0LkRFRkFVTFRfVFNfSkVTVF9UUkFORk9STV9QQVRURVJOXTogbmV3IFRyYW5zZm9ybShcbiAgICAgICAgICBcInRzLWplc3RcIixcbiAgICAgICAgICB7XG4gICAgICAgICAgICB0c2NvbmZpZzogVHNKZXN0VHNjb25maWcuZnJvbUZpbGUodGhpcy50c2NvbmZpZ0Rldi5maWxlTmFtZSksXG4gICAgICAgICAgICAuLi4odHNKZXN0T3B0aW9ucz8udHJhbnNmb3JtT3B0aW9ucyA/PyB7fSksXG4gICAgICAgICAgfVxuICAgICAgICApLFxuICAgICAgfSxcbiAgICAgIGplc3QuY29uZmlnLnRyYW5zZm9ybSxcbiAgICBdKTtcbiAgfVxuXG4gIHByaXZhdGUgYWRkSmVzdE5vQ29tcGlsZUxlZ2FjeShcbiAgICBqZXN0OiBKZXN0LFxuICAgIHRzSmVzdE9wdGlvbnM6IFRzSmVzdE9wdGlvbnMgfCB1bmRlZmluZWRcbiAgKSB7XG4gICAgaWYgKHRzSmVzdE9wdGlvbnMpIHtcbiAgICAgIHRoaXMubG9nZ2VyLndhcm4oXG4gICAgICAgIFwiWW91IGFyZSB1c2luZyBhIGxlZ2FjeSB2ZXJzaW9uICg8MjkpIG9mIGplc3QgYW5kIHRzLWplc3QgdGhhdCBkb2VzIG5vdCBzdXBwb3J0IHRzSmVzdE9wdGlvbnMsIHRoZXkgd2lsbCBiZSBpZ25vcmVkLlwiXG4gICAgICApO1xuICAgIH1cbiAgICBpZiAoIWplc3QuY29uZmlnLnByZXNldCkge1xuICAgICAgamVzdC5jb25maWcucHJlc2V0ID0gXCJ0cy1qZXN0XCI7XG4gICAgfVxuICAgIGplc3QuY29uZmlnLmdsb2JhbHMgPSBkZWVwTWVyZ2UoW1xuICAgICAge1xuICAgICAgICBcInRzLWplc3RcIjoge1xuICAgICAgICAgIHRzY29uZmlnOiB0aGlzLnRzY29uZmlnRGV2LmZpbGVOYW1lLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIGplc3QuY29uZmlnLmdsb2JhbHMsXG4gICAgXSk7XG4gIH1cbn1cblxuY2xhc3MgU2FtcGxlQ29kZSBleHRlbmRzIENvbXBvbmVudCB7XG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IFR5cGVTY3JpcHRQcm9qZWN0KSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG4gICAgY29uc3Qgc3JjQ29kZSA9IFtcbiAgICAgIFwiZXhwb3J0IGNsYXNzIEhlbGxvIHtcIixcbiAgICAgIFwiICBwdWJsaWMgc2F5SGVsbG8oKSB7XCIsXG4gICAgICBcIiAgICByZXR1cm4gJ2hlbGxvLCB3b3JsZCEnO1wiLFxuICAgICAgXCIgIH1cIixcbiAgICAgIFwifVwiLFxuICAgIF0uam9pbihcIlxcblwiKTtcblxuICAgIGNvbnN0IHRlc3RDb2RlID0gW1xuICAgICAgXCJpbXBvcnQgeyBIZWxsbyB9IGZyb20gJy4uL3NyYyc7XCIsXG4gICAgICBcIlwiLFxuICAgICAgXCJ0ZXN0KCdoZWxsbycsICgpID0+IHtcIixcbiAgICAgIFwiICBleHBlY3QobmV3IEhlbGxvKCkuc2F5SGVsbG8oKSkudG9CZSgnaGVsbG8sIHdvcmxkIScpO1wiLFxuICAgICAgXCJ9KTtcIixcbiAgICBdLmpvaW4oXCJcXG5cIik7XG5cbiAgICBuZXcgU2FtcGxlRGlyKHByb2plY3QsIHByb2plY3Quc3JjZGlyLCB7XG4gICAgICBmaWxlczoge1xuICAgICAgICBcImluZGV4LnRzXCI6IHNyY0NvZGUsXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgaWYgKHByb2plY3QuamVzdCkge1xuICAgICAgbmV3IFNhbXBsZURpcihwcm9qZWN0LCBwcm9qZWN0LnRlc3RkaXIsIHtcbiAgICAgICAgZmlsZXM6IHtcbiAgICAgICAgICBcImhlbGxvLnRlc3QudHNcIjogdGVzdENvZGUsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH1cbn1cblxuLyoqXG4gKiBUeXBlU2NyaXB0IGFwcC5cbiAqXG4gKiBAcGppZCB0eXBlc2NyaXB0LWFwcFxuICovXG5leHBvcnQgY2xhc3MgVHlwZVNjcmlwdEFwcFByb2plY3QgZXh0ZW5kcyBUeXBlU2NyaXB0UHJvamVjdCB7XG4gIGNvbnN0cnVjdG9yKG9wdGlvbnM6IFR5cGVTY3JpcHRQcm9qZWN0T3B0aW9ucykge1xuICAgIC8vIFJlbGVhc2luZyBhbmQgcGFja2FnaW5nIGFyZSBjb3VwbGVkLiBJZiBvbmUgaXMgZGlzYWJsZWQsIGRpc2FibGUgdGhlIG90aGVyIGJ5IGRlZmF1bHQuXG4gICAgY29uc3Qgc2hvdWxkUmVsZWFzZSA9IG9wdGlvbnMucmVsZWFzZSA/PyBvcHRpb25zLnJlbGVhc2VXb3JrZmxvdyA/PyBmYWxzZTtcblxuICAgIHN1cGVyKHtcbiAgICAgIHJlbGVhc2U6IHNob3VsZFJlbGVhc2UsXG4gICAgICBwYWNrYWdlOiBzaG91bGRSZWxlYXNlLFxuICAgICAgYWxsb3dMaWJyYXJ5RGVwZW5kZW5jaWVzOiBmYWxzZSxcbiAgICAgIGVudHJ5cG9pbnQ6IFwiXCIsIC8vIFwibWFpblwiIGlzIG5vdCBuZWVkZWQgaW4gdHlwZXNjcmlwdCBhcHBzXG4gICAgICAuLi5vcHRpb25zLFxuICAgIH0pO1xuICB9XG59XG5cbi8qKlxuICogQGRlcHJlY2F0ZWQgdXNlIGBUeXBlU2NyaXB0UHJvamVjdGBcbiAqL1xuZXhwb3J0IGNsYXNzIFR5cGVTY3JpcHRMaWJyYXJ5UHJvamVjdCBleHRlbmRzIFR5cGVTY3JpcHRQcm9qZWN0IHt9XG5cbi8qKlxuICogQGRlcHJlY2F0ZWQgdXNlIFR5cGVTY3JpcHRQcm9qZWN0T3B0aW9uc1xuICovXG5leHBvcnQgaW50ZXJmYWNlIFR5cGVTY3JpcHRMaWJyYXJ5UHJvamVjdE9wdGlvbnNcbiAgZXh0ZW5kcyBUeXBlU2NyaXB0UHJvamVjdE9wdGlvbnMge31cblxuLyoqXG4gKiBAaW50ZXJuYWxcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIG1lcmdlVHNjb25maWdPcHRpb25zKFxuICAuLi5vcHRpb25zOiAoVHlwZXNjcmlwdENvbmZpZ09wdGlvbnMgfCB1bmRlZmluZWQpW11cbik6IFR5cGVzY3JpcHRDb25maWdPcHRpb25zIHtcbiAgY29uc3QgZGVmaW5lZE9wdGlvbnMgPSBvcHRpb25zLmZpbHRlcihCb29sZWFuKSBhcyBUeXBlc2NyaXB0Q29uZmlnT3B0aW9uc1tdO1xuICByZXR1cm4gZGVmaW5lZE9wdGlvbnMucmVkdWNlPFR5cGVzY3JpcHRDb25maWdPcHRpb25zPihcbiAgICAocHJldmlvdXMsIGN1cnJlbnQpID0+ICh7XG4gICAgICAuLi5wcmV2aW91cyxcbiAgICAgIC4uLmN1cnJlbnQsXG4gICAgICBpbmNsdWRlOiBbLi4uKHByZXZpb3VzLmluY2x1ZGUgPz8gW10pLCAuLi4oY3VycmVudC5pbmNsdWRlID8/IFtdKV0sXG4gICAgICBleGNsdWRlOiBbLi4uKHByZXZpb3VzLmV4Y2x1ZGUgPz8gW10pLCAuLi4oY3VycmVudC5leGNsdWRlID8/IFtdKV0sXG4gICAgICBjb21waWxlck9wdGlvbnM6IHtcbiAgICAgICAgLi4ucHJldmlvdXMuY29tcGlsZXJPcHRpb25zLFxuICAgICAgICAuLi5jdXJyZW50LmNvbXBpbGVyT3B0aW9ucyxcbiAgICAgIH0sXG4gICAgfSksXG4gICAgeyBjb21waWxlck9wdGlvbnM6IHt9IH1cbiAgKTtcbn1cbiJdfQ==