[![CloudFormation CLI](https://github.com/aws-cloudformation/cloudformation-cli/actions/workflows/pr-ci.yaml/badge.svg?branch=master)](https://github.com/aws-cloudformation/cloudformation-cli/actions/workflows/pr-ci.yaml)

# AWS CloudFormation CLI

The CloudFormation CLI (cfn) allows you to author your own resource providers, hooks, and modules that can be used by CloudFormation.

## Usage

### Documentation

Primary documentation for the CloudFormation CLI can be found at the [AWS Documentation](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html) site.

### Installation

This tool can be installed using [pip](https://pypi.org/project/pip/) from the Python Package Index (PyPI). It requires Python 3. For resource and hook types, the tool requires at least one language plugin. Language plugins are not needed to create a module type. The language plugins are also available on PyPI and as such can be installed all at once:

```bash
pip install cloudformation-cli cloudformation-cli-java-plugin cloudformation-cli-go-plugin cloudformation-cli-python-plugin cloudformation-cli-typescript-plugin
```


### Command: init

To create a project in the current directory, use the `init` command. A wizard will guide you through the creation.

```bash
cfn init
```

### Command: generate

To refresh auto-generated code, use the `generate` command. Usually, plugins try to integrate this command in the native build flow, so please consult a plugin's README to see if this is necessary.
In a module project, this will regenerate the module schema.

```bash
cfn generate
```

### Command: submit

To register a resource provider, module, or hook in your account, use the `submit` command.

```bash
cfn submit
cfn submit --dry-run #prepares schema handler package without submitting for registration
cfn submit --set-default # if successfully registered, set submitted version to be the new default version
```

### Command: test

To run the contract tests for a resource type, use the `test` command.

```bash
cfn test
cfn test -- -k contract_delete_update # to run a single test
cfn test -- --tb=long # exhaustive, informative traceback formatting
cfn test --enforce-timeout 60  # Read/List handler timeout (Create/Update/Delete handler timeout is twice the Read/List handler timeout)
cfn test --enforce-timeout 60 -- -k contract_delete_update # combine arguments
cfn test --log-group-name cw_log_group --log-role-arn log_delivery_role_arn # Handler logs generated by contract tests will be delivered to the specified cw_log_group using the credentials from log_delivery_role_arn
```

Note:
* To use your type configuration in contract tests, you will need to save your type configuration json file in `~/.cfn-cli/typeConfiguration.json` or specify the file you would like to use
    * `--typeconfig ./myResourceTypeConfig.json`
    * `--typeconfig /test/myresource/config1.json`
    * `--typeconfig C:\MyResource\typeconf.json`

* To use `propertyTransform` in schema, you will need to install [PYJQ](https://pypi.org/project/pyjq/). This feature will not be available to use with contract tests on Windows OS

Install PYJQ for Linux system

```bash
yum install autoconf automake libtool
pip install pyjq
```

Install PYJQ for macOS system

```bash
brew install autoconf automake libtool
brew install jq
pip install pyjq
```

Install PYJQ for Ubuntu system

```bash
pip install pyjq
```

### Command: validate

To validate the schema, use the `validate` command.

This command is automatically run whenever one attempts to submit a resource, module, or hook. Errors will prevent you from submitting your resource/module. Module fragments will additionally be validated via [`cfn-lint`](https://github.com/aws-cloudformation/cfn-python-lint/) (but resulting warnings will not cause this step to fail).

```bash
cfn validate
```

### Command: build-image

To build an image for a resource type. This image provides a minimalistic execution environment for the resource handler that does not depend on AWS Lambda in anyway. This image can be used during cfn invoke and cfn test instead of using sam cli.

```bash
cfn build-image
cfn build-image --image-name my-handler --executable target/myjar.jar
```

The resulting image can be run in a container by executing the following command:

```
docker run IMAGE_NAME HANDLER_ENTRYPOINT PAYLOAD
docker run my-test-resource com.my.test.resource.ExecutableHandlerWrapper PAYLOAD_JSON # Example for a java based-project
```


## Development

For developing, it's strongly suggested to install the development dependencies inside a virtual environment. (This isn't required if you just want to use this tool.)

```bash
python3 -m venv env
source env/bin/activate
pip install -e . -r requirements.txt
pre-commit install
```

If you're creating a resource or hook type, you will also need to install a language plugin, such as [the Java language plugin](https://github.com/aws-cloudformation/cloudformation-cli-java-plugin), also via `pip install`. For example, assuming the plugin is checked out in the same parent directory as this repository:

```bash
pip install -e ../cloudformation-cli-java-plugin
```

```bash
# run all hooks on all files, mirrors what the CI runs
pre-commit run --all-files
# run unit tests only. can also be used for other hooks, e.g. black, flake8, pylint-local
pre-commit run pytest-local
```

If you want to generate an HTML coverage report afterwards, run `coverage html`. The report is output to `htmlcov/index.html`.

## Plugin system

New language plugins can be independently developed. As long as they declare the appropriate entry point and are installed in the same environment, they can even be completely separate codebases. For example, a plugin for Groovy might have the following entry point:

```python
entry_points={
    "rpdk.v1.languages": ["groovy = rpdk.groovy:GroovyLanguagePlugin"],
},
```

Plugins must provide the same interface as `LanguagePlugin` (in `plugin_base.py`). And they may inherit from `LanguagePlugin` for the helper methods - but this is not necessary. As long as the class has the same methods, it will work as a plugin.

### Supported plugins

#### Resource Types Supported Plugins
| Language | Status            | Github                                                                                                      | PyPI                                                                                       |
| -------- | ----------------- | ----------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- |
| Java      | Available         | [cloudformation-cli-java-plugin](https://github.com/aws-cloudformation/cloudformation-cli-java-plugin/)     | [cloudformation-cli-java-plugin](https://pypi.org/project/cloudformation-cli-java-plugin/)     |
| Go        | Available         | [cloudformation-cli-go-plugin](https://github.com/aws-cloudformation/cloudformation-cli-go-plugin/)         | [cloudformation-cli-go-plugin](https://pypi.org/project/cloudformation-cli-go-plugin/)         |
| Python    | Available         | [cloudformation-cli-python-plugin](https://github.com/aws-cloudformation/cloudformation-cli-python-plugin/) | [cloudformation-cli-python-plugin](https://pypi.org/project/cloudformation-cli-python-plugin/) |
| TypeScript| Available         | [cloudformation-cli-typescript-plugin](https://github.com/aws-cloudformation/cloudformation-cli-typescript-plugin/) | [cloudformation-cli-typescript-plugin](https://pypi.org/project/cloudformation-cli-typescript-plugin/) |

#### Hook Types Supported Plugins
| Language | Status            | Github                                                                                                      | PyPI                                                                                       |
| -------- | ----------------- | ----------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- |
| Java      | Available         | [cloudformation-cli-java-plugin](https://github.com/aws-cloudformation/cloudformation-cli-java-plugin/)     | [cloudformation-cli-java-plugin](https://pypi.org/project/cloudformation-cli-java-plugin/)     |
| Python    | Available         | [cloudformation-cli-python-plugin](https://github.com/aws-cloudformation/cloudformation-cli-python-plugin/) | [cloudformation-cli-python-plugin](https://pypi.org/project/cloudformation-cli-python-plugin/) |

## License

This library is licensed under the Apache 2.0 License.

## Community

Join us on Discord! Connect & interact with CloudFormation developers &
experts, find channels to discuss and get help for our CLI, cfn-lint, CloudFormation registry, StackSets,
Guard and more:

[![Join our Discord](https://discordapp.com/api/guilds/981586120448020580/widget.png?style=banner3)](https://discord.gg/9zpd7TTRwq)
