#
# Copyright 2021 Splunk Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import os
import os.path as op
import platform
import sys

import __main__


def get_main_file():
    """Return the running mod input file"""
    return __main__.__file__


def get_app_root_dir():
    """Return the root dir of app"""
    return op.dirname(op.dirname(op.abspath(get_main_file())))


def get_mod_input_script_name():
    """Return the name of running mod input"""
    script_name = os.path.basename(get_main_file())
    if script_name.lower().endswith(".py"):
        script_name = script_name[:-3]
    return script_name


def register_module(new_path):
    """register_module(new_path): adds a directory to sys.path.
    Do nothing if it does not exist or if it's already in sys.path.
    """
    if not os.path.exists(new_path):
        return

    new_path = os.path.abspath(new_path)
    if platform.system() == "Windows":
        new_path = new_path.lower()
    for x in sys.path:
        x = os.path.abspath(x)
        if platform.system() == "Windows":
            x = x.lower()
        if new_path in (x, x + os.sep):
            return
    sys.path.insert(0, new_path)
