"""
Company ASCII logos for terminal display
"""

NETGURU_LOGO = """
  ███╗   ██╗███████╗████████╗ ██████╗ ██╗   ██╗██████╗ ██╗   ██╗
  ████╗  ██║██╔════╝╚══██╔══╝██╔════╝ ██║   ██║██╔══██╗██║   ██║
  ██╔██╗ ██║█████╗     ██║   ██║  ███╗██║   ██║██████╔╝██║   ██║
  ██║╚██╗██║██╔══╝     ██║   ██║   ██║██║   ██║██╔══██╗██║   ██║
  ██║ ╚████║███████╗   ██║   ╚██████╔╝╚██████╔╝██║  ██║╚██████╔╝
  ╚═╝  ╚═══╝╚══════╝   ╚═╝    ╚═════╝  ╚═════╝ ╚═╝  ╚═╝ ╚═════╝
"""

GOOGLE_LOGO = """
   ██████╗  ██████╗  ██████╗  ██████╗ ██╗     ███████╗
  ██╔════╝ ██╔═══██╗██╔═══██╗██╔════╝ ██║     ██╔════╝
  ██║  ███╗██║   ██║██║   ██║██║  ███╗██║     █████╗  
  ██║   ██║██║   ██║██║   ██║██║   ██║██║     ██╔══╝  
  ╚██████╔╝╚██████╔╝╚██████╔╝╚██████╔╝███████╗███████╗
   ╚═════╝  ╚═════╝  ╚═════╝  ╚═════╝ ╚══════╝╚══════╝
"""

SPOTIFY_LOGO = """
  ███████╗██████╗  ██████╗ ████████╗██╗███████╗██╗   ██╗
  ██╔════╝██╔══██╗██╔═══██╗╚══██╔══╝██║██╔════╝╚██╗ ██╔╝
  ███████╗██████╔╝██║   ██║   ██║   ██║█████╗   ╚████╔╝ 
  ╚════██║██╔═══╝ ██║   ██║   ██║   ██║██╔══╝    ╚██╔╝  
  ███████║██║     ╚██████╔╝   ██║   ██║██║        ██║   
  ╚══════╝╚═╝      ╚═════╝    ╚═╝   ╚═╝╚═╝        ╚═╝   
"""

KNOWDE_LOGO = """
  ██╗  ██╗███╗   ██╗ ██████╗ ██╗    ██╗██████╗ ███████╗
  ██║ ██╔╝████╗  ██║██╔═══██╗██║    ██║██╔══██╗██╔════╝
  █████╔╝ ██╔██╗ ██║██║   ██║██║ █╗ ██║██║  ██║█████╗  
  ██╔═██╗ ██║╚██╗██║██║   ██║██║███╗██║██║  ██║██╔══╝  
  ██║  ██╗██║ ╚████║╚██████╔╝╚███╔███╔╝██████╔╝███████╗
  ╚═╝  ╚═╝╚═╝  ╚═══╝ ╚═════╝  ╚══╝╚══╝ ╚═════╝ ╚══════╝
"""

RAGNARRSON_LOGO = """
  ██████╗  █████╗  ██████╗ ███╗   ██╗ █████╗ ██████╗ ██████╗ 
  ██╔══██╗██╔══██╗██╔════╝ ████╗  ██║██╔══██╗██╔══██╗██╔══██╗
  ██████╔╝███████║██║  ███╗██╔██╗ ██║███████║██████╔╝██████╔╝
  ██╔══██╗██╔══██║██║   ██║██║╚██╗██║██╔══██║██╔══██╗██╔══██╗
  ██║  ██║██║  ██║╚██████╔╝██║ ╚████║██║  ██║██║  ██║██║  ██║
  ╚═╝  ╚═╝╚═╝  ╚═╝ ╚═════╝ ╚═╝  ╚═══╝╚═╝  ╚═╝╚═╝  ╚═╝╚═╝  ╚═╝
"""

AMSTERDAM_STANDARD_LOGO = """
   █████╗ ███╗   ███╗███████╗████████╗███████╗██████╗ ██████╗  █████╗ ███╗   ███╗
  ██╔══██╗████╗ ████║██╔════╝╚══██╔══╝██╔════╝██╔══██╗██╔══██╗██╔══██╗████╗ ████║
  ███████║██╔████╔██║███████╗   ██║   █████╗  ██████╔╝██║  ██║███████║██╔████╔██║
  ██╔══██║██║╚██╔╝██║╚════██║   ██║   ██╔══╝  ██╔══██╗██║  ██║██╔══██║██║╚██╔╝██║
  ██║  ██║██║ ╚═╝ ██║███████║   ██║   ███████╗██║  ██║██████╔╝██║  ██║██║ ╚═╝ ██║
  ╚═╝  ╚═╝╚═╝     ╚═╝╚══════╝   ╚═╝   ╚══════╝╚═╝  ╚═╝╚═════╝ ╚═╝  ╚═╝╚═╝     ╚═╝
"""

KRUKO_LOGO = """
  ██╗  ██╗██████╗ ██╗   ██╗██╗  ██╗ ██████╗ 
  ██║ ██╔╝██╔══██╗██║   ██║██║ ██╔╝██╔═══██╗
  █████╔╝ ██████╔╝██║   ██║█████╔╝ ██║   ██║
  ██╔═██╗ ██╔══██╗██║   ██║██╔═██╗ ██║   ██║
  ██║  ██╗██║  ██║╚██████╔╝██║  ██╗╚██████╔╝
  ╚═╝  ╚═╝╚═╝  ╚═╝ ╚═════╝ ╚═╝  ╚═╝ ╚═════╝
"""

MONZO_LOGO = """
  ███╗   ███╗ ██████╗ ███╗   ██╗███████╗ ██████╗ 
  ████╗ ████║██╔═══██╗████╗  ██║╚══███╔╝██╔═══██╗
  ██╔████╔██║██║   ██║██╔██╗ ██║  ███╔╝ ██║   ██║
  ██║╚██╔╝██║██║   ██║██║╚██╗██║ ███╔╝  ██║   ██║
  ██║ ╚═╝ ██║╚██████╔╝██║ ╚████║███████╗╚██████╔╝
  ╚═╝     ╚═╝ ╚═════╝ ╚═╝  ╚═══╝╚══════╝ ╚═════╝
"""

DELIVEROO_LOGO = """
  ██████╗ ███████╗██╗     ██╗██╗   ██╗███████╗██████╗  ██████╗  ██████╗ 
  ██╔══██╗██╔════╝██║     ██║██║   ██║██╔════╝██╔══██╗██╔═══██╗██╔═══██╗
  ██║  ██║█████╗  ██║     ██║██║   ██║█████╗  ██████╔╝██║   ██║██║   ██║
  ██║  ██║██╔══╝  ██║     ██║╚██╗ ██╔╝██╔══╝  ██╔══██╗██║   ██║██║   ██║
  ██████╔╝███████╗███████╗██║ ╚████╔╝ ███████╗██║  ██║╚██████╔╝╚██████╔╝
  ╚═════╝ ╚══════╝╚══════╝╚═╝  ╚═══╝  ╚══════╝╚═╝  ╚═╝ ╚═════╝  ╚═════╝
"""

REVOLUT_LOGO = """
  ██████╗ ███████╗██╗   ██╗ ██████╗ ██╗     ██╗   ██╗████████╗
  ██╔══██╗██╔════╝██║   ██║██╔═══██╗██║     ██║   ██║╚══██╔══╝
  ██████╔╝█████╗  ██║   ██║██║   ██║██║     ██║   ██║   ██║   
  ██╔══██╗██╔══╝  ╚██╗ ██╔╝██║   ██║██║     ██║   ██║   ██║   
  ██║  ██║███████╗ ╚████╔╝ ╚██████╔╝███████╗╚██████╔╝   ██║   
  ╚═╝  ╚═╝╚══════╝  ╚═══╝   ╚═════╝ ╚══════╝ ╚═════╝    ╚═╝
"""

STRIPE_LOGO = """
  ███████╗████████╗██████╗ ██╗██████╗ ███████╗
  ██╔════╝╚══██╔══╝██╔══██╗██║██╔══██╗██╔════╝
  ███████╗   ██║   ██████╔╝██║██████╔╝█████╗  
  ╚════██║   ██║   ██╔══██╗██║██╔═══╝ ██╔══╝  
  ███████║   ██║   ██║  ██║██║██║     ███████╗
  ╚══════╝   ╚═╝   ╚═╝  ╚═╝╚═╝╚═╝     ╚══════╝
"""

VERCEL_LOGO = """
  ██╗   ██╗███████╗██████╗  ██████╗███████╗██╗     
  ██║   ██║██╔════╝██╔══██╗██╔════╝██╔════╝██║     
  ██║   ██║█████╗  ██████╔╝██║     █████╗  ██║     
  ╚██╗ ██╔╝██╔══╝  ██╔══██╗██║     ██╔══╝  ██║     
   ╚████╔╝ ███████╗██║  ██║╚██████╗███████╗███████╗
    ╚═══╝  ╚══════╝╚═╝  ╚═╝ ╚═════╝╚══════╝╚══════╝
"""

RAILWAY_LOGO = """
  ██████╗  █████╗ ██╗██╗     ██╗    ██╗ █████╗ ██╗   ██╗
  ██╔══██╗██╔══██╗██║██║     ██║    ██║██╔══██╗╚██╗ ██╔╝
  ██████╔╝███████║██║██║     ██║ █╗ ██║███████║ ╚████╔╝ 
  ██╔══██╗██╔══██║██║██║     ██║███╗██║██╔══██║  ╚██╔╝  
  ██║  ██║██║  ██║██║███████╗╚███╔███╔╝██║  ██║   ██║   
  ╚═╝  ╚═╝╚═╝  ╚═╝╚═╝╚══════╝ ╚══╝╚══╝ ╚═╝  ╚═╝   ╚═╝
"""

LINEAR_LOGO = """
  ██╗     ██╗███╗   ██╗███████╗ █████╗ ██████╗ 
  ██║     ██║████╗  ██║██╔════╝██╔══██╗██╔══██╗
  ██║     ██║██╔██╗ ██║█████╗  ███████║██████╔╝
  ██║     ██║██║╚██╗██║██╔══╝  ██╔══██║██╔══██╗
  ███████╗██║██║ ╚████║███████╗██║  ██║██║  ██║
  ╚══════╝╚═╝╚═╝  ╚═══╝╚══════╝╚═╝  ╚═╝╚═╝  ╚═╝
"""

SUPABASE_LOGO = """
  ███████╗██╗   ██╗██████╗  █████╗ ██████╗  █████╗ ███████╗███████╗
  ██╔════╝██║   ██║██╔══██╗██╔══██╗██╔══██╗██╔══██╗██╔════╝██╔════╝
  ███████╗██║   ██║██████╔╝███████║██████╔╝███████║███████╗█████╗  
  ╚════██║██║   ██║██╔═══╝ ██╔══██║██╔══██╗██╔══██║╚════██║██╔══╝  
  ███████║╚██████╔╝██║     ██║  ██║██████╔╝██║  ██║███████║███████╗
  ╚══════╝ ╚═════╝ ╚═╝     ╚═╝  ╚═╝╚═════╝ ╚═╝  ╚═╝╚══════╝╚══════╝
"""

COMPANY_LOGOS = {
    'netguru': NETGURU_LOGO,
    'google': GOOGLE_LOGO,
    'spotify': SPOTIFY_LOGO,
    'knowde': KNOWDE_LOGO,
    'ragnarrson': RAGNARRSON_LOGO,
    'amsterdam standard': AMSTERDAM_STANDARD_LOGO,
    'amsterdamstandard': AMSTERDAM_STANDARD_LOGO,
    'kruko': KRUKO_LOGO,
    'monzo': MONZO_LOGO,
    'deliveroo': DELIVEROO_LOGO,
    'revolut': REVOLUT_LOGO,
    'stripe': STRIPE_LOGO,
    'vercel': VERCEL_LOGO,
    'railway': RAILWAY_LOGO,
    'linear': LINEAR_LOGO,
    'supabase': SUPABASE_LOGO,
}

def get_company_logo(company_name: str) -> str:
    """Get ASCII logo for company"""
    company_key = company_name.lower().replace(' ', '').replace('-', '')
    return COMPANY_LOGOS.get(company_key, '')

def display_company_header(company_name: str, job_count: int = 0) -> str:
    """Display company header with logo and job count"""
    logo = get_company_logo(company_name)
    if logo:
        header = f"""
{logo}

🏢 {company_name.upper()} JOBS
📊 {job_count} positions available
🚀 Apply directly from terminal
        """
        return header
    return f"\n🏢 {company_name} - {job_count} jobs available\n"