# ConfigCat Resource Provider

The ConfigCat Resource Provider lets you manage [ConfigCat](https://configcat.com) resources.

## Installing

This package is available for several languages/platforms:

### Node.js (JavaScript/TypeScript)

To use from JavaScript or TypeScript in Node.js, install using either `npm`:

```bash
npm install @pulumiverse/configcat
```

or `yarn`:

```bash
yarn add @pulumiverse/configcat
```

### Python

To use from Python, install using `pip`:

```bash
pip install pulumiverse_configcat
```

### Go

To use from Go, use `go get` to grab the latest version of the library:

```bash
go get github.com/pulumiverse/pulumi-configcat/sdk/v5/go/...
```

### .NET

To use from .NET, install using `dotnet add package`:

```bash
dotnet add package Pulumiverse.ConfigCat
```

## Configuration

The following configuration points are available for the `configcat` provider:

- `configcat:apiKey` (environment: `FOO_API_KEY`) - the API key for `foo`

## Reference

For detailed reference documentation, please visit [the Pulumi registry](https://www.pulumi.com/registry/packages/configcat/api-docs/).
